/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.content.client.util.FolderTypeUtil;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.CopyContainerNode;
import com.sas.svcs.content.lifecycle.client.CopyNode;
import com.sas.svcs.content.lifecycle.client.CopyOperation;
import com.sas.svcs.content.lifecycle.client.MappableEntity;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.NestedCopyNode;
import com.sas.svcs.content.lifecycle.client.NodeProcessingState;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportOperation;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.dao.NameValidator;
import com.sas.svcs.content.lifecycle.dao.TransportNodeRenameUtil;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionDependency;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMappingUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractExportMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractImportMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.lifecycle.spi.CopyResult;
import com.sas.svcs.content.logging.client.LogItem;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CopyMetadataUtil {
    protected ObjectTypeService objectTypeService;
    protected MetadataTemplate metadataTemplate;
    protected TransportNodeRenameUtil nodeRenameUtil;
    private NameValidator nameValidator;
    private CopyExportMetadataUtil exportUtil;
    private CopyImportMetadataUtil importUtil;

    public void setNameValidator(NameValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public void setMetadataTemplate(MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void setTransportNodeRenameUtil(TransportNodeRenameUtil nodeRenameUtil) {
        this.nodeRenameUtil = nodeRenameUtil;
    }

    public AbstractExportMetadataUtil.RequestData copyMetadata(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
        List<CopyNode> nodeList = Arrays.asList(node);
        try {
            this.exportUtil = new CopyExportMetadataUtil();
            this.exportUtil.setMetadataTemplate(this.metadataTemplate);
            this.exportUtil.setObjectTypeService(this.objectTypeService);
            return this.exportUtil.exportMetadata(nodeList);
        }
        catch (Exception e) {
            throw new ContentException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void pasteMetadata(CopyNode node, CopyOperation operation, CopyResult result, AbstractExportMetadataUtil.RequestData requestData) throws ContentException {
        if (requestData == null) {
            return;
        }
        List<CopyNode> nodeList = Arrays.asList(node);
        try {
            this.importUtil = new CopyImportMetadataUtil(operation);
            this.importUtil.setMetadataTemplate(this.metadataTemplate);
            this.importUtil.setObjectTypeService(this.objectTypeService);
            boolean success = this.importUtil.mapConnections(node);
            if (!success) {
                node.setProcessingState(NodeProcessingState.DEFERRED);
                return;
            }
            ArrayList logItems = new ArrayList();
            List renamedNodes = this.nodeRenameUtil.getRenamedNodes(nodeList, this.nameValidator, (TargetTransportOperation)operation, logItems);
            if (renamedNodes != null && !renamedNodes.isEmpty()) {
                for (CopyNode cn : renamedNodes) {
                    this.importUtil.renameItem((TargetTransportNode)cn);
                }
            }
            for (LogItem logItem : logItems) {
                result.addLogItem(logItem);
            }
            this.importUtil.importMetadata(nodeList, requestData.getTransportMetadata(), requestData.getDeployMap());
        }
        catch (Exception e) {
            throw new ContentException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setCreatedModifiedBy(CopyNode node) throws ContentException {
        if (this.importUtil != null) {
            this.importUtil.setCreatedModifiedBy(Arrays.asList(node));
        }
    }

    private class CopyExportMetadataUtil
    extends AbstractExportMetadataUtil<CopyNode> {
        private CopyExportMetadataUtil() {
        }

        @Override
        protected CopyNode createNestedNode() {
            return new NestedCopyNode();
        }
    }

    private class CopyImportMetadataUtil
    extends AbstractImportMetadataUtil<CopyNode> {
        public CopyImportMetadataUtil(CopyOperation operation) {
            super(operation, operation.getTargetContainer());
        }

        public boolean mapConnections(CopyNode node) throws ContentException {
            Set<String> containerIds = (Set<String>)this.operation.getObjectFromCache((Object)"Framework.Container.Ids");
            if (containerIds == null) {
                containerIds = Collections.emptySet();
            } else {
                String[] idsArray;
                for (String id : idsArray = containerIds.toArray(new String[containerIds.size()])) {
                    if (!"ROOT_FOLDER_ID".equalsIgnoreCase(id)) continue;
                    String rootFolderId = this.getRootFolderId();
                    containerIds.remove(id);
                    containerIds.add(rootFolderId);
                }
            }
            ConnectionMappingUtil mappingUtil = new ConnectionMappingUtil();
            CopyContainerNode container = node.getContainer();
            Set cps = mappingUtil.getConnectionPoints(Arrays.asList(node));
            if (cps != null && !cps.isEmpty()) {
                HashMap<String, ConnectionPoint> cpCache = new HashMap<String, ConnectionPoint>(cps.size());
                for (ConnectionPoint cp : cps) {
                    cpCache.put(cp.getSourceId(), cp);
                }
                Map<String, CopyNode> nodeCache = this.buildNodeCache();
                for (ConnectionPoint cp : cps) {
                    ConnectionPoint parentConnection;
                    String parentId;
                    ConnectionMapping mapping;
                    if (cp.getParentConnection() == null && (mapping = mappingUtil.getConnectionMapping(cp)) instanceof ConnectionDependency && (parentId = ((ConnectionDependency)mapping).getParentId((MappableEntity)cp)) != null && (parentConnection = (ConnectionPoint)cpCache.get(parentId)) != null) {
                        cp.setParentConnection(parentConnection);
                    }
                    if (!cp.isActive() || cp.isMapped()) continue;
                    if (container != null && container.getId().equalsIgnoreCase(cp.getSourceId())) {
                        this.mapContainerConnection(cp, container);
                        continue;
                    }
                    if (container == null && containerIds.contains(cp.getSourceId())) {
                        this.mapContainerConnection(cp, this.target);
                        continue;
                    }
                    CopyNode associatedNode = this.getAssociatedNode(cp, nodeCache);
                    if (associatedNode != null) {
                        boolean success = this.mapConnectionByAssociatedNode(cp, associatedNode);
                        if (success) continue;
                        return false;
                    }
                    this.mapConnectionBySourceId(cp);
                }
            }
            return true;
        }

        private void mapContainerConnection(ConnectionPoint cp, ContainerNode targetNode) {
            if (cp instanceof ContentConnectionPoint) {
                ContentConnectionPoint ccp = (ContentConnectionPoint)cp;
                long cpType = ccp.getObjectType();
                if (cpType == 29L && targetNode.getObjectType() == 28L || cpType == 28L && targetNode.getObjectType() == 29L) {
                    this.updateFolderConnections((ConnectionPoint)ccp);
                } else {
                    String path = null;
                    ContentComponent targetComp = targetNode.getContentObject();
                    if (targetComp instanceof ContentNode) {
                        path = ((ContentNode)targetComp).getPath();
                    }
                    this.mapConnection(cp, targetNode.getId(), path);
                }
            } else {
                this.mapConnection(cp, targetNode.getId(), null);
            }
        }

        private void mapContainerConnection(ConnectionPoint cp, CopyContainerNode container) throws ContentException {
            String targetId = container.getTargetId();
            if (targetId == null) {
                throw new ContentException(RB.getStringResource("CopyMetadataUtil.CopyError.MissingTargetId.txt", this.operation.getLocale()));
            }
            this.mapConnection(cp, targetId, container.getTargetPath());
        }

        private boolean mapConnectionByAssociatedNode(ConnectionPoint cp, CopyNode associatedNode) throws ContentException {
            String targetId = associatedNode.getTargetId();
            if (associatedNode.getProcessingState() == NodeProcessingState.FAILED) {
                String msg = Message.format((String)RB.getStringResource("CopyMetadataUtil.CopyError.DependentError.fmt.txt", this.operation.getLocale()), (Object)associatedNode.getContentObject().getObjectTypeName(), (Object)associatedNode.toString());
                throw new ContentException(msg);
            }
            if (targetId == null) {
                return false;
            }
            this.mapConnection(cp, targetId, associatedNode.getTargetPath());
            return true;
        }

        private void mapConnectionBySourceId(ConnectionPoint cp) {
            String path = null;
            if (cp instanceof ContentConnectionPoint) {
                path = ((ContentConnectionPoint)cp).getSourcePath();
            }
            this.mapConnection(cp, cp.getSourceId(), path);
        }

        private void mapConnection(ConnectionPoint cp, String targetId, String targetPath) {
            cp.setTargetId(targetId);
            if (cp instanceof ContentConnectionPoint) {
                ContentConnectionPoint ccp = (ContentConnectionPoint)cp;
                ccp.setTargetPath(targetPath);
            }
        }

        private CopyNode getAssociatedNode(ConnectionPoint cp, Map<String, CopyNode> nodeCache) {
            String cpId = cp.getSourceId();
            return nodeCache.get(cpId);
        }

        private Map<String, CopyNode> buildNodeCache() {
            HashMap<String, CopyNode> nodeCache = new HashMap<String, CopyNode>();
            List nodeList = this.operation.getOperationNodes();
            for (CopyNode node : nodeList) {
                nodeCache.put(node.getId(), node);
                List nestedNodes = node.getNestedNodes();
                if (nestedNodes == null) continue;
                this.cacheNestedNodes(nestedNodes, nodeCache);
            }
            return nodeCache;
        }

        private void cacheNestedNodes(List<Nested> nestedNodes, Map<String, CopyNode> nodeCache) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof CopyNode)) continue;
                nodeCache.put(nestedNode.getId(), (CopyNode)nestedNode);
                List childNested = ((CopyNode)nestedNode).getNestedNodes();
                if (childNested == null) continue;
                this.cacheNestedNodes(childNested, nodeCache);
            }
        }

        private void updateFolderConnections(ConnectionPoint cp) {
            List nodeList = cp.getAssociatedObjects();
            if (nodeList != null && !nodeList.isEmpty()) {
                for (TransportNode node : nodeList) {
                    if (!FolderTypeUtil.isFolderType((long)node.getObjectType()) || !(node instanceof CopyNode) || this.operation.hasNodeMoved((TargetTransportNode)((CopyNode)node))) continue;
                    this.operation.moveNode((TargetTransportNode)((CopyNode)node), this.target);
                }
            }
        }

        private String getRootFolderId() throws ContentException {
            try {
                RootFolderInterface mi = this.metaTemplate.getServer().getRootFolder();
                return mi.getReposKey();
            }
            catch (Exception e) {
                throw new ContentException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

