/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTypeTransportManager {
    protected SessionContextInterface session;
    protected ServerInterface server;
    protected ObjectTypeService objectTypeService;
    protected String objectTypeName;
    private List<LogMessage> logMessages;

    public AbstractTypeTransportManager(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public SessionContextInterface getSession() {
        return this.session;
    }

    public void setSession(SessionContextInterface session) {
        this.session = session;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    public void setServer(ServerInterface server) {
        this.server = server;
    }

    public ObjectTypeService getObjectTypeService() {
        return this.objectTypeService;
    }

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public List<LogMessage> getLogMessages() {
        return this.logMessages;
    }

    public void addLogMessage(String message, int priority) {
        if (this.logMessages == null) {
            this.logMessages = new ArrayList<LogMessage>();
        }
        this.logMessages.add(new LogMessage(message, priority));
    }

    public void addEnumerationLogMessages(List<String> messages, int priority) {
        if (this.logMessages == null) {
            this.logMessages = new ArrayList<LogMessage>();
        }
        this.logMessages.add(new EnumerationLogMessage(messages, priority));
    }

    class LogMessage {
        private String message;
        private int priority;

        LogMessage(int priority) {
            this.priority = priority;
        }

        public LogMessage(String message, int priority) {
            this.message = message;
            this.priority = priority;
        }

        public String getMessage() {
            return this.message;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    class EnumerationLogMessage
    extends LogMessage {
        private List<String> messages;

        public EnumerationLogMessage(List<String> messages, int priority) {
            super(priority);
            this.messages = messages;
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }
}

