/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.svcs.content.lifecycle.client.ImportNode;
import com.sas.svcs.content.lifecycle.dao.omr.FinishedParsingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class AbstractTransportMetadataParser
extends DefaultHandler {
    protected static final int OBJECT_LEVEL = 1;
    protected Map<String, ImportNode> _processingCache;
    protected Stack<BaseElement> _elementStack = new Stack();
    protected String _currentObjectID = null;
    protected int _currentLevel = 0;
    protected Document _template;
    protected Node _currentTemplateNode;
    protected boolean _parsingTemplate = false;

    public AbstractTransportMetadataParser(List<ImportNode> importNodes) {
        this._processingCache = new HashMap<String, ImportNode>(importNodes.size());
        for (ImportNode item : importNodes) {
            this._processingCache.put(item.getId(), item);
        }
    }

    public void applyTemplate(Document template) {
        this._template = template;
        this._parsingTemplate = this._template != null;
    }

    protected abstract ObjectElement createNewObjectElement(String var1, BaseElement var2) throws SAXException;

    protected abstract AssocElement createNewAssocElement(String var1, BaseElement var2) throws SAXException;

    protected abstract void createTopLevelObject(ObjectElement var1, String var2, String var3, String var4) throws SAXException;

    protected abstract void createSecondaryObject(ObjectElement var1, String var2, String var3, String var4, boolean var5) throws SAXException;

    protected abstract void addObjectAttribute(ObjectElement var1, String var2, String var3) throws SAXException;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._currentLevel == 1) {
            this._currentObjectID = null;
            String objectID = attributes.getValue("Id") + "/" + qName;
            ImportNode importNode = this._processingCache.get(objectID);
            if (importNode != null) {
                this._currentObjectID = objectID;
                this.processTopLevelObject(importNode, qName, attributes);
            }
        } else if (this._currentLevel > 1 && this._currentObjectID != null) {
            if (attributes == null || attributes.getLength() == 0) {
                this.processAssociation(qName);
            } else {
                this.processObject(qName, attributes);
            }
        }
        ++this._currentLevel;
    }

    private void processAssociation(String nodeName) throws SAXException {
        BaseElement parent = this._elementStack.peek();
        AssocElement element = this.createNewAssocElement(nodeName, parent);
        this._elementStack.add(element);
        if (this._parsingTemplate) {
            if (!parent.isContainedInTemplate()) {
                return;
            }
            String elementName = element.getName();
            NodeList childNodes = this._currentTemplateNode.getChildNodes();
            if (childNodes != null && childNodes.getLength() > 0) {
                for (int index = 0; index < childNodes.getLength(); ++index) {
                    Node node = childNodes.item(index);
                    if (node.getNodeType() != 1 || !elementName.equalsIgnoreCase(node.getNodeName())) continue;
                    element.setContainedInTemplate(true);
                    this._currentTemplateNode = node;
                    return;
                }
            }
        } else {
            element.setContainedInTemplate(true);
        }
    }

    private void processObject(String nodeName, Attributes objectAttributes) throws SAXException {
        BaseElement parent = this._elementStack.peek();
        ObjectElement element = this.createNewObjectElement(nodeName, parent);
        this._elementStack.add(element);
        if (this._parsingTemplate) {
            if (!parent.isContainedInTemplate()) {
                return;
            }
            String elementName = element.getName();
            NodeList childNodes = this._currentTemplateNode.getChildNodes();
            if (childNodes != null) {
                if (childNodes.getLength() == 0) {
                    this.processSecondaryObject(nodeName, objectAttributes, element, false);
                } else {
                    for (int index = 0; index < childNodes.getLength(); ++index) {
                        Node node = childNodes.item(index);
                        if (node.getNodeType() != 1 || !elementName.equalsIgnoreCase(node.getNodeName())) continue;
                        element.setContainedInTemplate(true);
                        this._currentTemplateNode = node;
                        this.processSecondaryObject(nodeName, objectAttributes, element, true);
                        return;
                    }
                }
            }
        } else {
            element.setContainedInTemplate(true);
            this.processSecondaryObject(nodeName, objectAttributes, element, true);
        }
    }

    private void processTopLevelObject(ImportNode importNode, String type, Attributes objectAttributes) throws SAXException {
        ObjectElement element = this.createNewObjectElement(type, null);
        element.setContainedInTemplate(true);
        this._elementStack.push(element);
        this.createTopLevelObject(element, importNode.getId(), importNode.getName(), type);
        if (this._parsingTemplate) {
            Node node = this._template.getFirstChild();
            if (node == null) {
                throw new IllegalStateException("Invalid object template.");
            }
            this._currentTemplateNode = node.getFirstChild();
        }
        this.processObjectAttributes(element, objectAttributes);
    }

    private void processSecondaryObject(String nodeName, Attributes objectAttributes, ObjectElement element, boolean includeAttributes) throws SAXException {
        BaseElement parent = element.getParent();
        if (parent instanceof AssocElement) {
            String id = objectAttributes.getValue("Id");
            boolean isObjRef = false;
            if (id == null && (id = objectAttributes.getValue("ObjRef")) != null) {
                isObjRef = true;
            }
            String name = objectAttributes.getValue("Name");
            this.createSecondaryObject(element, id, name, nodeName, isObjRef);
            if (includeAttributes) {
                this.processObjectAttributes(element, objectAttributes);
            }
        }
    }

    private void processObjectAttributes(ObjectElement element, Attributes objectAttributes) throws SAXException {
        block3: {
            block2: {
                if (!this._parsingTemplate) break block2;
                NamedNodeMap templateAttrs = this._currentTemplateNode.getAttributes();
                if (templateAttrs == null || templateAttrs.getLength() <= 0) break block3;
                int length = templateAttrs.getLength();
                for (int index = 0; index < length; ++index) {
                    String attrName;
                    Node templateAttr = templateAttrs.item(index);
                    String attrValue = objectAttributes.getValue(attrName = templateAttr.getNodeName());
                    this.addObjectAttribute(element, attrName, attrValue == null ? "" : attrValue);
                }
                break block3;
            }
            int length = objectAttributes.getLength();
            for (int index = 0; index < length; ++index) {
                String attrName;
                String attrValue = objectAttributes.getValue(attrName = objectAttributes.getQName(index));
                this.addObjectAttribute(element, attrName, attrValue == null ? "" : attrValue);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        BaseElement element;
        --this._currentLevel;
        if (this._currentLevel == 1) {
            if (this._currentObjectID != null) {
                this._processingCache.remove(this._currentObjectID);
                BaseElement element2 = this._elementStack.pop();
                if (element2 != null && element2.getParent() == null) {
                    this.addMissingAssociations(element2);
                }
            }
            this._elementStack.clear();
            if (this._processingCache.isEmpty()) {
                throw new FinishedParsingException();
            }
        } else if (this._currentLevel > 1 && this._currentObjectID != null && !this._elementStack.isEmpty() && (element = this._elementStack.pop()).isContainedInTemplate()) {
            if (element instanceof AssocElement) {
                BaseElement parent;
                List<?> assocList = ((AssocElement)element).getAssocList();
                if (assocList != null && (parent = element.getParent()) instanceof ObjectElement) {
                    ((ObjectElement)parent).addAssociation(element.getName(), assocList);
                }
            } else if (element instanceof ObjectElement) {
                this.addMissingAssociations(element);
            }
            if (this._currentTemplateNode != null) {
                this._currentTemplateNode = this._currentTemplateNode.getParentNode();
            }
        }
    }

    private void addMissingAssociations(BaseElement element) {
        if (this._currentTemplateNode != null && element.getName().equals(this._currentTemplateNode.getNodeName())) {
            ObjectElement objElement = (ObjectElement)element;
            NodeList childNodes = this._currentTemplateNode.getChildNodes();
            for (int index = 0; index < childNodes.getLength(); ++index) {
                String nodeName;
                Node childNode = childNodes.item(index);
                if (childNode.getNodeType() != 1 || objElement.containsAssociation(nodeName = childNode.getNodeName())) continue;
                objElement.addAssociation(nodeName, Collections.emptyList());
            }
        }
    }

    protected abstract class BaseElement {
        protected String _name;
        protected boolean _contained = false;
        protected BaseElement _parent;

        public BaseElement(String name, BaseElement parentElement) {
            this._name = name;
            this._parent = parentElement;
        }

        public String getName() {
            return this._name;
        }

        public boolean isContainedInTemplate() {
            return this._contained;
        }

        public void setContainedInTemplate(boolean contained) {
            this._contained = contained;
        }

        public BaseElement getParent() {
            return this._parent;
        }

        public int getLevel() {
            int level = 0;
            for (BaseElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
                ++level;
            }
            return level;
        }
    }

    protected abstract class AssocElement
    extends BaseElement {
        public AssocElement(String name, BaseElement parentElement) {
            super(name, parentElement);
        }

        public abstract List<?> getAssocList();

        public String toString() {
            return "Association: " + this.getName();
        }
    }

    protected abstract class ObjectElement
    extends BaseElement {
        public ObjectElement(String name, BaseElement parentElement) {
            super(name, parentElement);
        }

        public abstract void addAssociation(String var1, List<?> var2);

        public abstract boolean containsAssociation(String var1);

        public String toString() {
            return "Object: " + this.getName();
        }
    }
}

