/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.svcs.content.lifecycle.client.ConnectionNotMappedException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.ValidationResponse;
import com.sas.svcs.content.lifecycle.client.ValidationState;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRPromptedConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.transport.client.mapping.PromptType;
import com.sas.text.Message;
import java.util.Locale;

public abstract class AbstractOMRContentNodeConnectionMapping
extends AbstractOMRPromptedConnectionMapping {
    public PromptType getConnectionPromptType() {
        return PromptType.OBJECT_SELECTOR;
    }

    public <T extends TransportNode> String findDefaultMapping(ConnectionPoint cp, ContentOperation<T> operation) throws ConnectionNotMappedException {
        return this.findConnectionByPath(cp, operation);
    }

    protected final <T extends TransportNode> String findConnectionByPath(ConnectionPoint cp, ContentOperation<T> operation) throws ConnectionNotMappedException {
        String path;
        if (cp instanceof ContentConnectionPoint && (path = ((ContentConnectionPoint)cp).getSourcePath()) != null && path.length() > 0) {
            try {
                path = path + "(" + ((ContentConnectionPoint)cp).getTypeName() + ")";
                MetadataInterface mi = this.getMetadataTemplate().getMetadataObjectByPath(path);
                if (mi != null) {
                    return mi.getReposKey();
                }
            }
            catch (Exception e) {
                ValidationResponse validation = new ValidationResponse();
                validation.setState(ValidationState.WARNING);
                validation.setMessage(e.getLocalizedMessage());
                throw new ConnectionNotMappedException(validation, (Throwable)e);
            }
        }
        return null;
    }

    public <T extends TransportNode> ConnectionPoint mapConnection(ConnectionPoint cp, String targetValue, ContentOperation<T> operation) throws ConnectionNotMappedException {
        if (targetValue == null || targetValue.isEmpty()) {
            cp.setTargetId(null);
        } else {
            try {
                MetadataInterface mi = this.getMetadataTemplate().getMetadataObjectByPath(targetValue);
                if (mi == null) {
                    Locale locale = operation.getLocale();
                    ValidationResponse validation = new ValidationResponse();
                    validation.setState(ValidationState.WARNING);
                    validation.setMessage(Message.format((String)RB.getStringResource("AbstractOMRPromptedConnectionMapping.MappingNotFound.fmt.txt", locale), (Object)this.getTypeLabel(locale), (Object)targetValue));
                    throw new ConnectionNotMappedException(validation);
                }
                cp.setTargetId(mi.getReposKey());
                if (cp instanceof ContentConnectionPoint) {
                    PathUrl pathUrl = mi.getPathUrl();
                    ((ContentConnectionPoint)cp).setTargetPath(pathUrl.getDisplayPath());
                }
            }
            catch (ConnectionNotMappedException e) {
                throw e;
            }
            catch (Exception e) {
                ValidationResponse validation = new ValidationResponse();
                validation.setState(ValidationState.WARNING);
                validation.setMessage(e.getLocalizedMessage());
                throw new ConnectionNotMappedException(validation, (Throwable)e);
            }
        }
        return cp;
    }

    protected final String getPathWithType(String path, String type) {
        return path + "(" + type + ")";
    }
}

