/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.DAOUtil;
import com.sas.svcs.common.client.dao.omr.mapping.ObjectMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.content.lifecycle.client.ConnectionNotMappedException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.client.ValidationResponse;
import com.sas.svcs.content.lifecycle.client.ValidationState;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.InitializingConnectionPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractOMRConnectionMapping
implements ConnectionMapping,
InitializingConnectionPoint {
    private MetadataTemplate metadataTemplate;

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    public final MetadataTemplate getMetadataTemplate() {
        return this.metadataTemplate;
    }

    public <T extends TransportNode> boolean isConnectionActive(ConnectionPoint cp, ContentOperation<T> operation) {
        if (cp.isActive()) {
            TransportNode node = (TransportNode)operation.getOperationNode(cp.getSourceId());
            if (node != null) {
                if (node instanceof TargetTransportNode) {
                    return TransportUtil.isDisabled((TargetTransportNode)((TargetTransportNode)node));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void afterCreation(ConnectionPoint cp) {
        Map<String, String> propertyMap;
        ObjectMapping objMapping = this.getObjectMapping(cp);
        if (objMapping != null && (propertyMap = this.makePropertyMap(cp, objMapping)) != null) {
            for (String key : propertyMap.keySet()) {
                cp.addProperty(key, propertyMap.get(key));
            }
        }
    }

    private ObjectMapping getObjectMapping(ConnectionPoint cp) {
        ObjectMapping result = null;
        List<AttributeMapping> attrs = this.getAttributeMapping(cp);
        if (attrs != null) {
            result = new ObjectMapping("com.sas.svcs.content.lifecycle.client.ConnectionPoint");
            ArrayList<AttributeMapping> attributeMapList = new ArrayList<AttributeMapping>(attrs.size());
            attributeMapList.addAll(attrs);
            result.mappingList = attributeMapList;
        }
        return result;
    }

    protected List<AttributeMapping> getAttributeMapping(ConnectionPoint cp) {
        return null;
    }

    protected String getOMRTemplate() {
        return null;
    }

    private Map<String, String> makePropertyMap(ConnectionPoint cp, ObjectMapping objMapping) {
        String template = this.getOMRTemplate();
        HashMap<String, String> result = new HashMap<String, String>();
        BrowseMetadataInterface browse = this.getMetadataTemplate().fetchBrowseMetadataById(cp.getSourceId(), template);
        if (browse != null) {
            try {
                ServerInterface server = this.getMetadataTemplate().getServer();
                DAOUtil daoUtil = new DAOUtil();
                daoUtil.setServer(server);
                Map daoMap = daoUtil.processMapBrowse(objMapping, (BrowseMetadata)browse);
                Set keySet = daoMap.keySet();
                for (String nextKey : keySet) {
                    ResultMapEntry nextEntry = (ResultMapEntry)daoMap.get(nextKey);
                    Object valueObject = nextEntry.value;
                    if (!(valueObject instanceof String)) continue;
                    result.put(nextKey, (String)valueObject);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    protected final String searchForConnectionPointId(FilterInterface filter) throws ConnectionNotMappedException {
        BrowseMetadataInterface browse = this.searchForConnectionPoint(filter);
        return browse == null ? null : browse.getReposId() + "/" + browse.getNativeType();
    }

    protected final BrowseMetadataInterface searchForConnectionPoint(FilterInterface filter) throws ConnectionNotMappedException {
        try {
            ServerInterface server = this.getMetadataTemplate().getServer();
            List browseList = server.browseSearch(filter);
            if (browseList != null && !browseList.isEmpty()) {
                return (BrowseMetadataInterface)browseList.get(0);
            }
        }
        catch (Exception e) {
            ValidationResponse validation = new ValidationResponse();
            validation.setState(ValidationState.WARNING);
            validation.setMessage(e.getLocalizedMessage());
            throw new ConnectionNotMappedException(validation, (Throwable)e);
        }
        return null;
    }
}

