/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.meta.SASOMI.IMetadataTransport;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdResponsibilitiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.XMLUtil;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.FatalContentException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.Container;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportOperation;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.omr.FinishedParsingException;
import com.sas.svcs.content.lifecycle.dao.omr.ImportOutputParser;
import com.sas.svcs.content.lifecycle.dao.omr.ParsingConstants;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.streaming.client.StreamService;
import com.sas.text.Message;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AbstractImportMetadataUtil<T extends TargetTransportNode> {
    private static final Logger log = LogManager.getLogger(AbstractImportMetadataUtil.class);
    private static final String DELETE_IN_TARGET = "DeleteInTarget";
    protected XMLEventFactory eventFactory = null;
    protected XMLInputFactory inputFactory = null;
    protected XMLOutputFactory outputFactory = null;
    protected List<ServerSubstitution> substitutionsList;
    protected String currentObjectId = null;
    protected Map<String, String> objectReposMap;
    protected ContainerNode target;
    protected ObjectTypeService objectTypeService;
    protected MetadataTemplate metaTemplate;
    protected StreamService streamService;
    protected String targetReposId;
    protected boolean mergeSupported;
    protected TargetTransportOperation<T> operation;

    public AbstractImportMetadataUtil(TargetTransportOperation<T> operation, ContainerNode target) {
        this.operation = operation;
        this.target = target;
        this.eventFactory = XMLEventFactory.newInstance();
        this.inputFactory = XMLInputFactory.newInstance();
        this.outputFactory = XMLOutputFactory.newInstance();
    }

    public void setMetadataTemplate(MetadataTemplate metadataTemplate) {
        this.metaTemplate = metadataTemplate;
    }

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void setMergeSupported(boolean merge) {
        this.mergeSupported = merge;
    }

    public boolean isMergeSupported() {
        return this.mergeSupported;
    }

    private boolean isMergingNode(TargetTransportNode node) {
        if (this.isMergeSupported()) {
            List nestedNodes = node.getNestedNodes();
            return nestedNodes != null && !nestedNodes.isEmpty();
        }
        return false;
    }

    protected void renameItem(TargetTransportNode node) {
        if (this.substitutionsList == null) {
            this.substitutionsList = new ArrayList<ServerSubstitution>();
        }
        this.substitutionsList.add(new ServerSubstitution(node, "Name", node.getName()));
    }

    protected String getTargetRepositoryId() throws ContentException {
        if (this.targetReposId == null) {
            String id = this.target.getId();
            if (this.target.getObjectType() == 29L) {
                try {
                    MetadataInterface mi = this.metaTemplate.getMetadataObjectByPath("/");
                    if (mi == null) {
                        throw new ContentException(RB.getStringResource("ImportMetadataUtil.nofindrootfolder.txt", this.operation.getLocale()));
                    }
                    id = mi.getReposKey();
                }
                catch (Exception e) {
                    throw new ContentException(RB.getStringResource("ImportMetadataUtil.nofindtargetroot.txt", this.operation.getLocale()));
                }
            }
            this.targetReposId = this.getRepositoryIdFromObject(id);
        }
        return this.targetReposId;
    }

    protected void setCreatedModifiedBy(List<T> nodes) throws ContentException {
        ChildServerInterface childServer = null;
        try {
            childServer = this.metaTemplate.getServer().newChild(true);
            int count = 0;
            for (TargetTransportNode node : nodes) {
                MetadataInterface mi;
                String targetId = node.getTargetId();
                if (targetId == null || (mi = childServer.fetch(node.getTargetId())) == null) continue;
                CMetadata meta = (CMetadata)mi.getRepositoryEntity();
                MdResponsibilitiesUtil.setCreatedModifiedByValues((CMetadata)meta, (boolean)TransportUtil.isCreating((TargetTransportNode)node));
                if (++count < 50) continue;
                childServer.flush();
                count = 0;
            }
            if (count > 0 && childServer != null) {
                childServer.flush();
            }
        }
        catch (Exception e) {
            throw new ContentException((Throwable)e);
        }
        finally {
            if (childServer != null) {
                try {
                    childServer.rollback();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void importMetadata(List<T> nodes, String transportMetadata, String deployMap) throws ContentException {
        if (log.isDebugEnabled()) {
            log.debug(RB.getStringResource("ImportMetadataUtil.submittingimport.txt"));
        }
        MdOMRConnection connection = null;
        IMetadataTransport transport = null;
        try {
            deployMap = this.getUpdatedDeployMap(deployMap, nodes);
            UserContextInterface user22 = this.metaTemplate.getUserContext();
            OMIServer server = (OMIServer)user22.getAuthServer();
            MdFactory factory = server.getMdFactory();
            connection = factory.getConnection();
            transport = connection.makeIMetadataTransportConnection(connection.getCMRHandle());
            StringHolder outMetadata = new StringHolder();
            transport.ImportMetadata(transportMetadata, deployMap, outMetadata, "SAS", 0, "");
            transportMetadata = null;
            deployMap = null;
            this.processOutput(nodes, outMetadata.value);
            if (transport == null) return;
            if (connection == null) return;
        }
        catch (Exception ex) {
            try {
                throw new FatalContentException(ex.getMessage());
            }
            catch (Throwable throwable) {
                if (transport == null) throw throwable;
                if (connection == null) throw throwable;
                try {
                    connection.closeIMetadataTransportConnection(transport);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            connection.closeIMetadataTransportConnection(transport);
            return;
        }
        catch (Exception user22) {
            return;
        }
    }

    private void cacheNestedNodes(Map<String, T> importCache, T node) {
        List nestedNodes = node.getNestedNodes();
        if (nestedNodes != null) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof TargetTransportNode)) continue;
                OMRRepositoryKey key = new OMRRepositoryKey(nestedNode.getId());
                importCache.put(key.getId(), (TargetTransportNode)nestedNode);
                this.cacheNestedNodes(importCache, (TargetTransportNode)nestedNode);
            }
        }
    }

    String getUpdatedDeployMap(String deployMap, List<T> nodes) throws ContentException {
        if (log.isDebugEnabled()) {
            log.debug(RB.getStringResource("ImportMetadataUtil.updatingdeploymap.txt"));
        }
        Map<String, T> importCache = this.getNodeMap(nodes);
        Map<String, ConnectionPoint> cpCache = this.getConnectionPointMap(importCache);
        StringReader sr = null;
        XMLEventReader eventReader = null;
        try {
            StringWriter sw = new StringWriter();
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(sw);
            sr = new StringReader(deployMap);
            deployMap = null;
            eventReader = this.inputFactory.createXMLEventReader(sr);
            int currentLevel = 0;
            boolean processingObject = false;
            boolean processingConnection = false;
            boolean processingRepository = false;
            boolean processingSubstitution = false;
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 7: {
                        writer.add(this.eventFactory.createStartDocument());
                        break;
                    }
                    case 1: {
                        StartElement se = e.asStartElement();
                        if (currentLevel == 0) {
                            writer.add(this.eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                            this.updateRepositoryMapping(writer, importCache);
                        } else if (currentLevel == 1) {
                            String tagName = se.getName().getLocalPart();
                            if ("Objects".equals(tagName)) {
                                processingObject = true;
                            } else if ("Connections".equals(tagName)) {
                                processingConnection = true;
                            } else {
                                if ("ReposMap".equals(tagName)) {
                                    ++currentLevel;
                                    processingRepository = true;
                                    break;
                                }
                                if ("Substitutions".equals(tagName)) {
                                    processingSubstitution = true;
                                }
                            }
                            writer.add(this.eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        } else if (currentLevel > 1) {
                            StartElement updatedElement = null;
                            if (processingObject) {
                                boolean isTopLevel = currentLevel == 2;
                                updatedElement = this.updatePublicObject(se, isTopLevel, importCache);
                            } else if (processingConnection) {
                                updatedElement = this.updateConnectionPoint(se, cpCache);
                            } else {
                                if (processingRepository) {
                                    ++currentLevel;
                                    break;
                                }
                                if (processingSubstitution) {
                                    ++currentLevel;
                                    break;
                                }
                            }
                            if (updatedElement != null) {
                                writer.add(updatedElement);
                            } else {
                                writer.add(se);
                            }
                        } else {
                            writer.add(this.eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        EndElement ee = e.asEndElement();
                        if (--currentLevel == 1) {
                            String tagName = ee.getName().getLocalPart();
                            if ("Objects".equals(tagName)) {
                                processingObject = false;
                            } else if ("Connections".equals(tagName)) {
                                processingConnection = false;
                            } else if ("Substitutions".equals(tagName)) {
                                this.updateServerSubstitutions(writer);
                            } else if ("ReposMap".equals(tagName)) {
                                processingRepository = false;
                                break;
                            }
                        } else if (currentLevel > 1) {
                            if (processingObject) {
                                boolean isTopLevel = currentLevel == 2;
                                this.endPublicObjectUpdate(isTopLevel, writer, importCache);
                            } else if (processingRepository || processingSubstitution) break;
                        }
                        writer.add(this.eventFactory.createEndElement(ee.getName(), ee.getNamespaces()));
                        break;
                    }
                    case 8: {
                        writer.add(this.eventFactory.createEndDocument());
                    }
                }
            }
            writer.flush();
            writer.close();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(RB.getStringResource("ImportMetadataUtil.parsingerror.txt"), (Throwable)e);
            }
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                log.debug(RB.getStringResource("ExportMetadataUtil.closingerror.txt"));
            }
        }
    }

    private Map<String, ConnectionPoint> getConnectionPointMap(Map<String, T> importCache) {
        HashMap<String, ConnectionPoint> cpCache = new HashMap<String, ConnectionPoint>();
        for (Map.Entry<String, T> entry : importCache.entrySet()) {
            TargetTransportNode node = (TargetTransportNode)entry.getValue();
            List connections = node.getConnectionPoints();
            if (connections == null) continue;
            for (ConnectionPoint pt : connections) {
                OMRRepositoryKey key = new OMRRepositoryKey(pt.getSourceId());
                if (cpCache.containsKey(key.getId())) continue;
                cpCache.put(key.getId(), pt);
            }
        }
        return cpCache;
    }

    private Map<String, T> getNodeMap(List<T> nodes) {
        HashMap<String, TargetTransportNode> importCache = new HashMap<String, TargetTransportNode>(nodes.size());
        for (TargetTransportNode node : nodes) {
            OMRRepositoryKey key = new OMRRepositoryKey(node.getId());
            importCache.put(key.getId(), node);
            this.cacheNestedNodes(importCache, node);
        }
        return importCache;
    }

    private void processOutput(List<T> nodes, String output) throws ContentException {
        Map<String, String> idMap = this.parseObjectIDs(output);
        for (TargetTransportNode node : nodes) {
            String targetId = idMap.get(node.getId());
            if (targetId == null) continue;
            node.setTargetId(targetId);
            this.processOutput_NestedNodes(node.getNestedNodes(), idMap);
        }
        Map<String, String> pathMap = this.getTargetPaths(nodes);
        List allNodes = this.operation.getOperationNodes();
        for (TargetTransportNode node : allNodes) {
            this.setConnectionPointTargetIds(node, idMap, pathMap);
        }
    }

    private void setConnectionPointTargetIds(T node, Map<String, String> idMap, Map<String, String> pathMap) {
        List connections = node.getConnectionPoints();
        if (connections != null) {
            for (ConnectionPoint pt : connections) {
                String targetPath;
                String targetId;
                String sourceId;
                if (pt.isActive() || pt.getTargetId() != null || !idMap.containsKey(sourceId = pt.getSourceId()) || (targetId = idMap.get(sourceId)) == null) continue;
                pt.setTargetId(targetId);
                if (!(pt instanceof ContentConnectionPoint) || (targetPath = ((ContentConnectionPoint)pt).getTargetPath()) != null || pathMap == null) continue;
                String theTargetPath = pathMap.get(targetId);
                ((ContentConnectionPoint)pt).setTargetPath(theTargetPath);
            }
        }
    }

    private void processOutput_NestedNodes(List<Nested> nestedNodes, Map<String, String> idMap) {
        if (nestedNodes != null && !nestedNodes.isEmpty()) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof TargetTransportNode)) continue;
                String targetId = idMap.get(nestedNode.getId());
                if (targetId != null) {
                    ((TargetTransportNode)nestedNode).setTargetId(targetId);
                }
                List list = ((TargetTransportNode)nestedNode).getNestedNodes();
                this.processOutput_NestedNodes(list, idMap);
            }
        }
    }

    private Map<String, String> parseObjectIDs(String outputXML) throws ContentException {
        ImportOutputParser parser = new ImportOutputParser();
        try {
            XMLUtil.parseXML((String)outputXML, (DefaultHandler)parser);
        }
        catch (FinishedParsingException finishedParsingException) {
        }
        catch (SAXException e) {
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
        return parser.getDeployedObjectsMap();
    }

    private Map<String, String> getTargetPaths(List<T> nodes) throws ContentException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (TargetTransportNode node : nodes) {
            result.put(node.getTargetId(), node.getTargetPath());
        }
        return result;
    }

    private void updateRepositoryMapping(XMLEventWriter writer, Map<String, T> importCache) throws XMLStreamException, ContentException {
        if (log.isDebugEnabled()) {
            log.debug(RB.getStringResource("ImportMetadataUtil.initrepomappings.txt"));
        }
        this.objectReposMap = new HashMap<String, String>();
        String defaultReposId = this.getTargetRepositoryId();
        for (Map.Entry<String, T> entry : importCache.entrySet()) {
            String targetId;
            String reposId = null;
            TargetTransportNode node = (TargetTransportNode)entry.getValue();
            if (node instanceof Nested) continue;
            if (TransportUtil.isCreating((TargetTransportNode)node)) {
                Container container = node.getContainer();
                while (container != null && container instanceof TargetTransportNode) {
                    TargetTransportNode containerNode = (TargetTransportNode)container;
                    if (TransportUtil.isOverwriting((TargetTransportNode)containerNode) && containerNode.getTargetId() != null) {
                        reposId = this.getRepositoryIdFromObject(containerNode.getTargetId());
                        break;
                    }
                    container = containerNode.getContainer();
                }
            } else if (TransportUtil.isOverwriting((TargetTransportNode)node) && (targetId = node.getTargetId()) != null) {
                reposId = this.getRepositoryIdFromObject(targetId);
            }
            if (reposId == null || reposId.equalsIgnoreCase(defaultReposId)) continue;
            this.objectReposMap.put(node.getId(), reposId);
        }
        QName repositoriesTagName = QName.valueOf("Repositories");
        writer.add(this.eventFactory.createStartElement(repositoriesTagName, null, null));
        this.addTargetRepositoryMapping(writer, defaultReposId);
        if (this.objectReposMap != null && !this.objectReposMap.isEmpty()) {
            LinkedHashSet<String> targetReposSet = new LinkedHashSet<String>(this.objectReposMap.values());
            for (String reposID : targetReposSet) {
                this.addTargetRepositoryMapping(writer, reposID);
            }
        }
        writer.add(this.eventFactory.createEndElement(repositoriesTagName, null));
    }

    private String getRepositoryIdFromObject(String objectId) {
        OMRRepositoryKey key = new OMRRepositoryKey(objectId);
        String objId = key.getId();
        return "A0000001." + objId.substring(0, 8);
    }

    private void addTargetRepositoryMapping(XMLEventWriter writer, String reposID) throws XMLStreamException {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(this.eventFactory.createAttribute("Id", reposID));
        QName targetReposTag = QName.valueOf("Target");
        writer.add(this.eventFactory.createStartElement(targetReposTag, attrs.iterator(), null));
        writer.add(this.eventFactory.createEndElement(targetReposTag, null));
    }

    private StartElement updatePublicObject(StartElement se, boolean isTopLevel, Map<String, T> importCache) throws ServiceException, RemoteException {
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return se;
        }
        HashMap<QName, Attribute> attrs = new HashMap<QName, Attribute>(8);
        Iterator<Attribute> iter = se.getAttributes();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            if (ParsingConstants.ATTRIBUTE_QNAME_PATH.equals(attr.getName()) || ParsingConstants.ATTRIBUTE_QNAME_DESC.equals(attr.getName())) continue;
            attrs.put(attr.getName(), attr);
        }
        String metadataId = idAttr.getValue();
        TargetTransportNode node = (TargetTransportNode)importCache.get(metadataId);
        if (node == null || TransportUtil.isDisabled((TargetTransportNode)node)) {
            this.setObjectAction(attrs, "No", null);
        } else {
            if (isTopLevel) {
                ContainerNode container;
                this.currentObjectId = idAttr.getValue();
                String id = node.getId();
                if (this.objectReposMap != null && this.objectReposMap.containsKey(id)) {
                    attrs.put(ParsingConstants.ATTRIBUTE_QNAME_NEW_REPOSITORY, this.eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_NEW_REPOSITORY, this.objectReposMap.get(id)));
                }
                if (this.operation.hasNodeMoved(node) && (container = this.operation.getNewContainerForNode(node)) != null) {
                    String containerPath = ((ContentNode)container.getContentObject()).getPath();
                    PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.metaTemplate.getServer(), (String)containerPath);
                    MetadataInterface mi = this.metaTemplate.getServer().getObjectByPath(url);
                    if (mi instanceof FolderInterface) {
                        if (log.isDebugEnabled()) {
                            log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ImportMetadataUtil.reparenting.fmt.txt", (Object)node.getName(), (Object)url.getDisplayPath()));
                        }
                        attrs.put(ParsingConstants.ATTRIBUTE_QNAME_NEW_PARENTFOLDER, this.eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_NEW_PARENTFOLDER, mi.getIdentifier()));
                    }
                }
            }
            if (TransportUtil.isOverwriting((TargetTransportNode)node)) {
                if (isTopLevel) {
                    if (node.getTargetId() == null) {
                        // empty if block
                    }
                    if (this.isMergingNode(node)) {
                        this.setObjectAction(attrs, "Merge", node.getTargetId());
                    } else {
                        this.setObjectAction(attrs, "Update", node.getTargetId());
                    }
                } else if (this.isMergeSupported()) {
                    this.setObjectAction(attrs, "Update", node.getTargetId());
                }
            }
        }
        return this.eventFactory.createStartElement(se.getName(), attrs.values().iterator(), null);
    }

    private void setObjectAction(Map<QName, Attribute> attrs, String action, String targetID) {
        attrs.put(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION, this.eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION, action));
        if (targetID != null) {
            OMRRepositoryKey key = new OMRRepositoryKey(targetID);
            attrs.put(ParsingConstants.ATTRIBUTE_QNAME_DEPLOY_ID, this.eventFactory.createAttribute(ParsingConstants.ATTRIBUTE_QNAME_DEPLOY_ID, key.getId()));
        }
    }

    private void endPublicObjectUpdate(boolean isTopLevel, XMLEventWriter writer, Map<String, T> importCache) throws XMLStreamException, ServiceException, RemoteException {
        if (isTopLevel && this.currentObjectId != null) {
            TargetTransportNode node;
            if (this.isMergeSupported() && (node = (TargetTransportNode)importCache.get(this.currentObjectId)) != null && TransportUtil.isOverwriting((TargetTransportNode)node)) {
                this.updateObjectMergeSettings(node, writer);
            }
            this.currentObjectId = null;
        }
    }

    private void updateObjectMergeSettings(T node, XMLEventWriter writer) throws XMLStreamException, ServiceException, RemoteException {
        if (this.containsDeletedItems((TargetTransportNode)node)) {
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
            attrs.add(this.eventFactory.createAttribute("Name", DELETE_IN_TARGET));
            QName tagName = QName.valueOf("Nested");
            writer.add(this.eventFactory.createStartElement(tagName, attrs.iterator(), null));
            this.processDeletedItems((TargetTransportNode)node, writer);
            writer.add(this.eventFactory.createEndElement(tagName, null));
        }
    }

    private boolean containsDeletedItems(TargetTransportNode node) {
        List nestedNodes = node.getNestedNodes();
        if (nestedNodes != null) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof TargetTransportNode)) continue;
                if (TransportUtil.isObjectStateSet((TargetTransportNode)((TargetTransportNode)nestedNode), (int)8)) {
                    return true;
                }
                if (!this.containsDeletedItems((TargetTransportNode)nestedNode)) continue;
                return true;
            }
        }
        return false;
    }

    private void processDeletedItems(TargetTransportNode node, XMLEventWriter writer) throws XMLStreamException, ServiceException, RemoteException {
        for (Nested nested : node.getNestedNodes()) {
            TargetTransportNode nestedNode = (TargetTransportNode)nested;
            if (TransportUtil.isObjectStateSet((TargetTransportNode)nestedNode, (int)8)) {
                this.addDeletedItem(nestedNode, writer);
            }
            if (nestedNode.getNestedNodes() == null) continue;
            this.processDeletedItems(nestedNode, writer);
        }
    }

    private void addDeletedItem(TargetTransportNode node, XMLEventWriter writer) throws XMLStreamException, ServiceException, RemoteException {
        String id = node.getId();
        String typeName = this.getPublicTypeFromObjectType(node.getObjectType());
        String targetID = node.getTargetId();
        TypeDescriptorInterface typeDescriptor = this.metaTemplate.getServer().getTypeDescriptor(typeName);
        if (id == null || typeName == null || targetID == null || typeDescriptor == null) {
            return;
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(3);
        attrs.add(this.eventFactory.createAttribute("Id", new OMRRepositoryKey(id).getId()));
        attrs.add(this.eventFactory.createAttribute("PublicType", typeName));
        attrs.add(this.eventFactory.createAttribute("Deploy_Id", new OMRRepositoryKey(targetID).getId()));
        String metadataType = typeDescriptor.getMetadataType();
        QName tagName = QName.valueOf(metadataType);
        writer.add(this.eventFactory.createStartElement(tagName, attrs.iterator(), null));
        writer.add(this.eventFactory.createEndElement(tagName, null));
    }

    private String getPublicTypeFromObjectType(long objectTypeId) {
        ObjectType type = this.objectTypeService.getTypeById(objectTypeId);
        return type == null ? null : type.getName();
    }

    private StartElement updateConnectionPoint(StartElement se, Map<String, ConnectionPoint> cpCache) {
        String targetID;
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return se;
        }
        HashMap<QName, Attribute> attrs = new HashMap<QName, Attribute>(8);
        Iterator<Attribute> iter = se.getAttributes();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            if (ParsingConstants.ATTRIBUTE_QNAME_SEARCH.equals(attr.getName()) || ParsingConstants.ATTRIBUTE_QNAME_CONNACTION.equals(attr.getName()) || ParsingConstants.ATTRIBUTE_QNAME_DESC.equals(attr.getName())) continue;
            attrs.put(attr.getName(), attr);
        }
        ConnectionPoint pt = cpCache.get(idAttr.getValue());
        if (pt != null && (targetID = pt.getTargetId()) != null && !targetID.isEmpty()) {
            Attribute actionAttr;
            OMRRepositoryKey key = new OMRRepositoryKey(targetID);
            attrs.put(ParsingConstants.ATTRIBUTE_QNAME_DEPLOY_ID, this.eventFactory.createAttribute("Deploy_Id", key.getId()));
            if (pt.isActive() && (actionAttr = (Attribute)attrs.get(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION)) != null && "Ignore".equalsIgnoreCase(actionAttr.getValue())) {
                attrs.remove(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION);
            }
        }
        return this.eventFactory.createStartElement(se.getName(), attrs.values().iterator(), null);
    }

    private void updateServerSubstitutions(XMLEventWriter writer) throws XMLStreamException {
        if (this.substitutionsList == null || this.substitutionsList.isEmpty()) {
            return;
        }
        for (ServerSubstitution sub : this.substitutionsList) {
            TargetTransportNode node = sub.getNode();
            if (node == null) continue;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(2);
            attrs.add(this.eventFactory.createAttribute("Id", node.getId()));
            attrs.add(this.eventFactory.createAttribute(sub.getAttributeName(), sub.getAttributeValue()));
            OMRRepositoryKey key = new OMRRepositoryKey(node.getId());
            QName name = QName.valueOf(key.getType());
            writer.add(this.eventFactory.createStartElement(name, attrs.iterator(), null));
            writer.add(this.eventFactory.createEndElement(name, null));
        }
    }

    private class ServerSubstitution {
        TargetTransportNode node = null;
        String attributeName = null;
        String attributeValue = null;

        public ServerSubstitution(TargetTransportNode node, String attributeName, String attributeValue) {
            this.node = node;
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
        }

        public TargetTransportNode getNode() {
            return this.node;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }
    }
}

