/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IMetadataTransport;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionPointFactory;
import com.sas.svcs.content.lifecycle.dao.omr.ParsingConstants;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;

public abstract class AbstractExportMetadataUtil<T extends TransportNode> {
    private static final Logger log = LogManager.getLogger(AbstractExportMetadataUtil.class);
    protected ObjectTypeService objectTypeService;
    protected MetadataTemplate metadataTemplate;
    protected Map<String, T> nodeIndexCache = null;
    protected Map<String, T> nodeIdCache = null;

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void setMetadataTemplate(MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    protected abstract T createNestedNode();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RequestData exportMetadata(List<T> nodes) throws ContentException {
        RequestData requestData;
        if (log.isDebugEnabled()) {
            log.debug(RB.getStringResource("ExportMetadataUtil.submitting.txt"));
        }
        MdOMRConnection connection = null;
        IMetadataTransport transport = null;
        UserContextInterface user = this.metadataTemplate.getUserContext();
        String inputRequest = this.createExportRequest(nodes);
        try {
            RequestData data;
            OMIServer server = (OMIServer)user.getAuthServer();
            MdFactory factory = server.getMdFactory();
            connection = factory.getConnection();
            transport = connection.makeIMetadataTransportConnection(connection.getCMRHandle());
            StringHolder outTransport = new StringHolder();
            StringHolder outDeployMap = new StringHolder();
            transport.ExportMetadata(inputRequest, outTransport, outDeployMap, "SAS", 0, "");
            String transportXML = outTransport.value;
            String deployXML = outDeployMap.value;
            inputRequest = null;
            this.processDeployMap(nodes, deployXML);
            requestData = data = new RequestData(transportXML, deployXML);
            if (transport == null) return requestData;
            if (connection == null) return requestData;
        }
        catch (ServiceException ex) {
            try {
                throw new ContentException(ex.getMessage());
                catch (MdException ex2) {
                    throw new ContentException(ex2.getMessage());
                }
                catch (RemoteException ex3) {
                    throw new ContentException(ex3.getMessage(), (Throwable)ex3);
                }
                catch (GenericError ex4) {
                    throw new ContentException(ex4.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (transport == null) throw throwable;
                if (connection == null) throw throwable;
                try {
                    connection.closeIMetadataTransportConnection(transport);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            connection.closeIMetadataTransportConnection(transport);
            return requestData;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestData;
    }

    void processDeployMap(List<T> nodes, String deployXML) throws ContentException, ServiceException, RemoteException {
        this.nodeIdCache = new HashMap<String, T>(nodes.size());
        for (TransportNode node : nodes) {
            this.nodeIdCache.put(node.getId(), node);
        }
        this.nodeIndexCache = new HashMap<String, T>(nodes.size());
        XMLEventReader eventReader = null;
        ChildServerInterface childServer = null;
        try {
            childServer = this.metadataTemplate.getServer().newChild(true);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            eventReader = inputFactory.createXMLEventReader(new StringReader(deployXML));
            int currentLevel = 0;
            boolean processingObject = false;
            boolean processingConnection = false;
            Stack<T> nodeStack = new Stack<T>();
            block14: while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 1: {
                        StartElement se = e.asStartElement();
                        if (currentLevel == 1) {
                            if ("Objects".equals(se.getName().getLocalPart())) {
                                processingObject = true;
                            } else if ("Connections".equals(se.getName().getLocalPart())) {
                                processingConnection = true;
                            }
                        } else if (currentLevel > 1) {
                            if (processingObject) {
                                boolean isTopLevel = currentLevel == 2;
                                T node = this.parseNode(se, isTopLevel);
                                if (node != null) {
                                    if (!isTopLevel && !nodeStack.isEmpty()) {
                                        TransportNode parentItem = (TransportNode)nodeStack.get(nodeStack.size() - 1);
                                        this.setParentItem(parentItem, node);
                                    }
                                    nodeStack.push(node);
                                }
                            } else if (processingConnection) {
                                this.parseConnectionPoint(se, (ServerInterface)childServer);
                            }
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        EndElement ee;
                        if (--currentLevel == 1) {
                            ee = e.asEndElement();
                            if ("Objects".equals(ee.getName().getLocalPart())) {
                                processingObject = false;
                                break;
                            }
                            if (!"Connections".equals(ee.getName().getLocalPart())) continue block14;
                            processingConnection = true;
                            break;
                        }
                        if (!processingObject || currentLevel < 2 || "Nested".equalsIgnoreCase((ee = e.asEndElement()).getName().getLocalPart()) || nodeStack.isEmpty()) break;
                        nodeStack.pop();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ContentException((Throwable)e);
        }
        finally {
            deployXML = null;
            if (childServer instanceof ChildServerInterface) {
                childServer.destroy();
            }
            try {
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                log.warn(RB.getStringResource("ExportMetadataUtil.closingerror.txt"));
            }
        }
    }

    private T parseNode(StartElement se, boolean isTopLevel) {
        Attribute indexAttr;
        String metadataType = se.getName().getLocalPart();
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return null;
        }
        String id = this.getObjectId(idAttr.getValue(), metadataType);
        Object node = (TransportNode)this.nodeIdCache.get(id);
        if (node == null && !isTopLevel) {
            Attribute nameAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_NAME);
            Attribute typeAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PUBLICTYPE);
            if (nameAttr == null || typeAttr == null) {
                return null;
            }
            String publicType = typeAttr.getValue();
            ObjectType objType = this.objectTypeService.getTypeByName(publicType);
            if (objType != null) {
                node = this.createNestedNode();
                ContentComponent comp = new ContentComponent();
                node.setContentObject(comp);
                comp.setId(id);
                comp.setObjectType(objType.getId());
                comp.setObjectTypeName(objType.getName());
                comp.setName(nameAttr.getValue());
                Attribute descAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DESC);
                if (descAttr != null) {
                    comp.setDescription(descAttr.getValue());
                }
            }
        }
        if ((indexAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PO)) != null) {
            String sID = indexAttr.getValue();
            this.nodeIndexCache.put(sID, node);
        }
        return (T)node;
    }

    private void setParentItem(T parent, T child) {
        if (child instanceof Nested) {
            ((Nested)child).setParent(parent);
        }
    }

    private String getObjectId(String id, String metadataType) {
        return id + "/" + metadataType;
    }

    private void parseConnectionPoint(StartElement se, ServerInterface childServer) throws ServiceException, RemoteException {
        Attribute topLevelAttr;
        String value;
        String metadataType = se.getName().getLocalPart();
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        Attribute nameAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_NAME);
        if (metadataType == null || idAttr == null || nameAttr == null) {
            throw new IllegalStateException();
        }
        String desc = null;
        Attribute descAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DESC);
        if (descAttr != null && (value = descAttr.getValue()) != null && !value.isEmpty()) {
            desc = value;
        }
        String id = this.getObjectId(idAttr.getValue(), metadataType);
        ObjectType objType = null;
        String path = null;
        Attribute typeAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PUBLICTYPE);
        if (typeAttr != null) {
            String publicType = typeAttr.getValue();
            objType = this.objectTypeService.getTypeByName(publicType);
            path = this.getObjectPath(childServer, id);
        }
        ConnectionPoint pt = ConnectionPointFactory.createConnectionPoint((String)id, (String)nameAttr.getValue(), (String)desc, objType, path);
        Attribute internalAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION);
        if (internalAttr != null && "Ignore".equalsIgnoreCase(internalAttr.getValue())) {
            pt.addProperty("OMRAttribute_Internal", Boolean.TRUE.toString());
            pt.setActive(false);
        }
        if ((topLevelAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_CPO)) != null && topLevelAttr.getValue().length() > 0) {
            this.setAssociatedObjects(pt, topLevelAttr.getValue());
        }
    }

    private String getObjectPath(ServerInterface childServer, String id) throws ServiceException, RemoteException {
        PathUrl url;
        MetadataInterface mi;
        String path = null;
        TransportNode node = (TransportNode)this.nodeIdCache.get(id);
        if (node != null && node.getContentObject() instanceof ContentNode) {
            ContentNode contentNode = (ContentNode)node.getContentObject();
            path = contentNode.getPath();
        }
        if (path == null && (mi = childServer.fetch(id)) != null && (url = mi.getPathUrl()) != null) {
            path = url.getDisplayPath();
        }
        return path;
    }

    private void setAssociatedObjects(ConnectionPoint pt, String objectKeys) {
        if (objectKeys == null) {
            return;
        }
        if (objectKeys.indexOf(91) > -1) {
            String s = objectKeys.substring(objectKeys.indexOf(91) + 1, objectKeys.indexOf(93));
            StringTokenizer st = new StringTokenizer(s, " ");
            while (st.hasMoreTokens()) {
                this.setAssociatedObject(pt, st.nextToken());
            }
        } else {
            this.setAssociatedObject(pt, objectKeys);
        }
    }

    private void setAssociatedObject(ConnectionPoint pt, String objectKey) {
        TransportNode node = (TransportNode)this.nodeIndexCache.get(objectKey);
        if (node != null) {
            node.addConnectionPoint(pt);
        }
    }

    private String createExportRequest(List<T> nodes) {
        StringBuilder builder = new StringBuilder(nodes.size() * 50);
        for (TransportNode node : nodes) {
            OMRRepositoryKey reposKey = new OMRRepositoryKey(node.getId());
            String ident = reposKey.getId();
            String type = reposKey.getType();
            builder.append("<" + type + " Id=\"" + ident + "\"/>");
        }
        return builder.toString();
    }

    protected static class RequestData {
        String transportMetadata;
        String deployMap;

        public RequestData(String transportMetadata, String deployMap) {
            this.transportMetadata = transportMetadata;
            this.deployMap = deployMap;
        }

        public String getTransportMetadata() {
            return this.transportMetadata;
        }

        public String getDeployMap() {
            return this.deployMap;
        }
    }
}

