/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util.pv2xml;

import com.sas.PublicClonable;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.UserInfo;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;

public final class XPath2PromptBindings {
    private Map<String, MutableUserInfoInterface> bindings = new HashMap<String, MutableUserInfoInterface>();
    static final String XPATH = "XPath";
    public static final String NAMESPACE_PREFIX = "namespacePrefix";
    public static final String NAMESPACE_URI = "namespaceURI";
    public static final String MAXIMUM_ELEMENT_NAME = "maxElementName";
    public static final String MAXIMUM_ELEMENT_XPATH = "maxElementXPath";
    static final String ELEMENT_NAME = "elementName";
    static final String PARENTS_XPATH = "parentsXPath";

    MutableUserInfoInterface get(String promptID) {
        return this.bindings.get(promptID);
    }

    public void remove(String promptID) {
        this.bindings.remove(promptID);
    }

    Set<Map.Entry<String, MutableUserInfoInterface>> entrySet() {
        return this.bindings.entrySet();
    }

    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    public void add(@NotNull String promptID, @NotNull String xpath, @NotNull String elementName, @NotNull String parentsXPath, MutableUserInfoInterface userInfo) {
        ValidateArg.notNull((Object)promptID, (String)"promptID");
        ValidateArg.notNull((Object)xpath, (String)"xpath");
        ValidateArg.notNull((Object)elementName, (String)ELEMENT_NAME);
        ValidateArg.notNull((Object)parentsXPath, (String)PARENTS_XPATH);
        UserInfo thisUserInfo = null;
        if (null != userInfo) {
            try {
                thisUserInfo = (MutableUserInfoInterface)((PublicClonable)userInfo).clone();
            }
            catch (CloneNotSupportedException e) {
                thisUserInfo = new UserInfo();
                e.printStackTrace();
            }
        } else {
            thisUserInfo = new UserInfo();
        }
        thisUserInfo.put(XPATH, xpath);
        thisUserInfo.put(ELEMENT_NAME, elementName);
        thisUserInfo.put(PARENTS_XPATH, parentsXPath);
        this.bindings.put(promptID, (MutableUserInfoInterface)thisUserInfo);
    }

    public static XPath2PromptBindings newBindings(String theXML) throws XMLStreamException {
        Field[] fields = XPath2PromptBindings.class.getFields();
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(theXML.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(xmlStream);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)reader);
        OMElement element = builder.getDocumentElement();
        XPath2PromptBindings bindings = null;
        if (element.getLocalName().equals("Bindings")) {
            bindings = new XPath2PromptBindings();
            Iterator it = element.getChildrenWithLocalName("Binding");
            while (it.hasNext()) {
                OMElement child = (OMElement)it.next();
                String promptID = child.getAttributeValue(new QName("promptID"));
                String xpath = child.getAttributeValue(new QName(XPATH));
                String elementName = child.getAttributeValue(new QName(ELEMENT_NAME));
                String parentsXPath = child.getAttributeValue(new QName(PARENTS_XPATH));
                UserInfo userInfo = new UserInfo();
                for (int i = 0; i < fields.length; ++i) {
                    try {
                        String key = (String)fields[i].get(null);
                        String value = child.getAttributeValue(new QName(key));
                        if (null == value) continue;
                        userInfo.put(key, value);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                bindings.add(promptID, xpath, elementName, parentsXPath, (MutableUserInfoInterface)userInfo);
            }
        }
        return bindings;
    }

    public String write() {
        Field[] fields = XPath2PromptBindings.class.getFields();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement parent = factory.createOMElement("Bindings", null);
        parent.addAttribute("version", "1.0", null);
        Set<Map.Entry<String, MutableUserInfoInterface>> set = this.entrySet();
        for (Map.Entry<String, MutableUserInfoInterface> entry : set) {
            OMElement child = factory.createOMElement("Binding", null);
            child.addAttribute("promptID", entry.getKey(), null);
            MutableUserInfoInterface map = entry.getValue();
            child.addAttribute(XPATH, map.get(XPATH), null);
            child.addAttribute(ELEMENT_NAME, map.get(ELEMENT_NAME), null);
            child.addAttribute(PARENTS_XPATH, map.get(PARENTS_XPATH), null);
            for (int i = 0; i < fields.length; ++i) {
                try {
                    String key = (String)fields[i].get(null);
                    String value = map.get(key);
                    if (null == value) continue;
                    child.addAttribute(key, value, null);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            parent.addChild((OMNode)child);
        }
        return parent.toString();
    }
}

