/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.util.pv2xml;

import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.FindPromptValuesByPromptDefinitionIDVisitor;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.util.pv2xml.XPath2PromptBindings;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;

public final class PromptValuesInterchange {
    private PromptValuesInterchange() {
    }

    public static void setPromptValuesFromOMElementValues(@NotNull XPath2PromptBindings xpBindings, @NotNull PromptValues promptValues, @NotNull OMElement element, Locale locale) throws InvalidPromptValueException {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        ValidateArg.notNull((Object)element, (String)"element");
        ValidateArg.notNull((Object)xpBindings, (String)"xpBindings");
        CommonLoggerInterface logger = new Log4JFactory2().makeNewLoggerInstance(PromptValuesInterchange.class.getName());
        if (!xpBindings.isEmpty()) {
            Set<Map.Entry<String, MutableUserInfoInterface>> set = xpBindings.entrySet();
            for (Map.Entry<String, MutableUserInfoInterface> entry : set) {
                String promptID = entry.getKey();
                MutableUserInfoInterface map = entry.getValue();
                FindPromptValuesByPromptDefinitionIDVisitor visitor = new FindPromptValuesByPromptDefinitionIDVisitor(promptID);
                promptValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
                PromptValuesInterface pv = visitor.getPromptValues();
                if (null != pv) {
                    try {
                        List<OMElement> listOfValueNodes;
                        PromptDefinitionInterface prompt = visitor.getPromptDefinition();
                        String name = prompt.getPromptName();
                        if (null == name) {
                            name = prompt.getPromptID();
                        }
                        logger.debug("setOMElementFromPromptValues() for prompt", name);
                        logger.debug("The binding data is", map.toString());
                        if (prompt instanceof BaseDefinitionRangeInterface) {
                            logger.debug("setting prompt value from range elements");
                            PromptValuesInterchange.setFromRangeElements(pv, prompt, map, element, logger, locale);
                            continue;
                        }
                        DataTypeInterface dataType = prompt.getPromptDataType();
                        if (dataType instanceof CollectionType) {
                            dataType = ((CollectionType)dataType).getTypeOfData();
                        }
                        if ((listOfValueNodes = PromptValuesInterchange.getListOfValueNodes(element, map)).isEmpty()) {
                            pv.clearPromptValue(prompt);
                            logger.debug("Clearing the prompt value as nothing was found in the XML for this prompt ID: ", promptID);
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (OMElement e : listOfValueNodes) {
                            list.add(dataType.coerceValue((Object)e.getText(), locale));
                            logger.debug("Got a value from the XML. count is:", Integer.toString(list.size() + 1));
                        }
                        pv.setPromptValue(prompt, list);
                        continue;
                    }
                    catch (JaxenException e) {
                        throw new IllegalStateException(e);
                    }
                }
                logger.info("No prompt value was found for the prompt with this ID: " + promptID);
            }
        } else {
            logger.info("The bindings object was empty.");
        }
    }

    private static List<OMElement> getListOfValueNodes(OMElement element, MutableUserInfoInterface map) throws JaxenException {
        AXIOMXPath xpathExpression = new AXIOMXPath(map.get("XPath"));
        Iterator it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            xpathExpression.addNamespace(ns.getPrefix(), ns.getNamespaceURI());
        }
        List listOfValueNodes = xpathExpression.selectNodes((Object)element);
        return listOfValueNodes;
    }

    public static void setDOMElementFromPromptValues(@NotNull XPath2PromptBindings xpBindings, @NotNull PromptValues promptValues, @NotNull Element element, Locale locale) {
        OMElement omE = null;
        try {
            omE = PromptValuesInterchange.convertToOM(element);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        PromptValuesInterchange.setOMElementValuesFromPromptValues(xpBindings, promptValues, omE, locale);
    }

    public static String setXMLFromPromptValues(@NotNull XPath2PromptBindings xpBindings, @NotNull PromptValues promptValues, @NotNull String xmlString, Locale locale) throws XMLStreamException {
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(xmlString.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(xmlStream);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)reader);
        OMElement element = builder.getDocumentElement();
        PromptValuesInterchange.setOMElementValuesFromPromptValues(xpBindings, promptValues, element, locale);
        StringWriter writer = new StringWriter();
        element.serializeAndConsume((Writer)writer);
        return ((Object)writer).toString();
    }

    public static void setOMElementValuesFromPromptValues(@NotNull XPath2PromptBindings xpBindings, @NotNull PromptValues promptValues, @NotNull OMElement element, Locale locale) {
        ValidateArg.notNull((Object)promptValues, (String)"promptValues");
        ValidateArg.notNull((Object)element, (String)"element");
        ValidateArg.notNull((Object)xpBindings, (String)"xpBindings");
        CommonLoggerInterface logger = new Log4JFactory2().makeNewLoggerInstance(PromptValuesInterchange.class.getName());
        if (!xpBindings.isEmpty()) {
            Set<Map.Entry<String, MutableUserInfoInterface>> set = xpBindings.entrySet();
            for (Map.Entry<String, MutableUserInfoInterface> entry : set) {
                String promptID = entry.getKey();
                MutableUserInfoInterface map = entry.getValue();
                FindPromptValuesByPromptDefinitionIDVisitor visitor = new FindPromptValuesByPromptDefinitionIDVisitor(promptID);
                promptValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
                PromptValuesInterface pv = visitor.getPromptValues();
                if (null != pv) {
                    try {
                        OMElement e;
                        int i;
                        PromptDefinitionInterface prompt = visitor.getPromptDefinition();
                        String name = prompt.getPromptName();
                        if (null == name) {
                            name = prompt.getPromptID();
                        }
                        logger.debug("setOMElementFromPromptValues() for prompt", name);
                        logger.debug("The binding data is", map.toString());
                        if (prompt instanceof BaseDefinitionRangeInterface) {
                            logger.debug("setting OMElements from a range prompt");
                            PromptValuesInterchange.setFromRangePrompt(pv, prompt, map, element, logger);
                            continue;
                        }
                        List<OMElement> listOfValueNodes = PromptValuesInterchange.getListOfValueNodes(element, map);
                        List pvList = Collections.emptyList();
                        try {
                            pvList = pv.getPromptValueAsList(prompt);
                        }
                        catch (PromptValueNotFoundException e2) {
                            logger.info("Nothing was found in the promptValues so clearing the XML for this prompt ID: " + promptID);
                        }
                        DataTypeInterface dataType = prompt.getPromptDataType();
                        if (dataType instanceof CollectionType) {
                            dataType = ((CollectionType)dataType).getTypeOfData();
                        }
                        int valueNodesSize = listOfValueNodes.size();
                        int promptValuesSize = pvList.size();
                        if (promptValuesSize <= valueNodesSize) {
                            for (i = 0; i < valueNodesSize; ++i) {
                                e = listOfValueNodes.get(i);
                                if (i < promptValuesSize) {
                                    e.setText(dataType.getValueAsString(pvList.get(i), locale));
                                    logger.debug("Setting a value into the XML. index is:", Integer.toString(i));
                                    continue;
                                }
                                e.detach();
                                logger.debug("Removed an extra element from the XML. index is:", Integer.toString(i));
                            }
                            continue;
                        }
                        for (i = 0; i < promptValuesSize; ++i) {
                            if (i < valueNodesSize) {
                                e = listOfValueNodes.get(i);
                                e.setText(dataType.getValueAsString(pvList.get(i), locale));
                                logger.debug("Setting a value into the XML. index is:", Integer.toString(i));
                                continue;
                            }
                            OMElement eNew = PromptValuesInterchange.addElementToParent(element, map, "elementName");
                            eNew.setText(dataType.getValueAsString(pvList.get(i), locale));
                            logger.debug("Created a new element and added it.");
                            logger.debug("Setting a value into the XML. index is:", Integer.toString(i));
                        }
                        continue;
                    }
                    catch (JaxenException e) {
                        throw new IllegalStateException(e);
                    }
                }
                logger.info("No prompt value was found for the prompt with this ID: " + promptID);
            }
        } else {
            logger.info("The bindings object was empty.");
        }
    }

    private static void setFromRangePrompt(PromptValuesInterface pv, PromptDefinitionInterface prompt, MutableUserInfoInterface map, OMElement element, CommonLoggerInterface logger) throws JaxenException {
        String promptName = prompt.getPromptName();
        if (null == promptName) {
            promptName = prompt.getPromptID();
        }
        Object value = null;
        try {
            value = pv.getPromptValue(prompt);
        }
        catch (PromptValueNotFoundException e) {
            logger.info("Nothing was found in the promptValues so clearing the XML for this prompt ID: " + promptName);
        }
        BaseRangeDataType dataType = (BaseRangeDataType)prompt.getPromptDataType();
        logger.debug("setting range elements using data type of:", dataType.getClass().getName());
        OMElement[] retVal = PromptValuesInterchange.getMinMaxElements(map, element, promptName);
        if (null == retVal[0] || null == retVal[1]) {
            if (null == retVal[0]) {
                retVal[0] = PromptValuesInterchange.addElementToParent(element, map, "elementName");
                logger.debug("Created a new element for minimum and added it.");
            }
            if (null == retVal[1]) {
                retVal[1] = PromptValuesInterchange.addElementToParent(element, map, "maxElementName");
                logger.debug("Created a new element for maximum and added it.");
            }
        }
        if (null == value) {
            retVal[0].detach();
            retVal[1].detach();
            logger.debug("The min and max OMElements were detached.");
        } else {
            Object minValue = dataType.getMinimumValue(value);
            retVal[0].setText(minValue.toString());
            Object maxValue = dataType.getMaximumValue(value);
            retVal[1].setText(maxValue.toString());
            logger.debug("The min and max were set on OMElments");
        }
    }

    private static void setFromRangeElements(PromptValuesInterface pv, PromptDefinitionInterface prompt, MutableUserInfoInterface map, OMElement element, CommonLoggerInterface logger, Locale locale) throws JaxenException, InvalidPromptValueException {
        String promptName = prompt.getPromptName();
        if (null == promptName) {
            promptName = prompt.getPromptID();
        }
        OMElement[] retVal = PromptValuesInterchange.getMinMaxElements(map, element, promptName);
        BaseRangeDataType dataType = (BaseRangeDataType)prompt.getPromptDataType();
        logger.debug("setting value from range elements with data type of:", dataType.getClass().getName());
        if (null == retVal[0] || null == retVal[1]) {
            throw new JaxenException("Either the minimum element or the maximum element could not be found. Prompt value will not be set for " + promptName);
        }
        Object value = dataType.coerceRangeValues((Object)retVal[0].getText(), (Object)retVal[1].getText(), locale);
        if (PromptValuesInterchange.isGoodRangeValue(value)) {
            pv.setPromptValue(prompt, value, locale);
            logger.debug("Prompt value set from a good range value for this prompt:", promptName);
        } else {
            pv.clearPromptValue(prompt);
            logger.debug("Prompt range value cleared for this prompt:", promptName);
        }
    }

    private static OMElement[] getMinMaxElements(MutableUserInfoInterface map, OMElement element, String promptName) throws JaxenException {
        if (null == map.get("maxElementName") || null == map.get("maxElementXPath")) {
            throw new IllegalStateException("The element name or XPath are missing for the maximum of this range prompt: " + promptName);
        }
        AXIOMXPath xpathMin = new AXIOMXPath(map.get("XPath"));
        AXIOMXPath xpathMax = new AXIOMXPath(map.get("maxElementXPath"));
        Iterator it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            xpathMin.addNamespace(ns.getPrefix(), ns.getNamespaceURI());
            xpathMax.addNamespace(ns.getPrefix(), ns.getNamespaceURI());
        }
        OMElement min = (OMElement)xpathMin.selectSingleNode((Object)element);
        OMElement max = (OMElement)xpathMax.selectSingleNode((Object)element);
        OMElement[] retVal = new OMElement[]{min, max};
        return retVal;
    }

    private static boolean isGoodRangeValue(Object value) {
        Object[] x;
        boolean retVal = false;
        if (null != value && value instanceof Object[] && (x = (Object[])value).length == 2 && x[0] != null && x[1] != null) {
            retVal = true;
        }
        return retVal;
    }

    private static OMElement addElementToParent(OMElement element, MutableUserInfoInterface map, String elementName) throws JaxenException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        AXIOMXPath xpathParentExpression = new AXIOMXPath(map.get("parentsXPath"));
        Iterator itParent = element.getAllDeclaredNamespaces();
        while (itParent.hasNext()) {
            OMNamespace nsParent = (OMNamespace)itParent.next();
            xpathParentExpression.addNamespace(nsParent.getPrefix(), nsParent.getNamespaceURI());
        }
        OMElement parent = (OMElement)xpathParentExpression.selectSingleNode((Object)element);
        OMNamespace ns = null;
        if (map.contains("namespaceURI")) {
            ns = factory.createOMNamespace(map.get("namespaceURI"), map.get("namespacePrefix"));
        }
        OMElement child = factory.createOMElement(map.get(elementName), ns);
        parent.addChild((OMNode)child);
        return child;
    }

    public static void setPromptValuesFromDOMValues(@NotNull XPath2PromptBindings xpBindings, @NotNull PromptValues promptValues, @NotNull Element element, Locale locale) throws InvalidPromptValueException {
        OMElement omE = null;
        try {
            omE = PromptValuesInterchange.convertToOM(element);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        PromptValuesInterchange.setPromptValuesFromOMElementValues(xpBindings, promptValues, omE, locale);
    }

    public static void setPromptValuesFromXML(@NotNull XPath2PromptBindings xpBindings, @NotNull PromptValues promptValues, @NotNull String xmlString, Locale locale) throws XMLStreamException, InvalidPromptValueException {
        ValidateArg.notNull((Object)xmlString, (String)"xmlString");
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(xmlString.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(xmlStream);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)reader);
        OMElement element = builder.getDocumentElement();
        PromptValuesInterchange.setPromptValuesFromOMElementValues(xpBindings, promptValues, element, locale);
    }

    private static OMElement convertToOM(Element element) throws TransformerFactoryConfigurationError, TransformerException, XMLStreamException {
        DOMSource source = new DOMSource(element);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(source, result);
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(is);
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)reader);
        return builder.getDocumentElement();
    }
}

