/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.storedprocess;

import com.sas.beans.PropertyChangeSource;
import com.sas.beans.PropertyChangeSupport;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.ResultContainer;
import com.sas.prompts.storedprocess.StoredProcessMediatorImpl;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.storedprocess.Execution2Interface;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.ExecutionStatusListener2Interface;
import com.sas.util.ChainedException;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.List;

final class StoredProcessResultContainer
implements ResultContainer,
PropertyChangeSource,
ExecutionStatusListener2Interface {
    private Exception exception;
    private String executionLog = "";
    private int logLength = -1;
    private Execution2Interface output;
    private int status = -1;
    private LoggerFactoryInterface factory;
    private CommonLoggerInterface logger;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private StoredProcessMediatorImpl mediator;

    StoredProcessResultContainer(StoredProcessMediatorImpl mediator) {
        this.mediator = mediator;
    }

    public Exception getException() {
        if (null != this.output) {
            try {
                ExecutionException[] array = this.output.getExceptions();
                if (array.length > 0) {
                    this.exception = array[0];
                    this.getLogger().debug("getException() returning a single exception.");
                    if (array.length > 1) {
                        this.getLogger().debug("getException(), size of exceptions array is:", Integer.toString(array.length));
                    }
                }
            }
            catch (RemoteException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        if (null == this.exception) {
            this.getLogger().debug("getException() returns null.");
        }
        return this.exception;
    }

    public String getExecutionLog() {
        if ("".equals(this.executionLog)) {
            try {
                if (null != this.output && this.output.getStatus() != 1) {
                    this.executionLog = this.output.readSASLog(1, -1);
                    this.getLogger().debug("getExecutionLog() called output.readSASLog()");
                }
            }
            catch (TransportException e) {
                StringBuffer buf = ChainedException.printStackTrace((Throwable)e, (StringBuffer)new StringBuffer(), (boolean)true);
                this.executionLog = buf.toString();
            }
            catch (RemoteException e) {
                StringBuffer buf = ChainedException.printStackTrace((Throwable)e, (StringBuffer)new StringBuffer(), (boolean)true);
                this.executionLog = buf.toString();
            }
            catch (IllegalStateException e) {
                StringBuffer buf = ChainedException.printStackTrace((Throwable)e, (StringBuffer)new StringBuffer(), (boolean)true);
                this.executionLog = buf.toString();
            }
            if (null == this.executionLog) {
                this.executionLog = "";
            }
            this.logLength = this.executionLog.length();
        }
        return this.executionLog;
    }

    public int getLengthOfExecutionLog() {
        if (this.logLength == -1) {
            this.getExecutionLog();
        }
        return this.logLength;
    }

    public Object getOutput() {
        return this.output;
    }

    public int getStatus() {
        if (null != this.output) {
            try {
                int retVal = this.output.getStatus();
                this.getLogger().debug("getStatus() from output obj is", Integer.toString(retVal));
                return retVal;
            }
            catch (RemoteException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.status;
    }

    public LoggerFactoryInterface getLoggerFactory() {
        return this.factory;
    }

    public void setLoggerFactory(LoggerFactoryInterface factory) {
        this.factory = factory;
    }

    public final void setException(Exception exception) {
    }

    public final void setExecutionLog(String log) {
    }

    public final void setOutput(Object output) {
        ValidateArg.notNull((Object)output, (String)"output");
        if (!(output instanceof Execution2Interface)) {
            throw new IllegalArgumentException("This method requires an instance of Execution2Interface.");
        }
        this.output = (Execution2Interface)output;
    }

    public final void setStatus(int status) {
        this.pcs.firePropertyChange("status", this.status, status);
        this.status = status;
    }

    public boolean abort() {
        boolean retVal = false;
        if (this.isAsynchronous() && null != this.output) {
            try {
                this.output.abort();
                retVal = true;
            }
            catch (TransportException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        return retVal;
    }

    public void destroy() {
        if (null != this.output) {
            try {
                this.output.destroy();
            }
            catch (TransportException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            catch (ConnectionFactoryException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        this.logger = null;
    }

    public boolean isAsynchronous() {
        if (this.output != null) {
            try {
                boolean retVal = !this.output.isSynchronous();
                this.getLogger().debug("isAsynchronous() returns:", Boolean.toString(retVal));
                return retVal;
            }
            catch (RemoteException e) {
                this.getLogger().error("Exception thrown by Execution2Interface.isSynchronous()", (Throwable)e);
            }
        }
        return false;
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            if (null != this.factory) {
                this.logger = this.factory.makeNewLoggerInstance(this.getClass().getName());
            }
            this.logger = new Log4JFactory2().makeNewLoggerInstance(this.getClass().getName());
        }
        return this.logger;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void executionStatusChanged(Execution2Interface storedProcessExecution) throws RemoteException {
        int executionStatus = storedProcessExecution.getStatus();
        switch (executionStatus) {
            case 1: {
                this.getLogger().debug("executionStatusChanged() Execution started.");
                break;
            }
            default: {
                this.getLogger().debug("executionStatusChanged() completed:", Integer.toString(executionStatus));
                try {
                    this.mediator.setPromptValue(executionStatus);
                    if (storedProcessExecution.getStatus() == 3) {
                        List params = storedProcessExecution.getOutputParameters();
                        this.mediator.applyOutputs(params);
                    }
                }
                catch (InvalidPromptValueException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                    throw new RemoteException(e.getMessage());
                }
                catch (TransportException e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                    throw new RemoteException(e.getMessage());
                }
                this.setStatus(executionStatus);
            }
        }
    }
}

