/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.script.util;

import com.sas.prompts.script.ScriptCommand;
import com.sas.prompts.script.ScriptHolder;
import com.sas.prompts.script.util.DefaultScriptCommand;
import com.sas.prompts.script.util.GroovyReceiver;
import com.sas.prompts.script.util.Receiver;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;

public final class RemoteScriptCommandFactory {
    public static ScriptCommand newScriptCommand(@NotNull ScriptHolder scriptHolder, LoggerFactoryInterface factory) {
        ValidateArg.notNull((Object)scriptHolder, (String)"scriptHolder");
        ValidateArg.notNull((Object)scriptHolder.getType(), (String)"scriptHolder.getType()");
        ValidateArg.notNull((Object)scriptHolder.getScript(), (String)"scriptHolder.getScript()");
        if (scriptHolder.getScript().trim().length() == 0) {
            throw new IllegalArgumentException("Blank scripts are not allowed.");
        }
        DefaultScriptCommand retVal = null;
        String type = scriptHolder.getType();
        LoggerFactoryInterface logFactory = factory;
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)RemoteScriptCommandFactory.class.getName(), null);
        Receiver receiver = RemoteScriptCommandFactory.newReceiver(type, logger, logFactory);
        if (null != receiver) {
            retVal = new DefaultScriptCommand(receiver);
            retVal.setScript(scriptHolder.getScript());
        }
        return retVal;
    }

    private static Receiver newReceiver(String type, CommonLoggerInterface logger, LoggerFactoryInterface logFactory) {
        GroovyReceiver receiver = null;
        String upperType = type.toUpperCase();
        if ("GROOVY".equals(upperType)) {
            receiver = new GroovyReceiver();
            logger.debug("newScriptCommand(), Creating a Groovy command.");
        } else {
            logger.warn("newScriptCommand(), This is an unsupported type:", type);
        }
        return receiver;
    }
}

