/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.InvalidRecurrenceException;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.text.Message;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="YearlyRecurrence", propOrder={"monthDataBinding", "dayOfMonthDataBinding", "dayOfWeekDataBinding", "whichWeekDataBinding"})
public class YearlyRecurrence
extends AbstractRecurrence
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Month")
    protected int monthDataBinding = 1;
    @XmlElement(name="DayOfMonth")
    protected int dayOfMonthDataBinding = 1;
    @XmlElement(name="DayOfWeek")
    protected int dayOfWeekDataBinding = -1;
    @XmlElement(name="WhichWeek")
    protected int whichWeekDataBinding = -1;
    static final String XML_Yearly_Tag = "yearly";
    static final String XML_Month_of_Year = "month";
    static final String XML_Day_of_Month = "day";

    public int getMonthDataBinding() {
        return this.monthDataBinding;
    }

    public void setMonthDataBinding(int value) {
        this.monthDataBinding = value;
    }

    public int getDayOfMonthDataBinding() {
        return this.dayOfMonthDataBinding;
    }

    public void setDayOfMonthDataBinding(int value) {
        this.dayOfMonthDataBinding = value;
    }

    public int getDayOfWeekDataBinding() {
        return this.dayOfWeekDataBinding;
    }

    public void setDayOfWeekDataBinding(int value) {
        this.dayOfWeekDataBinding = value;
    }

    public int getWhichWeekDataBinding() {
        return this.whichWeekDataBinding;
    }

    public void setWhichWeekDataBinding(int value) {
        this.whichWeekDataBinding = value;
    }

    public boolean setDate(int month, int day) {
        if (month >= 1 && month <= 12 && day >= 1 && day <= 31) {
            GregorianCalendar cal = new GregorianCalendar(Locale.getDefault());
            cal.set(2, month - 1);
            int maxDay = 0;
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    maxDay = 31;
                    break;
                }
                case 2: {
                    maxDay = 29;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    maxDay = 30;
                }
            }
            if (maxDay < day) {
                return false;
            }
            this.monthDataBinding = month;
            this.dayOfMonthDataBinding = day;
            this.whichWeekDataBinding = -1;
            this.dayOfWeekDataBinding = -1;
            return true;
        }
        return false;
    }

    public boolean setFloatingDay(int month, int dayConstant, int occurrenceConstant) {
        if (!(month < 1 || month > 12 || occurrenceConstant != 1 && occurrenceConstant != 2 && occurrenceConstant != 3 && occurrenceConstant != 4 && occurrenceConstant != 6 || dayConstant != 1 && dayConstant != 2 && dayConstant != 4 && dayConstant != 8 && dayConstant != 16 && dayConstant != 32 && dayConstant != 64 && dayConstant != 128)) {
            this.dayOfMonthDataBinding = 0;
            this.dayOfWeekDataBinding = dayConstant;
            this.whichWeekDataBinding = occurrenceConstant;
            this.monthDataBinding = month;
            return true;
        }
        return false;
    }

    public int getMonth() {
        return this.monthDataBinding;
    }

    public int getDay() {
        return this.dayOfMonthDataBinding;
    }

    public int getDayOfWeek() {
        return this.dayOfWeekDataBinding;
    }

    public int getWhichWeek() {
        return this.whichWeekDataBinding;
    }

    @Override
    public String toString(Locale locale) {
        String strClassName = YearlyRecurrence.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        String expression = "";
        Calendar startTime = this.getStartDate();
        Calendar endTime = this.getEndDate();
        String startTimeString = null;
        if (startTime != null) {
            startTimeString = AbstractRecurrence.dateToString(startTime, locale);
        }
        String endTimeString = null;
        if (endTime != null) {
            endTimeString = AbstractRecurrence.dateToString(endTime, locale);
        }
        String monthString = "";
        switch (this.monthDataBinding) {
            case 1: {
                monthString = bundle.getString("Recurrence.toString.Month.Jan.txt");
                break;
            }
            case 2: {
                monthString = bundle.getString("Recurrence.toString.Month.Feb.txt");
                break;
            }
            case 3: {
                monthString = bundle.getString("Recurrence.toString.Month.Mar.txt");
                break;
            }
            case 4: {
                monthString = bundle.getString("Recurrence.toString.Month.Apr.txt");
                break;
            }
            case 5: {
                monthString = bundle.getString("Recurrence.toString.Month.May.txt");
                break;
            }
            case 6: {
                monthString = bundle.getString("Recurrence.toString.Month.June.txt");
                break;
            }
            case 7: {
                monthString = bundle.getString("Recurrence.toString.Month.July.txt");
                break;
            }
            case 8: {
                monthString = bundle.getString("Recurrence.toString.Month.Aug.txt");
                break;
            }
            case 9: {
                monthString = bundle.getString("Recurrence.toString.Month.Sept.txt");
                break;
            }
            case 10: {
                monthString = bundle.getString("Recurrence.toString.Month.Oct.txt");
                break;
            }
            case 11: {
                monthString = bundle.getString("Recurrence.toString.Month.Nov.txt");
                break;
            }
            case 12: {
                monthString = bundle.getString("Recurrence.toString.Month.Dec.txt");
            }
        }
        if (this.monthDataBinding >= 1 && this.dayOfMonthDataBinding >= 1) {
            if (this.getSkipCount() > 1) {
                if (startTimeString != null) {
                    if (endTimeString == null) {
                        Object[] args = new Object[]{String.valueOf(this.getSkipCount()), monthString, String.valueOf(this.dayOfMonthDataBinding), startTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.SkipMonthOffsetStart.fmt.txt", (Object[])args);
                    } else {
                        Object[] args = new Object[]{String.valueOf(this.getSkipCount()), monthString, String.valueOf(this.dayOfMonthDataBinding), startTimeString, endTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.SkipMonthOffsetStartEnd.fmt.txt", (Object[])args);
                    }
                }
            } else if (startTimeString == null && endTimeString == null) {
                Object[] args = new Object[]{monthString, String.valueOf(this.dayOfMonthDataBinding)};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.MonthOffset.fmt.txt", (Object[])args);
            } else if (endTimeString == null) {
                Object[] args = new Object[]{monthString, String.valueOf(this.dayOfMonthDataBinding), startTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.MonthOffsetStart.fmt.txt", (Object[])args);
            } else if (startTimeString == null) {
                Object[] args = new Object[]{monthString, String.valueOf(this.dayOfMonthDataBinding), endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.MonthOffsetEnd.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{monthString, String.valueOf(this.dayOfMonthDataBinding), startTimeString, endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.MonthOffsetStartEnd.fmt.txt", (Object[])args);
            }
        } else if (this.monthDataBinding >= 1 && this.whichWeekDataBinding != -1 && this.dayOfWeekDataBinding != -1) {
            String dayOfWeekString = "";
            switch (this.dayOfWeekDataBinding) {
                case 1: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Monday.txt");
                    break;
                }
                case 16: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Friday.txt");
                    break;
                }
                case 32: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Saturday.txt");
                    break;
                }
                case 64: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Sunday.txt");
                    break;
                }
                case 8: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Thursday.txt");
                    break;
                }
                case 2: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Tuesday.txt");
                    break;
                }
                case 4: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.DayOfWeek.Wednesday.txt");
                    break;
                }
                case 128: {
                    dayOfWeekString = bundle.getString("Recurrence.toString.Anyday.txt");
                }
            }
            String whichWeekString = "";
            switch (this.whichWeekDataBinding) {
                case 1: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.First.txt");
                    break;
                }
                case 4: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Fourth.txt");
                    break;
                }
                case 6: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Last.txt");
                    break;
                }
                case 2: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Second.txt");
                    break;
                }
                case 3: {
                    whichWeekString = bundle.getString("Recurrence.toString.Ordinal.Third.txt");
                }
            }
            if (this.getSkipCount() > 1) {
                if (startTimeString != null) {
                    if (endTimeString == null) {
                        Object[] args = new Object[]{whichWeekString, dayOfWeekString, monthString, String.valueOf(this.getSkipCount()), startTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.OrdinalDayMonthSkipStart.fmt.txt", (Object[])args);
                    } else {
                        Object[] args = new Object[]{whichWeekString, dayOfWeekString, monthString, String.valueOf(this.getSkipCount()), startTimeString, endTimeString};
                        expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.OrdinalDayMonthSkipStartEnd.fmt.txt", (Object[])args);
                    }
                }
            } else if (startTimeString == null && endTimeString == null) {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, monthString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.OrdinalDayMonth.fmt.txt", (Object[])args);
            } else if (endTimeString == null) {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, monthString, startTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.OrdinalDayMonthStart.fmt.txt", (Object[])args);
            } else if (startTimeString == null) {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, monthString, endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.OrdinalDayMonthEnd.fmt.txt", (Object[])args);
            } else {
                Object[] args = new Object[]{whichWeekString, dayOfWeekString, monthString, startTimeString, endTimeString};
                expression = Message.format((ResourceBundle)bundle, (String)"YearlyRecurrence.toString.OrdinalDayMonthStartEnd.fmt.txt", (Object[])args);
            }
        }
        return expression;
    }

    @Override
    public List<Calendar> getNextDates(Calendar queryDate, Calendar endQueryDate, int count) throws InvalidRecurrenceException {
        ArrayList<Calendar> results = new ArrayList<Calendar>();
        if (endQueryDate == null || queryDate == null || count < 0) {
            return results;
        }
        Calendar calStart = this.getStartDate();
        Calendar currentDate = (Calendar)queryDate.clone();
        if (calStart != null) {
            if (AbstractRecurrence.isBeforeByDay(currentDate, calStart)) {
                currentDate = (Calendar)calStart.clone();
            } else if (this.getSkipCount() > 1) {
                currentDate = (Calendar)calStart.clone();
                currentDate.set(5, 1);
                currentDate.set(2, this.getMonth() - 1);
                this.moveCurrentDateJustBeforeQueryDate(currentDate, queryDate, this.getSkipCount(), 1);
            }
        }
        currentDate.set(2, this.getMonth() - 1);
        int dayOfMonth = this.getDay();
        int dayOfWeek = this.getDayOfWeek();
        int whichWeek = this.getWhichWeek();
        while (!AbstractRecurrence.isAfterByDay(currentDate, endQueryDate)) {
            boolean useThisDay = true;
            if (dayOfMonth > 0) {
                int maxDay = currentDate.getActualMaximum(5);
                if (maxDay >= dayOfMonth) {
                    currentDate.set(5, dayOfMonth);
                } else {
                    useThisDay = false;
                }
            } else if (dayOfWeek == 128) {
                int ordinalIndex = MonthlyRecurrence.getDayOfMonthFromOrdinal(currentDate, whichWeek);
                currentDate.set(5, ordinalIndex);
            } else {
                int calendarWeekDay = WeeklyRecurrence.getCalendarWeekDay(dayOfWeek);
                currentDate.set(7, calendarWeekDay);
                int ordinalIndex = MonthlyRecurrence.getWeekOfMonthFromOrdinal(whichWeek);
                currentDate.set(8, ordinalIndex);
            }
            if (useThisDay && !AbstractRecurrence.isBeforeByDay(currentDate, queryDate) && this.isDateInRange(currentDate)) {
                if (AbstractRecurrence.isAfterByDay(currentDate, endQueryDate)) break;
                results.add((Calendar)currentDate.clone());
                if (count > 0 && results.size() >= count) break;
            }
            currentDate.add(1, this.getSkipCount());
            currentDate.set(5, 1);
            if (!this.isDateAfterRange(currentDate)) continue;
            break;
        }
        return results;
    }

    @Override
    public boolean includesDate(Calendar queryDate) throws InvalidRecurrenceException {
        if (!this.isDateInRange(queryDate)) {
            return false;
        }
        if (this.getDay() > 0) {
            if (queryDate.get(5) != this.getDay()) {
                return false;
            }
            if (queryDate.get(2) != this.getMonth() - 1) {
                return false;
            }
        } else {
            if (queryDate.get(2) != this.getMonth() - 1) {
                return false;
            }
            boolean okay = MonthlyRecurrence.isDateAllowedUnderOrdinalSettings(queryDate, this.getDayOfWeek(), this.getWhichWeek());
            if (!okay) {
                return false;
            }
        }
        if (this.getSkipCount() > 1) {
            return super.includesDate(queryDate);
        }
        return true;
    }

    @Override
    public IRecurrenceInfo copy() {
        YearlyRecurrence recurrence = new YearlyRecurrence();
        recurrence.copyFrom(this);
        return recurrence;
    }

    @Override
    public void copyFrom(IRecurrenceInfo source) {
        if (source instanceof YearlyRecurrence) {
            YearlyRecurrence recurrence = (YearlyRecurrence)source;
            super.copyFrom(recurrence);
            this.dayOfMonthDataBinding = recurrence.dayOfMonthDataBinding;
            this.dayOfWeekDataBinding = recurrence.dayOfWeekDataBinding;
            this.monthDataBinding = recurrence.monthDataBinding;
            this.whichWeekDataBinding = recurrence.whichWeekDataBinding;
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<");
        buffer.append(XML_Yearly_Tag);
        if (this.monthDataBinding > 0) {
            buffer.append(' ');
            buffer.append(XML_Month_of_Year);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.monthDataBinding);
            buffer.append('\"');
        }
        if (this.dayOfMonthDataBinding > 0) {
            buffer.append(' ');
            buffer.append(XML_Day_of_Month);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.dayOfMonthDataBinding);
            buffer.append('\"');
        }
        if (this.dayOfWeekDataBinding > 0 && this.whichWeekDataBinding > 0) {
            buffer.append(' ');
            buffer.append("dayOfWeek");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.dayOfWeekDataBinding);
            buffer.append('\"');
            buffer.append(' ');
            buffer.append("whichWeek");
            buffer.append("=");
            buffer.append('\"');
            buffer.append(this.whichWeekDataBinding);
            buffer.append('\"');
        }
        buffer.append(">");
        super.toXML(buffer);
        buffer.append("</");
        buffer.append(XML_Yearly_Tag);
        buffer.append('>');
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_Yearly_Tag);
        parent.appendChild(tag);
        if (this.monthDataBinding > 0) {
            tag.setAttribute(XML_Month_of_Year, Integer.toString(this.monthDataBinding));
        }
        if (this.dayOfMonthDataBinding > 0) {
            tag.setAttribute(XML_Day_of_Month, Integer.toString(this.dayOfMonthDataBinding));
        }
        if (this.dayOfWeekDataBinding > 0 && this.whichWeekDataBinding > 0) {
            tag.setAttribute("dayOfWeek", Integer.toString(this.dayOfWeekDataBinding));
            tag.setAttribute("whichWeek", Integer.toString(this.whichWeekDataBinding));
        }
        super.injectXML(doc, tag);
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("YE_");
        if (this.monthDataBinding > 0) {
            buffer.append("m" + this.monthDataBinding + '_');
        }
        if (this.dayOfMonthDataBinding > 0) {
            buffer.append("d" + this.dayOfMonthDataBinding + '_');
        }
        if (this.dayOfWeekDataBinding > 0 && this.whichWeekDataBinding > 0) {
            buffer.append("dw" + this.dayOfWeekDataBinding + "ww" + this.whichWeekDataBinding + '_');
        }
        super.toShortUniqueString(buffer);
    }
}

