/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.DisplayInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SchedulerServerInfo", propOrder={"classidDataBinding", "typeDataBinding", "hostDataBinding", "portDataBinding", "protocolDataBinding", "usernameDataBinding", "passwordDataBinding", "outDirDataBinding", "javaNamingProviderUrlDataBinding", "javaNamingFactoryDataBinding", "jobExecutionProviderDataBinding", "launcherPathDataBinding", "flowOrchHostDataBinding", "flowOrchPortDataBinding", "flowOrchCommandDataBinding", "triggerCommandDataBinding", "osCommandPathDataBinding", "authInfoDataBinding", "bufferSizeDataBinding", "useHADataBinding", "restAPIPathDataBinding", "configPropertiesDataBinding", "jobTrackerDataBinding", "webNameNodeDataBinding", "nameNodeDataBinding", "coordinatorDirDataBinding", "workflowDirDataBinding", "connectionIdDataBinding", "subflowSupportedDataBinding", "timeeventSupportedDataBinding", "fileeventSupportedDataBinding", "fileeventSupportedAsTriggersDataBinding", "enterpriseLevelSupportOfFileEventsDataBinding", "multiTriggersSupportedDataBinding", "advanceFlowCompletionCriteriaSupportedDataBinding", "emailNotificationSupportedDataBinding", "areQueuesDataBinding", "queueListDataBinding", "jobDefaultEmailNotificationSupportedDataBinding", "jobDefaultPrioritySupportedDataBinding", "jobDefaultEnvironmentVariablesSupportedDataBinding", "exclusiveExecutionSupportedDataBinding", "timezoneSupportedDataBinding", "limitedSkipsDataBinding", "basicSchedulerDataBinding", "consoleDataBinding"})
public class SchedulerServerInfo
extends DisplayInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="ClassId", required=true)
    protected String classidDataBinding;
    @XmlElement(name="Type", required=true)
    protected String typeDataBinding;
    @XmlElement(name="Host", required=true)
    protected String hostDataBinding;
    @XmlElement(name="Port", required=true)
    protected String portDataBinding;
    @XmlElement(name="Protocol", required=true)
    protected String protocolDataBinding;
    @XmlElement(name="Username", required=true)
    protected String usernameDataBinding;
    @XmlElement(name="Password", required=true)
    protected String passwordDataBinding;
    @XmlElement(name="OutputDir", required=false)
    protected String outDirDataBinding;
    @XmlElement(name="JavaNamingProviderUrl", required=false)
    protected String javaNamingProviderUrlDataBinding;
    @XmlElement(name="JavaNamingFactory", required=false)
    protected String javaNamingFactoryDataBinding;
    @XmlElement(name="RestAPIPath", required=false)
    protected String restAPIPathDataBinding;
    @XmlElement(name="JobExecutionProvider", required=false)
    protected String jobExecutionProviderDataBinding;
    @XmlElement(name="LauncherPath", required=false)
    protected String launcherPathDataBinding;
    @XmlElement(name="FlowOrchHost", required=false)
    protected String flowOrchHostDataBinding;
    @XmlElement(name="FlowOrchPort", required=false)
    protected String flowOrchPortDataBinding;
    @XmlElement(name="FlowOrchCommand", required=false)
    protected String flowOrchCommandDataBinding;
    @XmlElement(name="TriggerCommand", required=false)
    protected String triggerCommandDataBinding;
    @XmlElement(name="OsCommandPath", required=false)
    protected String osCommandPathDataBinding;
    @XmlElement(name="AuthInfo", required=false)
    protected String authInfoDataBinding;
    @XmlElement(name="BufferSize", required=false)
    protected String bufferSizeDataBinding;
    @XmlElement(name="UseHA")
    protected boolean useHADataBinding;
    @XmlElement(name="JobTracker", required=false)
    protected String jobTrackerDataBinding;
    @XmlElement(name="WebNameNode", required=false)
    protected String webNameNodeDataBinding;
    @XmlElement(name="NameNode", required=false)
    protected String nameNodeDataBinding;
    @XmlElement(name="CoordinatorDir", required=false)
    protected String coordinatorDirDataBinding;
    @XmlElement(name="WorkflowDir", required=false)
    protected String workflowDirDataBinding;
    @XmlElement(name="ConfigProperties", required=false)
    protected String configPropertiesDataBinding;
    @XmlElement(name="ConnectionId", required=false)
    protected String connectionIdDataBinding;
    @XmlElement(name="SubflowSupported")
    protected boolean subflowSupportedDataBinding;
    @XmlElement(name="TimeeventSupported")
    protected boolean timeeventSupportedDataBinding;
    @XmlElement(name="FileeventSupported")
    protected boolean fileeventSupportedDataBinding;
    @XmlElement(name="FileeventSupportedAsTriggers")
    protected boolean fileeventSupportedAsTriggersDataBinding;
    @XmlElement(name="EnterpriseLevelSupportOfFileEvents")
    protected boolean enterpriseLevelSupportOfFileEventsDataBinding;
    @XmlElement(name="MultiTriggersSupported")
    protected boolean multiTriggersSupportedDataBinding;
    @XmlElement(name="AdvanceFlowCompletionCriteriaSupported")
    protected boolean advanceFlowCompletionCriteriaSupportedDataBinding;
    @XmlElement(name="EmailNotificationSupported")
    protected boolean emailNotificationSupportedDataBinding;
    @XmlElement(name="AreQueues")
    protected boolean areQueuesDataBinding;
    @XmlElement(name="QueueList")
    protected List<String> queueListDataBinding;
    @XmlElement(name="JobDefaultEmailNotificationSupported")
    protected boolean jobDefaultEmailNotificationSupportedDataBinding;
    @XmlElement(name="JobDefaultPrioritySupported")
    protected boolean jobDefaultPrioritySupportedDataBinding;
    @XmlElement(name="JobDefaultEnvironmentVariablesSupported")
    protected boolean jobDefaultEnvironmentVariablesSupportedDataBinding;
    @XmlElement(name="ExclusiveExecutionSupported")
    protected boolean exclusiveExecutionSupportedDataBinding;
    @XmlElement(name="TimezoneSupported")
    protected boolean timezoneSupportedDataBinding;
    @XmlElement(name="LimitedSkips")
    protected boolean limitedSkipsDataBinding;
    @XmlElement(name="BasicScheduler")
    protected boolean basicSchedulerDataBinding;
    @XmlElement(name="Console")
    protected boolean consoleDataBinding;
    private static final ResourceBundle m_bundle;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String IconName;
    public static final int ANY_SCHEDULE_SERVER = 100;
    public static final int PLATFORM_SCHEDULE_SERVER = 101;
    public static final int PLATFORM_PM_SCHEDULE_SERVER = 102;
    public static final int PLATFORM_JS_SCHEDULE_SERVER = 103;
    public static final int OS_SCHEDULE_SERVER = 104;
    public static final int IP_SCHEDULE_SERVER = 105;
    public static final int PIP_SCHEDULE_SERVER = 106;
    public static final int OOZIE_SCHEDULE_SERVER = 107;
    public static final int SASJFS_SCHEDULE_SERVER = 108;
    public static final String SCH_Platform_JobScheduler_ID = "d7111ce7-c910-4227-8b3d-af4533660891";
    public static final String SCH_Platform_ProcessManager_ID = "a1661499-5d7d-4fcc-8fc3-c6509853e116";
    public static final String SCH_OS_Scheduler_ID = "b379c9c1-89e0-4e72-ba43-6a416899b5dd";
    public static final String SCH_IP_Scheduler_ID = "c8b4baf0-5f9f-471e-ba76-1201e1e81aef";
    public static final String SCH_PIP_Scheduler_ID = "c8b4baf0-5f9f-488e-ba76-1201e1e81aef";
    public static final String SCH_OOZIE_Scheduler_ID = "ff3aab60-8926-4e88-8af3-4287787d7d7";
    public static final String SCH_SASJFS_Scheduler_ID = "8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae";
    public static final String PROPERTY_CONFIGURATION = "CommonProperties";
    public static final String PROPERTY_OUTDIR = "OutDir";
    public static final String PROPERTY_TYPE = "ExecutionType";
    public static final String TYPE_ENUM_RESTURI = "REST";
    public static final String TYPE_ENUM_LAUNCHER = "Launcher";
    public static final String TYPE_ENUM_OS = "operatingSystem";
    public static final String PROPERTY_Launcher = "ExecutionLauncher";
    public static final String PROPERTY_RESTURI = "ExecutionRESTAPI";
    public static final String PROPERTY_FLOWORCHHOST = "FlowOrchHost";
    public static final String PROPERTY_FLOWORCHPORT = "FlowOrchPort";
    public static final String PROPERTY_FLOWORCHCOMMAND = "FlowOrchCommand";
    public static final String PROPERTY_TRIGGERCOMMAND = "OSTriggerCommand";
    public static final String PROPERTY_OSPATH = "OSCommandPath";
    public static final String PROPERTY_AUTHINFO = "AuthInfo";
    public static final String PROPERTY_BUFSIZE = "BufferSize";
    public static final String PROPERTY_HA_Enabled = "UseHA";
    public static final String PROPERTY_JAVANAMINGPROVIDERURL = "java.naming.provider.url";
    public static final String PROPERTY_JAVANAMINGFACTORY = "java.naming.factory.initial";
    public static final String PROPERTY_RESTAPI = "RestAPI";
    public static final String PROPERTY_HADOOPCONFIG = "HadoopConfig";
    public static final String PROPERTY_JOBTRACKER = "JobTracker";
    public static final String PROPERTY_WEBNAMENODE = "WebNameNode";
    public static final String PROPERTY_NAMENODE = "NameNode";
    public static final String PROPERTY_COORDINATOR = "Coordinator";
    public static final String PROPERTY_WORKFLOW = "Workflow";

    public SchedulerServerInfo() {
    }

    public SchedulerServerInfo(String classid) {
        this(null, classid);
    }

    public SchedulerServerInfo(String name, String classid) {
        super(name, null, IconName);
        this.classidDataBinding = classid;
        if (classid.compareTo(SCH_Platform_ProcessManager_ID) == 0) {
            this.typeDataBinding = m_bundle.getString("SchedulerServerInfo.PlatformPMServerTypeName.txt");
            this.subflowSupportedDataBinding = true;
            this.timeeventSupportedDataBinding = true;
            this.fileeventSupportedDataBinding = true;
            this.fileeventSupportedAsTriggersDataBinding = true;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = true;
            this.emailNotificationSupportedDataBinding = true;
            this.areQueuesDataBinding = true;
            this.exclusiveExecutionSupportedDataBinding = true;
            this.jobDefaultEmailNotificationSupportedDataBinding = true;
            this.jobDefaultPrioritySupportedDataBinding = true;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = true;
            this.timezoneSupportedDataBinding = true;
            this.limitedSkipsDataBinding = false;
            this.basicSchedulerDataBinding = false;
            this.multiTriggersSupportedDataBinding = true;
            this.consoleDataBinding = false;
        } else if (classid.compareTo(SCH_OS_Scheduler_ID) == 0) {
            this.typeDataBinding = m_bundle.getString("SchedulerServerInfo.OSServerTypeName.txt");
            this.subflowSupportedDataBinding = false;
            this.timeeventSupportedDataBinding = false;
            this.fileeventSupportedDataBinding = false;
            this.fileeventSupportedAsTriggersDataBinding = false;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = false;
            this.emailNotificationSupportedDataBinding = false;
            this.areQueuesDataBinding = false;
            this.exclusiveExecutionSupportedDataBinding = false;
            this.jobDefaultEmailNotificationSupportedDataBinding = false;
            this.jobDefaultPrioritySupportedDataBinding = true;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = false;
            this.timezoneSupportedDataBinding = false;
            this.limitedSkipsDataBinding = false;
            this.basicSchedulerDataBinding = true;
            this.multiTriggersSupportedDataBinding = false;
            this.consoleDataBinding = false;
        } else if (classid.compareTo(SCH_PIP_Scheduler_ID) == 0) {
            this.typeDataBinding = m_bundle.getString("SchedulerServerInfo.PIPServerTypeName.txt");
            this.subflowSupportedDataBinding = true;
            this.timeeventSupportedDataBinding = true;
            this.fileeventSupportedDataBinding = true;
            this.fileeventSupportedAsTriggersDataBinding = true;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = true;
            this.emailNotificationSupportedDataBinding = true;
            this.areQueuesDataBinding = false;
            this.exclusiveExecutionSupportedDataBinding = true;
            this.jobDefaultEmailNotificationSupportedDataBinding = true;
            this.jobDefaultPrioritySupportedDataBinding = true;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = false;
            this.timezoneSupportedDataBinding = true;
            this.limitedSkipsDataBinding = false;
            this.basicSchedulerDataBinding = false;
            this.multiTriggersSupportedDataBinding = false;
            this.consoleDataBinding = true;
        } else if (classid.compareTo(SCH_SASJFS_Scheduler_ID) == 0) {
            this.typeDataBinding = m_bundle.getString("SchedulerServerInfo.SASJFSServerTypeName.txt");
            this.subflowSupportedDataBinding = true;
            this.timeeventSupportedDataBinding = true;
            this.fileeventSupportedDataBinding = false;
            this.fileeventSupportedAsTriggersDataBinding = false;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = true;
            this.emailNotificationSupportedDataBinding = false;
            this.areQueuesDataBinding = true;
            this.exclusiveExecutionSupportedDataBinding = false;
            this.jobDefaultEmailNotificationSupportedDataBinding = false;
            this.jobDefaultPrioritySupportedDataBinding = false;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = false;
            this.timezoneSupportedDataBinding = false;
            this.limitedSkipsDataBinding = false;
            this.basicSchedulerDataBinding = false;
            this.multiTriggersSupportedDataBinding = true;
            this.consoleDataBinding = false;
        } else if (classid.compareTo(SCH_IP_Scheduler_ID) == 0) {
            this.typeDataBinding = m_bundle.getString("SchedulerServerInfo.IPServerTypeName.txt");
            this.subflowSupportedDataBinding = false;
            this.timeeventSupportedDataBinding = true;
            this.fileeventSupportedDataBinding = true;
            this.fileeventSupportedAsTriggersDataBinding = false;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = false;
            this.emailNotificationSupportedDataBinding = false;
            this.areQueuesDataBinding = false;
            this.exclusiveExecutionSupportedDataBinding = false;
            this.jobDefaultEmailNotificationSupportedDataBinding = false;
            this.jobDefaultPrioritySupportedDataBinding = false;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = false;
            this.timezoneSupportedDataBinding = false;
            this.limitedSkipsDataBinding = false;
            this.basicSchedulerDataBinding = true;
            this.multiTriggersSupportedDataBinding = false;
            this.consoleDataBinding = false;
        } else if (classid.compareTo(SCH_OOZIE_Scheduler_ID) == 0) {
            this.typeDataBinding = null;
            this.subflowSupportedDataBinding = false;
            this.timeeventSupportedDataBinding = false;
            this.fileeventSupportedDataBinding = false;
            this.fileeventSupportedAsTriggersDataBinding = false;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = false;
            this.emailNotificationSupportedDataBinding = false;
            this.areQueuesDataBinding = false;
            this.exclusiveExecutionSupportedDataBinding = false;
            this.jobDefaultEmailNotificationSupportedDataBinding = false;
            this.jobDefaultPrioritySupportedDataBinding = false;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = false;
            this.timezoneSupportedDataBinding = false;
            this.limitedSkipsDataBinding = true;
            this.basicSchedulerDataBinding = true;
            this.multiTriggersSupportedDataBinding = false;
            this.consoleDataBinding = false;
        } else {
            this.typeDataBinding = null;
            this.subflowSupportedDataBinding = false;
            this.timeeventSupportedDataBinding = false;
            this.fileeventSupportedDataBinding = false;
            this.fileeventSupportedAsTriggersDataBinding = false;
            this.advanceFlowCompletionCriteriaSupportedDataBinding = false;
            this.emailNotificationSupportedDataBinding = false;
            this.areQueuesDataBinding = false;
            this.exclusiveExecutionSupportedDataBinding = false;
            this.jobDefaultEmailNotificationSupportedDataBinding = false;
            this.jobDefaultPrioritySupportedDataBinding = false;
            this.jobDefaultEnvironmentVariablesSupportedDataBinding = false;
            this.timezoneSupportedDataBinding = false;
            this.limitedSkipsDataBinding = false;
            this.basicSchedulerDataBinding = true;
            this.multiTriggersSupportedDataBinding = false;
            this.consoleDataBinding = false;
        }
        if (name == null) {
            this.nameDataBinding = this.typeDataBinding;
        }
    }

    public String getClassidDataBinding() {
        return this.classidDataBinding;
    }

    public void setClassidDataBinding(String value) {
        this.classidDataBinding = value;
    }

    public String getTypeDataBinding() {
        return this.typeDataBinding;
    }

    public void setTypeDataBinding(String value) {
        this.typeDataBinding = value;
    }

    public String getHostDataBinding() {
        return this.hostDataBinding;
    }

    public void setHostDataBinding(String value) {
        this.hostDataBinding = value;
    }

    public String getPortDataBinding() {
        return this.portDataBinding;
    }

    public void setPortDataBinding(String value) {
        this.portDataBinding = value;
    }

    public String getProtocolDataBinding() {
        return this.protocolDataBinding;
    }

    public void setProtocolDataBinding(String value) {
        this.protocolDataBinding = value;
    }

    public String getUsernameDataBinding() {
        return this.usernameDataBinding;
    }

    public void setUsernameDataBinding(String value) {
        this.usernameDataBinding = value;
    }

    public String getPasswordDataBinding() {
        return this.passwordDataBinding;
    }

    public void setPasswordDataBinding(String value) {
        this.passwordDataBinding = value;
    }

    public String getConfigPropertiesDataBinding() {
        return this.configPropertiesDataBinding;
    }

    public void setConfigPropertiesDataBinding(String value) {
        this.configPropertiesDataBinding = value;
    }

    public String getOutDirDataBinding() {
        return this.outDirDataBinding;
    }

    public void setOutDirDataBinding(String value) {
        this.outDirDataBinding = value;
    }

    public String getRestAPIPathDataBinding() {
        return this.restAPIPathDataBinding;
    }

    public void setRestAPIPathDataBinding(String value) {
        this.restAPIPathDataBinding = value;
    }

    public String getJavaNamingProviderUrlDataBinding() {
        return this.javaNamingProviderUrlDataBinding;
    }

    public void setJavaNamingProviderUrlDataBinding(String value) {
        this.javaNamingProviderUrlDataBinding = value;
    }

    public String getJavaNamingFactoryDataBinding() {
        return this.javaNamingFactoryDataBinding;
    }

    public void setJavaNamingFactoryDataBinding(String value) {
        this.javaNamingFactoryDataBinding = value;
    }

    public String getJobExecutionProviderDataBinding() {
        return this.jobExecutionProviderDataBinding;
    }

    public void setJobExecutionProviderDataBinding(String value) {
        this.jobExecutionProviderDataBinding = value;
    }

    public String getFlowOrchHostDataBinding() {
        return this.flowOrchHostDataBinding;
    }

    public void setFlowOrchHostDataBinding(String value) {
        this.flowOrchHostDataBinding = value;
    }

    public String getFlowOrchPortDataBinding() {
        return this.flowOrchPortDataBinding;
    }

    public void setFlowOrchPortDataBinding(String value) {
        this.flowOrchPortDataBinding = value;
    }

    public String getFlowOrchCommandDataBinding() {
        return this.flowOrchCommandDataBinding;
    }

    public void setFlowOrchCommandDataBinding(String value) {
        this.flowOrchCommandDataBinding = value;
    }

    public String getTriggerCommandDataBinding() {
        return this.triggerCommandDataBinding;
    }

    public void setTriggerCommandDataBinding(String value) {
        this.triggerCommandDataBinding = value;
    }

    public String getOsCommandPathDataBinding() {
        return this.flowOrchCommandDataBinding;
    }

    public void setOSCommandPathDataBinding(String value) {
        this.osCommandPathDataBinding = value;
    }

    public String getAuthInfoDataBinding() {
        return this.authInfoDataBinding;
    }

    public void setAuthInfoDataBinding(String value) {
        this.authInfoDataBinding = value;
    }

    public String getBufferSizeDataBinding() {
        return this.bufferSizeDataBinding;
    }

    public void setBufferSizeDataBinding(String value) {
        this.bufferSizeDataBinding = value;
    }

    public boolean isUseHADataBinding() {
        return this.useHADataBinding;
    }

    public void setUseHADataBinding(boolean value) {
        this.useHADataBinding = value;
    }

    public String getJobTrackerDataBinding() {
        return this.jobTrackerDataBinding;
    }

    public void setJobTrackerDataBinding(String value) {
        this.jobTrackerDataBinding = value;
    }

    public String getWebNameNodeDataBinding() {
        return this.webNameNodeDataBinding;
    }

    public void setWebNameNodeDataBinding(String value) {
        this.webNameNodeDataBinding = value;
    }

    public String getNameNodeDataBinding() {
        return this.nameNodeDataBinding;
    }

    public void setNameNodeDataBinding(String value) {
        this.nameNodeDataBinding = value;
    }

    public String getCoordinatorDirDataBinding() {
        return this.coordinatorDirDataBinding;
    }

    public void setCoordinatorDirDataBinding(String value) {
        this.coordinatorDirDataBinding = value;
    }

    public String getWorkflowDirDataBinding() {
        return this.workflowDirDataBinding;
    }

    public void setWorkflowDirDataBinding(String value) {
        this.workflowDirDataBinding = value;
    }

    public String getConnectionIdDataBinding() {
        return this.connectionIdDataBinding;
    }

    public void setConnectionIdDataBinding(String value) {
        this.connectionIdDataBinding = value;
    }

    public boolean isSubflowSupportedDataBinding() {
        return this.subflowSupportedDataBinding;
    }

    public void setSubflowSupportedDataBinding(boolean value) {
        this.subflowSupportedDataBinding = value;
    }

    public boolean isTimeeventSupportedDataBinding() {
        return this.timeeventSupportedDataBinding;
    }

    public void setTimeeventSupportedDataBinding(boolean value) {
        this.timeeventSupportedDataBinding = value;
    }

    public boolean isFileeventSupportedDataBinding() {
        return this.fileeventSupportedDataBinding;
    }

    public void setFileeventSupportedDataBinding(boolean value) {
        this.fileeventSupportedDataBinding = value;
    }

    public boolean isFileeventSupportedAsTriggersDataBinding() {
        return this.fileeventSupportedAsTriggersDataBinding;
    }

    public void setFileeventSupportedAsTriggersDataBinding(boolean value) {
        this.fileeventSupportedAsTriggersDataBinding = value;
    }

    public boolean isEnterpriseLevelSupportOfFileEventsDataBinding() {
        return this.enterpriseLevelSupportOfFileEventsDataBinding;
    }

    public void setEnterpriseLevelSupportOfFileEventsDataBinding(boolean value) {
        this.enterpriseLevelSupportOfFileEventsDataBinding = value;
    }

    public boolean isMultiTriggersSupportedDataBinding() {
        return this.multiTriggersSupportedDataBinding;
    }

    public void setMultiTriggersSupportedDataBinding(boolean value) {
        this.multiTriggersSupportedDataBinding = value;
    }

    public boolean isAdvanceFlowCompletionCriteriaSupportedDataBinding() {
        return this.advanceFlowCompletionCriteriaSupportedDataBinding;
    }

    public void setAdvanceFlowCompletionCriteriaSupportedDataBinding(boolean value) {
        this.advanceFlowCompletionCriteriaSupportedDataBinding = value;
    }

    public boolean isEmailNotificationSupportedDataBinding() {
        return this.emailNotificationSupportedDataBinding;
    }

    public void setEmailNotificationSupportedDataBinding(boolean value) {
        this.emailNotificationSupportedDataBinding = value;
    }

    public boolean isAreQueuesDataBinding() {
        return this.areQueuesDataBinding;
    }

    public void setAreQueuesDataBinding(boolean value) {
        this.areQueuesDataBinding = value;
    }

    public List<String> getQueueListDataBinding() {
        if (this.queueListDataBinding == null) {
            this.queueListDataBinding = new ArrayList<String>();
        }
        return this.queueListDataBinding;
    }

    public boolean isJobDefaultEmailNotificationSupportedDataBinding() {
        return this.jobDefaultEmailNotificationSupportedDataBinding;
    }

    public void setJobDefaultEmailNotificationSupportedDataBinding(boolean value) {
        this.jobDefaultEmailNotificationSupportedDataBinding = value;
    }

    public boolean isJobDefaultPrioritySupportedDataBinding() {
        return this.jobDefaultPrioritySupportedDataBinding;
    }

    public void setJobDefaultPrioritySupportedDataBinding(boolean value) {
        this.jobDefaultPrioritySupportedDataBinding = value;
    }

    public boolean isJobDefaultEnvironmentVariablesSupportedDataBinding() {
        return this.jobDefaultEnvironmentVariablesSupportedDataBinding;
    }

    public void setJobDefaultEnvironmentVariablesSupportedDataBinding(boolean value) {
        this.jobDefaultEnvironmentVariablesSupportedDataBinding = value;
    }

    public boolean isExclusiveExecutionSupportedDataBinding() {
        return this.exclusiveExecutionSupportedDataBinding;
    }

    public void setExclusiveExecutionSupportedDataBinding(boolean value) {
        this.exclusiveExecutionSupportedDataBinding = value;
    }

    public boolean isTimezoneSupportedDataBinding() {
        return this.timezoneSupportedDataBinding;
    }

    public void setTimezoneSupportedDataBinding(boolean value) {
        this.timezoneSupportedDataBinding = value;
    }

    public boolean isLimitedSkipsDataBinding() {
        return this.limitedSkipsDataBinding;
    }

    public void setLimitedSkipsDataBinding(boolean value) {
        this.limitedSkipsDataBinding = value;
    }

    public boolean isBasicSchedulerDataBinding() {
        return this.basicSchedulerDataBinding;
    }

    public void setBasicSchedulerDataBinding(boolean value) {
        this.basicSchedulerDataBinding = value;
    }

    public void setQueueListDataBinding(List<String> queueListDataBinding) {
        this.queueListDataBinding = queueListDataBinding;
    }

    public String getHost() {
        return this.hostDataBinding;
    }

    public boolean setHost(String host) {
        this.hostDataBinding = host;
        return true;
    }

    public String getPort() {
        return this.portDataBinding;
    }

    public boolean setPort(String port) {
        this.portDataBinding = port;
        return true;
    }

    public String getProtocol() {
        return this.protocolDataBinding;
    }

    public boolean setProtocol(String protocol) {
        this.protocolDataBinding = protocol;
        return true;
    }

    public String getUsername() {
        return this.usernameDataBinding;
    }

    public boolean setUsername(String user) {
        this.usernameDataBinding = user;
        return true;
    }

    public String getPassword() {
        return this.passwordDataBinding;
    }

    public boolean setPassword(String passwd) {
        this.passwordDataBinding = passwd;
        return true;
    }

    public String getOutDir() {
        return this.outDirDataBinding;
    }

    public boolean setOutDir(String outdir) {
        this.outDirDataBinding = outdir;
        return true;
    }

    public String getRestAPIPath() {
        return this.restAPIPathDataBinding;
    }

    public boolean setRestApiPath(String uri) {
        this.restAPIPathDataBinding = uri;
        return true;
    }

    public String getJobExecutionProvider() {
        return this.jobExecutionProviderDataBinding;
    }

    public boolean setJobExecutionProvider(String type) {
        this.jobExecutionProviderDataBinding = type.equals(TYPE_ENUM_RESTURI) || type.equals(TYPE_ENUM_LAUNCHER) ? type : TYPE_ENUM_OS;
        return true;
    }

    public String getFlowOrchestratorHost() {
        return this.flowOrchHostDataBinding;
    }

    public void setFlowOrchestratorHost(String value) {
        this.flowOrchHostDataBinding = value;
    }

    public String getFlowOrchestratorPort() {
        return this.flowOrchPortDataBinding;
    }

    public void setFlowOrchestratorPort(String value) {
        this.flowOrchPortDataBinding = value;
    }

    public String getFlowOrchestrationCommand() {
        return this.flowOrchCommandDataBinding;
    }

    public void setFlowOrchestrationCommand(String value) {
        this.flowOrchCommandDataBinding = value;
    }

    public String getTriggerCommand() {
        return this.triggerCommandDataBinding;
    }

    public boolean setTriggerCommand(String path) {
        this.triggerCommandDataBinding = path;
        return true;
    }

    public String getOSCommandPath() {
        return this.osCommandPathDataBinding;
    }

    public void setOSCommandPath(String value) {
        this.osCommandPathDataBinding = value;
    }

    public String getAuthInfo() {
        return this.authInfoDataBinding;
    }

    public boolean setAuthInfo(String value) {
        this.authInfoDataBinding = value;
        return true;
    }

    public String getJobTracker() {
        return this.jobTrackerDataBinding;
    }

    public boolean setJobTracker(String path) {
        this.jobTrackerDataBinding = path;
        return true;
    }

    public String getWebNameNode() {
        return this.webNameNodeDataBinding;
    }

    public boolean setWebNameNode(String path) {
        this.webNameNodeDataBinding = path;
        return true;
    }

    public String getNameNode() {
        return this.nameNodeDataBinding;
    }

    public boolean setNameNode(String path) {
        this.nameNodeDataBinding = path;
        return true;
    }

    public String getCoordinatorPath() {
        return this.coordinatorDirDataBinding;
    }

    public boolean setCoordinatorPath(String path) {
        this.coordinatorDirDataBinding = path;
        return true;
    }

    public String getWorkflowPath() {
        return this.workflowDirDataBinding;
    }

    public boolean setWorkflowPath(String path) {
        this.workflowDirDataBinding = path;
        return true;
    }

    public static boolean checkCompatible(String oldClassID, String newClassID) {
        boolean compatible = false;
        if (oldClassID.compareTo(newClassID) == 0) {
            compatible = true;
        } else if (oldClassID.compareTo(SCH_Platform_JobScheduler_ID) == 0) {
            if (newClassID.compareTo(SCH_Platform_ProcessManager_ID) == 0) {
                compatible = true;
            }
        } else if (oldClassID.compareTo(SCH_Platform_ProcessManager_ID) == 0) {
            if (newClassID.compareTo(SCH_Platform_JobScheduler_ID) == 0) {
                compatible = true;
            }
        } else if (oldClassID.compareTo(SCH_OS_Scheduler_ID) == 0) {
            compatible = true;
        }
        return compatible;
    }

    public boolean isSubflowSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_SASJFS_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isTimeEventSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isFileEventSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isFileEventSupportedAsTriggers() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_IP_Scheduler_ID) == 0;
    }

    public boolean isEnterpriseLevelSupportOfFileEvents() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isAdvanceFlowCompletionCriteriaSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_SASJFS_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isEmailNotificationSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0;
    }

    public boolean isExclusiveSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0;
    }

    public boolean isJobDefaultEmailNotificationSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0;
    }

    public boolean isJobDefaultPrioritySupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_OS_Scheduler_ID) == 0;
    }

    public boolean isJobDefaultEnvironmentVariablesSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_OOZIE_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean hasCustomCalendarSupport() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isTimezoneSupported() {
        return this.timezoneSupportedDataBinding;
    }

    public boolean setTimezoneSupported(boolean value) {
        this.timezoneSupportedDataBinding = value;
        return true;
    }

    public boolean isMultiTriggersSupported() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_SASJFS_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0;
    }

    public boolean areQueues() {
        return this.classidDataBinding.compareTo(SCH_Platform_ProcessManager_ID) == 0 || this.classidDataBinding.compareTo(SCH_SASJFS_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_Platform_JobScheduler_ID) == 0;
    }

    public boolean isORGateSupported() {
        return this.classidDataBinding.compareTo(SCH_OOZIE_Scheduler_ID) != 0;
    }

    public boolean isSSLEnabled() {
        return this.protocolDataBinding != null && this.protocolDataBinding.compareToIgnoreCase(HTTPS) == 0;
    }

    public boolean isConsoleSupported() {
        return this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_SASJFS_Scheduler_ID) == 0;
    }

    public String generateXML() {
        if (this.nameDataBinding == null) {
            return "";
        }
        if (this.classidDataBinding == null) {
            return "";
        }
        return "<Scheduler Name=\"" + this.nameDataBinding + "\" ClassID=\"" + this.classidDataBinding + "\" Id=\"" + this.getId() + "\"/>\n";
    }

    public String getClassId() {
        return this.classidDataBinding;
    }

    public String getType() {
        return this.typeDataBinding;
    }

    public boolean isBasicScheduler() {
        return this.classidDataBinding.compareTo(SCH_OS_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_IP_Scheduler_ID) == 0;
    }

    public boolean hasJobRenderers() {
        return this.classidDataBinding.compareTo(SCH_PIP_Scheduler_ID) == 0 || this.classidDataBinding.compareTo(SCH_IP_Scheduler_ID) == 0;
    }

    public boolean showMessageQueues() {
        return this.classidDataBinding.compareTo(SCH_SASJFS_Scheduler_ID) == 0;
    }

    public int[] getAllSupportedEvents() {
        int[] jevents = SchedulerServerInfo.getAllJobEvents(this.classidDataBinding);
        int[] sevents = SchedulerServerInfo.getAllSubFlowEvents(this.classidDataBinding);
        int j = jevents.length;
        int count = j + sevents.length;
        int[] list = new int[count];
        for (int x = 0; x < count; ++x) {
            list[x] = x < j ? jevents[x] : sevents[x - j];
        }
        return list;
    }

    public static int[] getAllJobEvents(String classid) {
        int[] oJobEvents = null;
        oJobEvents = classid.compareTo(SCH_OS_Scheduler_ID) == 0 || classid.compareTo(SCH_OOZIE_Scheduler_ID) == 0 ? new int[]{0, 1, 2, 3} : (classid.compareTo(SCH_SASJFS_Scheduler_ID) == 0 ? new int[]{0, 1, 2, 3, 4, 5} : new int[]{0, 1, 2, 3, 6, 7, 8, 4, 5});
        return oJobEvents;
    }

    public static int[] getAllSubFlowEvents(String classid) {
        int[] oJobEvents = null;
        if (classid.compareTo(SCH_OS_Scheduler_ID) != 0 && classid.compareTo(SCH_PIP_Scheduler_ID) != 0 && classid.compareTo(SCH_OOZIE_Scheduler_ID) != 0 && classid.compareTo(SCH_IP_Scheduler_ID) != 0) {
            oJobEvents = classid.compareTo(SCH_SASJFS_Scheduler_ID) == 0 ? new int[]{10, 11, 13} : new int[]{10, 11, 13, 16, 18, 14, 15};
        }
        return oJobEvents;
    }

    public String getConnectionId() {
        return this.connectionIdDataBinding;
    }

    public void setConnectionId(String connectionId) {
        this.connectionIdDataBinding = connectionId;
    }

    public String buildFlowOrchestratorCommandLine(String id) {
        String sslOpt = "";
        if (this.isSSLEnabled()) {
            sslOpt = "-ssl";
        }
        String command = this.getFlowOrchestrationCommand() + " " + id + " -host " + this.getFlowOrchestratorHost() + " -port " + this.getFlowOrchestratorPort() + " " + sslOpt;
        return command;
    }

    static {
        String strClassName = SchedulerServerInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        IconName = m_bundle.getString("ScheduleServer.image");
    }
}

