/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SchedulerException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String m_packageName = null;
    private String m_tag = null;
    private Object[] m_args;

    public SchedulerException() {
    }

    public SchedulerException(String s) {
        super(s);
    }

    public SchedulerException(String defaultmessage, Class<?> source, String tag, Object[] args) {
        super(defaultmessage);
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_packageName = strPackageName + ".PropertyBundle";
        this.m_tag = tag;
        this.m_args = args;
    }

    public String getLocalizedMessage(Locale locale) {
        ResourceBundle lbundle = null;
        try {
            lbundle = ResourceBundle.getBundle(this.m_packageName, locale);
        }
        catch (Throwable e) {
            try {
                lbundle = PropertyResourceBundle.getBundle(this.m_packageName, locale);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (lbundle != null) {
            try {
                String pattern = lbundle.getString(this.m_tag);
                String msg = MessageFormat.format(pattern, this.m_args);
                return msg;
            }
            catch (RuntimeException ex) {
                return this.toString();
            }
        }
        return this.getLocalizedMessage();
    }
}

