/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.RunHistory;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public abstract class RunningItemInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Calendar m_creationTime = new GregorianCalendar();
    protected Calendar m_startTime = null;
    protected Calendar m_finishTime = null;
    protected boolean m_complete = false;
    protected int m_completionCode;
    protected boolean m_held = false;
    protected Calendar m_deadlineTime;
    protected RunningItemInfo m_parent = null;
    protected int m_priorityAddition = 0;
    protected int m_retryAttempts = 0;

    public void incrementPriorityAddition(int amount) {
        this.m_priorityAddition += amount;
    }

    public int getPriorityAddition() {
        return this.m_priorityAddition;
    }

    public int getCompletionCode() {
        return this.m_completionCode;
    }

    void setCompletionCode(int completionCode) {
        this.m_completionCode = completionCode;
    }

    public String getCompletionString() {
        return RunHistory.getCompletionAsString(this.getCompletionCode());
    }

    public abstract String getName();

    public abstract int getExitCode();

    public abstract String getUniqueID();

    public Calendar getCreationTime() {
        return this.m_creationTime;
    }

    public void setCreationTime(Calendar creationTime) {
        this.m_creationTime = creationTime;
    }

    public Calendar getFinishTime() {
        return this.m_finishTime;
    }

    public void setFinishTime(Calendar finishTime) {
        this.m_finishTime = finishTime;
    }

    public Calendar getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.m_startTime = startTime;
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    void setComplete(boolean complete) {
        this.m_complete = complete;
    }

    public abstract String getUserName();

    public abstract boolean kill(boolean var1);

    public RunningItemInfo getParent() {
        return this.m_parent;
    }

    protected void copyFrom(RunningItemInfo sourceItem) {
        this.m_complete = sourceItem.m_complete;
        this.m_held = sourceItem.m_held;
        this.m_completionCode = sourceItem.m_completionCode;
        this.m_creationTime = (Calendar)sourceItem.m_creationTime.clone();
        if (sourceItem.m_deadlineTime != null) {
            this.m_deadlineTime = (Calendar)sourceItem.m_deadlineTime.clone();
        }
        this.m_priorityAddition = sourceItem.m_priorityAddition;
        if (sourceItem.m_startTime != null) {
            this.m_startTime = (Calendar)sourceItem.m_startTime.clone();
        }
        if (sourceItem.m_finishTime != null) {
            this.m_finishTime = (Calendar)sourceItem.m_finishTime.clone();
        }
    }

    public int getRetryAttempts() {
        return this.m_retryAttempts;
    }

    public void incrementRetryAttempts() {
        ++this.m_retryAttempts;
    }

    protected abstract RunningItemInfo copy();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Complete: " + this.m_complete);
        buffer.append('\n');
        buffer.append("Held: " + this.m_held);
        buffer.append('\n');
        buffer.append("CompletionCode: " + this.m_completionCode);
        buffer.append('\n');
        buffer.append("Creation Time: " + SimpleDateFormat.getDateTimeInstance().format(this.m_creationTime.getTime()));
        buffer.append('\n');
        if (this.m_deadlineTime != null) {
            buffer.append("DeadLine: " + SimpleDateFormat.getDateTimeInstance().format(this.m_deadlineTime.getTime()));
            buffer.append('\n');
        }
        if (this.m_startTime != null) {
            buffer.append("StartTime: " + SimpleDateFormat.getDateTimeInstance().format(this.m_startTime.getTime()));
            buffer.append('\n');
        }
        if (this.m_finishTime != null) {
            buffer.append("FinishTime: " + SimpleDateFormat.getDateTimeInstance().format(this.m_finishTime.getTime()));
            buffer.append('\n');
        }
        buffer.append("Priority Addition: " + this.m_priorityAddition);
        buffer.append('\n');
        return buffer.toString();
    }
}

