/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowEventInterface;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="JobEventInfo", propOrder={"jobDataBinding", "typeDataBinding", "operatorDataBinding", "valueDataBinding"})
public class JobEventInfo
extends AbstractEventInfo
implements Serializable,
FlowEventInterface,
AbstractEventInterface {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Job", required=true)
    protected JobInfo jobDataBinding;
    @XmlElement(name="Type", required=true)
    protected int typeDataBinding;
    @XmlElement(name="Operator")
    protected int operatorDataBinding;
    @XmlElement(name="Value")
    protected int valueDataBinding;
    private static final ResourceBundle m_bundle;
    public static final int JOB_CompletesSuccessfully = 0;
    public static final String JOB_CompletesSuccessfully_Description;
    public static final int JOB_EndsWithAnyExitCode = 1;
    public static final String JOB_EndsWithAnyExitCode_Description;
    public static final int JOB_Starts = 2;
    public static final String JOB_Starts_Description;
    public static final int JOB_MissesScheduledTime = 6;
    public static final String JOB_MissesScheduledTime_Description;
    public static final int JOB_FailsToStart = 7;
    public static final String JOB_FailsToStart_Description;
    public static final int JOB_CannotRun = 8;
    public static final String JOB_CannotRun_Description;
    public static final int JOB_RunsMoreThan = 4;
    public static final String JOB_RunsMoreThan_Description;
    public static final int JOB_RunsLessThan = 5;
    public static final String JOB_RunsLessThan_Description;
    public static final int JOB_EndsExitCode = 3;
    public static final String JOB_EndsExitCode_Description;
    public static final int FLOW_CompletesSuccessfully = 10;
    public static final String FLOW_CompletesSuccessfully_Description;
    public static final int FLOW_EndsWithAnyExitCode = 11;
    public static final String FLOW_EndsWithAnyExitCode_Description;
    public static final int FLOW_MissesScheduledTime = 16;
    public static final String FLOW_MissesScheduledTime_Description;
    public static final int FLOW_CannotRun = 18;
    public static final String FLOW_CannotRun_Description;
    public static final int FLOW_RunsMoreThan = 14;
    public static final String FLOW_RunsMoreThan_Description;
    public static final int FLOW_RunsLessThan = 15;
    public static final String FLOW_RunsLessThan_Description;
    public static final int FLOW_EndsExitCode = 13;
    public static final String FLOW_EndsExitCode_Description;
    public static final String IconName;
    public static final int NO_OP = -1;
    public static final int OP_EQ = 21;
    public static final int OP_GT = 23;
    public static final int OP_GTE = 24;
    public static final int OP_LT = 25;
    public static final int OP_LTE = 26;
    public static final int OP_NE = 22;
    public static final int OP_NEGATION = 16;
    public static final int VAL_NONE = 0;

    public JobEventInfo() {
        super("", null, IconName);
        this.typeDataBinding = -1;
        this.operatorDataBinding = -1;
        this.valueDataBinding = 0;
    }

    public JobEventInfo(String name, int nType, int nOperator, int nValue) {
        super(name, MessageFormat.format(m_bundle.getString("JobEventInfo.Event.Description.fmt"), name), IconName);
        this.jobDataBinding = null;
        this.typeDataBinding = nType;
        this.setOperator(nOperator);
        this.valueDataBinding = nValue;
    }

    public JobEventInfo(JobInfo oJob, int nType, int nOperator, int nValue) {
        super(oJob.getName(), MessageFormat.format(m_bundle.getString("JobEventInfo.Event.Description.fmt"), oJob.getName()), IconName);
        this.jobDataBinding = oJob;
        this.typeDataBinding = nType;
        this.setOperator(nOperator);
        this.valueDataBinding = nValue;
    }

    public JobInfo getJobDataBinding() {
        return this.jobDataBinding;
    }

    public void setJobDataBinding(JobInfo value) {
        this.jobDataBinding = value;
    }

    public int getTypeDataBinding() {
        return this.typeDataBinding;
    }

    public void setTypeDataBinding(int value) {
        this.typeDataBinding = value;
    }

    public int getOperatorDataBinding() {
        return this.operatorDataBinding;
    }

    public void setOperatorDataBinding(int value) {
        this.operatorDataBinding = value;
    }

    public int getValueDataBinding() {
        return this.valueDataBinding;
    }

    public void setValueDataBinding(int value) {
        this.valueDataBinding = value;
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        return JobEventInfo.toString(this.getName(), this.typeDataBinding, this.operatorDataBinding, this.valueDataBinding, locale);
    }

    public static String toString(String job, int type, int operator, int value, Locale locale) {
        if (null == job) {
            return "";
        }
        String sDefinition = null;
        switch (type) {
            case 0: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_CompletesSuccessfully.fmt"), job);
                break;
            }
            case 1: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_EndsWithAnyExitCode.fmt"), job);
                break;
            }
            case 2: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_Starts.fmt"), job);
                break;
            }
            case 6: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_MissesScheduledTime.fmt"), job);
                break;
            }
            case 7: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_FailsToStart.fmt"), job);
                break;
            }
            case 8: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_CannotRun.fmt"), job);
                break;
            }
            case 4: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_RunsMoreThan.fmt"), job, String.valueOf(value));
                break;
            }
            case 5: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_RunsLessThan.fmt"), job, String.valueOf(value));
                break;
            }
            case 3: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.JOB_EndsExitCode.fmt"), job, String.valueOf(operator), String.valueOf(value));
                break;
            }
            case 10: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_CompletesSuccessfully.fmt"), job);
                break;
            }
            case 11: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_EndsWithAnyExitCode.fmt"), job);
                break;
            }
            case 16: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_MissesScheduledTime.fmt"), job);
                break;
            }
            case 18: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_CannotRun.fmt"), job);
                break;
            }
            case 14: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_RunsMoreThan.fmt"), job, String.valueOf(value));
                break;
            }
            case 15: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_RunsLessThan.fmt"), job, String.valueOf(value));
                break;
            }
            case 13: {
                sDefinition = MessageFormat.format(m_bundle.getString("JobEventInfo.EventName.FLOW_EndsExitCode.fmt"), job, String.valueOf(operator), String.valueOf(value));
                break;
            }
        }
        return sDefinition;
    }

    public static String getJobEventNameFromConditionString(String conditionString) {
        String name = null;
        try {
            name = conditionString.substring(conditionString.indexOf(40) + 1, conditionString.indexOf(41));
            int index = name.indexOf(",");
            if (index > 0) {
                name = name.substring(0, index);
            }
        }
        catch (RuntimeException ex) {
            name = null;
        }
        return name;
    }

    public static int getJobEventTypeFromConditionString(String conditionString, boolean subFlow) {
        try {
            String typeStr = conditionString.substring(0, conditionString.indexOf(40));
            if (subFlow) {
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_CompletesSuccessfully.fmt").startsWith(typeStr)) {
                    return 10;
                }
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_EndsWithAnyExitCode.fmt").startsWith(typeStr)) {
                    return 11;
                }
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_MissesScheduledTime.fmt").startsWith(typeStr)) {
                    return 16;
                }
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_CannotRun.fmt").startsWith(typeStr)) {
                    return 18;
                }
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_RunsMoreThan.fmt").startsWith(typeStr)) {
                    return 14;
                }
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_RunsLessThan.fmt").startsWith(typeStr)) {
                    return 15;
                }
                if (m_bundle.getString("JobEventInfo.EventName.FLOW_EndsExitCode.fmt").startsWith(typeStr)) {
                    return 13;
                }
            } else {
                if (m_bundle.getString("JobEventInfo.EventName.JOB_CompletesSuccessfully.fmt").startsWith(typeStr)) {
                    return 0;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_EndsWithAnyExitCode.fmt").startsWith(typeStr)) {
                    return 1;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_Starts.fmt").startsWith(typeStr)) {
                    return 2;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_MissesScheduledTime.fmt").startsWith(typeStr)) {
                    return 6;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_FailsToStart.fmt").startsWith(typeStr)) {
                    return 7;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_CannotRun.fmt").startsWith(typeStr)) {
                    return 8;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_RunsMoreThan.fmt").startsWith(typeStr)) {
                    return 4;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_RunsLessThan.fmt").startsWith(typeStr)) {
                    return 5;
                }
                if (m_bundle.getString("JobEventInfo.EventName.JOB_EndsExitCode.fmt").startsWith(typeStr)) {
                    return 3;
                }
            }
        }
        catch (RuntimeException ex) {
            return -1;
        }
        return -1;
    }

    public static String getJobEventOperatorFromConditionString(String conditionString) {
        String operator = null;
        try {
            String token = conditionString.substring(conditionString.indexOf(40) + 1, conditionString.indexOf(41));
            int index = token.indexOf(",");
            operator = index > 0 ? ((index = (operator = token.substring(index + 1)).indexOf(".")) > 0 ? operator.substring(0, index) : null) : null;
        }
        catch (RuntimeException ex) {
            operator = null;
        }
        return operator;
    }

    public static int getJobEventValueFromConditionString(String conditionString) {
        int value = 0;
        String valueStr = null;
        try {
            String token = conditionString.substring(conditionString.indexOf(40) + 1, conditionString.indexOf(41));
            int index = token.indexOf(",");
            if (index > 0) {
                valueStr = token.substring(index + 1);
                if ((index = valueStr.indexOf(".")) > 0) {
                    valueStr = valueStr.substring(index + 1);
                }
            } else {
                valueStr = null;
            }
        }
        catch (RuntimeException ex) {
            valueStr = null;
        }
        if (valueStr != null) {
            value = Integer.valueOf(valueStr);
        }
        return value;
    }

    public static String getEventTypeDescription(int type) {
        String strCondition = null;
        switch (type) {
            case 0: {
                strCondition = JOB_CompletesSuccessfully_Description;
                break;
            }
            case 1: {
                strCondition = JOB_EndsWithAnyExitCode_Description;
                break;
            }
            case 2: {
                strCondition = JOB_Starts_Description;
                break;
            }
            case 6: {
                strCondition = JOB_MissesScheduledTime_Description;
                break;
            }
            case 7: {
                strCondition = JOB_FailsToStart_Description;
                break;
            }
            case 8: {
                strCondition = JOB_CannotRun_Description;
                break;
            }
            case 4: {
                strCondition = JOB_RunsMoreThan_Description;
                break;
            }
            case 5: {
                strCondition = JOB_RunsLessThan_Description;
                break;
            }
            case 3: {
                strCondition = JOB_EndsExitCode_Description;
                break;
            }
            case 10: {
                strCondition = FLOW_CompletesSuccessfully_Description;
                break;
            }
            case 11: {
                strCondition = FLOW_EndsWithAnyExitCode_Description;
                break;
            }
            case 16: {
                strCondition = FLOW_MissesScheduledTime_Description;
                break;
            }
            case 18: {
                strCondition = FLOW_CannotRun_Description;
                break;
            }
            case 14: {
                strCondition = FLOW_RunsMoreThan_Description;
                break;
            }
            case 15: {
                strCondition = FLOW_RunsLessThan_Description;
                break;
            }
            case 13: {
                strCondition = FLOW_EndsExitCode_Description;
            }
        }
        return strCondition;
    }

    public JobInfo getJobInfo() {
        return this.jobDataBinding;
    }

    public boolean setJobInfo(JobInfo job) {
        this.setName(job.getName());
        this.setDescription(MessageFormat.format(m_bundle.getString("JobEventInfo.Event.Description.fmt"), job.getName()));
        this.jobDataBinding = job;
        return true;
    }

    public int getEventType() {
        return this.typeDataBinding;
    }

    public void setEventType(int nType) {
        this.typeDataBinding = nType;
    }

    public int getOperator() {
        return this.operatorDataBinding;
    }

    public void setOperator(int nOperator) {
        this.operatorDataBinding = nOperator;
    }

    public int getValue() {
        return this.valueDataBinding;
    }

    public void setValue(int nValue) {
        this.valueDataBinding = nValue;
    }

    public static String genName(DisplayInfo job) {
        return job.getName();
    }

    private String getDisplayDefinition() {
        if (null == this.jobDataBinding) {
            return "";
        }
        return JobEventInfo.toString(this.jobDataBinding.getName(), this.typeDataBinding, this.operatorDataBinding, this.valueDataBinding, Locale.getDefault());
    }

    private String getOperatorXML() {
        String operator = null;
        switch (this.operatorDataBinding) {
            case 21: {
                operator = "EQ";
                break;
            }
            case 23: {
                operator = "GT";
                break;
            }
            case 24: {
                operator = "GTE";
                break;
            }
            case 25: {
                operator = "LT";
                break;
            }
            case 26: {
                operator = "LTE";
                break;
            }
            case 22: {
                operator = "NE";
                break;
            }
            default: {
                operator = "";
            }
        }
        return operator;
    }

    @Override
    public String generateXML() {
        return this.generateXML(false, true);
    }

    @Override
    public String generateXML(boolean exportFormat) {
        return this.generateXML(exportFormat, true);
    }

    private String generateXML(boolean exportFormat, boolean newlines) {
        StringBuffer jobXML = new StringBuffer();
        String jobname = this.jobDataBinding.getName();
        if (!exportFormat) {
            jobname = this.jobDataBinding.getName() + "{" + this.jobDataBinding.getId() + "}";
        }
        String newline = "";
        if (newlines) {
            newline = "\n";
        }
        switch (this.typeDataBinding) {
            case 0: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<done Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 1: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<end Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 2: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<start Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 6: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<miss Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 7: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<fails Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 8: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<cannot Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 4: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<over Depend=\"" + jobname + "\" Value=\"" + this.valueDataBinding + "\"/>" + newline);
                break;
            }
            case 5: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<under Depend=\"" + jobname + "\" Value=\"" + this.valueDataBinding + "\"/>" + newline);
                break;
            }
            case 3: {
                jobXML.append("<Event Type=\"Job\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<exit Depend=\"" + jobname + "\" Operator=\"" + this.getOperatorXML() + "\" Value=\"" + this.valueDataBinding + "\"/>" + newline);
                break;
            }
            case 10: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<done Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 11: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<end Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 16: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<miss Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 18: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<cannot Depend=\"" + jobname + "\"/>" + newline);
                break;
            }
            case 14: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<over Depend=\"" + jobname + "\" Value=\"" + this.valueDataBinding + "\"/>" + newline);
                break;
            }
            case 15: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<under Depend=\"" + jobname + "\" Value=\"" + this.valueDataBinding + "\"/>" + newline);
                break;
            }
            case 13: {
                jobXML.append("<Event Type=\"subFlow\" Description=\"" + this.getDisplayDefinition() + "\">" + newline);
                jobXML.append("<exit Depend=\"" + jobname + "\" Operator=\"" + this.getOperatorXML() + "\" Value=\"" + this.valueDataBinding + "\"/>" + newline);
            }
        }
        jobXML.append("</Event>" + newline);
        return jobXML.toString();
    }

    public void initFromNode(Node node, HashMap<String, DisplayInfo> jobs) throws SchedulerException {
        try {
            NamedNodeMap map = node.getAttributes();
            String type = map.getNamedItem("Type").getNodeValue();
            boolean subFlow = false;
            if (type.compareTo("Job") == 0) {
                subFlow = false;
            } else if (type.compareTo("subFlow") == 0) {
                subFlow = true;
            } else {
                SchedulerException se = new SchedulerException("Invalid Type");
                throw se;
            }
            NodeList cnodes = node.getChildNodes();
            int numCNodes = cnodes.getLength();
            for (int x = 0; x < numCNodes; ++x) {
                DisplayInfo job;
                String jobName;
                NamedNodeMap attrs;
                Node cnode = cnodes.item(x);
                String tagname = cnode.getNodeName();
                if (tagname.compareTo("done") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    if (subFlow) {
                        this.typeDataBinding = 10;
                        continue;
                    }
                    this.typeDataBinding = 0;
                    continue;
                }
                if (tagname.compareTo("end") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    if (subFlow) {
                        this.typeDataBinding = 11;
                        continue;
                    }
                    this.typeDataBinding = 1;
                    continue;
                }
                if (tagname.compareTo("start") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    if (subFlow) {
                        SchedulerException se = new SchedulerException("Invalid Type");
                        throw se;
                    }
                    this.typeDataBinding = 2;
                    continue;
                }
                if (tagname.compareTo("miss") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    if (subFlow) {
                        this.typeDataBinding = 16;
                        continue;
                    }
                    this.typeDataBinding = 6;
                    continue;
                }
                if (tagname.compareTo("fails") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    if (subFlow) {
                        SchedulerException se = new SchedulerException("Invalid Type");
                        throw se;
                    }
                    this.typeDataBinding = 7;
                    continue;
                }
                if (tagname.compareTo("cannot") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    if (subFlow) {
                        this.typeDataBinding = 18;
                        continue;
                    }
                    this.typeDataBinding = 8;
                    continue;
                }
                if (tagname.compareTo("over") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    this.typeDataBinding = subFlow ? 14 : 4;
                    this.valueDataBinding = Integer.parseInt(attrs.getNamedItem("Value").getNodeValue());
                    continue;
                }
                if (tagname.compareTo("under") == 0) {
                    attrs = cnode.getAttributes();
                    jobName = attrs.getNamedItem("Depend").getNodeValue();
                    job = jobs.get(jobName);
                    if (job instanceof FlowInfo) {
                        this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                        this.jobDataBinding.setAsSubflow();
                        this.jobDataBinding.setDisplayOnly(true);
                    } else if (job instanceof JobInfo) {
                        this.jobDataBinding = (JobInfo)job;
                    }
                    this.typeDataBinding = subFlow ? 15 : 5;
                    this.valueDataBinding = Integer.parseInt(attrs.getNamedItem("Value").getNodeValue());
                    continue;
                }
                if (tagname.compareTo("exit") != 0) continue;
                attrs = cnode.getAttributes();
                jobName = attrs.getNamedItem("Depend").getNodeValue();
                job = jobs.get(jobName);
                if (job instanceof FlowInfo) {
                    this.jobDataBinding = new JobInfo(job.getName(), job.getId(), null);
                    this.jobDataBinding.setAsSubflow();
                    this.jobDataBinding.setDisplayOnly(true);
                } else if (job instanceof JobInfo) {
                    this.jobDataBinding = (JobInfo)job;
                }
                this.typeDataBinding = subFlow ? 13 : 3;
                this.setOperatorBasedOnXMLOperator(attrs.getNamedItem("Operator").getNodeValue());
                this.valueDataBinding = Integer.parseInt(attrs.getNamedItem("Value").getNodeValue());
            }
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause(npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause(rte);
            throw se;
        }
    }

    private void setOperatorBasedOnXMLOperator(String operator) {
        this.operatorDataBinding = operator.compareTo("EQ") == 0 ? 21 : (operator.compareTo("GT") == 0 ? 23 : (operator.compareTo("GTE") == 0 ? 24 : (operator.compareTo("LT") == 0 ? 25 : (operator.compareTo("LTE") == 0 ? 26 : (operator.compareTo("NE") == 0 ? 22 : -1)))));
    }

    static {
        String strClassName = JobEventInfo.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        JOB_CompletesSuccessfully_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_CompletesSuccessfully.txt");
        JOB_EndsWithAnyExitCode_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_EndsWithAnyExitCode.txt");
        JOB_Starts_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_Starts.txt");
        JOB_MissesScheduledTime_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_MissesScheduledTime.txt");
        JOB_FailsToStart_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_FailsToStart.txt");
        JOB_CannotRun_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_CannotRun.txt");
        JOB_RunsMoreThan_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_RunsMoreThan.txt");
        JOB_RunsLessThan_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_RunsLessThan.txt");
        JOB_EndsExitCode_Description = m_bundle.getString("JobEventInfo.EventDesc.JOB_EndsExitCode.txt");
        FLOW_CompletesSuccessfully_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_CompletesSuccessfully.txt");
        FLOW_EndsWithAnyExitCode_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_EndsWithAnyExitCode.txt");
        FLOW_MissesScheduledTime_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_MissesScheduledTime.txt");
        FLOW_CannotRun_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_CannotRun.txt");
        FLOW_RunsMoreThan_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_RunsMoreThan.txt");
        FLOW_RunsLessThan_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_RunsLessThan.txt");
        FLOW_EndsExitCode_Description = m_bundle.getString("JobEventInfo.EventDesc.FLOW_EndsExitCode.txt");
        IconName = m_bundle.getString("Default.image");
    }
}

