/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.model;

import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.svcs.commons.webservice.jaxb.JaxbDateXmlAdapter;
import com.sas.text.Message;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DateList", propOrder={"datesDataBinding"})
public class DateList
extends AbstractRecurrence
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Date", required=true, type=String.class)
    @XmlJavaTypeAdapter(value=JaxbDateXmlAdapter.class)
    @XmlSchemaType(name="date")
    protected List<Date> datesDataBinding = new ArrayList<Date>();
    static final String XML_DateList_Tag = "dateList";
    static final String XML_Date_Year = "year";
    static final String XML_Date_Month = "month";
    static final String XML_Date_Day = "day";
    static final String XML_Date_Tag = "date";

    public List<Date> getDatesDataBinding() {
        if (this.datesDataBinding == null) {
            this.datesDataBinding = new ArrayList<Date>();
        }
        return this.datesDataBinding;
    }

    public void setDatesDataBinding(List<Date> datesDataBinding) {
        this.datesDataBinding = datesDataBinding;
    }

    public List<Calendar> getDatesToRun() {
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        for (Date date : this.datesDataBinding) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            list.add(cal);
        }
        return list;
    }

    public void setDatesToRun(List<Calendar> datesToRun) {
        this.clearDates();
        for (Calendar cal : datesToRun) {
            this.addDate(cal);
        }
    }

    public void clearDates() {
        this.datesDataBinding.clear();
    }

    public boolean addDate(Calendar newDate) {
        if (newDate != null) {
            for (Date runDate : this.datesDataBinding) {
                Calendar runCal = Calendar.getInstance();
                runCal.setTime(runDate);
                if (!AbstractRecurrence.isEqualByDay(runCal, newDate)) continue;
                return false;
            }
            this.datesDataBinding.add(newDate.getTime());
            Collections.sort(this.datesDataBinding, AbstractRecurrence.MyDateComparator);
            return true;
        }
        return false;
    }

    @Override
    public boolean includesDate(Calendar date) {
        for (Date existingDate : this.datesDataBinding) {
            Calendar existingCal = Calendar.getInstance();
            existingCal.setTime(existingDate);
            if (!AbstractRecurrence.isEqualByDay(date, existingCal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Calendar> getNextDates(Calendar startDate, Calendar endQueryDate, int count) {
        ArrayList<Calendar> results = new ArrayList<Calendar>();
        if (endQueryDate == null || startDate == null || count < 0) {
            return results;
        }
        for (Date runDate : this.datesDataBinding) {
            Calendar runCal = Calendar.getInstance();
            runCal.setTime(runDate);
            if (AbstractRecurrence.isBeforeByDay(runCal, startDate) || AbstractRecurrence.isAfterByDay(runCal, endQueryDate)) continue;
            results.add((Calendar)runCal.clone());
            if (count <= 0 || results.size() < count) continue;
            break;
        }
        return results;
    }

    @Override
    public String toString(Locale locale) {
        String strClassName = DateList.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        ResourceBundle bundle = ResourceBundle.getBundle(strBundlePath, locale);
        String expression = "";
        String[] dateStrings = new String[this.datesDataBinding.size()];
        int index = 0;
        for (Date runDate : this.datesDataBinding) {
            Calendar runCal = Calendar.getInstance();
            runCal.setTime(runDate);
            dateStrings[index++] = AbstractRecurrence.dateToString(runCal, locale);
        }
        String dateListString = AbstractRecurrence.generateLocaleStringFromList(locale, dateStrings, "DateList.toString.List.First.fmt.txt", "DateList.toString.List.Middle.fmt.txt", "DateList.toString.List.Last.fmt.txt");
        Object[] args = new Object[]{dateListString};
        expression = Message.format((ResourceBundle)bundle, (String)"DateList.toString.List.fmt.txt", (Object[])args);
        return expression;
    }

    @Override
    public IRecurrenceInfo copy() {
        DateList recurrence = new DateList();
        recurrence.copyFrom(this);
        return recurrence;
    }

    @Override
    protected void copyFrom(IRecurrenceInfo source) {
        this.datesDataBinding.clear();
        if (source instanceof DateList) {
            DateList recurrence = (DateList)source;
            for (Date runDate : recurrence.getDatesDataBinding()) {
                this.datesDataBinding.add(runDate);
            }
        }
    }

    @Override
    public void toXML(StringBuffer buffer) {
        buffer.append("<");
        buffer.append(XML_DateList_Tag);
        buffer.append(">");
        for (Date date : this.datesDataBinding) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            buffer.append("<");
            buffer.append(XML_Date_Tag);
            buffer.append(" ");
            buffer.append(XML_Date_Year);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(cal.get(1));
            buffer.append('\"');
            buffer.append(" ");
            buffer.append(XML_Date_Month);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(cal.get(2) + 1);
            buffer.append('\"');
            buffer.append(" ");
            buffer.append(XML_Date_Day);
            buffer.append("=");
            buffer.append('\"');
            buffer.append(cal.get(5));
            buffer.append('\"');
            buffer.append("/>");
        }
        buffer.append("</");
        buffer.append(XML_DateList_Tag);
        buffer.append(">");
    }

    @Override
    public void injectXML(Document doc, Element parent) {
        Element tag = doc.createElement(XML_DateList_Tag);
        parent.appendChild(tag);
        for (Date date : this.datesDataBinding) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            Element dateTag = doc.createElement(XML_Date_Tag);
            tag.appendChild(dateTag);
            dateTag.setAttribute(XML_Date_Year, Integer.toString(cal.get(1)));
            dateTag.setAttribute(XML_Date_Month, Integer.toString(cal.get(2) + 1));
            dateTag.setAttribute(XML_Date_Day, Integer.toString(cal.get(5)));
        }
    }

    @Override
    public void toShortUniqueString(StringBuffer buffer) {
        buffer.append("DL_");
        for (Date date : this.datesDataBinding) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            buffer.append(this.calendarToShortString(cal));
            buffer.append('_');
        }
    }
}

