/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.antlr;

import com.sas.commons.antlr.ParseError;
import com.sas.commons.antlr.Util;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ErrorHandler {
    private final LinkedList<ParseError> errors = new LinkedList();

    public void handleError(@NonNull ParseError error) {
        this.errors.add(error);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ParseError> errors() {
        return Util.unmodifiableList(this.errors);
    }

    public List<String> messages() {
        ArrayList<String> messages = new ArrayList<String>(this.errors.size());
        for (ParseError err : this.errors) {
            messages.add(err.message);
        }
        return Util.unmodifiableList(messages);
    }

    public void clear() {
        this.errors.clear();
    }

    public String toString() {
        return this.toString(", ");
    }

    public String toString(String delimiter) {
        if (this.errors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator itr = this.errors.iterator();
        while (true) {
            sb.append(itr.next());
            if (!itr.hasNext()) break;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

