/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security.sspi;

import com.sas.security.sspi.SSPIAuthException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSPIAuth {
    public static final String SECURITY_PACKAGE_KERBEROS = "Kerberos";
    public static final String SECURITY_PACKAGE_NTLM = "NTLM";
    public static final String SECURITY_PACKAGE_NEGOTIATE = "Negotiate";
    public static final String SECURITY_PACKAGE_DEFAULT = "Negotiate";
    public static final String SECURITY_PACKAGE_LIST_DEFAULT = "Kerberos,NTLM";
    public static final String PROPERTYNAME_LIBRARY_NAME = "com.sas.security.sspi.library.name";
    private static final String[] libraryNameArr = new String[]{"sspiauth", "sspiauth_w32", "sspiauth_w64", "sspiauth_wx6"};
    private static final String SERVICE_CLASS_SAS = "SAS";
    private static final String libPathPropName = "java.library.path";
    private static Pattern listDelim;
    private static boolean libraryLoaded;
    private String securityPackage;
    private String securityPackageList;
    private String servicePrincipalName;
    private String machineName;
    private int maxMessage;
    private long[] hcTxt;
    private long[] hCred;
    private boolean pfDone;
    private boolean bKerb;
    private boolean bNego;

    private static native String n_CreateServicePrincipalName(String var0, String var1, int var2);

    private static native int n_QueryMaxMessageSize(String var0);

    private static native void n_DeleteSecurityContext(long[] var0);

    private static native void n_FreeCredentialsHandle(long[] var0);

    private static native int n_GenClientContext(Object var0, String var1, String var2, String var3, byte[] var4, byte[] var5, long[] var6, long[] var7) throws SSPIAuthException;

    public SSPIAuth(String sp, String spl, String spn, String machine, int p) {
        String msg = "SSPIAuth.<init>(" + sp + "," + spl + "," + spn + "," + machine + "," + Integer.toString(p) + ")";
        SSPIAuth.logMessageFine(msg);
        this.hcTxt = new long[2];
        this.hCred = new long[2];
        this.securityPackage = sp == null ? "Negotiate" : sp;
        this.securityPackageList = spl;
        this.servicePrincipalName = spn;
        this.machineName = machine;
        SSPIAuth.loadNativeLibrary();
        this.bNego = this.securityPackage.equals("Negotiate");
        this.bKerb = this.securityPackage.equals(SECURITY_PACKAGE_KERBEROS);
        if (this.bKerb || this.bNego) {
            if (this.servicePrincipalName == null) {
                this.servicePrincipalName = this.CreateServicePrincipalName();
            }
            if (this.bNego && this.securityPackageList == null) {
                this.securityPackageList = SECURITY_PACKAGE_LIST_DEFAULT;
            }
        }
        this.maxMessage = SSPIAuth.n_QueryMaxMessageSize(this.securityPackage);
        this.pfDone = false;
    }

    public SSPIAuth(String sp, String spn, String machine, int p) {
        this(sp, null, spn, machine, p);
    }

    protected SSPIAuth(String spn) {
        this.servicePrincipalName = spn;
    }

    private String CreateServicePrincipalName() {
        String hostName = SSPIAuth.createServicePrincipalNameForHost(this.machineName);
        return hostName;
    }

    private static String getHostName(String machineName) {
        try {
            InetAddress inetAddr = InetAddress.getByName(machineName);
            SSPIAuth.logMessageFine("machineName " + machineName + " resolved to IP address " + inetAddr);
            String hostName = inetAddr.getHostName();
            SSPIAuth.logMessageFine("IP address " + inetAddr + " resolved to " + hostName);
            return hostName;
        }
        catch (Throwable t) {
            SSPIAuth.logMessageFine("machineName resolution failed " + t);
            return machineName;
        }
    }

    public String GetServicePricipalName() {
        String spn = this.GetServicePrincipalName();
        return spn;
    }

    public String GetServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public int GetMaxMessageSize() {
        return this.maxMessage;
    }

    public void SetSecurityPackageList(String spl) {
        this.securityPackageList = spl;
    }

    public boolean AmIDone() {
        return this.pfDone;
    }

    public int GenClientContext(byte[] in, byte[] out) {
        int ss = SSPIAuth.n_GenClientContext(this, this.securityPackage, this.securityPackageList, this.servicePrincipalName, in, out, this.hCred, this.hcTxt);
        return ss;
    }

    public void deleteSecurityContext() {
        SSPIAuth.n_DeleteSecurityContext(this.hcTxt);
    }

    public void freeCredentialsHandle() {
        SSPIAuth.n_FreeCredentialsHandle(this.hCred);
    }

    public static String normalizeSecurityPackage(String sp) {
        if ("Negotiate".equalsIgnoreCase(sp)) {
            return "Negotiate";
        }
        if (SECURITY_PACKAGE_KERBEROS.equalsIgnoreCase(sp)) {
            return SECURITY_PACKAGE_KERBEROS;
        }
        if (SECURITY_PACKAGE_NTLM.equalsIgnoreCase(sp)) {
            return SECURITY_PACKAGE_NTLM;
        }
        return sp;
    }

    public static String normalizeSecurityPackageList(String spl) {
        Pattern delim = SSPIAuth.getListDelim();
        String[] spArr = delim.split(spl);
        int splL = spl.length();
        StringBuffer buf = new StringBuffer(splL);
        for (int i = 0; i < spArr.length; ++i) {
            String rawSP = spArr[i];
            if (rawSP == null || rawSP.length() <= 0) continue;
            String nrmSP = SSPIAuth.normalizeSecurityPackage(rawSP);
            buf.append(nrmSP).append(",");
        }
        int bufL = buf.length();
        buf.setLength(bufL - 1);
        String nrm = buf.toString();
        return nrm;
    }

    public static String createServicePrincipalNameForHost(String host) {
        String hostName = SSPIAuth.getHostName(host);
        int bufL = SERVICE_CLASS_SAS.length() + hostName.length() + 1;
        StringBuffer buf = new StringBuffer(bufL);
        buf.append(SERVICE_CLASS_SAS);
        buf.append("/");
        buf.append(hostName);
        String str = buf.toString();
        return str;
    }

    private static void logMessageFine(String msg) {
        SSPIAuth.logMessageFine(msg, null);
    }

    private static void logMessageFine(String msg, Throwable ex) {
        String loggerName = SSPIAuth.class.getPackage().getName();
        Logger logger = LogManager.getLogger((String)loggerName);
        if (logger.isDebugEnabled()) {
            if (ex == null) {
                logger.debug(msg);
            } else {
                logger.debug(msg, ex);
            }
        }
    }

    private static synchronized Pattern getListDelim() {
        if (listDelim == null) {
            listDelim = Pattern.compile("([\\s]*,[\\s]*)+");
        }
        return listDelim;
    }

    private static synchronized void loadNativeLibrary() {
        String[][] stringArrayArray;
        if (libraryLoaded) {
            return;
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                try {
                    String libPath = System.getProperty(SSPIAuth.libPathPropName);
                    SSPIAuth.logMessageFine("java.library.path=" + libPath);
                }
                catch (SecurityException libPath) {
                    // empty catch block
                }
                String name = null;
                try {
                    name = System.getProperty(SSPIAuth.PROPERTYNAME_LIBRARY_NAME);
                    SSPIAuth.logMessageFine("com.sas.security.sspi.library.name=" + name);
                }
                catch (SecurityException se) {
                    SSPIAuth.logMessageFine("ignoring system property com.sas.security.sspi.library.name due to security exception", se);
                }
                return name;
            }
        };
        String overrideName = (String)AccessController.doPrivileged(action);
        if (overrideName != null) {
            String[][] stringArrayArray2 = new String[2][];
            stringArrayArray2[0] = new String[]{overrideName};
            stringArrayArray = stringArrayArray2;
            stringArrayArray2[1] = libraryNameArr;
        } else {
            String[][] stringArrayArray3 = new String[1][];
            stringArrayArray = stringArrayArray3;
            stringArrayArray3[0] = libraryNameArr;
        }
        String[][] nameArr = stringArrayArray;
        UnsatisfiedLinkError firstULE = null;
        for (int i = 0; i < nameArr.length; ++i) {
            for (int j = 0; j < nameArr[i].length; ++j) {
                String name = nameArr[i][j];
                try {
                    System.loadLibrary(name);
                    SSPIAuth.logMessageFine("loaded " + name);
                    libraryLoaded = true;
                    return;
                }
                catch (UnsatisfiedLinkError ule) {
                    if (firstULE == null) {
                        firstULE = ule;
                    }
                    SSPIAuth.logMessageFine("could not load " + name + ": " + ule.getMessage());
                    continue;
                }
            }
        }
        throw firstULE;
    }
}

