/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.simple;

import MITI.MIRException;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.profiles.impl.memory.simple.SubModelProfiler;
import java.util.Iterator;
import java.util.LinkedList;

public class ProfilerModelCache {
    private SubModelProfiler current = null;
    private LinkedList<SubModelProfiler> supplierCache = new LinkedList();
    private int maxSize;

    public ProfilerModelCache(int n) {
        this.maxSize = n;
    }

    private static boolean isStoreContent(SubModelProfiler subModelProfiler) {
        MIRContent mIRContent = subModelProfiler.getContent();
        return mIRContent instanceof MIRStoreContent;
    }

    public void load(SubModelProfiler subModelProfiler) throws MIRException {
        this.clearCurrent();
        if (ProfilerModelCache.isStoreContent(subModelProfiler)) {
            this.loadSupplier(subModelProfiler);
        } else {
            subModelProfiler.load();
        }
        this.current = subModelProfiler;
    }

    public void unload(SubModelProfiler subModelProfiler) {
    }

    public void loadSupplier(SubModelProfiler subModelProfiler) throws MIRException {
        if (this.supplierCache.contains(subModelProfiler)) {
            this.supplierCache.remove(subModelProfiler);
            this.supplierCache.addFirst(subModelProfiler);
        } else {
            if (this.supplierCache.size() == this.maxSize) {
                SubModelProfiler subModelProfiler2 = this.getModelToRemove();
                this.supplierCache.remove(subModelProfiler2);
                subModelProfiler2.unload();
            }
            subModelProfiler.load();
            this.supplierCache.addFirst(subModelProfiler);
        }
    }

    private SubModelProfiler getModelToRemove() {
        Iterator<SubModelProfiler> iterator = this.supplierCache.descendingIterator();
        while (iterator.hasNext()) {
            SubModelProfiler subModelProfiler = iterator.next();
            if (this.current != null && subModelProfiler == this.current || this.current != null && subModelProfiler == this.current) continue;
            return subModelProfiler;
        }
        return null;
    }

    public void unloadSupplier(SubModelProfiler subModelProfiler) {
    }

    public void clear() throws MIRException {
        this.clearCurrent();
        for (SubModelProfiler subModelProfiler : this.supplierCache) {
            subModelProfiler.unload();
        }
        this.supplierCache.clear();
    }

    private void clearCurrent() throws MIRException {
        if (this.current != null) {
            if (!ProfilerModelCache.isStoreContent(this.current)) {
                this.current.unload();
            }
            this.current = null;
        }
    }
}

