/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.simple;

import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.SummaryLineageProfileLink;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.List;

public class DeferredLineageProfileLink {
    private PartialNode source;
    private PartialNode destination;
    private LineageProfileLink link;

    public DeferredLineageProfileLink(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, LineageProfileLink lineageProfileLink) {
        this.source = new PartialNode(objectIdentifier);
        this.destination = new PartialNode(objectIdentifier2);
        this.link = lineageProfileLink;
    }

    public DeferredLineageProfileLink(DeferredLineageProfileLink deferredLineageProfileLink) {
        this.source = deferredLineageProfileLink.getSource();
        this.destination = deferredLineageProfileLink.getDestination();
        LineageProfileLink lineageProfileLink = deferredLineageProfileLink.getLink();
        this.link = lineageProfileLink instanceof SummaryLineageProfileLink ? new SummaryLineageProfileLink((SummaryLineageProfileLink)lineageProfileLink) : new LineageProfileLink(lineageProfileLink);
    }

    public PartialNode getSource() {
        return this.source;
    }

    public PartialNode getDestination() {
        return this.destination;
    }

    public LineageProfileLink getLink() {
        return this.link;
    }

    public void setLink(LineageProfileLink lineageProfileLink) {
        this.link = lineageProfileLink;
    }

    public class PartialNode {
        private ObjectIdentifier identifier;
        private List<ProfiledObject> resolvedObjects;
        private boolean resolved;

        public PartialNode(ObjectIdentifier objectIdentifier) {
            this.identifier = objectIdentifier;
            this.resolvedObjects = null;
            this.resolved = false;
        }

        public ObjectIdentifier getIdentifier() {
            return this.identifier;
        }

        public void addResolvedObject(ProfiledObject profiledObject) {
            if (this.resolvedObjects == null) {
                this.resolvedObjects = new ArrayList<ProfiledObject>();
            }
            this.resolvedObjects.add(profiledObject);
        }

        public void setResolved() {
            this.resolved = true;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public List<ProfiledObject> getResolvedObjects() {
            if (this.resolvedObjects == null) {
                this.resolvedObjects = new ArrayList<ProfiledObject>();
            }
            return this.resolvedObjects;
        }
    }
}

