/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.messages.MIR.MIRSDK;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.ReferenceProfileLink;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeSet;

public class SimpleTreeIterator
implements Iterator<ProfileLink> {
    protected Stack<AggregationProfileLink> childrenCache = new Stack();
    protected Stack<ReferenceProfileLink> allLinksCache = new Stack();
    protected Stack<ReferenceProfileLink> linksCache = new Stack();
    protected ProfilerImpl profiler;
    private TreeSet<ObjectIdentifier> objectIds = new TreeSet();
    private ProfiledObject root;

    public String toString() {
        String string = this.getClass().getSimpleName();
        return string + " [" + this.root.getObjectDefinition().toString() + "]";
    }

    public SimpleTreeIterator(ProfilerImpl profilerImpl, ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        this.profiler = profilerImpl;
        this.childrenCache.push(this.createAggregationLink(profiledObject, profiledObject2));
        this.objectIds.add(profiledObject2.getObjectDefinition());
        this.root = profiledObject2;
    }

    private AggregationProfileLink createAggregationLink(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        MIRProfileLink mIRProfileLink = this.profiler.getProfileLink(profiledObject, profiledObject2);
        return new AggregationProfileLink(profiledObject, profiledObject2, mIRProfileLink, profiledObject2.getObjectDefinition().getGroupName());
    }

    @Override
    public boolean hasNext() {
        if (this.childrenCache.size() != 0) {
            return true;
        }
        this.fetchNextLink();
        return this.linksCache.size() != 0;
    }

    private void fetchNextLink() {
        while (this.allLinksCache.size() > 0) {
            ReferenceProfileLink referenceProfileLink = this.allLinksCache.pop();
            if (!this.objectIds.contains(referenceProfileLink.getDestinationNode().getObjectDefinition()) || !this.objectIds.contains(referenceProfileLink.getSourceNode().getObjectDefinition())) continue;
            this.linksCache.push(referenceProfileLink);
            return;
        }
    }

    @Override
    public ProfileLink next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No elements exist");
            }
            if (this.childrenCache.size() == 0) {
                return this.linksCache.pop();
            }
            ProfileLink profileLink = this.childrenCache.pop();
            ProfiledObject profiledObject = profileLink.getDestinationNode();
            MIRProfileEntity mIRProfileEntity = this.profiler.getProfileEntity(profiledObject);
            MIRProfileGroup mIRProfileGroup = this.profiler.getProfileGroup(profiledObject);
            ProfiledObject[] profiledObjectArray = this.profiler.getLinks(profiledObject);
            if (profiledObjectArray != null) {
                for (int i = profiledObjectArray.length - 1; i >= 0; --i) {
                    Object object;
                    ProfiledObject profiledObject2 = profiledObjectArray[i];
                    if (profiledObject2.getLinkType() == 0 || profiledObject2.getLinkType() == 1) {
                        object = null;
                        if (mIRProfileEntity != null) {
                            object = mIRProfileEntity.getProfileLink(profiledObject2.getLinkId(), this.profiler.getProfileEntity(profiledObject2));
                        } else if (mIRProfileGroup != null) {
                            object = mIRProfileGroup.getProfileLink(profiledObject2.getLinkId(), this.profiler.getProfileEntity(profiledObject2));
                        }
                        ReferenceProfileLink referenceProfileLink = new ReferenceProfileLink(profiledObject, profiledObject2, (MIRProfileLink)object);
                        this.allLinksCache.push(referenceProfileLink);
                        continue;
                    }
                    if (!this.isProcessChildren(profiledObject, profiledObject2)) continue;
                    object = this.createAggregationLink(profiledObject, profiledObject2);
                    this.childrenCache.push((AggregationProfileLink)object);
                    this.objectIds.add(profiledObject2.getObjectDefinition());
                }
            }
            return profileLink;
        }
        catch (MIRException mIRException) {
            MIRSDK.EXCEPTION.log(mIRException, mIRException.getMessage());
            throw new NoSuchElementException(mIRException.getMessage());
        }
    }

    protected boolean isProcessChildren(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    ProfileLink peek() {
        return this.childrenCache.peek();
    }

    public TreeSet<ObjectIdentifier> getObjectIds() {
        return this.objectIds;
    }
}

