/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.messages.MIR.MIRSDK;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.impl.memory.original.SimpleTreeIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class QueuedIterators
implements Iterator<ProfileLink> {
    private static int modelsIterated = 0;
    protected List<Iterator<ProfileLink>> iterators = new LinkedList<Iterator<ProfileLink>>();
    private Iterator<ProfileLink> currentIterator = null;
    private long startTime;

    void addIterator(Iterator<ProfileLink> iterator) {
        this.iterators.add(iterator);
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                return true;
            }
            this.loadNextIterator();
            return this.currentIterator == null ? false : this.currentIterator.hasNext();
        }
        catch (MIRException mIRException) {
            MIRSDK.EXCEPTION.log(mIRException, mIRException.getMessage());
            throw new NoSuchElementException(mIRException.getMessage());
        }
    }

    @Override
    public ProfileLink next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNextIterator() throws MIRException {
        this.iteratorComplete(this.currentIterator);
        if (this.currentIterator != null) {
            PRFLR.MSG_DONE_ITERATING_MODEL.log("(" + (System.currentTimeMillis() - this.startTime) + "ms)" + this.currentIterator);
        }
        this.currentIterator = null;
        while (this.iterators.size() > 0) {
            Iterator<ProfileLink> iterator = this.iterators.remove(0);
            this.loadNextIterator(iterator);
            if (iterator.hasNext()) {
                this.currentIterator = iterator;
                break;
            }
            this.iteratorComplete(iterator);
        }
        if (this.currentIterator != null) {
            this.startTime = System.currentTimeMillis();
            PRFLR.MSG_START_ITERATING_MODEL.log("(" + modelsIterated + ") " + this.currentIterator);
            if (this.currentIterator instanceof SimpleTreeIterator) {
                ++modelsIterated;
            }
        }
    }

    protected void loadNextIterator(Iterator<ProfileLink> iterator) throws MIRException {
    }

    protected void iteratorComplete(Iterator<ProfileLink> iterator) throws MIRException {
    }
}

