/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFilter;
import MITI.sdk.MIRLevelAttribute;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.impl.memory.Util;
import MITI.sdk.profiles.impl.memory.original.DirectoryContentLinkIterator;
import MITI.sdk.profiles.impl.memory.original.ProfiledObjectWithParent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ModelSummary {
    private MIRStoreModel model;
    private Map<MIRObject, Set<ProfiledObjectWithParent>> map = new TreeMap<MIRObject, Set<ProfiledObjectWithParent>>();

    public ModelSummary(MIRStoreModel mIRStoreModel) throws MIRException {
        this.model = mIRStoreModel;
    }

    public Set<ProfiledObjectWithParent> getSources(MIRObject mIRObject) {
        Set<ProfiledObjectWithParent> set = this.map.get(mIRObject);
        return set;
    }

    private static Set<MIRObject> getDirectSources(MIRObject mIRObject) {
        SortedSet<MIRElement> sortedSet;
        HashSet<MIRObject> hashSet = new HashSet<MIRObject>();
        if (mIRObject instanceof MIRLevelAttribute) {
            mIRObject = ((MIRLevelAttribute)mIRObject).getDimensionAttribute();
        }
        if (mIRObject instanceof MIRFeature) {
            sortedSet = ((MIRFeature)mIRObject).getDestinationOfFeatureMaps();
            for (MIRElement mIRElement : sortedSet) {
                hashSet.addAll(((MIRFeatureMap)mIRElement).getSourceFeatures());
            }
        }
        if (mIRObject instanceof MIRElement) {
            sortedSet = ((MIRElement)mIRObject).getClientOfElementMaps();
            for (MIRElement mIRElement : sortedSet) {
                hashSet.addAll(((MIRElementMap)mIRElement).getSupplierElements());
            }
        }
        return hashSet;
    }

    private static void getUltimateSources(Set<MIRObject> set, Set<MIRObject> set2, Set<MIRObject> set3) {
        for (MIRObject mIRObject : set) {
            if (set3.contains(mIRObject)) continue;
            Set<MIRObject> set4 = ModelSummary.getDirectSources(mIRObject);
            if (set4.isEmpty()) {
                if (Util.getStoreConnection(mIRObject) == null) continue;
                set2.add(mIRObject);
                continue;
            }
            set3.add(mIRObject);
            ModelSummary.getUltimateSources(set4, set2, set3);
        }
    }

    private static Set<MIRObject> getUltimateSources(MIRObject mIRObject) {
        TreeSet<MIRObject> treeSet = new TreeSet<MIRObject>();
        TreeSet<MIRObject> treeSet2 = new TreeSet<MIRObject>();
        treeSet2.add(mIRObject);
        TreeSet<MIRObject> treeSet3 = new TreeSet<MIRObject>();
        ModelSummary.getUltimateSources(treeSet2, treeSet, treeSet3);
        return treeSet;
    }

    public void buildSummary(DirectoryContentLinkIterator directoryContentLinkIterator) throws MIRException {
        ModelTraversal modelTraversal = new ModelTraversal();
        this.model.depthTraversal(modelTraversal);
        List<MIRFeature> list = modelTraversal.getFeatures();
        for (MIRFeature mIRFeature : list) {
            Set<MIRObject> set = ModelSummary.getUltimateSources(mIRFeature);
            TreeSet<ProfiledObjectWithParent> treeSet = new TreeSet<ProfiledObjectWithParent>();
            for (MIRObject mIRObject : set) {
                List<ProfiledObjectWithParent> list2 = directoryContentLinkIterator.getMasterProfiledObjects(mIRObject);
                if (list2 == null) continue;
                treeSet.addAll(list2);
            }
            this.map.put(mIRFeature, treeSet);
            if (!(mIRFeature instanceof MIRCondition) || !(mIRFeature.getClassifier() instanceof MIRFilter)) continue;
            this.map.put(mIRFeature.getClassifier(), treeSet);
        }
    }

    private class ModelTraversal
    implements MIR_Object.MIRTraversalOperation {
        private List<MIRFeature> features = new ArrayList<MIRFeature>();

        private ModelTraversal() {
        }

        public List<MIRFeature> getFeatures() {
            return this.features;
        }

        @Override
        public boolean traverse(MIRObject mIRObject) throws MIRException {
            switch (mIRObject.getElementType()) {
                case 11: 
                case 76: 
                case 78: 
                case 90: 
                case 92: 
                case 108: 
                case 112: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) throws MIRException {
            if (mIRObject instanceof MIRFeature) {
                this.features.add((MIRFeature)mIRObject);
            }
        }

        @Override
        public void post_process(MIRObject mIRObject) throws MIRException {
        }
    }
}

