/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.original;

import MITI.MIRException;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.messages.MIRProfilerPartnerSDK.PPSDK;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.impl.memory.original.DirectoryContentLinkIterator;
import MITI.sdk.profiles.impl.memory.original.DirectoryContentTreeIterator;
import MITI.sdk.profiles.impl.memory.original.ModelSummary;
import MITI.sdk.profiles.impl.memory.original.MultiModelIterator;
import MITI.sdk.profiles.impl.memory.original.QueuedIterators;
import MITI.sdk.profiles.impl.memory.original.StitchingResultsIterator;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.stitching.Stitching;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class DirectoryContentIterator
extends QueuedIterators {
    boolean isVisited = false;
    private MIRContent dirContent;
    private ProfiledObject root;
    private int numConnectionModelsRemaining = 0;
    boolean isLoaded;
    private HashMap<String, StitchingResultsIterator> stitchingResults = new HashMap();
    private DirectoryContentLinkIterator linkIterator = null;
    private boolean isLineageProcessed = false;
    private MultiModelIterator multiModelIterator;
    private TreeSet<String> externalConnections = new TreeSet();
    private ModelSummary modelSummary = null;

    public String toString() {
        return "DirectoryContentIterator [" + this.dirContent.getName() + "]";
    }

    public DirectoryContentIterator(MIRContent mIRContent, ProfiledObject profiledObject, ProfiledObject profiledObject2, MultiModelIterator multiModelIterator) {
        this.dirContent = mIRContent;
        this.setRoot(profiledObject2);
        this.multiModelIterator = multiModelIterator;
    }

    public MIRContent getDirContent() {
        return this.dirContent;
    }

    public void setNumRefModelsRemaining(int n) {
        this.numConnectionModelsRemaining = n;
    }

    public void referenceUnloaded(MIRContent mIRContent) throws MIRException {
        --this.numConnectionModelsRemaining;
        this.unload();
    }

    public void unload() throws MIRException {
        if (!this.isLoaded || this.numConnectionModelsRemaining > 0) {
            return;
        }
        PPSDK.DBG_FREEING_MODEL.log(this.dirContent.getName());
        this.stitchingResults = null;
        this.linkIterator = null;
        this.multiModelIterator.getStitcher().unload(this.dirContent);
        this.multiModelIterator.getProfiler().unload(this.dirContent);
    }

    public void load() throws MIRException {
        MIRStoreModel mIRStoreModel;
        Cloneable cloneable;
        if (this.isLoaded) {
            if (this.linkIterator != null) {
                super.addIterator(this.linkIterator);
            }
            return;
        }
        this.isLoaded = this.multiModelIterator.getProfiler().load(this.dirContent);
        if (!this.isLoaded) {
            return;
        }
        boolean bl = this.multiModelIterator.getOptions().isMergeExternalConnections();
        boolean bl2 = this.multiModelIterator.getOptions().isSkipOverOlapModels();
        for (MIRConnection object2 : this.dirContent.getClientOfConnections()) {
            this.stitchingResults.put(object2.getName(), null);
            cloneable = object2.getSupplierStoreContent();
            if (cloneable == null || bl || cloneable.getConnectionOfDirectoryStructureModel() == null) continue;
            this.externalConnections.add(object2.getName());
        }
        ProfiledObject profiledObject = this.multiModelIterator.getProfiler().getObject(this.dirContent.getModel());
        if (profiledObject == null) {
            throw new MIRException(PRFLR.ERR_MODEL_NOT_IN_PROFILE.getMessage(this.root.toString()));
        }
        if (bl2 && this.dirContent.getModel() instanceof MIRStoreModel && (mIRStoreModel = (MIRStoreModel)this.dirContent.getModel()).getStoreType() == 1) {
            this.modelSummary = new ModelSummary(mIRStoreModel);
        }
        Object var4_7 = null;
        cloneable = null;
        if (this.modelSummary == null) {
            DirectoryContentTreeIterator directoryContentTreeIterator = new DirectoryContentTreeIterator(this.multiModelIterator.getProfiler(), this.getRoot(), profiledObject, this.dirContent, this.stitchingResults.keySet(), this.externalConnections);
            cloneable = directoryContentTreeIterator.getObjectIds();
            super.addIterator(directoryContentTreeIterator);
        }
        this.linkIterator = new DirectoryContentLinkIterator(this.multiModelIterator.getProfiler(), profiledObject, (TreeSet<ObjectIdentifier>)cloneable, this.externalConnections, this.modelSummary);
        super.addIterator(this.linkIterator);
    }

    public ProfiledObject getRoot() {
        return this.root;
    }

    public void setRoot(ProfiledObject profiledObject) {
        this.root = profiledObject;
    }

    @Override
    protected void loadNextIterator(Iterator<ProfileLink> iterator) throws MIRException {
        if (iterator instanceof DirectoryContentLinkIterator) {
            SortedSet<MIRConnection> sortedSet;
            boolean bl = true;
            Iterator<MIRConnection> iterator2 = this.dirContent.getClientOfConnectionIterator();
            while (iterator2.hasNext()) {
                sortedSet = iterator2.next();
                MIRStoreContent mIRStoreContent = ((MIRConnection)((Object)sortedSet)).getSupplierStoreContent();
                DirectoryContentIterator object = this.multiModelIterator.getDirectoryContentIterator(mIRStoreContent);
                if (object == null || object.isLoaded) continue;
                bl = false;
                break;
            }
            if (!bl) {
                return;
            }
            this.isLineageProcessed = true;
            sortedSet = this.dirContent.getClientOfConnections();
            if (!sortedSet.isEmpty()) {
                PPSDK.DBG_STITCHING_MODEL.log(this.dirContent.getName());
            }
            for (MIRConnection mIRConnection : sortedSet) {
                MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
                try {
                    DirectoryContentIterator directoryContentIterator = this.multiModelIterator.getDirectoryContentIterator(mIRStoreContent);
                    if (directoryContentIterator == null) continue;
                    PPSDK.DBG_STITCHING_MODEL_CONNECTION.log(this.dirContent.getName(), mIRConnection.getName());
                    Stitching stitching = this.multiModelIterator.getStitcher().matchModels(this.dirContent, mIRConnection, mIRStoreContent);
                    StitchingResultsIterator stitchingResultsIterator = new StitchingResultsIterator(mIRConnection.getName(), stitching, directoryContentIterator);
                    this.stitchingResults.put(mIRConnection.getName(), stitchingResultsIterator);
                }
                catch (MIRException mIRException) {
                    PRFLR.ERR_STITCHING_ERROR.log(mIRException, this.dirContent.getName(), mIRException.getMessage());
                }
            }
            ((DirectoryContentLinkIterator)iterator).setStitchingResults(this.stitchingResults);
        }
    }

    @Override
    protected void iteratorComplete(Iterator<ProfileLink> iterator) throws MIRException {
        if (iterator instanceof DirectoryContentLinkIterator && this.isLineageProcessed) {
            if (!this.stitchingResults.isEmpty()) {
                PPSDK.DBG_FREEING_MODEL_STITCHINGS.log(this.dirContent.getName());
            }
            this.linkIterator.resetStitchingResults();
            this.stitchingResults = null;
        }
    }

    public boolean isLineageProcessed() {
        return this.isLineageProcessed;
    }

    public DirectoryContentLinkIterator getLineageIterator() {
        return this.linkIterator;
    }

    public ModelSummary getModelSummary() {
        return this.modelSummary;
    }
}

