/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory;

import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionClassifier;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.profiles.impl.memory.SynonymIdentifier;
import java.util.Iterator;

public class Util {
    public static MIRStoreConnection getStoreConnection(MIRObject mIRObject) {
        if (mIRObject == null) {
            return null;
        }
        if (mIRObject instanceof MIRConnectionElement) {
            return ((MIRConnectionElement)mIRObject).getStoreConnection();
        }
        if (mIRObject instanceof MIRConnectionNamespace) {
            MIRObject mIRObject2;
            for (mIRObject2 = mIRObject.getParent(); mIRObject2 != null && !(mIRObject2 instanceof MIRStoreConnection); mIRObject2 = mIRObject2.getParent()) {
            }
            return (MIRStoreConnection)mIRObject2;
        }
        if (mIRObject instanceof MIRFeature) {
            return Util.getStoreConnection(((MIRFeature)mIRObject).getClassifier());
        }
        if (mIRObject instanceof MIRConnectionClassifier) {
            return ((MIRConnectionClassifier)mIRObject).getStoreConnection();
        }
        if (mIRObject instanceof MIRClassifier) {
            MIRNamespaceElement mIRNamespaceElement;
            if (mIRObject instanceof MIRDataSet) {
                mIRNamespaceElement = (MIRDataSet)mIRObject;
                MIRStoredProcedure mIRStoredProcedure = ((MIRDataSet)mIRNamespaceElement).getParametersOfStoredProcedure();
                if (mIRStoredProcedure != null) {
                    return Util.getStoreConnection(mIRStoredProcedure);
                }
                mIRStoredProcedure = ((MIRDataSet)mIRNamespaceElement).getResultOfStoredProcedure();
                if (mIRStoredProcedure != null) {
                    return Util.getStoreConnection(mIRStoredProcedure);
                }
            }
            mIRNamespaceElement = Util.getConnectionPackage((MIRClassifier)mIRObject);
            return Util.getStoreConnection(mIRNamespaceElement);
        }
        if (mIRObject instanceof MIRStoredProcedure) {
            MIRNamespace mIRNamespace = ((MIRStoredProcedure)mIRObject).getNamespace();
            if (mIRNamespace instanceof MIRConnectionDataPackage) {
                return Util.getStoreConnection(mIRNamespace);
            }
            return null;
        }
        if (mIRObject instanceof MIRConnectionPackage) {
            return ((MIRConnectionPackage)mIRObject).getStoreConnection();
        }
        if (mIRObject instanceof MIRStoreConnection) {
            return (MIRStoreConnection)mIRObject;
        }
        if (mIRObject instanceof MIRClassifierMap) {
            return Util.getStoreConnection(((MIRClassifierMap)mIRObject).getClassifier());
        }
        if (mIRObject instanceof MIRFeatureMap) {
            return Util.getStoreConnection(((MIRFeatureMap)mIRObject).getClassifierMap());
        }
        return null;
    }

    private static MIRConnectionDataPackage getConnectionPackage(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            return null;
        }
        MIRConnectionDataPackage mIRConnectionDataPackage = mIRClassifier.getConnectionDataPackage();
        if (mIRConnectionDataPackage != null) {
            return mIRConnectionDataPackage;
        }
        MIRNamespace mIRNamespace = mIRClassifier.getNamespace();
        if (mIRNamespace instanceof MIRConnectionDataPackage) {
            return (MIRConnectionDataPackage)mIRNamespace;
        }
        Iterator<MIRPackage> iterator = mIRClassifier.getImportedByPackageIterator();
        while (iterator.hasNext()) {
            MIRPackage mIRPackage = iterator.next();
            if (!(mIRPackage instanceof MIRConnectionDataPackage)) continue;
            return (MIRConnectionDataPackage)mIRPackage;
        }
        return null;
    }

    public static String getStoreConnectionName(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection.getPhysicalName().isEmpty()) {
            return mIRStoreConnection.getName();
        }
        return mIRStoreConnection.getPhysicalName();
    }

    public static MIRNamespaceElement lookupSynonymObject(MIRStoreModel mIRStoreModel, SynonymIdentifier synonymIdentifier) {
        String string = synonymIdentifier.getSchemaName();
        String string2 = synonymIdentifier.getObjectName();
        MIRDataPackage mIRDataPackage = mIRStoreModel.getDataPackage(string);
        if (mIRDataPackage != null) {
            MIRNamespaceElement mIRNamespaceElement = mIRDataPackage.getNamespaceElement(string2);
            if (mIRNamespaceElement == null) {
                mIRNamespaceElement = mIRDataPackage.getImportedNamespaceElement(string2);
            }
            return mIRNamespaceElement;
        }
        return null;
    }
}

