/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory;

import MITI.MIRException;
import MITI.lineage.links.Links;
import MITI.lineage.links.ModelLineageAugmenter;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.messages.MIRProfilerPartnerSDK.PPSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDiRuntimeContent;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRJoinRelationship;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRNote;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIR_Object;
import MITI.sdk.id.MIRSystemId;
import MITI.sdk.id.MIRSystemIdCache;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.mix.MIRObjectCache;
import MITI.sdk.mix.checksum.FileChecksum;
import MITI.sdk.mix.checksum.MixChecksum;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfilerOptions;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledAttribute;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import MITI.sdk.profiles.ProfilerFactory;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.impl.MIRProfiler;
import MITI.sdk.profiles.impl.memory.MemoryDataProvider;
import MITI.sdk.profiles.impl.memory.id.MIRObjectIdentity;
import MITI.sdk.profiles.impl.memory.id.MIRObjectIdentityFactory;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.ProfiledObjectDefinition;
import MITI.util.VersionInfo;
import MITI.util.os.MachineInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ProfilerImpl
implements Profiler {
    private MIRProfiler profiler = null;
    private ProfiledObject rootProfiledObject;
    private MIRMixCache cache;
    private MemoryDataProvider dataProvider;
    private MIRSystemIdCache systemIdCache = new MIRSystemIdCache();
    private Map<Integer, String> modelToProfile = new TreeMap<Integer, String>();
    private Map<Integer, MixChecksum> modelToChecksum = new TreeMap<Integer, MixChecksum>();
    private Map<Integer, Links> modelToLinks = new TreeMap<Integer, Links>();
    private String rootProfile = null;
    protected ProfilerOptions options = new ProfilerOptions();
    private static final boolean newLinksImplementation = false;

    public ProfilerImpl(MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        this.printEnvInfo();
        FileChecksum fileChecksum = null;
        File file = mIRMixCache.getMultiModelFile();
        if (mIRModel instanceof MIRDirectoryStructureModel) {
            fileChecksum = FileChecksum.read(file);
        } else {
            File file2 = file.getParentFile();
            File file3 = MIRMixManager.getModelFile(file2);
            fileChecksum = FileChecksum.read(file3);
        }
        this.init(mIRModel, mIRMixCache);
        this.addChecksum(mIRModel, fileChecksum);
        this.initLinks(mIRModel, mIRMixCache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProfilerImpl(File file) throws MIRException {
        Object object;
        this.printEnvInfo();
        MIRMixCache mIRMixCache = null;
        MIRModel mIRModel = null;
        if (!file.exists()) {
            throw new MIRException(PRFLR.INPUT_FILE_NOT_FOUND.getMessage(file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            object = MIRMixManager.getMultiModelFile(file);
            File file2 = MIRMixManager.getModelFile(file);
            if (((File)object).exists()) {
                mIRMixCache = new MIRMixCache(file);
                mIRModel = mIRMixCache.loadDirectoryStructure();
            } else {
                if (!file2.exists()) throw new MIRException(PRFLR.INPUT_FILE_NOT_FOUND.getMessage(((File)object).getAbsolutePath()));
                mIRMixCache = new MIRMixCache();
                mIRModel = mIRMixCache.readFile(file2);
            }
        } else {
            mIRMixCache = new MIRMixCache();
            mIRModel = mIRMixCache.readFile(file);
        }
        PRFLR.MSG_LOADING_ROOT_MODEL.log(mIRModel.getName());
        object = FileChecksum.read(file);
        this.init(mIRModel, mIRMixCache);
        this.addChecksum(mIRModel, (MixChecksum)object);
        this.initLinks(mIRModel, mIRMixCache);
    }

    private void printEnvInfo() {
        PRFLR.MSG_ENV_INFO.log("Processor and Memory: " + MachineInfo.getHardware());
        PRFLR.MSG_ENV_INFO.log("Operating System: " + MachineInfo.getSoftware());
        PRFLR.MSG_ENV_INFO.log("Java Environment: " + MachineInfo.getJavaInfo());
        PRFLR.MSG_ENV_INFO.log("File Encoding: " + MachineInfo.getEncoding());
        String string = "unknown";
        VersionInfo versionInfo = VersionInfo.loadMitiJar(ProfilerImpl.class);
        if (versionInfo != null) {
            string = versionInfo.getVersionString() + " - " + versionInfo.getDate();
        }
        PRFLR.MSG_ENV_INFO.log("ProfilerPartnerSDK version: " + string);
    }

    private void init(MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        this.cache = mIRMixCache;
        this.dataProvider = new MemoryDataProvider(this.cache);
        this.profiler = new MIRProfiler(this.dataProvider);
        ObjectDefinition objectDefinition = this.cache.getObjectDefinition(mIRModel);
        this.addProfile(mIRModel, objectDefinition, this.rootProfile);
        this.rootProfiledObject = this.profiler.getObject(objectDefinition, this.getProfileName(objectDefinition));
    }

    @Override
    public void setOptions(ProfilerOptions profilerOptions) {
        String string;
        this.options = profilerOptions;
        MIRProfilerOptions mIRProfilerOptions = new MIRProfilerOptions();
        if (profilerOptions != null && (string = profilerOptions.getDateFormat()) != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            mIRProfilerOptions.setDateFormat(simpleDateFormat);
        }
        this.dataProvider.setOptions(mIRProfilerOptions);
    }

    public ProfilerOptions getOptions() {
        return this.options;
    }

    @Override
    public void setRootProfile(int n) throws MIRException {
        MIRProfile mIRProfile = ProfilerFactory.getProfile(n);
        if (mIRProfile == null) {
            throw new IllegalStateException(PRFLR.PROFILE_NOT_FOUND.getMessage(Integer.toString(n)));
        }
        this.rootProfile = mIRProfile.getName();
        ProfiledObjectDefinition profiledObjectDefinition = this.rootProfiledObject.getObjectDefinition();
        MIRModel mIRModel = (MIRModel)this.cache.getMirObject(profiledObjectDefinition);
        this.addProfile(mIRModel, profiledObjectDefinition, this.rootProfile);
        this.rootProfiledObject = this.profiler.getObject(profiledObjectDefinition, this.rootProfile);
    }

    private String getProfileName(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == null) {
            return null;
        }
        return this.modelToProfile.get(objectIdentifier.getModelId());
    }

    private void addProfile(MIRModel mIRModel, ObjectIdentifier objectIdentifier, String string) throws MIRException {
        if (string == null) {
            MIRMetadataOrigin mIRMetadataOrigin = mIRModel.getMetadataOrigin();
            MIRProfile mIRProfile = ProfilerFactory.getProfile(mIRMetadataOrigin.getProfileId());
            if (mIRProfile == null) {
                throw new IllegalStateException(PRFLR.PROFILE_NOT_FOUND.getMessage(Integer.toString(mIRMetadataOrigin.getProfileId())));
            }
            string = mIRProfile.getName();
        }
        this.modelToProfile.put(objectIdentifier.getModelId(), string);
        PRFLR.USING_PROFILE.log(string, mIRModel.getName());
    }

    private void addContentProfile(MIRContent mIRContent, MIRModel mIRModel, ObjectIdentifier objectIdentifier) throws MIRException {
        ProfiledObject profiledObject;
        MIRProfileEntity mIRProfileEntity;
        MIRProfile mIRProfile;
        String string = null;
        if (this.rootProfile != null && (mIRProfile = ProfilerFactory.getProfile(string = (mIRProfileEntity = this.getProfileEntity(profiledObject = this.profiler.getObject(this.getObjectDefinition(mIRContent), this.rootProfile))).getContentProfile() != null ? mIRProfileEntity.getContentProfile() : this.rootProfile)) == null) {
            throw new IllegalStateException(PRFLR.PROFILE_NOT_FOUND.getMessage(string));
        }
        this.addProfile(mIRModel, objectIdentifier, string);
    }

    @Override
    public ProfiledAttribute[] getAttributes(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject == null) {
            return null;
        }
        ProfiledObjectDefinition profiledObjectDefinition = new ProfiledObjectDefinition(profiledObject.getObjectDefinition());
        ProfiledAttribute[] profiledAttributeArray = this.profiler.get(profiledObjectDefinition, this.getProfileName(profiledObjectDefinition));
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (profiledAttributeArray != null && mIRObject != null) {
            if (mIRObject instanceof MIRConnectionDataAttribute) {
                Object object;
                Object object2;
                MIRConnectionDataAttribute mIRConnectionDataAttribute = (MIRConnectionDataAttribute)mIRObject;
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<MIRSummaryMap> iterator = mIRConnectionDataAttribute.getDestinationOfSummaryMapIterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    object = ((MIRSummaryMap)object2).getOperation();
                    if (object == null || ((String)object).isEmpty()) continue;
                    if (!((MIRSummaryMap)object2).getExternalContentId().isEmpty()) {
                        stringBuilder.append(this.getRuntimeTaskContentPath(((MIRSummaryMap)object2).getExternalContentId()));
                        stringBuilder.append(": ");
                    }
                    stringBuilder.append((String)object);
                    stringBuilder.append("\n");
                }
                object2 = stringBuilder.toString();
                object = this.getProfiledAttribute(profiledAttributeArray, (short)358);
                if (object != null && !((String)object2).isEmpty()) {
                    ((ProfiledAttribute)object).setValue((String)object2);
                }
            } else if (mIRObject instanceof MIRJoinRelationship) {
                MIRJoinRelationship mIRJoinRelationship = (MIRJoinRelationship)mIRObject;
                String string = mIRJoinRelationship.getContexts();
                ProfiledAttribute profiledAttribute = this.getProfiledAttribute(profiledAttributeArray, (short)500);
                if (profiledAttribute != null && !string.isEmpty()) {
                    String string2 = "";
                    for (String string3 : string.split(",")) {
                        String string4 = this.getRuntimeTaskContentPath(string3.trim());
                        if (!string2.isEmpty()) {
                            string2 = string2 + "\n";
                        }
                        string2 = string2 + string4;
                    }
                    profiledAttribute.setValue(string2);
                }
            }
        }
        return profiledAttributeArray;
    }

    private ProfiledAttribute getProfiledAttribute(ProfiledAttribute[] profiledAttributeArray, short s) {
        if (profiledAttributeArray != null) {
            for (ProfiledAttribute profiledAttribute : profiledAttributeArray) {
                if (profiledAttribute.getType() != s) continue;
                return profiledAttribute;
            }
        }
        return null;
    }

    public String getRuntimeTaskContentPath(String string) {
        String string2 = "";
        try {
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(0, Integer.parseInt(string));
            MIRObject mIRObject = this.getMIRObject(objectIdentifier);
            if (mIRObject != null && mIRObject instanceof MIRDiRuntimeContent) {
                string2 = mIRObject.getName();
                for (MIRObject mIRObject2 = mIRObject.getParent(); mIRObject2 != null; mIRObject2 = mIRObject2.getParent()) {
                    string2 = mIRObject2.getName() + "/" + string2;
                }
            }
        }
        catch (MIRException mIRException) {
            // empty catch block
        }
        return string2;
    }

    @Override
    public ProfiledObject[] getLinks(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject == null) {
            return null;
        }
        ProfiledObjectDefinition profiledObjectDefinition = new ProfiledObjectDefinition(profiledObject.getObjectDefinition());
        Set<ProfiledObject> set = this.profiler.list(profiledObjectDefinition, this.getProfileName(profiledObjectDefinition));
        return set == null ? null : set.toArray(new ProfiledObject[set.size()]);
    }

    @Override
    public ProfiledObject[] getObjectPath(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        if (profiledObject == null) {
            return null;
        }
        if (profiledObject2 == null) {
            profiledObject2 = this.rootProfiledObject;
        }
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        ProfiledObjectDefinition profiledObjectDefinition2 = profiledObject2.getObjectDefinition();
        return this.profiler.getObjectPath(profiledObjectDefinition, profiledObjectDefinition2, this.getProfileName(profiledObjectDefinition));
    }

    public ProfiledObject[] getObjectPath(ObjectDefinition objectDefinition, ObjectDefinition objectDefinition2) throws MIRException {
        if (objectDefinition == null) {
            return null;
        }
        if (objectDefinition2 == null) {
            objectDefinition2 = this.rootProfiledObject.getObjectDefinition();
        }
        return this.profiler.getObjectPath(objectDefinition, objectDefinition2, this.getProfileName(objectDefinition));
    }

    @Override
    public ProfiledObject getParent(ProfiledObject profiledObject) throws MIRException {
        boolean bl;
        if (profiledObject == null) {
            return null;
        }
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        ProfiledObjectDefinition profiledObjectDefinition2 = this.rootProfiledObject.getObjectDefinition();
        String string = this.getProfileName(profiledObjectDefinition);
        boolean bl2 = bl = profiledObjectDefinition.getGroupName() != null;
        if (profiledObjectDefinition.getModelId() == profiledObjectDefinition2.getModelId()) {
            return this.profiler.getParent(profiledObjectDefinition, profiledObjectDefinition2, string, false);
        }
        if (profiledObjectDefinition.isInstanceOf((short)218) && !bl) {
            MIRObject mIRObject = this.getMIRObject(profiledObjectDefinition);
            MIRObject mIRObject2 = mIRObject.getParent();
            return this.getObject(mIRObject2);
        }
        return this.profiler.getParent(profiledObjectDefinition, this.getRootModel(profiledObject).getObjectDefinition(), string, false);
    }

    @Override
    public ProfiledObject getRootObject() {
        return this.rootProfiledObject;
    }

    public ProfiledObject getObject(MIRObject mIRObject) throws MIRException {
        ObjectDefinition objectDefinition = this.cache.getObjectDefinition(mIRObject);
        return this.getObject(objectDefinition);
    }

    @Override
    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        return this.cache.getObjectDefinition(mIRObject);
    }

    public ObjectIdentifier getObjectIdentifier(MIRObject mIRObject) {
        return this.cache.getObjectIdentifier(mIRObject);
    }

    ProfiledObject getObject(ObjectDefinition objectDefinition) throws MIRException {
        return this.profiler.getObject(objectDefinition, this.getProfileName(objectDefinition));
    }

    ProfiledObject[] getObjectPath(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject == null) {
            return null;
        }
        return this.profiler.getObjectPath(profiledObject.getObjectDefinition(), this.rootProfiledObject.getObjectDefinition(), this.getProfileName(profiledObject.getObjectDefinition()));
    }

    @Override
    public MIRObject getMIRObject(ObjectIdentifier objectIdentifier) throws MIRException {
        return this.cache.getMirObject(objectIdentifier);
    }

    @Override
    public MIRProfileEntity getProfileEntity(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject.getObjectDefinition().getGroupName() != null) {
            return null;
        }
        return this.profiler.getProfileEntity(this.getProfileName(profiledObject.getObjectDefinition()), profiledObject);
    }

    public MIRProfileLink getProfileLink(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        if (profiledObject2.getLinkId() == null) {
            return null;
        }
        MIRProfileGroup mIRProfileGroup = this.getProfileGroup(profiledObject);
        MIRProfileEntity mIRProfileEntity = this.getProfileEntity(profiledObject);
        MIRProfileLink mIRProfileLink = null;
        if (mIRProfileGroup != null) {
            mIRProfileLink = mIRProfileGroup.getProfileLink(profiledObject2.getLinkId(), this.getProfileEntity(profiledObject2));
        } else if (mIRProfileEntity != null) {
            mIRProfileLink = mIRProfileEntity.getProfileLink(profiledObject2.getLinkId(), this.getProfileEntity(profiledObject2));
        }
        return mIRProfileLink;
    }

    @Override
    public MIRProfileGroup getProfileGroup(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject.getObjectDefinition().getGroupName() == null) {
            return null;
        }
        MIRProfileEntity mIRProfileEntity = this.profiler.getProfileEntity(this.getProfileName(profiledObject.getObjectDefinition()), profiledObject);
        if (mIRProfileEntity.getGroups() != null) {
            return mIRProfileEntity.getGroups().get(profiledObject.getObjectDefinition().getGroupName());
        }
        return null;
    }

    public MIRObjectCache getCache() {
        return this.cache;
    }

    public boolean load(MIRObject mIRObject) throws MIRException {
        if (this.cache.getMultiModelFile() != null && MIR_Object.isInstanceOf(mIRObject.getElementType(), (short)159)) {
            PPSDK.DBG_LOADING_MODEL.log(mIRObject.getName());
            MIRContent mIRContent = (MIRContent)mIRObject;
            File file = this.cache.getFile(mIRContent);
            if (!file.exists()) {
                throw new MIRException("The model file " + file.getName() + " does not exist for content '" + mIRObject.getName() + "'");
            }
            FileChecksum fileChecksum = FileChecksum.read(file);
            MIRModel mIRModel = this.cache.loadModel(mIRContent);
            this.addContentProfile(mIRContent, mIRModel, this.cache.getObjectIdentifier(mIRModel));
            this.addChecksum(mIRModel, fileChecksum);
            this.initLinks(mIRModel, this.cache);
            return true;
        }
        return false;
    }

    public void unload(MIRObject mIRObject) {
        if (MIR_Object.isInstanceOf(mIRObject.getElementType(), (short)159)) {
            MIRContent mIRContent = (MIRContent)mIRObject;
            MIRModel mIRModel = mIRContent.getModel();
            this.freeLinks(mIRModel);
            this.systemIdCache.remove(mIRModel);
            this.cache.removeModel(mIRModel);
        }
    }

    private void addChecksum(MIRModel mIRModel, MixChecksum mixChecksum) {
        this.modelToChecksum.put(mIRModel.getModelId(), mixChecksum);
    }

    private void initLinks(MIRModel mIRModel, MIRObjectCache mIRObjectCache) {
        new ModelLineageAugmenter(mIRModel);
    }

    private void freeLinks(MIRModel mIRModel) {
        this.modelToLinks.put(mIRModel.getModelId(), null);
    }

    public Links getLinks(Integer n) {
        return this.modelToLinks.get(n);
    }

    @Override
    public String getObjectIdentity(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject.getObjectDefinition().getGroupName() != null) {
            return null;
        }
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (mIRObject == null) {
            return null;
        }
        MIRSystemId mIRSystemId = this.systemIdCache.getObjectIdentity(mIRObject);
        return mIRSystemId == null ? null : mIRSystemId.getId();
    }

    @Override
    public ProfiledObject getRootModel(ProfiledObject profiledObject) throws MIRException {
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (mIRObject != null) {
            return this.getObject(mIRObject.getRootModel());
        }
        return null;
    }

    @Override
    public abstract Iterator<ProfileLink> createIterator(ProfiledObject var1) throws MIRException;

    @Override
    public boolean isRepeatableIdentity(ProfiledObject profiledObject) throws MIRException {
        if (profiledObject.getObjectDefinition().getGroupName() != null) {
            return true;
        }
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (mIRObject == null) {
            return false;
        }
        MIRSystemId mIRSystemId = this.systemIdCache.getObjectIdentity(mIRObject);
        return mIRSystemId == null ? false : !mIRSystemId.isRandom();
    }

    @Override
    public ProfiledObject getReportItemParent(ProfiledObject profiledObject) throws MIRException {
        if (MIR_Object.isInstanceOf(profiledObject.getObjectDefinition().getObjectType(), (short)124)) {
            MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
            do {
                if ((mIRObject = ProfilerImpl.getReportItemParent(mIRObject)) == null) {
                    return null;
                }
                ProfiledObject profiledObject2 = this.getObject(mIRObject);
                if (profiledObject2 == null) continue;
                return profiledObject2;
            } while (mIRObject != null);
        }
        return null;
    }

    private static MIRObject getReportItemParent(MIRObject mIRObject) {
        if ((mIRObject = mIRObject.getParent()).isInstanceOf((short)124)) {
            return mIRObject;
        }
        if (mIRObject.isInstanceOf((short)119)) {
            return mIRObject;
        }
        return mIRObject.getRootModel();
    }

    @Override
    public ProfiledObject getClassifier(ProfiledObject profiledObject) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        if (MIR_Object.isInstanceOf(profiledObjectDefinition.getObjectType(), (short)77)) {
            return this.profiler.getParent(profiledObjectDefinition, this.getRootModel(profiledObject).getObjectDefinition(), this.getProfileName(profiledObjectDefinition), true);
        }
        return null;
    }

    @Override
    public ProfiledObject getDataPackage(ProfiledObject profiledObject) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        MIRObject mIRObject = this.cache.getMirObject(profiledObjectDefinition);
        if (mIRObject == null) {
            return null;
        }
        if (mIRObject instanceof MIRClassifier) {
            return this.getObject(((MIRClassifier)mIRObject).getDataPackage());
        }
        if (mIRObject instanceof MIRStoredProcedure) {
            return this.getObject(((MIRStoredProcedure)mIRObject).getDataPackage());
        }
        if (mIRObject instanceof MIRDataPackage) {
            MIRDataPackage mIRDataPackage = (MIRDataPackage)mIRObject;
            return this.getObject(mIRDataPackage.getNamespace());
        }
        return null;
    }

    @Override
    public boolean isConnection(ProfiledObject profiledObject) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        MIRObject mIRObject = this.cache.getMirObject(profiledObjectDefinition);
        if (mIRObject == null) {
            return false;
        }
        if (mIRObject instanceof MIRStoreContent) {
            return ((MIRStoreContent)mIRObject).getConnectionOfDirectoryStructureModel() != null;
        }
        if (mIRObject instanceof MIRStoreModel) {
            MIRContent mIRContent = ((MIRStoreModel)mIRObject).getContent();
            if (mIRContent instanceof MIRStoreContent) {
                MIRStoreContent mIRStoreContent = (MIRStoreContent)mIRContent;
                return mIRStoreContent.getConnectionOfDirectoryStructureModel() != null;
            }
        } else if (mIRObject instanceof MIRStoreConnection) {
            return true;
        }
        return false;
    }

    @Override
    public Profiler.StoreType getStoreType(ProfiledObject profiledObject) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        MIRObject mIRObject = this.cache.getMirObject(profiledObjectDefinition);
        if (mIRObject == null) {
            return null;
        }
        int n = -1;
        if (mIRObject instanceof MIRStoreModel) {
            n = ((MIRStoreModel)mIRObject).getStoreType();
        } else if (mIRObject instanceof MIRStoreConnection) {
            n = ((MIRStoreConnection)mIRObject).getStoreType();
        }
        if (n == 0) {
            return Profiler.StoreType.RELATIONAL;
        }
        if (n == 3) {
            return Profiler.StoreType.LOGICAL;
        }
        if (n == 2) {
            return Profiler.StoreType.FILE;
        }
        if (n == 1) {
            return Profiler.StoreType.OLAP;
        }
        if (n == 4) {
            return Profiler.StoreType.REPORT;
        }
        return null;
    }

    @Override
    public String getSystemType(ProfiledObject profiledObject) throws MIRException {
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        MIRObject mIRObject = this.cache.getMirObject(profiledObjectDefinition);
        if (mIRObject == null) {
            return null;
        }
        String string = "";
        if (mIRObject instanceof MIRSystemPackage) {
            string = ((MIRSystemPackage)mIRObject).getSystemType();
        }
        return string;
    }

    @Override
    public boolean isCaseSensitive(ProfiledObject profiledObject) throws MIRException {
        byte by;
        int n;
        int n2;
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        return mIRObject instanceof MIRFeature ? ((n2 = ((MIRFeature)mIRObject).getLineageOptions()) & 0x1000) == 4096 : (mIRObject instanceof MIRClassifier ? ((n = ((MIRClassifier)mIRObject).getLineageOptions()) & 0x1000) == 4096 : mIRObject instanceof MIRSystemPackage && (by = ((MIRSystemPackage)mIRObject).getSystemCase()) == 1);
    }

    @Override
    public boolean isTemporary(ProfiledObject profiledObject) throws MIRException {
        int n;
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        return mIRObject instanceof MIRClassifier && ((n = ((MIRClassifier)mIRObject).getLineageOptions()) & 0x400) == 1024;
    }

    @Override
    public String getChecksum(ProfiledObject profiledObject) throws MIRException {
        MixChecksum mixChecksum = null;
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (mIRObject instanceof MIRContent) {
            mixChecksum = this.modelToChecksum.get(mIRObject.getObjectId());
            if (mixChecksum == null) {
                MIRContent mIRContent = (MIRContent)mIRObject;
                mixChecksum = this.getChecksum(mIRContent);
            }
        } else if (mIRObject instanceof MIRModel && (mixChecksum = this.modelToChecksum.get(mIRObject.getModelId())) == null) {
            MIRContent mIRContent = ((MIRModel)mIRObject).getContent();
            mixChecksum = this.getChecksum(mIRContent);
        }
        if (mixChecksum != null) {
            return mixChecksum.getStructure();
        }
        return null;
    }

    private MixChecksum getChecksum(MIRContent mIRContent) {
        FileChecksum fileChecksum = null;
        if (mIRContent != null) {
            String string = mIRContent.getModelKey();
            fileChecksum = new FileChecksum(string, "");
        }
        return fileChecksum;
    }

    @Override
    public MIRProfile getRootProfile() {
        if (this.rootProfiledObject == null) {
            return null;
        }
        String string = this.modelToProfile.get(this.rootProfiledObject.getObjectDefinition().getModelId());
        MIRProfile mIRProfile = null;
        try {
            mIRProfile = ProfilerFactory.getProfile(string);
        }
        catch (MIRException mIRException) {
            BLIB.DBG_DEBUG.log(mIRException, "Error loading profile: " + string);
        }
        return mIRProfile;
    }

    @Override
    public void setSkipOverOlapModels(boolean bl) {
        this.options.setSkipOverOlapModels(bl);
    }

    @Override
    public String getNativeId(ProfiledObject profiledObject) throws MIRException {
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (mIRObject instanceof MIRElement) {
            return ((MIRElement)mIRObject).getNativeId();
        }
        if (mIRObject instanceof MIRNote) {
            return ((MIRNote)mIRObject).getNativeId();
        }
        return "";
    }

    @Override
    public ProfiledObject getSynonymTargetSchema(ProfiledObject profiledObject) throws MIRException {
        MIRDataPackage mIRDataPackage;
        MIRModelObject mIRModelObject;
        ProfiledObject profiledObject2 = null;
        MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
        if (mIRObject instanceof MIRSynonym && (mIRModelObject = ((MIRSynonym)mIRObject).getModelObject()) instanceof MIRNamespaceElement && (mIRDataPackage = ((MIRNamespaceElement)mIRModelObject).getDataPackage()) != null) {
            profiledObject2 = this.getObject(mIRDataPackage);
        }
        return profiledObject2;
    }

    @Override
    public String getProfiledObjectIdentity(ProfiledObject profiledObject) throws MIRException {
        String string = "";
        ArrayList<ProfiledObject> arrayList = new ArrayList<ProfiledObject>();
        ArrayList<ProfiledObject> arrayList2 = new ArrayList<ProfiledObject>();
        this.getLocalAndParentPath(profiledObject, arrayList, arrayList2);
        String string2 = this.computeIdentifier(arrayList);
        String string3 = this.computeIdentifier(arrayList2);
        if (!string2.isEmpty()) {
            string = string2 + "##";
        }
        string = string + string3;
        return string;
    }

    private void getLocalAndParentPath(ProfiledObject profiledObject, List<ProfiledObject> list, List<ProfiledObject> list2) throws MIRException {
        ProfiledObject[] profiledObjectArray = this.getObjectPath(profiledObject);
        boolean bl = false;
        for (int i = profiledObjectArray.length - 1; i >= 0; --i) {
            ProfiledObject profiledObject2 = profiledObjectArray[i];
            String string = profiledObject2.getObjectDefinition().getGroupName();
            MIRObject mIRObject = this.getMIRObject(profiledObject2.getObjectDefinition());
            if (string != null || mIRObject != null) {
                if (bl) {
                    list.add(profiledObject2);
                } else {
                    list2.add(profiledObject2);
                }
            }
            if (string != null || !(mIRObject instanceof MIRModel)) continue;
            bl = true;
        }
    }

    private String computeIdentifier(List<ProfiledObject> list) throws MIRException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ProfiledObject profiledObject : list) {
            Object object;
            String string = profiledObject.getObjectDefinition().getGroupName();
            if (string != null) {
                arrayList.add(string);
                continue;
            }
            MIRObject mIRObject = this.getMIRObject(profiledObject.getObjectDefinition());
            if (mIRObject == null || mIRObject instanceof MIRModel && !(mIRObject instanceof MIRDirectoryStructureModel)) continue;
            if (mIRObject instanceof MIRElement && ((String)(object = ((MIRElement)mIRObject).getNativeId())).length() > 0) {
                arrayList.add(object);
                break;
            }
            object = MIRObjectIdentityFactory.getIdentity(mIRObject);
            arrayList.add(((MIRObjectIdentity)object).compute(mIRObject));
        }
        Collections.reverse(arrayList);
        String string = String.join((CharSequence)"/", arrayList);
        return string;
    }
}

