/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.ProfilerFactory;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.ReferenceProfileLink;
import MITI.sdk.profiles.impl.csv.CsvFileTask;
import MITI.sdk.profiles.impl.csv.CsvLineage;
import MITI.sdk.profiles.impl.csv.CsvModelInfo;
import MITI.sdk.profiles.impl.csv.CsvObject;
import MITI.sdk.profiles.impl.csv.CsvProfileLinks;
import MITI.sdk.profiles.impl.csv.CsvProfilerOptions;
import MITI.sdk.profiles.impl.csv.CsvReference;
import MITI.sdk.profiles.impl.csv.CsvUtil;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;

public class CsvModelProfiler {
    private File dir;
    private int modelId;
    private MIRProfile profile;
    private CsvObject rootObject;
    private CsvModelInfo modelInfo;
    private CsvProfileLinks profileLinks;
    private Map<ObjectIdentifier, List<CsvReference>> forwardReferences;
    private Map<ObjectIdentifier, List<CsvReference>> reverseReferences;
    private Map<ObjectIdentifier, CsvObject> objectsById = new TreeMap<ObjectIdentifier, CsvObject>();
    private Map<MIRProfileEntity, CsvObject.Reader> objectReadersMap = new HashMap<MIRProfileEntity, CsvObject.Reader>();
    private Queue<CsvObject.Reader> objectReaders = new LinkedList<CsvObject.Reader>();
    private List<CsvReference.Reader> referenceReaders = new LinkedList<CsvReference.Reader>();
    private Map<MIRProfileEntity, CsvReference.Reader> referenceReadersMap = new HashMap<MIRProfileEntity, CsvReference.Reader>();
    private CsvLineage.Reader lineageReader;
    private CsvLineage.Reader lineageSummaryReader;
    private long sequence;
    private Map<MIRProfileEntity, Set<MIRProfileEntity>> entityChildren;
    private Set<MIRProfileEntity> postponeEntityReferences = new LinkedHashSet<MIRProfileEntity>();
    private List<CsvObject> contents;
    private boolean skipLineage = false;
    private boolean skipSummaryLineage = false;
    private boolean skipDetailedLineage = false;

    public CsvModelProfiler(File file, CsvModelInfo csvModelInfo, CsvProfileLinks csvProfileLinks, ProfilerOptions profilerOptions) throws MIRException {
        this.dir = file;
        this.modelInfo = csvModelInfo;
        this.modelId = csvModelInfo.getModelId();
        this.profile = ProfilerFactory.getProfile(csvModelInfo.getProfileId());
        this.profileLinks = csvProfileLinks;
        List<MIRProfileEntity> list = null;
        if (profilerOptions != null) {
            this.skipLineage = profilerOptions.isSkipLineage();
            this.skipSummaryLineage = profilerOptions.isSkipSummaryLineage();
            this.skipDetailedLineage = profilerOptions.isSkipDetailedLineage();
            if (profilerOptions instanceof CsvProfilerOptions) {
                list = ((CsvProfilerOptions)profilerOptions).getPostponedEntityReferences();
            }
        }
        if (list != null) {
            for (MIRProfileEntity mIRProfileEntity : list) {
                if (mIRProfileEntity == null || mIRProfileEntity.getProfile() != this.profile) continue;
                this.postponeEntityReferences.add(mIRProfileEntity);
            }
        }
        this.rootObject = null;
        this.entityChildren = CsvUtil.buildProfileChildren(this.profile);
        this.forwardReferences = new TreeMap<ObjectIdentifier, List<CsvReference>>();
        this.reverseReferences = new TreeMap<ObjectIdentifier, List<CsvReference>>();
    }

    public void load() throws MIRException {
        File[] fileArray;
        BLIB.DBG_DEBUG.log("Loading model " + this.modelId + " with profile '" + this.profile.getName() + "'");
        for (File file : fileArray = this.dir.listFiles()) {
            CsvFileTask csvFileTask;
            MIRProfileEntity mIRProfileEntity;
            String string = file.getName();
            if (!string.endsWith(".csv")) continue;
            if ((string = string.substring(0, string.lastIndexOf("."))).startsWith("ReferenceLinks_")) {
                mIRProfileEntity = this.profile.getProfileEntity(string = string.substring("ReferenceLinks_".length()));
                if (mIRProfileEntity == null) continue;
                csvFileTask = new CsvReference.Reader(file, this.modelId, mIRProfileEntity);
                this.referenceReaders.add((CsvReference.Reader)csvFileTask);
                this.referenceReadersMap.put(mIRProfileEntity, (CsvReference.Reader)csvFileTask);
                if (this.postponeEntityReferences.contains(mIRProfileEntity)) continue;
                this.loadReferenceLinks((CsvReference.Reader)csvFileTask);
                continue;
            }
            if (string.equals("LineageLinks") && !this.skipLineage && !this.skipDetailedLineage) {
                this.lineageReader = new CsvLineage.Reader(file, this.modelId, false);
                continue;
            }
            if (string.equals("LineageSummaryLinks") && !this.skipLineage && !this.skipSummaryLineage) {
                this.lineageSummaryReader = new CsvLineage.Reader(file, this.modelId, true);
                continue;
            }
            mIRProfileEntity = this.profile.getProfileEntity(string);
            if (mIRProfileEntity != null) {
                csvFileTask = new CsvObject.Reader(file, this.modelId, mIRProfileEntity);
                this.objectReaders.add((CsvObject.Reader)csvFileTask);
                this.objectReadersMap.put(mIRProfileEntity, (CsvObject.Reader)csvFileTask);
                continue;
            }
            BLIB.DBG_DEBUG.log("No profile entity found for file: " + file);
        }
        BLIB.DBG_DEBUG.log("Building reference links");
    }

    private void registerObject(CsvObject csvObject) {
        this.objectsById.put(csvObject.getObjectDefinition(), csvObject);
    }

    private void deregisterObject(CsvObject csvObject) {
        this.objectsById.remove(csvObject.getObjectDefinition());
    }

    public CsvObject getObject(ObjectIdentifier objectIdentifier) {
        CsvObject csvObject = this.objectsById.get(objectIdentifier);
        return csvObject;
    }

    public CsvObject getRootObject() {
        if (this.rootObject == null) {
            try {
                for (CsvObject.Reader reader : this.objectReaders) {
                    CsvObject csvObject = (CsvObject)reader.peek();
                    ObjectIdentifier objectIdentifier = csvObject.getParent();
                    boolean bl = CsvUtil.isModel(csvObject.getObjectDefinition());
                    if (objectIdentifier != null && !bl) continue;
                    this.rootObject = csvObject;
                    this.registerObject(this.rootObject);
                    reader.pop();
                    break;
                }
            }
            catch (MIRException mIRException) {
                BLIB.DBG_DEBUG.log("Error reading root object: " + mIRException.getMessage(), mIRException);
            }
        }
        return this.rootObject;
    }

    private void loadReferenceLinks(CsvReference.Reader reader) throws MIRException {
        if (reader != null) {
            CsvReference csvReference = null;
            while ((csvReference = (CsvReference)reader.peek()) != null) {
                reader.pop();
                this.buildForwardReferences(csvReference);
                this.buildReverseReferences(csvReference);
            }
        }
    }

    public MIRProfile getProfile() {
        return this.profile;
    }

    public CsvModelInfo getModelInfo() {
        return this.modelInfo;
    }

    private void buildForwardReferences(CsvReference csvReference) {
        ObjectIdentifier objectIdentifier = csvReference.getSrc();
        if (objectIdentifier != null) {
            List<CsvReference> list = this.forwardReferences.get(objectIdentifier);
            if (list == null) {
                list = new LinkedList<CsvReference>();
                this.forwardReferences.put(objectIdentifier, list);
            }
            list.add(csvReference);
        }
    }

    private void buildReverseReferences(CsvReference csvReference) {
        ObjectIdentifier objectIdentifier = csvReference.getDst();
        if (objectIdentifier != null) {
            List<CsvReference> list = this.reverseReferences.get(objectIdentifier);
            if (list == null) {
                list = new LinkedList<CsvReference>();
                this.reverseReferences.put(objectIdentifier, list);
            }
            list.add(csvReference);
        }
    }

    public void iterate(ProfiledObject profiledObject, CsvObject csvObject, ProfileLinkProcessor profileLinkProcessor, Set<ObjectIdentifier> set) throws MIRException {
        BLIB.DBG_DEBUG.log("Iterating model: " + this.modelInfo.getModelId());
        CsvObject csvObject2 = this.getObject(profiledObject.getObjectDefinition());
        AggregationProfileLink aggregationProfileLink = CsvUtil.createAggregationLink(csvObject, csvObject2, this.profileLinks);
        this.registerObject(csvObject2);
        profileLinkProcessor.process(aggregationProfileLink);
        set.add(profiledObject.getObjectDefinition());
        this.setSequence(csvObject2.getSequence() + 1L);
        this.iterateChildren(csvObject2, profileLinkProcessor, set);
        this.deregisterObject(csvObject2);
        this.forwardReferences.clear();
        this.reverseReferences.clear();
        this.iteratePostponedReferences(profileLinkProcessor, set);
        this.checkReaders();
    }

    private CsvObject getNextChild(CsvObject csvObject, Set<MIRProfileEntity> set, Set<ObjectIdentifier> set2) throws MIRException {
        for (MIRProfileEntity mIRProfileEntity : set) {
            ObjectIdentifier objectIdentifier;
            CsvObject csvObject2;
            CsvObject.Reader reader = this.objectReadersMap.get(mIRProfileEntity);
            if (reader == null || (csvObject2 = (CsvObject)reader.peek()) == null || (objectIdentifier = csvObject2.getParent()) == null || !objectIdentifier.equals(csvObject.getObjectDefinition()) || csvObject2.getSequence() != this.sequence) continue;
            reader.pop();
            return csvObject2;
        }
        return null;
    }

    private void iterateChildren(CsvObject csvObject, ProfileLinkProcessor profileLinkProcessor, Set<ObjectIdentifier> set) throws MIRException {
        MIRProfileEntity mIRProfileEntity = csvObject.getEntity();
        Set<MIRProfileEntity> set2 = this.entityChildren.get(mIRProfileEntity);
        CsvObject csvObject2 = null;
        while ((csvObject2 = this.getNextChild(csvObject, set2, set)) != null) {
            ObjectDefinition objectDefinition = csvObject2.getObjectDefinition();
            AggregationProfileLink aggregationProfileLink = CsvUtil.createAggregationLink(csvObject, csvObject2, this.profileLinks);
            this.registerObject(csvObject2);
            profileLinkProcessor.process(aggregationProfileLink);
            this.print(aggregationProfileLink);
            ++this.sequence;
            set.add(objectDefinition);
            if (CsvUtil.isContent(csvObject2.getObjectDefinition())) {
                this.addContent(csvObject2);
            }
            this.iterateReferences(csvObject2, profileLinkProcessor, set);
            this.iterateChildren(csvObject2, profileLinkProcessor, set);
            this.deregisterObject(csvObject2);
        }
    }

    private void addContent(CsvObject csvObject) {
        if (this.contents == null) {
            this.contents = new LinkedList<CsvObject>();
        }
        this.contents.add(csvObject);
    }

    private void print(ProfileLink profileLink) {
        if (this.sequence % 100000L == 0L) {
            ProfiledObject profiledObject = profileLink.getSourceNode();
            ProfiledObject profiledObject2 = profileLink.getDestinationNode();
            String string = profiledObject != null ? profiledObject.toString() : "null";
            String string2 = profiledObject2 != null ? profiledObject2.toString() : "null";
            BLIB.DBG_DEBUG.log("Processed link: " + this.sequence + " " + string + " -> " + string2);
        }
    }

    private void iterateReferences(CsvObject csvObject, ProfileLinkProcessor profileLinkProcessor, Set<ObjectIdentifier> set) throws MIRException {
        List<CsvReference> list;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        List<CsvReference> list2 = this.forwardReferences.get(csvObject.getObjectDefinition());
        if (list2 != null) {
            list = list2.iterator();
            while (list.hasNext()) {
                CsvReference csvReference = list.next();
                if (!csvReference.isProcessed() && set.contains(csvReference.getDst())) {
                    ReferenceProfileLink object = CsvUtil.createReferenceLink(csvObject.getObjectDefinition(), csvReference.getDst(), csvReference, this.profileLinks);
                    profileLinkProcessor.process(object);
                    csvReference.setProcessed();
                }
                if (!csvReference.isProcessed()) continue;
                linkedList.add(csvReference);
            }
        }
        if ((list = this.reverseReferences.get(csvObject.getObjectDefinition())) != null) {
            for (CsvReference csvReference : list) {
                if (!csvReference.isProcessed() && set.contains(csvReference.getSrc())) {
                    ReferenceProfileLink referenceProfileLink = CsvUtil.createReferenceLink(csvReference.getSrc(), csvObject.getObjectDefinition(), csvReference, this.profileLinks);
                    profileLinkProcessor.process(referenceProfileLink);
                    csvReference.setProcessed();
                }
                if (!csvReference.isProcessed()) continue;
                linkedList.add(csvReference);
            }
        }
        for (CsvReference csvReference : linkedList) {
            list2 = this.forwardReferences.get(csvReference.getSrc());
            if (list2 != null) {
                list2.remove(csvReference);
                if (list2.isEmpty()) {
                    this.forwardReferences.remove(csvReference.getSrc());
                }
            }
            if ((list = this.reverseReferences.get(csvReference.getDst())) == null) continue;
            list.remove(csvReference);
            if (!list.isEmpty()) continue;
            this.reverseReferences.remove(csvReference.getDst());
        }
    }

    private void iteratePostponedReferences(ProfileLinkProcessor profileLinkProcessor, Set<ObjectIdentifier> set) throws MIRException {
        for (MIRProfileEntity mIRProfileEntity : this.postponeEntityReferences) {
            CsvReference.Reader reader = this.referenceReadersMap.get(mIRProfileEntity);
            this.iteratePostponedReferences(profileLinkProcessor, mIRProfileEntity, reader, set);
        }
    }

    private void iteratePostponedReferences(ProfileLinkProcessor profileLinkProcessor, MIRProfileEntity mIRProfileEntity, CsvReference.Reader reader, Set<ObjectIdentifier> set) throws MIRException {
        if (reader != null) {
            BLIB.DBG_DEBUG.log("processing model: " + this.modelInfo.getModelId() + " postponed references: " + mIRProfileEntity.getName());
            CsvReference csvReference = null;
            while ((csvReference = (CsvReference)reader.peek()) != null) {
                reader.pop();
                ObjectIdentifier objectIdentifier = csvReference.getSrc();
                ObjectIdentifier objectIdentifier2 = csvReference.getDst();
                if (!set.contains(objectIdentifier) || !set.contains(objectIdentifier2)) continue;
                ReferenceProfileLink referenceProfileLink = CsvUtil.createReferenceLink(objectIdentifier, objectIdentifier2, csvReference, this.profileLinks);
                profileLinkProcessor.process(referenceProfileLink);
            }
        }
    }

    public void iterateLineage(CsvObject csvObject, ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        this.iterateLineage(csvObject, this.lineageReader, profileLinkProcessor);
        this.iterateLineage(csvObject, this.lineageSummaryReader, profileLinkProcessor);
    }

    private void iterateLineage(CsvObject csvObject, CsvLineage.Reader reader, ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        if (reader != null) {
            BLIB.DBG_DEBUG.log("processing lineage for model: " + this.modelInfo.getModelId());
            CsvLineage csvLineage = null;
            while ((csvLineage = (CsvLineage)reader.peek()) != null) {
                reader.pop();
                ObjectIdentifier objectIdentifier = csvLineage.getSource();
                ObjectIdentifier objectIdentifier2 = csvLineage.getDestination();
                ProfileLink.LINK_TYPE lINK_TYPE = csvLineage.getType();
                ObjectIdentifier objectIdentifier3 = csvLineage.getDatabaseOperation();
                ObjectIdentifier objectIdentifier4 = csvLineage.getTransformation();
                ObjectIdentifier objectIdentifier5 = this.buildTransformationModel(csvObject, lINK_TYPE);
                LineageProfileLink lineageProfileLink = CsvUtil.createLineageLink(objectIdentifier, objectIdentifier2, lINK_TYPE, objectIdentifier3, objectIdentifier4, objectIdentifier5);
                profileLinkProcessor.process(lineageProfileLink);
            }
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ObjectIdentifier buildTransformationModel(CsvObject csvObject, ProfileLink.LINK_TYPE lINK_TYPE) {
        ObjectIdentifier objectIdentifier = null;
        if (this.rootObject != null && this.rootObject.getEntity().getElementType() == 258 && csvObject != null && csvObject.getEntity().getElementType() == 283) {
            switch (lINK_TYPE) {
                case DATA_LINEAGE: 
                case CONTROL_LINEAGE: 
                case SUMMARY_LINEAGE: 
                case SUMMARY_CONTROL_LINEAGE: 
                case STITCHING: 
                case SEMANTIC_LINK: {
                    objectIdentifier = new ObjectIdentifier(this.modelId, 1);
                    break;
                }
                default: {
                    objectIdentifier = null;
                }
            }
        }
        return objectIdentifier;
    }

    public void checkReaders() throws MIRException {
        for (CsvObject.Reader reader : this.objectReaders) {
            CsvObject csvObject = (CsvObject)reader.peek();
            if (csvObject == null) continue;
            BLIB.DBG_DEBUG.log("Objects remaining in file: " + reader.toString());
        }
    }

    public void setSequence(long l) {
        this.sequence = l;
    }

    public List<CsvObject> getContents() {
        return this.contents;
    }

    public void close() {
        for (CsvObject.Reader csvFileTask : this.objectReaders) {
            try {
                csvFileTask.close();
            }
            catch (Exception exception) {
                BLIB.DBG_DEBUG.log(exception, new Object[0]);
            }
        }
        for (CsvReference.Reader reader : this.referenceReaders) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                BLIB.DBG_DEBUG.log(exception, new Object[0]);
            }
        }
    }
}

