/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.sdk.MIRStoreType;
import MITI.sdk.profiles.impl.csv.CsvFileTask;
import MITI.sdk.profiles.impl.csv.ProfiledCsvFileReader;
import java.io.File;
import java.util.List;

public class CsvModelInfo {
    private static final String MODEL_ID = "ModelId";
    private static final String PROFILE_ID = "ProfileId";
    private static final String CHECKSUM = "Checksum";
    private static final String IS_CONNECTION = "IsConnection";
    private static final String STORE_TYPE = "StoreType";
    private static final String SYSTEM_TYPE = "SystemType";
    private int modelId;
    private int profileId;
    private String checksum;
    private boolean isConnection;
    private byte storeType;
    private String systemType;

    public CsvModelInfo(int n, int n2, String string, boolean bl, byte by, String string2) {
        this.modelId = n;
        this.profileId = n2;
        this.checksum = string;
        this.storeType = by;
        this.systemType = string2;
    }

    public static CsvModelInfo build(ProfiledCsvFileReader profiledCsvFileReader, List<String> list) {
        String string = profiledCsvFileReader.getString(MODEL_ID, list);
        String string2 = profiledCsvFileReader.getString(PROFILE_ID, list);
        String string3 = profiledCsvFileReader.getString(CHECKSUM, list);
        boolean bl = Boolean.valueOf(profiledCsvFileReader.getString(IS_CONNECTION, list));
        String string4 = profiledCsvFileReader.getString(STORE_TYPE, list);
        String string5 = profiledCsvFileReader.getString(SYSTEM_TYPE, list);
        byte by = 0;
        if (string4 != null) {
            by = MIRStoreType.parseCppString(string4);
        }
        CsvModelInfo csvModelInfo = new CsvModelInfo(profiledCsvFileReader.getInt(string), profiledCsvFileReader.getInt(string2), string3, bl, by, string5);
        return csvModelInfo;
    }

    public int getModelId() {
        return this.modelId;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isConnection() {
        return this.isConnection;
    }

    public byte getStoreType() {
        return this.storeType;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public static class Reader
    extends CsvFileTask<CsvModelInfo> {
        public Reader(File file) {
            super(file, -1);
        }

        @Override
        protected CsvModelInfo build(List<String> list) {
            CsvModelInfo csvModelInfo = CsvModelInfo.build(this.reader, list);
            return csvModelInfo;
        }
    }
}

