/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.impl.csv.CsvFileTask;
import MITI.sdk.profiles.impl.csv.ProfiledCsvFileReader;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.io.File;
import java.util.List;

public class CsvLineage {
    private static final String SOURCE_MODEL_ID = "SourceModelId";
    private static final String SOURCE_ID = "SourceObjectId";
    private static final String DESTINATION_MODEL_ID = "DestinationModelId";
    private static final String DESTINATION_ID = "DestinationObjectId";
    private static final String TYPE = "Type";
    private static final String TR_MODEL_ID = "TransformationModelId";
    private static final String TR_OBJECT_ID = "QueryId";
    private ObjectIdentifier src;
    private ObjectIdentifier dst;
    private ProfileLink.LINK_TYPE type;
    private ObjectIdentifier dbOp;
    private ObjectIdentifier tr;

    public CsvLineage(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, ProfileLink.LINK_TYPE lINK_TYPE, ObjectIdentifier objectIdentifier3, ObjectIdentifier objectIdentifier4) {
        this.src = objectIdentifier;
        this.dst = objectIdentifier2;
        this.type = lINK_TYPE;
        this.dbOp = objectIdentifier3;
        this.tr = objectIdentifier4;
    }

    public static CsvLineage build(ProfiledCsvFileReader profiledCsvFileReader, List<String> list, int n, boolean bl) {
        String string = profiledCsvFileReader.getString(TYPE, list);
        ObjectIdentifier objectIdentifier = CsvLineage.readObjectIdentifier(profiledCsvFileReader, list, SOURCE_MODEL_ID, SOURCE_ID, n);
        ObjectIdentifier objectIdentifier2 = CsvLineage.readObjectIdentifier(profiledCsvFileReader, list, DESTINATION_MODEL_ID, DESTINATION_ID, n);
        ObjectIdentifier objectIdentifier3 = null;
        ObjectIdentifier objectIdentifier4 = bl ? null : CsvLineage.readObjectIdentifier(profiledCsvFileReader, list, TR_MODEL_ID, TR_OBJECT_ID, n);
        ProfileLink.LINK_TYPE lINK_TYPE = CsvLineage.fromShortName(string, bl);
        CsvLineage csvLineage = new CsvLineage(objectIdentifier, objectIdentifier2, lINK_TYPE, objectIdentifier3, objectIdentifier4);
        return csvLineage;
    }

    private static ProfileLink.LINK_TYPE fromShortName(String string, boolean bl) {
        ProfileLink.LINK_TYPE lINK_TYPE = "d".equals(string) ? (bl ? ProfileLink.LINK_TYPE.SUMMARY_LINEAGE : ProfileLink.LINK_TYPE.DATA_LINEAGE) : ("c".equals(string) ? (bl ? ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE : ProfileLink.LINK_TYPE.CONTROL_LINEAGE) : ("s".equals(string) ? ProfileLink.LINK_TYPE.STITCHING : ("e".equals(string) ? ProfileLink.LINK_TYPE.SEMANTIC_LINK : null)));
        return lINK_TYPE;
    }

    private static ObjectIdentifier readObjectIdentifier(ProfiledCsvFileReader profiledCsvFileReader, List<String> list, String string, String string2, int n) {
        String string3 = profiledCsvFileReader.getString(string, list);
        String string4 = profiledCsvFileReader.getString(string2, list);
        int n2 = string3 == null || string3.isEmpty() ? n : profiledCsvFileReader.getInt(string3);
        int n3 = string4 == null || string4.isEmpty() ? -1 : profiledCsvFileReader.getInt(string4);
        ObjectIdentifier objectIdentifier = null;
        if (n2 != -1 && n3 != -1) {
            objectIdentifier = new ObjectIdentifier(n2, n3);
        }
        return objectIdentifier;
    }

    public ObjectIdentifier getSource() {
        return this.src;
    }

    public ObjectIdentifier getDestination() {
        return this.dst;
    }

    public ProfileLink.LINK_TYPE getType() {
        return this.type;
    }

    public ObjectIdentifier getDatabaseOperation() {
        return this.dbOp;
    }

    public ObjectIdentifier getTransformation() {
        return this.tr;
    }

    public static class Reader
    extends CsvFileTask<CsvLineage> {
        private boolean forSummary;

        public Reader(File file, int n, boolean bl) {
            super(file, n);
            this.forSummary = bl;
        }

        @Override
        protected CsvLineage build(List<String> list) {
            CsvLineage csvLineage = CsvLineage.build(this.reader, list, this.modelId, this.forSummary);
            return csvLineage;
        }
    }
}

