/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.MIRException;
import MITI.sdk.profiles.impl.csv.ProfiledCsvFileReader;
import MITI.util.thread.SimpleTask;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class CsvFileTask<T>
extends SimpleTask {
    protected List<T> objects = new LinkedList<T>();
    protected File file;
    protected int modelId;
    protected String displayName;
    protected ProfiledCsvFileReader reader;
    protected T current;
    protected boolean closed;

    public CsvFileTask(File file, int n) {
        this.file = file;
        this.modelId = n;
        this.displayName = n != -1 ? String.valueOf(n) + "/" + file.getName() : file.getName();
        this.reader = null;
        this.current = null;
        this.closed = false;
    }

    private void init() throws Exception {
        if (this.reader == null && !this.closed) {
            this.reader = new ProfiledCsvFileReader(this.file, this.modelId);
            this.reader.readHeader();
        }
    }

    @Override
    protected Boolean internalCall() throws Exception {
        try {
            List<String> list;
            this.init();
            while ((list = this.reader.getNextLine()) != null) {
                T t = this.build(list);
                this.objects.add(t);
            }
        }
        finally {
            this.close();
        }
        return true;
    }

    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        this.closed = true;
    }

    protected abstract T build(List<String> var1);

    public List<T> getObjects() {
        return this.objects;
    }

    private T readNext() throws MIRException {
        T t = null;
        if (this.reader != null && !this.closed) {
            try {
                List<String> list = this.reader.getNextLine();
                if (list != null) {
                    t = this.build(list);
                }
            }
            catch (Exception exception) {
                throw new MIRException(exception.getMessage(), exception);
            }
        }
        return t;
    }

    public T peek() throws MIRException {
        if (this.current == null && !this.closed) {
            try {
                this.init();
                this.current = this.readNext();
            }
            catch (Exception exception) {
                throw new MIRException(exception.getMessage(), exception);
            }
        }
        return this.current;
    }

    public T pop() throws MIRException {
        T t = this.peek();
        this.current = null;
        return t;
    }

    public String toString() {
        return this.displayName;
    }
}

