/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.MIRException;
import MITI.sdk.MIRModel;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.Profiler;
import MITI.sdk.profiles.impl.MIRProfiler;
import MITI.sdk.profiles.impl.memory.original.ProfilerOriginalImpl;
import MITI.sdk.profiles.impl.memory.simple.ProfilerSimpleImpl;
import MITI.util.config.MimbConfiguration;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;

public class ProfilerFactory {
    private static Map<Integer, MIRProfile> profilesById = new TreeMap<Integer, MIRProfile>();
    private static Map<String, MIRProfile> profilesByName = new TreeMap<String, MIRProfile>();

    public static Profiler create(File file) throws MIRException {
        return ProfilerFactory.create(null, file);
    }

    public static Profiler create(File file, File file2) throws MIRException {
        if (file != null) {
            MimbConfiguration.setMimbHome(file.getAbsolutePath());
        }
        return new ProfilerOriginalImpl(file2);
    }

    public static Profiler create(MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        return ProfilerFactory.create(null, mIRModel, mIRMixCache);
    }

    public static Profiler createExtended(MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        return ProfilerFactory.createExtended(null, mIRModel, mIRMixCache);
    }

    public static Profiler create(File file, MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        if (file != null) {
            MimbConfiguration.setMimbHome(file.getAbsolutePath());
        }
        return new ProfilerOriginalImpl(mIRModel, mIRMixCache);
    }

    public static Profiler createExtended(File file, MIRModel mIRModel, MIRMixCache mIRMixCache) throws MIRException {
        if (file != null) {
            MimbConfiguration.setMimbHome(file.getAbsolutePath());
        }
        return new ProfilerSimpleImpl(mIRModel, mIRMixCache);
    }

    public static MIRProfile getProfile(int n) throws MIRException {
        MIRProfile mIRProfile = profilesById.get(n);
        if (mIRProfile == null) {
            String string = MIRProfiler.loadProfile(n);
            mIRProfile = MIRProfiler.getProfile(n);
            profilesById.put(n, mIRProfile);
            profilesByName.put(string, mIRProfile);
        }
        return mIRProfile;
    }

    public static MIRProfile getProfile(String string) throws MIRException {
        MIRProfile mIRProfile = profilesByName.get(string);
        if (mIRProfile == null) {
            MIRProfiler.loadProfile(string);
            mIRProfile = MIRProfiler.getProfile(string);
            int n = mIRProfile.getProfileId();
            profilesById.put(n, mIRProfile);
            profilesByName.put(string, mIRProfile);
        }
        return mIRProfile;
    }
}

