/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.tablecomparator;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.table.DefaultMergeImportItem;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.NestedImportItem;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PublicObjectPromotionOptions;
import com.sas.metadata.tools.tablecomparator.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NestedItemMergeManager {
    private ImportOperationInterface operation;
    private ImportItemInterface importItem;
    private PublicObjectPromotionOptions tableOptions;
    private String publicType;
    List<ImportItemInterface> objectsToImport;
    private Log logger = null;

    private NestedItemMergeManager() {
    }

    public static NestedItemMergeManager getInstance(ImportItemInterface importItem) {
        if (importItem != null) {
            ArrayList<ImportItemInterface> items = new ArrayList<ImportItemInterface>(1);
            items.add(importItem);
            return NestedItemMergeManager.getInstance(items);
        }
        throw new IllegalArgumentException("Object should not be null");
    }

    private NestedItemMergeManager(List<ImportItemInterface> objectsToImport) {
        if (objectsToImport == null || objectsToImport.size() <= 0) {
            throw new IllegalArgumentException("Object list should not be empty");
        }
        this.init(objectsToImport.get(0));
        this.objectsToImport = objectsToImport;
    }

    private boolean convertToBoolean(PublicObjectPromotionOptions.SelectionState selection) {
        boolean bool = false;
        switch (selection) {
            case ON: {
                bool = true;
                break;
            }
            case OFF: {
                bool = false;
            }
        }
        return bool;
    }

    public void setImportOptions(boolean deletSrc, boolean deletetrgt, ImportItemInterface importItem) {
        if ((deletSrc || deletetrgt) && importItem instanceof PublicObjectPromotionOptions) {
            PublicObjectPromotionOptions popo = (PublicObjectPromotionOptions)importItem;
            if (deletSrc) {
                popo.setStateOfKeepNewOption(PublicObjectPromotionOptions.SelectionState.OFF);
            }
            if (deletetrgt) {
                popo.setStateOfKeepDeletedOption(PublicObjectPromotionOptions.SelectionState.OFF);
            }
        }
    }

    public void restoreColumnConnectionPoints(ImportItemInterface table) {
        if (table != null && table.containsNestedItems()) {
            List columns = table.getNestedItems();
            ConnectionManagerInterface connectionManager = ConnectionManager.getInstance((PromotionInterface)table.getImportOperation());
            for (NestedImportItemInterface column : columns) {
                ConnectionPointInterface columnConnection = connectionManager.getConnection(column.getID());
                if (columnConnection == null) continue;
                if (column.getImportState() == 0 && !columnConnection.isActive()) {
                    columnConnection.setActive(true);
                } else if (column.getImportState() != 0 && columnConnection.isActive()) {
                    columnConnection.setActive(false);
                }
                if (columnConnection.getTargetID() != null || column.getTargetID() == null) continue;
                columnConnection.setTargetID(column.getTargetID());
            }
        }
    }

    public void mergeColumns(ImportItemInterface importItem) {
        if (importItem != null) {
            DataTableInterface table = null;
            ObjectConverter convertor = ObjectConverter.getInstance();
            if (this.considerForMerging(importItem)) {
                if (importItem instanceof PublicObjectPromotionOptions) {
                    this.tableOptions = (PublicObjectPromotionOptions)importItem;
                    this.importItem = importItem;
                }
                try {
                    table = (DataTableInterface)convertor.convertToTargetPublicObject(importItem, importItem.getImportOperation().getServer());
                    if (table != null) {
                        this.updateColumnStates(table.getColumns());
                    }
                }
                catch (RemoteException remoteException) {
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
        }
    }

    private void updateColumnStates(List<ColumnInterface> columns) throws RemoteException, ServiceException {
        List importColumns = this.importItem.getNestedItems();
        Map<String, String> columnNames = this.fetchNames(columns);
        boolean hasNewColumns = false;
        for (NestedImportItemInterface column : importColumns) {
            if (columnNames.containsKey(column.getName())) {
                if (column.getImportState() != -1 || this.targetOnly(column) || !(this.importItem instanceof DefaultMergeImportItem)) continue;
                if (!((DefaultMergeImportItem)this.importItem).getStateOfSkipUpdateOption().booleanValue()) {
                    column.setImportState(2);
                    column.setTargetID(columnNames.get(column.getName()));
                    continue;
                }
                column.setImportState(0);
                column.setTargetID(columnNames.get(column.getName()));
                continue;
            }
            if (this.tableOptions.getStateOfKeepNewOption() == PublicObjectPromotionOptions.SelectionState.ON) {
                column.setImportState(1);
                hasNewColumns = true;
                continue;
            }
            if (this.tableOptions.getStateOfKeepNewOption() != PublicObjectPromotionOptions.SelectionState.OFF) continue;
            column.setImportState(0);
            hasNewColumns = true;
        }
        boolean created = this.createDeletedImportItems(columns, this.fetchNames(importColumns).keySet());
        if (this.importItem instanceof DefaultMergeImportItem && !((DefaultMergeImportItem)this.importItem).isMerged()) {
            ((DefaultMergeImportItem)this.importItem).setMergeProperties(hasNewColumns, created);
        }
        this.updateDeletedImportItemStates();
    }

    private void updateDeletedImportItemStates() {
        if (this.importItem.containsNestedItems()) {
            List columns = this.importItem.getNestedItems();
            for (NestedImportItemInterface column : columns) {
                if (!this.targetOnly(column)) continue;
                if (this.tableOptions.getStateOfKeepDeletedOption() == PublicObjectPromotionOptions.SelectionState.ON) {
                    column.setImportState(2);
                    continue;
                }
                if (this.tableOptions.getStateOfKeepDeletedOption() != PublicObjectPromotionOptions.SelectionState.OFF) continue;
                column.setImportState(3);
            }
        }
    }

    private boolean targetOnly(NestedImportItemInterface column) {
        return column != null && column.getUserObject() != null && (Boolean)column.getUserObject() != false;
    }

    private boolean createDeletedImportItems(List<ColumnInterface> columns, Set<String> importColumns) {
        NestedImportItem deleted = null;
        boolean created = false;
        for (ColumnInterface column : columns) {
            try {
                if (importColumns.contains(column.getName())) continue;
                deleted = new NestedImportItem(column.getName(), column.getIdentifier(), this.operation.getTransportableType("Column"));
                deleted.setUserObject((Object)true);
                deleted.setTargetID(column.getIdentifier());
                deleted.setParent(this.importItem);
                created = true;
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException serviceException) {}
        }
        return created;
    }

    private Map<String, String> fetchNames(List<?> columns) throws ServiceException, RemoteException {
        HashMap<String, String> names = new HashMap<String, String>(columns.size());
        String name = null;
        String id = null;
        for (Object column : columns) {
            if (column instanceof ColumnInterface) {
                name = ((ColumnInterface)column).getName();
                id = ((ColumnInterface)column).getIdentifier();
            } else {
                name = ((ImportItemInterface)column).getName();
                id = ((ImportItemInterface)column).getID();
            }
            names.put(name, id);
        }
        return names;
    }

    private void init(ImportItemInterface importItem) {
        this.operation = importItem.getImportOperation();
        TypeInterface type = importItem.getTypeInterface();
        this.publicType = type.getPublicType();
        TransportableTypeInterface transType = this.operation.getTransportableType(this.publicType);
        this.logger = importItem.getImportOperation().getLogger();
    }

    public static NestedItemMergeManager getInstance(List<ImportItemInterface> objectsToImport) {
        return new NestedItemMergeManager(objectsToImport);
    }

    private boolean considerForMerging(ImportItemInterface importItem) {
        boolean consider = false;
        if (importItem != null && importItem.getImportState() == 2) {
            consider = true;
        }
        return consider;
    }

    public void logUserChanges() {
        ArrayList<NestedImportItemInterface> lstAddedObject = null;
        ArrayList<NestedImportItemInterface> lstModifiedObject = null;
        ArrayList<NestedImportItemInterface> lstDeletedObject = null;
        String NestedObjectType = "";
        for (ImportItemInterface importItem : this.objectsToImport) {
            List lstNestItem;
            if (importItem.containsNestedItems() && importItem.getImportState() == 2 && (lstNestItem = importItem.getNestedItems()) != null && lstNestItem.size() > 0) {
                lstAddedObject = new ArrayList<NestedImportItemInterface>(lstNestItem.size());
                lstModifiedObject = new ArrayList<NestedImportItemInterface>(lstNestItem.size());
                lstDeletedObject = new ArrayList<NestedImportItemInterface>(lstNestItem.size());
                block5: for (int i = 0; i < lstNestItem.size(); ++i) {
                    NestedImportItemInterface nestedItem = (NestedImportItemInterface)lstNestItem.get(i);
                    NestedObjectType = nestedItem.getTypeInterface().getMetadataType();
                    switch (nestedItem.getImportState()) {
                        case 0: {
                            if (nestedItem.getTargetID() != "." && nestedItem.getTargetID() != null) {
                                lstModifiedObject.add(nestedItem);
                                continue block5;
                            }
                            lstAddedObject.add(nestedItem);
                            continue block5;
                        }
                        case 3: {
                            lstDeletedObject.add(nestedItem);
                            continue block5;
                        }
                    }
                }
            }
            if (!(lstAddedObject != null && lstAddedObject.size() > 0 || lstAddedObject != null && lstModifiedObject.size() > 0) && (lstAddedObject == null || lstDeletedObject.size() <= 0)) continue;
            String LogString = "";
            if (lstAddedObject.size() > 0) {
                LogString = this.WriteToLog(lstAddedObject);
                this.logger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("NestedItemMergeManager.ObjectAdd.fmt"), (Object)NestedObjectType, (Object)importItem.getTypeInterface().getPublicType(), (Object)importItem.getName(), (Object)LogString));
            }
            if (lstModifiedObject.size() > 0) {
                LogString = this.WriteToLog(lstModifiedObject);
                this.logger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("NestedItemMergeManager.ObjectModify.fmt"), (Object)NestedObjectType, (Object)importItem.getTypeInterface().getPublicType(), (Object)importItem.getName(), (Object)LogString));
            }
            if (lstDeletedObject.size() <= 0) continue;
            LogString = this.WriteToLog(lstDeletedObject);
            this.logger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("NestedItemMergeManager.ObjectDelete.fmt"), (Object)NestedObjectType, (Object)importItem.getTypeInterface().getPublicType(), (Object)importItem.getName(), (Object)LogString));
        }
    }

    private String WriteToLog(List lstObject) {
        String logString = "";
        if (lstObject.size() > 0) {
            for (int i = 0; i < lstObject.size(); ++i) {
                NestedImportItem NestedItem = (NestedImportItem)lstObject.get(i);
                logString = i < lstObject.size() - 1 ? logString + NestedItem.getName() + ", " : logString + NestedItem.getName();
            }
        }
        return logString;
    }

    public List<NestedImportItemInterface> getNestedItems(ImportItemInterface importItem, int state) {
        ArrayList<NestedImportItemInterface> filtered = null;
        if (importItem != null && importItem.containsNestedItems()) {
            List nestedItems = importItem.getNestedItems();
            filtered = new ArrayList<NestedImportItemInterface>(nestedItems.size());
            for (NestedImportItemInterface nestedItem : nestedItems) {
                if (nestedItem.getImportState() != state) continue;
                filtered.add(nestedItem);
            }
            filtered = filtered.size() == 0 ? null : filtered;
        }
        return filtered;
    }
}

