/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.tablecomparator;

import com.sas.metadata.logical.comparison.AttributeComparisonResult;
import com.sas.metadata.logical.comparison.ComparisonConfigurationException;
import com.sas.metadata.logical.comparison.ComparisonResultNodeInterface;
import com.sas.metadata.logical.comparison.ComparisonResultsException;
import com.sas.metadata.logical.comparison.ComparisonTemplateNodeInterface;
import com.sas.metadata.logical.table.ComparisonObjectNode;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.tools.tablecomparator.ComparisonResultObjectPool;
import com.sas.metadata.tools.tablecomparator.DefaultController;
import com.sas.metadata.tools.tablecomparator.HashedResultNodeHelper;
import com.sas.metadata.tools.tablecomparator.PromotionComparisonNodeInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashedComparisonResultNode
implements PromotionComparisonNodeInterface {
    private static Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData;
    private static Map<String, Map<String, String>> rootNodeAttributeComparision;
    private Map<String, Map<String, String>> attributeComparision;
    private static ComparisonResultNodeInterface rootNode;
    private String objectPointer;
    private ImportItemInterface importItem;
    private ComparisonResultNodeInterface.Location location;
    private int Sequence_no;
    private ComparisonResultNodeInterface parent;
    private ComparisonResultObjectPool objectPool = DefaultController.getResultObjectsPool();
    private String thisMapKey;
    private ComparisonMapLevels thisMaplevel;
    private String thisMapKeyPath = "";
    private String logicalTypeName;
    private String associationName;
    private String path;

    private HashedComparisonResultNode(Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> comparisonResult, Map<String, Map<String, String>> baseObjectAttributeComparision) {
        resultData = comparisonResult;
        rootNodeAttributeComparision = baseObjectAttributeComparision;
        this.logicalTypeName = "table";
        this.thisMapKey = this.getRootObjectId(resultData);
        this.thisMaplevel = ComparisonMapLevels.ROOT;
        this.thisMapKeyPath = this.thisMapKey;
    }

    private HashedComparisonResultNode(String colName, Map<String, Map<String, String>> argAttributes, String objectPointer, String associationName, ComparisonResultNodeInterface parent) {
        this.thisMapKey = colName;
        this.associationName = associationName;
        this.attributeComparision = argAttributes;
        this.objectPointer = objectPointer;
        this.parent = parent;
    }

    public static ComparisonResultNodeInterface constructRootNode(Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> comparisonResult, Map<String, Map<String, String>> baseObjectAttributeComparision) {
        return rootNode;
    }

    private HashedComparisonResultNode(String objectPointer) {
        this.objectPointer = objectPointer;
        this.logicalTypeName = "table";
        Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData = null;
        try {
            resultData = this.objectPool.getAssociationComparisonResult(objectPointer);
            this.importItem = this.objectPool.getComparisonObjectNode(objectPointer).getImportItem();
        }
        catch (ComparisonResultsException comparisonResultsException) {
            // empty catch block
        }
        this.thisMapKey = this.getRootObjectId(resultData);
        this.setLocation(ComparisonResultNodeInterface.Location.BOTH);
        this.thisMaplevel = ComparisonMapLevels.ROOT;
        this.thisMapKeyPath = this.thisMapKey;
    }

    public static ComparisonResultNodeInterface constructRootNode(String objectPointer) {
        return new HashedComparisonResultNode(objectPointer);
    }

    @Override
    public List<String> getAssociations() {
        Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData = null;
        try {
            resultData = this.objectPool.getAssociationComparisonResult(this.objectPointer);
        }
        catch (ComparisonResultsException comparisonResultsException) {
            // empty catch block
        }
        ArrayList<String> retVal = null;
        String rootObjectId = null;
        rootObjectId = this.getRootObjectId(resultData);
        if (ComparisonMapLevels.ROOT.equals((Object)this.thisMaplevel)) {
            if (resultData != null) {
                retVal = this.getAssociationsForNode(rootObjectId);
            }
        } else if (this.attributeComparision != null) {
            Iterator<String> it = this.attributeComparision.keySet().iterator();
            String nestedObjectId = null;
            String attribName = null;
            while (it.hasNext()) {
                attribName = it.next();
                if (!attribName.startsWith("MultiAssoc_")) continue;
                nestedObjectId = attribName.substring("MultiAssoc_".length());
                break;
            }
            if (nestedObjectId != null && resultData != null) {
                retVal = this.getAssociationsForNode(attribName);
            }
        }
        return retVal;
    }

    private String getRootObjectId(Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData2) {
        String retVal = null;
        Set<String> keys = resultData2.keySet();
        Iterator<String> keyIterator = keys.iterator();
        String currentKey = null;
        while (keyIterator.hasNext()) {
            currentKey = keyIterator.next();
            if (currentKey.contains("MultiAssoc_")) continue;
            retVal = currentKey;
            break;
        }
        return retVal;
    }

    private ArrayList<String> getAssociationsForNode(String nodeId) {
        ArrayList<String> retVal = null;
        Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData = null;
        try {
            resultData = this.objectPool.getAssociationComparisonResult(this.objectPointer);
        }
        catch (ComparisonResultsException comparisonResultsException) {
            // empty catch block
        }
        Map level1Map = (Map)resultData.get(nodeId);
        if (level1Map != null) {
            for (String objectId : level1Map.keySet()) {
                Map level2Map = (Map)level1Map.get(objectId);
                Iterator it2 = level2Map.keySet().iterator();
                while (it2.hasNext()) {
                    if (retVal == null) {
                        retVal = new ArrayList<String>();
                    }
                    retVal.add((String)it2.next());
                }
            }
        }
        return retVal;
    }

    @Override
    public AttributeComparisonResult getAttributeComparison(String attributeName) {
        AttributeComparisonResult retVal = null;
        Map<String, Map<String, String>> localAttributeComparision = null;
        if ("table".equals(this.logicalTypeName)) {
            try {
                localAttributeComparision = this.objectPool.getNodeComparisonResult(this.objectPointer);
            }
            catch (ComparisonResultsException comparisonResultsException) {}
        } else {
            localAttributeComparision = this.attributeComparision;
        }
        if (localAttributeComparision != null) {
            Iterator<String> attribIterator = localAttributeComparision.keySet().iterator();
            if (localAttributeComparision.containsKey(attributeName)) {
                retVal = new AttributeComparisonResult();
                retVal.setName(attributeName);
                Map<String, String> attribMap = localAttributeComparision.get(attributeName);
                retVal.setSource1Val(attribMap.get("Xmlvalue"));
                retVal.setSource2Val(attribMap.get("Metadatavalue"));
                retVal.setResult("true".equals(attribMap.get("Result")) ? ComparisonResultNodeInterface.Result.MATCHED : ComparisonResultNodeInterface.Result.UNMACHED);
            }
        }
        return retVal;
    }

    private Map<String, Map<String, String>> getAttributes() {
        Object retVal = null;
        Object current = null;
        Map<String, Map<String, String>> localAttributeComparision = null;
        if ("table".equals(this.logicalTypeName)) {
            try {
                localAttributeComparision = this.objectPool.getNodeComparisonResult(this.objectPointer);
            }
            catch (ComparisonResultsException comparisonResultsException) {}
        } else {
            localAttributeComparision = this.attributeComparision;
        }
        return localAttributeComparision;
    }

    @Override
    public List<AttributeComparisonResult> getAttributeComparisons() {
        ArrayList<AttributeComparisonResult> retVal = null;
        AttributeComparisonResult current = null;
        Map<String, Map<String, String>> localAttributeComparision = this.getAttributes();
        if (localAttributeComparision != null) {
            for (String attribname : localAttributeComparision.keySet()) {
                if (this.isSpeacialAttribute(attribname)) continue;
                current = new AttributeComparisonResult();
                current.setName(attribname);
                Map<String, String> attribMap = localAttributeComparision.get(attribname);
                current.setSource1Val(attribMap.get("Xmlvalue"));
                current.setSource2Val(attribMap.get("Metadatavalue"));
                current.setResult("true".equals(attribMap.get("Result")) ? ComparisonResultNodeInterface.Result.MATCHED : ComparisonResultNodeInterface.Result.UNMACHED);
                if (retVal == null) {
                    retVal = new ArrayList<AttributeComparisonResult>();
                }
                retVal.add(current);
            }
        }
        return retVal;
    }

    private boolean isSpeacialAttribute(String attribName) {
        return attribName != null && (attribName.startsWith("MultiAssoc_") || attribName.equals("ImportState") || attribName.equals("OrigImportState") || attribName.equals("Id") || attribName.equals("MetadataObjectType"));
    }

    @Override
    public Collection<ComparisonResultNodeInterface> getComparisonResults(String associationName) {
        List<ComparisonResultNodeInterface> retVal = null;
        Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData = null;
        try {
            resultData = this.objectPool.getAssociationComparisonResult(this.objectPointer);
        }
        catch (ComparisonResultsException comparisonResultsException) {
            // empty catch block
        }
        if ("table".equals(this.logicalTypeName)) {
            if (resultData != null) {
                retVal = this.extractComparisionResults(this.getRootObjectId(resultData), associationName);
            }
        } else {
            String multiassocKey = null;
            String nestedObjectId = null;
            if (this.attributeComparision != null) {
                Iterator<String> it = this.attributeComparision.keySet().iterator();
                String attribName = null;
                while (it.hasNext()) {
                    attribName = it.next();
                    if (!attribName.startsWith("MultiAssoc_")) continue;
                    nestedObjectId = attribName.substring("MultiAssoc_".length());
                    multiassocKey = attribName;
                    break;
                }
            }
            if (multiassocKey != null && resultData != null) {
                retVal = this.extractComparisionResults(multiassocKey, associationName);
            }
        }
        return retVal;
    }

    private List<ComparisonResultNodeInterface> extractComparisionResults(String nodeId, String associationName) {
        List<ComparisonResultNodeInterface> retVal = null;
        Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> resultData = null;
        try {
            resultData = this.objectPool.getAssociationComparisonResult(this.objectPointer);
        }
        catch (ComparisonResultsException comparisonResultsException) {
            // empty catch block
        }
        Map level1Map = (Map)resultData.get(nodeId);
        for (String objectId : level1Map.keySet()) {
            Map level2Map = (Map)level1Map.get(objectId);
            Map level3Map = (Map)level2Map.get(associationName);
            retVal = this.appendNodesToList(retVal, level3Map, "Added", ComparisonResultNodeInterface.Location.SOURCE1, associationName);
            retVal = this.appendNodesToList(retVal, level3Map, "Modified", ComparisonResultNodeInterface.Location.BOTH, associationName);
            retVal = this.appendNodesToList(retVal, level3Map, "Deleted", ComparisonResultNodeInterface.Location.SOURCE2, associationName);
        }
        List SortedList = this.SortListBySequenceNumber(retVal);
        return SortedList;
    }

    private List SortListBySequenceNumber(List<ComparisonResultNodeInterface> retVal) {
        int i;
        ArrayList<ComparisonResultNodeInterface> DeleteList = new ArrayList<ComparisonResultNodeInterface>();
        ArrayList<ComparisonResultNodeInterface> SortedList = new ArrayList<ComparisonResultNodeInterface>(retVal.size());
        for (i = 0; i < retVal.size(); ++i) {
            for (int j = 0; j < retVal.size(); ++j) {
                ComparisonResultNodeInterface node1 = retVal.get(j);
                if (((HashedComparisonResultNode)node1).getSequenceNumber() != i) continue;
                SortedList.add(node1);
            }
        }
        for (i = 0; i < retVal.size(); ++i) {
            ComparisonResultNodeInterface node1 = retVal.get(i);
            if (((HashedComparisonResultNode)node1).getSequenceNumber() != -1) continue;
            DeleteList.add(node1);
        }
        SortedList.addAll(DeleteList);
        return SortedList;
    }

    private List<ComparisonResultNodeInterface> appendNodesToList(List<ComparisonResultNodeInterface> retVal, Map<String, Map<String, Map<String, Map<String, String>>>> level3Map, String modType, ComparisonResultNodeInterface.Location argLocation, String associationName) {
        Map<String, Map<String, Map<String, String>>> level4Map = level3Map.get(modType);
        if (level4Map != null) {
            Iterator<String> level4MapIterator = level4Map.keySet().iterator();
            ImportItemInterface childImportItem = null;
            while (level4MapIterator.hasNext()) {
                String colName = level4MapIterator.next();
                Map<String, Map<String, String>> level5Map = level4Map.get(colName);
                HashedComparisonResultNode node = new HashedComparisonResultNode(colName, level5Map, this.objectPointer, associationName, this);
                node.setLocation(argLocation);
                node.setPath(this.path != null ? this.path + "/" + associationName : associationName);
                try {
                    ComparisonTemplateNodeInterface rootNode = HashedResultNodeHelper.getComparisonTemplateNode(associationName);
                    if (rootNode.importable()) {
                        childImportItem = this.findChildImportItem(node);
                        if (childImportItem == null && argLocation.equals((Object)ComparisonResultNodeInterface.Location.SOURCE2)) {
                            childImportItem = HashedResultNodeHelper.createDeletedNestedItem(node, this.getImportItem());
                            PromotionComparisonNodeInterface.ImportState delState = node.getImportstate();
                            if (delState == PromotionComparisonNodeInterface.ImportState.OFF) {
                                childImportItem.setImportState(3);
                            } else {
                                childImportItem.setImportState(-1);
                            }
                        }
                        if (childImportItem != null) {
                            String targetId = HashedResultNodeHelper.getComparisonValue(node, "Id", false);
                            childImportItem.setTargetID(targetId);
                        }
                        node.setImportItem(childImportItem);
                    }
                }
                catch (ComparisonConfigurationException rootNode) {
                    // empty catch block
                }
                node.setLogicalTypeName(ComparisonMapLevels.ATTRIBUTES.toString());
                if (retVal == null) {
                    retVal = new ArrayList<ComparisonResultNodeInterface>();
                }
                if (level5Map.containsKey("Sequence_No")) {
                    Map<String, String> AttributeMap = level5Map.get("Sequence_No");
                    if (AttributeMap.get("Xmlvalue") != ".") {
                        int index = Integer.parseInt(AttributeMap.get("Xmlvalue"));
                        node.setSequenceNumber(index);
                        retVal.add(node);
                        continue;
                    }
                    node.setSequenceNumber(-1);
                    retVal.add(node);
                    continue;
                }
                retVal.add(node);
            }
        }
        return retVal;
    }

    private void setPath(String path) {
        this.path = path;
    }

    @Override
    public ComparisonResultNodeInterface.Location getLocation() {
        return this.location;
    }

    @Override
    public String getLogicalTypeName() {
        return null;
    }

    @Override
    public ComparisonResultNodeInterface getParent() {
        return this.parent;
    }

    @Override
    public List<ComparisonResultNodeInterface> getParentPath() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void setAssociationName(String associationName) {
    }

    @Override
    public void setComparableAttribute(String attribute) {
    }

    @Override
    public void setLocation(ComparisonResultNodeInterface.Location location) {
        this.location = location;
    }

    @Override
    public void setLogicalTypeName(String logiclaTypeName) {
    }

    @Override
    public void setImportState(PromotionComparisonNodeInterface.ImportState importState) {
        Map<String, Map<String, String>> attributes = this.getAttributes();
        Map<String, String> importValue = null;
        Map<String, String> currImportValue = null;
        String importKey = null;
        String importVal = null;
        String origImportVal = null;
        int importitemState = -1;
        if (attributes != null) {
            importKey = "OrigImportState";
            importValue = attributes.get(importKey);
            origImportVal = importValue.get("Xmlvalue");
            if (importState == PromotionComparisonNodeInterface.ImportState.ON) {
                if (importValue != null) {
                    importVal = origImportVal;
                }
            } else {
                importKey = "ImportState";
                importVal = "0";
            }
            importitemState = this.getLocation().equals((Object)ComparisonResultNodeInterface.Location.SOURCE2) ? (importVal.equals("0") ? 3 : -1) : Integer.parseInt(importVal);
            ImportItemInterface importItem = this.getImportItem();
            if (importItem != null) {
                importItem.setImportState(importitemState);
            }
            currImportValue = attributes.get("ImportState");
            currImportValue.put("Xmlvalue", importVal);
        }
    }

    @Override
    public PromotionComparisonNodeInterface.ImportState getImportstate() {
        Map<String, Map<String, String>> attributes = this.getAttributes();
        PromotionComparisonNodeInterface.ImportState importState = null;
        if (attributes != null) {
            String stateValue;
            Map<String, String> importValue = attributes.get("ImportState");
            Map<String, String> origImportValue = attributes.get("OrigImportState");
            if (importValue != null) {
                stateValue = importValue.get("Xmlvalue");
                importState = HashedResultNodeHelper.converToImportState(stateValue);
            }
            if (origImportValue != null) {
                stateValue = origImportValue.get("Xmlvalue");
                importState.setImportState(Integer.parseInt(stateValue));
            }
        }
        return importState;
    }

    @Override
    public String getObjectName() {
        AttributeComparisonResult acr = this.getAttributeComparison("Name");
        String objectName = null;
        if (acr != null) {
            objectName = acr.getSource1Val() != null && !acr.getSource1Val().equals("") && !acr.getSource1Val().equals(".") ? acr.getSource1Val() : acr.getSource2Val();
        }
        return objectName != null ? objectName : "";
    }

    @Override
    public String getObjectType() {
        AttributeComparisonResult acr = this.getAttributeComparison("PublicType");
        String objectType = null;
        if (acr != null) {
            objectType = acr.getSource1Val() != null && !acr.getSource1Val().equals("") && !acr.getSource1Val().equals(".") ? acr.getSource1Val() : acr.getSource2Val();
        }
        return objectType != null ? objectType : "";
    }

    @Override
    public String getMetadataType() {
        AttributeComparisonResult acr = this.getAttributeComparison("MetadataObjectType");
        String MetadataType = null;
        if (acr != null) {
            MetadataType = acr.getSource1Val() != null && !acr.getSource1Val().equals("") && !acr.getSource1Val().equals(".") ? acr.getSource1Val() : acr.getSource2Val();
        }
        return MetadataType != null ? MetadataType : "";
    }

    @Override
    public void setObjectName(String argObjectName) {
    }

    @Override
    public void addAttributeComparison(AttributeComparisonResult comparison) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAttributeComparisons(List<AttributeComparisonResult> comparisons) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(ComparisonResultNodeInterface child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean attributesCompaired() {
        return false;
    }

    @Override
    public String getAssociationName() {
        return this.associationName;
    }

    @Override
    public ComparisonResultNodeInterface getChild() {
        return null;
    }

    @Override
    public Collection<ComparisonResultNodeInterface> getChilren() {
        return null;
    }

    @Override
    public ComparisonResultNodeInterface.Result getResult() {
        return null;
    }

    @Override
    public String getId() {
        AttributeComparisonResult attComparison = this.getAttributeComparison("Id");
        String id = null;
        if (attComparison != null) {
            id = attComparison.getSource1Val() != null && !attComparison.getSource1Val().equals(".") ? attComparison.getSource1Val() : attComparison.getSource2Val();
        }
        return id == null ? this.thisMapKey : id;
    }

    @Override
    public ComparisonResultNodeInterface getRoot() {
        return null;
    }

    void changeDependentState(PromotionComparisonNodeInterface.ImportState state) {
    }

    @Override
    public boolean isImportItem() {
        ComparisonTemplateNodeInterface node = null;
        try {
            node = HashedResultNodeHelper.getComparisonTemplateNode(this.getAssociationName());
        }
        catch (ComparisonConfigurationException exception) {
            exception.printStackTrace();
        }
        return node != null ? node.importable() : false;
    }

    @Override
    public void updateState() {
        List<String> assocs = this.getAssociations();
        PromotionComparisonNodeInterface promoNode = null;
        HashMap<String, Integer> importStates = new HashMap<String, Integer>();
        for (String assoc : assocs) {
            List nodes = (List)this.getComparisonResults(assoc);
            for (ComparisonResultNodeInterface node : nodes) {
                PromotionComparisonNodeInterface.ImportState state;
                promoNode = (PromotionComparisonNodeInterface)node;
                if (!promoNode.isImportItem() || (state = promoNode.getImportstate()) == null) continue;
                importStates.put(promoNode.getId(), state.getState());
            }
        }
        if (importStates.size() > 0) {
            ComparisonObjectNode.setImportItemState(importStates, this.thisMapKey);
        }
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (another instanceof ComparisonResultNodeInterface) {
            return this.getId().equals(((ComparisonResultNodeInterface)another).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private int getSequenceNumber() {
        return this.Sequence_no;
    }

    private void setSequenceNumber(int index) {
        this.Sequence_no = index;
    }

    @Override
    public ImportItemInterface getImportItem() {
        return this.importItem;
    }

    private void setImportItem(ImportItemInterface importItem) {
        this.importItem = importItem;
    }

    private ImportItemInterface findChildImportItem(ComparisonResultNodeInterface node) {
        ImportItemInterface parentImportItem = this.getImportItem();
        String id = HashedResultNodeHelper.getComparisonValue(node, "Id", false);
        String name = node.getObjectName();
        if (parentImportItem != null && parentImportItem.containsNestedItems()) {
            List nestedItems = parentImportItem.getNestedItems();
            for (NestedImportItemInterface nestedItem : nestedItems) {
                if (!nestedItem.getName().equals(name)) continue;
                if (!node.getLocation().equals((Object)ComparisonResultNodeInterface.Location.SOURCE1)) {
                    nestedItem.setTargetID(id);
                }
                if (nestedItem.getImportState() == -1) {
                    nestedItem.setImportState(((PromotionComparisonNodeInterface)node).getImportstate().getImportState());
                }
                return nestedItem;
            }
        }
        return null;
    }

    @Override
    public String getAssocDisplayName(String Assoc) {
        String displayName = null;
        try {
            ComparisonTemplateNodeInterface rootNode = HashedResultNodeHelper.getComparisonTemplateNode(Assoc);
            displayName = rootNode.hasDisplayName() ? rootNode.getDisplayName() : Assoc;
        }
        catch (ComparisonConfigurationException e) {
            e.printStackTrace();
        }
        return displayName;
    }

    static enum ComparisonMapLevels {
        MULTIASSOCS,
        ROOT,
        ASSOCIATION,
        STATUS,
        TYPE,
        ATTRIBUTES,
        ATTRIBVALUES;

    }
}

