/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.tablecomparator;

import com.sas.metadata.logical.comparison.ComparisonConfigurationException;
import com.sas.metadata.logical.comparison.ComparisonControllerInterface;
import com.sas.metadata.logical.comparison.ComparisonTemplateFactory;
import com.sas.metadata.logical.comparison.ComparisonTemplateNodeInterface;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.tools.tablecomparator.DefaultController;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComparisonControllerFactory {
    private static Map<String, ComparisonControllerFactory> ownInstaces = new LinkedHashMap<String, ComparisonControllerFactory>(5);
    private static String logicalType;
    private AbstractImportListener listner;
    private static ImportOperationInterface operation;
    private String type;

    private ComparisonControllerFactory(String logicalType) {
        ComparisonControllerFactory.logicalType = logicalType;
        this.type = logicalType;
    }

    public ComparisonTemplateNodeInterface getComparisonTemplate() throws ComparisonConfigurationException {
        ComparisonTemplateFactory templateFactory = ComparisonTemplateFactory.getInstance();
        ComparisonTemplateNodeInterface comparisonTemplate = templateFactory.getTemplateRootNode(logicalType);
        return comparisonTemplate;
    }

    public static String getLogicalType() {
        return logicalType;
    }

    public String getDeploymentTemplate() throws ComparisonConfigurationException {
        ComparisonTemplateFactory comparisonTemplateFactory = ComparisonTemplateFactory.getInstance();
        return comparisonTemplateFactory.getDeploymentTemplate(logicalType);
    }

    public String getMetadataExtractionTemplate() throws ComparisonConfigurationException {
        ComparisonTemplateFactory comparisonTemplateFactory = ComparisonTemplateFactory.getInstance();
        return comparisonTemplateFactory.getMetadataExtractionTemplate(logicalType);
    }

    public static ComparisonControllerFactory getInstance(String logicalType) {
        ComparisonControllerFactory factory = null;
        if (ownInstaces.containsKey(logicalType)) {
            factory = ownInstaces.get(logicalType);
            ComparisonControllerFactory.logicalType = logicalType;
        } else {
            factory = new ComparisonControllerFactory(logicalType);
            ComparisonControllerFactory.manageInstances(logicalType, factory);
        }
        return factory;
    }

    private static void manageInstances(String logicalType, ComparisonControllerFactory factory) {
        if (ownInstaces.size() < 5) {
            ownInstaces.put(logicalType, factory);
        }
    }

    public AbstractImportListener getImportListener() {
        return this.listner;
    }

    public ImportOperationInterface getImportOperation() {
        return operation;
    }

    public ComparisonControllerInterface getComparisonController(AbstractImportListener listner, ImportOperationInterface operation) {
        this.listner = listner;
        ComparisonControllerFactory.operation = operation;
        return new DefaultController(this);
    }

    public String getType() {
        return this.type;
    }

    public static int getPackageVersion() {
        return operation.getPackageFileVersion();
    }
}

