/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.comparison.ComparisonControllerInterface;
import com.sas.metadata.logical.comparison.visual.ComparisonDialog;
import com.sas.metadata.logical.images.DefaultIconFactory;
import com.sas.metadata.logical.images.IconFactory;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.tools.tablecomparator.ComparisonControllerFactory;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;

@SASScope
public class ViewColumnsAction
extends AbstractAction {
    private AbstractImportListener m_listner = null;
    private ImportOperationInterface m_operation = null;
    private List m_items = null;
    private NotificationListener _notificationListener = null;
    private static final long serialVersionUID = -3217270159666348334L;

    public ViewColumnsAction(NotificationListener notificationListener) {
        super(RB.getStringResource("TableOptionsPanel.btnViewColumns.txt"));
        this._notificationListener = notificationListener;
    }

    public ViewColumnsAction(String title) {
        super(title);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_listner != null && this.m_operation != null && this.m_items != null && !this.m_items.isEmpty()) {
                SimpleLogicalObjectInterface slo = (SimpleLogicalObjectInterface)this.m_items.get(0);
                String type = slo.getTypeInterface().getMetadataType();
                ComparisonControllerFactory ccFactory = ComparisonControllerFactory.getInstance(type.toLowerCase());
                ComparisonControllerInterface controller = ccFactory.getComparisonController(this.m_listner, this.m_operation);
                DefaultIconFactory iconFactory = DefaultIconFactory.getInstance();
                ComparisonDialog dialog = new ComparisonDialog((Frame)Workspace.getWorkspace(), controller, this.m_items, (IconFactory)iconFactory);
                dialog.loadUIData();
                if (dialog.isLoadUIDataFail()) {
                    if (dialog.isVisible()) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                } else {
                    dialog.show();
                    if (this._notificationListener != null) {
                        NotificationEvent event = new NotificationEvent((Object)dialog, (PromotionInterface)this.m_operation, 290);
                        this._notificationListener.notify(event);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void setUnmatchedColumnsMapping(Map newMapping) {
    }

    public void setListenerAndHandler(AbstractImportListener listener, ImportOperationInterface operation, List objects) {
        this.m_listner = listener;
        this.m_operation = operation;
        this.m_items = objects;
    }
}

