/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.editor.LogListHolder;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.comparison.ComparisonTemplateFactory;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.server.FilePathSubstitutionType;
import com.sas.metadata.logical.table.ColumnMergeManager;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.logical.table.TableImportItem;
import com.sas.metadata.logical.table.TableNameValidator;
import com.sas.metadata.logical.table.TableOptionsPanel;
import com.sas.metadata.logical.table.TableUtil;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.UniqueKey;
import com.sas.metadata.tools.tablecomparator.NestedItemMergeManager;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ColumnHierarchyInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

@SASScope
public class TableImportListener
extends AbstractImportListener
implements PromotionOptionsInterface,
NotificationListener {
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{FilePathSubstitutionType.class};
    private static final String FILE_SERVICE_FILE_REF = "CMPRTREF";
    private String m_sTransportPathName;
    private TableOptionsPanel m_pnlOptions;
    private ColumnMergeManager m_manager = null;
    private String PROPERTY_EXCLUDE_SOURCE_ONLY_COLUMNS = "sas.promotion.columns.excludenewcolumns";
    private String PROPERTY_EXCLUDE_TARGET_ONLY_COLUMNS = "sas.promotion.columns.deletetargetcolumns";
    protected static final Class[] CONNECTION_TYPES = PrivateObjectImportUtility.appendPromptConnectionTypes((Class[])new Class[]{LibraryConnectionType.class});

    public TableImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int checkForContent(ImportOperationInterface operation, List objects, Properties importOperationProperties) throws RemoteException {
        int returnValue = 0;
        boolean bVVNSubmitted = false;
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        WsAppServer currentAppServer = null;
        IFileService fileService = null;
        boolean bMetadataChanges = false;
        for (TableImportItem tableImportItem : objects) {
            String oldSASTableName;
            MdObjectStore mdStore;
            boolean bTableIsScd;
            boolean bTableNameChanged;
            WsAppServer cImportAppServer;
            PhysicalTable table;
            HashMap exportProperties;
            block31: {
                if (operation.getLogger().isInfoEnabled()) {
                    String tableProcessing = UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ProcessingTable.txt"), (Object[])new Object[]{tableImportItem.getName()});
                    operation.getLogger().info((Object)tableProcessing);
                }
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ContentStatusIndicator.fmt.txt"), (Object)tableImportItem.getName()));
                exportProperties = new HashMap();
                table = null;
                cImportAppServer = null;
                bTableNameChanged = false;
                bTableIsScd = false;
                mdStore = operation.getMetadataFactory().createObjectStore(null, "TableImportListener:checkForContent");
                try {
                    String sSourceFqid = tableImportItem.getID();
                    String sTargetFqid = tableImportItem.getTargetID();
                    table = TableUtil.getTableMetadataObject(mdStore, "PhysicalTable", sTargetFqid, "<Templates><PhysicalTable><TablePackage><SASLibrary/><DatabaseSchema/></TablePackage></PhysicalTable></Templates>");
                    if (table == null) {
                        returnValue = 8;
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)sTargetFqid));
                        continue;
                    }
                    if (!this.includeOptionalContentForItem(operation, tableImportItem)) {
                        if (!bMetadataChanges) continue;
                        table.updateMetadataAll();
                        continue;
                    }
                    bTableIsScd = this.scdCheck(operation, tableImportItem);
                    Map mapContentStreams = contentHandler.getBinaryContent(sSourceFqid);
                    if (mapContentStreams.isEmpty()) {
                        returnValue = 8;
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.NoInStreamError.txt"), (Object)table.getName()));
                        continue;
                    }
                    InputStream inStream = (InputStream)mapContentStreams.get(sSourceFqid);
                    if (inStream != null) {
                        if (currentAppServer == null && (currentAppServer = WsAppServer.createDefaultAppServer((!operation.isBatchProcess() ? 1 : 0) != 0)) == null) {
                            operation.getLogger().error((Object)RB.getStringResource("TableImportListener.DefaultAppServerError.txt"));
                            int n = 8;
                            return n;
                        }
                        returnValue = TableUtil.assignLibraryAndServer((PromotionInterface)operation, currentAppServer, table, exportProperties);
                        if (returnValue == 8) {
                            String serverName = "";
                            if (currentAppServer != null) {
                                serverName = currentAppServer.getName();
                            }
                            operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.UnableToAssignLibAndServerWarning.fmt.txt"), (Object)table, (Object)serverName));
                            continue;
                        }
                        cImportAppServer = (WsAppServer)exportProperties.get(TableUtil.PORT_APP_SERVER);
                        if (cImportAppServer != null && (returnValue = this.extractTransportFileFromStream(operation, inStream, contentHandler, fileService = cImportAppServer.getWorkspace().FileService())) == 8) {
                            operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.UnableToAssignLibAndServerWarning.fmt.txt"), (Object)table, (Object)currentAppServer.getName()));
                            continue;
                        }
                    } else {
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.NoInStreamError.txt"), (Object)table.getName()));
                        returnValue = 8;
                        continue;
                    }
                    oldSASTableName = importOperationProperties.getProperty("OLD_SAS_TABLENAME");
                    if (oldSASTableName != null) break block31;
                }
                catch (Exception ex) {
                    String error = null;
                    error = table != null ? ex.getLocalizedMessage() + " " + table.getName() : ex.getLocalizedMessage();
                    operation.getLogger().error((Object)error);
                    returnValue = 8;
                    continue;
                }
                oldSASTableName = table.getSASTableName();
            }
            boolean bLibHasNoAppServer = false;
            String libNoAppServer = importOperationProperties.getProperty("LibHasNoAppServer");
            if (libNoAppServer != null && Boolean.TRUE.toString().equals(libNoAppServer)) {
                bLibHasNoAppServer = true;
            }
            SASLibrary tempLibrary = (SASLibrary)exportProperties.get("SourceLibrary");
            cImportAppServer = (WsAppServer)exportProperties.get(TableUtil.PORT_APP_SERVER);
            int localRC = this.submitProcCimport(operation, cImportAppServer, fileService, tableImportItem, table, oldSASTableName, tempLibrary, bTableNameChanged, bTableIsScd, bLibHasNoAppServer, bVVNSubmitted);
            returnValue |= localRC;
            if (localRC == 8 || cImportAppServer == null) continue;
            String strLibRef = "";
            if (tempLibrary != null) {
                tempLibrary.getLibref();
            }
            try {
                if (tempLibrary != null && tempLibrary.getIsPreassigned() == 0 && cImportAppServer.isLibrefAssigned(strLibRef)) {
                    cImportAppServer.clearLibref(strLibRef);
                }
            }
            catch (Exception ex) {
                operation.getLogger().warn((Object)ex.getLocalizedMessage());
                String tableRefString = TableUtil.generateTableReferenceName(table, strLibRef);
                operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.LibrefDeassignError.txt"), (Object)tableRefString));
                returnValue = 4;
            }
            if (cImportAppServer.equals(currentAppServer)) continue;
            cImportAppServer.dispose();
            bVVNSubmitted = false;
            continue;
            finally {
                if (mdStore == null || mdStore.isDisposed()) continue;
                mdStore.dispose();
            }
        }
        if (bMetadataChanges) {
            importOperationProperties.setProperty("METADATA_CHANGES", Boolean.TRUE.toString());
        }
        if (fileService != null) {
            fileService._release();
            fileService = null;
        }
        if (currentAppServer == null) return returnValue;
        currentAppServer.dispose();
        return returnValue;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new TableImportItem(name, id, type);
    }

    private int extractTransportFileFromStream(ImportOperationInterface operation, InputStream inStream, ContentHandlerInterface contentHandler, IFileService fileService) {
        int returnValue = 0;
        try {
            IFileref fileRef = fileService.AssignFileref(FILE_SERVICE_FILE_REF, "TEMP", "", "", new StringHolder());
            IBinaryStream outStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
            contentHandler.writeToBinaryStream(inStream, outStream);
        }
        catch (Exception e) {
            returnValue = 8;
            operation.getLogger().error((Object)e.getLocalizedMessage());
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ExtractXportFileError.txt"), (Object)""));
        }
        return returnValue;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface handler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface handler) {
        Boolean listenerExists;
        if (this.m_pnlOptions == null) {
            this.m_pnlOptions = new TableOptionsPanel(false);
        }
        if ((listenerExists = (Boolean)handler.getObjectFromCache((Object)"Table.ImportListener.OptionsNotificationListener")) == null || !listenerExists.booleanValue()) {
            handler.addNotificationListener((NotificationListener)this.m_pnlOptions);
            handler.addObjectToCache((Object)"Table.ImportListener.OptionsNotificationListener", (Object)Boolean.TRUE);
        }
        this.m_pnlOptions.populateImportOptions(aItems, handler);
        return this.m_pnlOptions;
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        return 0;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        int returnValue = 0;
        Properties importOperationProperties = new Properties();
        if (operation.getPromotionType() != 2) {
            returnValue |= this.checkForContent(operation, objects, importOperationProperties);
        }
        return returnValue;
    }

    public void saveSettings() {
        this.m_pnlOptions.saveSettings();
    }

    private boolean scdCheck(ImportOperationInterface operation, TableImportItem tableImportItem) {
        String sIncludeContent = operation.getPropertiesFile().getProperty(tableImportItem.getID() + "###SCDXTABLE###");
        return "true".equals(sIncludeContent);
    }

    private int submitProcCimport(ImportOperationInterface operation, WsAppServer appServer, IFileService fileService, TableImportItem tableImportItem, PhysicalTable table, String oldSASTableName, SASLibrary tempLibrary, boolean bTableNameChanged, boolean bTableIsScd, boolean bLibHasNoAppServer, boolean bVVNSubmitted) throws RemoteException {
        int returnValue = 0;
        String strLibRef = tempLibrary.getLibref();
        if (appServer == null) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, tempLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)RB.getStringResource("TableImportListener.UnableToCreateAppServer.txt"));
            returnValue = 8;
            return returnValue;
        }
        LogListHolder appLog = null;
        try {
            String infoTableItemName = tableImportItem.getTypeInterface().getPublicType() + " \"" + tableImportItem.toString() + "\" (" + tableImportItem.getTargetID() + ")";
            operation.getLogger().info((Object)infoTableItemName);
            String infoTableRefName = TableUtil.generateTableReferenceName(table, strLibRef);
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ImportContentInfo.txt"), (Object)infoTableRefName));
            StringBuffer sbTemp = new StringBuffer();
            if (!bVVNSubmitted) {
                sbTemp.append("options validvarname = any validmemname = extend;");
                bVVNSubmitted = true;
            }
            if (!bTableIsScd) {
                String sNlitsName = TableUtil.genNameLiterals(table.getSASTableName());
                sbTemp.append("PROC CIMPORT DATA=").append(strLibRef).append(".").append(sNlitsName).append(" INFILE=CMPRTREF; run;");
            } else if (!bTableNameChanged) {
                sbTemp.append("PROC CIMPORT LIB=").append(strLibRef).append(" INFILE=CMPRTREF; run;");
            } else {
                String sNlitsOldName;
                String sNlitsName;
                if (tempLibrary.getEngine().equalsIgnoreCase("BASE")) {
                    sNlitsName = table.getSASTableName();
                    sNlitsOldName = oldSASTableName;
                } else {
                    sNlitsName = TableUtil.genNameLiterals(table.getSASTableName());
                    sNlitsOldName = TableUtil.genNameLiterals(oldSASTableName);
                }
                sbTemp.append("PROC CIMPORT LIB=WORK INFILE=CMPRTREF; SELECT ").append(sNlitsOldName).append("; ");
                sbTemp.append("DATA ").append(strLibRef).append(".").append(sNlitsName).append("; SET WORK.").append(sNlitsOldName).append("; ").append("PROC DATASETS LIB=WORK; DELETE ").append(sNlitsOldName).append("; ");
                sbTemp.append("PROC CIMPORT LIB=").append(strLibRef).append(" INFILE=CMPRTREF; EXCLUDE ").append(sNlitsOldName).append("; run;");
            }
            StringBuffer sbLetStatement = new ParametersModel((Root)table).getParameterMacroCode();
            if (sbLetStatement != null) {
                sbTemp.insert(0, sbLetStatement.toString());
            }
            operation.getLogger().debug((Object)("Submitting code to sas for CIMPORT: " + sbTemp.toString()));
            appServer.submitSASCode(sbTemp.toString());
            appLog = appServer.getLog();
            operation.getLogger().debug((Object)("Log from CIMPORT Execution: \n" + TableUtil.getBufferFromAppLog(appLog)));
            returnValue |= TableUtil.displayErrorsFromSAS((PromotionInterface)operation, appLog);
            returnValue |= TableUtil.displayWarningsFromSAS((PromotionInterface)operation, appLog);
            fileService.DeassignFileref(FILE_SERVICE_FILE_REF);
        }
        catch (MdException ex) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, tempLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            returnValue = 8;
        }
        catch (WsAppServerFailException ex) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, tempLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            String infoTableRefName = TableUtil.generateTableReferenceName(table, strLibRef);
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ExeCimportError.txt"), (Object)infoTableRefName));
            returnValue = 8;
        }
        catch (WsAppServerCodeException acx) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, tempLibrary, bLibHasNoAppServer);
            if (appLog == null) {
                try {
                    appLog = appServer.getLog();
                    if (appLog != null) {
                        operation.getLogger().debug((Object)("Log from CIMPORT Execution: \n" + TableUtil.getBufferFromAppLog(appLog)));
                    }
                }
                catch (WsAppServerFailException e) {
                    operation.getLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            returnValue |= TableUtil.handleSASException((PromotionInterface)operation, (Exception)((Object)acx), appLog);
        }
        catch (GenericError ex) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, tempLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            String infoTableRefName = TableUtil.generateTableReferenceName(table, strLibRef);
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ExeCimportError.txt"), (Object)infoTableRefName));
            returnValue = 8;
        }
        return returnValue;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int returnValue = 0;
        Properties importOperationProperties = new Properties();
        try {
            returnValue |= this.updateAttributes(operation, objects, importOperationProperties);
            if (operation.getPromotionType() != 2) {
                NestedItemMergeManager _mergeManager = NestedItemMergeManager.getInstance(objects);
                _mergeManager.logUserChanges();
                returnValue |= this.updateTablePackages(operation, objects, importOperationProperties);
                if (operation.getPackageFileVersion() >= 9200) {
                    returnValue |= this.cleanUpKeys(operation, objects, importOperationProperties);
                }
                returnValue |= this.updatePrompts(operation, objects, importOperationProperties);
                returnValue |= this.cleanUpColumnHierarchies(operation, objects);
                if (operation.getPackageFileVersion() < 9200) {
                    returnValue |= this.m_manager.updateTableForPreviousVersionOverwrite(objects);
                }
            }
            boolean bMetadataChanges = false;
            String strMetaChanges = importOperationProperties.getProperty("METADATA_CHANGES");
            if (strMetaChanges != null && strMetaChanges.equals(Boolean.TRUE.toString())) {
                bMetadataChanges = true;
            }
            if (bMetadataChanges) {
                operation.getStore().updatedMetadataAll();
            }
            return returnValue;
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        catch (MdException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    private int cleanUpColumnHierarchies(ImportOperationInterface operation, List objects) throws ServiceException, RemoteException {
        ServerInterface server = operation.getServer();
        Filter filter = new Filter();
        filter.setType("PhysicalTable");
        filter.setOMRTemplate("<Templates><PhysicalTable><ColumnHierarchies/></PhysicalTable></Templates>");
        int returnValue = 0;
        this.fireDisplayMessage("");
        for (TableImportItem tableImportItem : objects) {
            try {
                PhysicalTableInterface table;
                List hierarchies;
                filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Id='" + tableImportItem.getTargetID() + "']\"/>");
                List tables = server.search((FilterInterface)filter);
                if (tables == null || tables.isEmpty() || (hierarchies = (table = (PhysicalTableInterface)tables.get(0)).getColumnHierarchies()) == null || hierarchies.isEmpty()) continue;
                HashSet<ColumnHierarchyInterface> hierarchiesToDelete = null;
                for (ColumnHierarchyInterface hierarchy : hierarchies) {
                    if (hierarchy.containsColumns()) continue;
                    if (hierarchiesToDelete == null) {
                        hierarchiesToDelete = new HashSet<ColumnHierarchyInterface>();
                    }
                    hierarchiesToDelete.add(hierarchy);
                }
                if (hierarchiesToDelete == null) continue;
                operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.RemovingHierarchies.fmt.txt"), (Object)table.getName()));
                for (ColumnHierarchyInterface hierarchy : hierarchiesToDelete) {
                    hierarchy.delete();
                }
                table.update();
            }
            catch (ServiceException e) {
                String type = tableImportItem.getTypeInterface().getDisplayType();
                String name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ErrorRemovingHierarchies.fmt.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateAttributes(ImportOperationInterface operation, List objects, Properties importOperationProperties) throws RemoteException {
        int returnValue = 0;
        boolean bMetadataChanges = false;
        for (TableImportItem tableImportItem : objects) {
            String name;
            String type;
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AttributeStatusIndicator.fmt.txt"), (Object)tableImportItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AttributeInfo.fmt.txt"), (Object)tableImportItem.getName()));
            String sTargetFqid = tableImportItem.getTargetID();
            PhysicalTable table = null;
            MdObjectStore mdStore = null;
            try {
                mdStore = operation.getMetadataFactory().createObjectStore(null, "TableImportListener:updateAttributes");
                table = TableUtil.getTableMetadataObject(mdStore, "PhysicalTable", sTargetFqid, "<Templates><PhysicalTable><Columns/><Documents/><Notes/><ResponsibleParties/><PropertySets/><TablePackage/></PhysicalTable><Column><Documents/><Notes/></Column><PropertySet><Properties/></PropertySet><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></Templates>");
                if (table == null) {
                    returnValue = 8;
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)sTargetFqid));
                    continue;
                }
                PromotionUtil.updateProductInfo((Root)table, (ImportOperationInterface)operation);
                bMetadataChanges = true;
                TableUtil.setPublicTypeAndVersion(table);
                String oldSASTableName = table.getSASTableName();
                String newSASTableName = this.updateTableName(operation, tableImportItem, table, oldSASTableName);
                if (newSASTableName != null && !oldSASTableName.equals(newSASTableName)) {
                    if (operation.getLogger().isInfoEnabled()) {
                        String tableProcessing = UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ChangedPhysicalTableName.txt"), (Object[])new Object[]{oldSASTableName, newSASTableName});
                        operation.getLogger().info((Object)tableProcessing);
                    }
                    importOperationProperties.setProperty("OLD_SAS_TABLENAME", oldSASTableName);
                }
                table.updateMetadataAll();
            }
            catch (RemoteException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorFixingPrompts.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            catch (MdException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorFixingPrompts.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            finally {
                if (mdStore == null || mdStore.isDisposed()) continue;
                mdStore.dispose();
            }
        }
        if (bMetadataChanges) {
            importOperationProperties.setProperty("METADATA_CHANGES", Boolean.TRUE.toString());
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updatePrompts(ImportOperationInterface operation, List objects, Properties importOperationProperties) throws RemoteException {
        int returnValue = 0;
        boolean bMetadataChanges = false;
        for (TableImportItem tableImportItem : objects) {
            String name;
            String type;
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.PromptsIndicator.fmt.txt"), (Object)tableImportItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.PromptsInfo.fmt.txt"), (Object)tableImportItem.getName()));
            String sTargetFqid = tableImportItem.getTargetID();
            PhysicalTable table = null;
            MdObjectStore mdStore = null;
            try {
                mdStore = operation.getMetadataFactory().createObjectStore(null, "TableImportListener:updatePrompts");
                table = TableUtil.getTableMetadataObject(mdStore, "PhysicalTable", sTargetFqid, "<Templates><PhysicalTable><PropertySets/><Prompts/></PhysicalTable></Templates>");
                if (table == null) {
                    returnValue = 8;
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)sTargetFqid));
                    continue;
                }
                bMetadataChanges = PrivateObjectImportUtility.updatePromptsForImportChanges((ImportOperationInterface)operation, (Root)table);
                mdStore.updatedMetadataAll();
            }
            catch (RemoteException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorFixingPrompts.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            catch (MdException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorFixingPrompts.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            catch (ServiceException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorFixingPrompts.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            finally {
                if (mdStore == null || mdStore.isDisposed()) continue;
                mdStore.dispose();
            }
        }
        if (bMetadataChanges) {
            importOperationProperties.setProperty("METADATA_CHANGES", Boolean.TRUE.toString());
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanUpKeys(ImportOperationInterface operation, List objects, Properties importOperationProperties) throws RemoteException {
        int returnValue = 0;
        boolean bMetadataChanges = false;
        for (TableImportItem tableImportItem : objects) {
            String name;
            String type;
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.KeysStatusIndicator.fmt.txt"), (Object)tableImportItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.KeysInfo.fmt.txt"), (Object)tableImportItem.getName()));
            String sTargetFqid = tableImportItem.getTargetID();
            PhysicalTable table = null;
            MdObjectStore mdStore = null;
            try {
                mdStore = operation.getMetadataFactory().createObjectStore(null, "TableImportListener:cleanUpKeys");
                table = TableUtil.getTableMetadataObject(mdStore, tableImportItem.getTypeInterface().getMetadataType(), sTargetFqid, "<Templates><PhysicalTable><ForeignKeys/></PhysicalTable><ForeignKey><PartnerUniqueKey/></ForeignKey></Templates>");
                if (table == null) {
                    returnValue = 8;
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)sTargetFqid));
                    continue;
                }
                ArrayList<ForeignKey> keysToRemove = new ArrayList<ForeignKey>();
                AssociationList foreignKeys = table.getForeignKeys();
                ArrayList<ForeignKey> usedKeys = new ArrayList<ForeignKey>();
                for (ForeignKey fkey : foreignKeys) {
                    UniqueKey ukey = fkey.getPartnerUniqueKey();
                    if (ukey == null) {
                        keysToRemove.add(fkey);
                        continue;
                    }
                    AssociationList keyedCols = fkey.getKeyedColumns();
                    if (keyedCols != null && keyedCols.size() > 0) {
                        ArrayList<Column> unmatchedColumns = new ArrayList<Column>();
                        for (Column col : keyedCols) {
                            AssociationList fkassocs = col.getForeignKeyAssociations();
                            if (fkassocs.size() != 0) continue;
                            unmatchedColumns.add(col);
                        }
                        for (Column col : unmatchedColumns) {
                            Column uKeyedCol;
                            AssociationList keyedColumns = ukey.getKeyedColumns();
                            boolean match = false;
                            Column matchedCol = null;
                            Iterator ukeyedColIter = keyedColumns.iterator();
                            while (ukeyedColIter.hasNext() && !match) {
                                uKeyedCol = (Column)ukeyedColIter.next();
                                if (!uKeyedCol.getSASColumnName().equals(col.getSASColumnName())) continue;
                                matchedCol = uKeyedCol;
                                match = true;
                            }
                            if (!match) {
                                int fkIndex = keyedCols.indexOf(col);
                                if (keyedColumns.size() > fkIndex) {
                                    uKeyedCol = (Column)keyedColumns.get(fkIndex);
                                    match = true;
                                    matchedCol = uKeyedCol;
                                }
                            }
                            if (match && matchedCol != null) {
                                KeyAssociation ka = (KeyAssociation)col.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)col.getObjectStore(), fkey.getName(), "KeyAssociation", col.getRepositoryID());
                                ka.setForeignKeyColumn(col);
                                ka.setOwningForeignKey(fkey);
                                usedKeys.add(fkey);
                                ka.setUniqueKeyColumn(matchedCol);
                                operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.KeyAssociationCreated.txt"), (Object)col, (Object)matchedCol));
                                returnValue |= 4;
                            }
                            if (match) continue;
                            keysToRemove.add(fkey);
                            operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.MatchingKeysNotFound.txt"), (Object)fkey, (Object)col));
                        }
                        continue;
                    }
                    keysToRemove.add(fkey);
                }
                table.updateMetadataAll();
                for (ForeignKey fk : keysToRemove) {
                    if (usedKeys.contains(fk)) continue;
                    operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.RemovingForeignKey.txt"), (Object)fk.getName()));
                    foreignKeys.remove(fk);
                    if (!bMetadataChanges) {
                        bMetadataChanges = true;
                    }
                    fk.delete();
                }
                table.updateMetadataAll();
                AssociationList indexes = table.getIndexes();
                ArrayList<Index> toDeleteIndexes = new ArrayList<Index>();
                for (Index index : indexes) {
                    AssociationList indexCols = index.getColumns();
                    if (indexCols.size() != 0) continue;
                    toDeleteIndexes.add(index);
                }
                for (Index index : toDeleteIndexes) {
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportExportListener.IndexRemovalWarning.fmt.txt"), (Object)index.getName(), (Object)tableImportItem.getName()));
                    index.delete();
                    returnValue |= 4;
                }
                table.updateMetadataAll();
                AssociationList UniqueKeys = table.getUniqueKeys();
                ArrayList<UniqueKey> toDeletekeys = new ArrayList<UniqueKey>();
                for (UniqueKey key : UniqueKeys) {
                    AssociationList keyedCols = key.getKeyedColumns();
                    if (keyedCols.size() != 0) continue;
                    toDeletekeys.add(key);
                }
                for (UniqueKey key : toDeletekeys) {
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportExportListener.uniquekeyRemovalWarning.fmt.txt"), (Object)key.getName(), (Object)tableImportItem.getName()));
                    key.delete();
                    returnValue |= 4;
                }
                table.updateMetadataAll();
            }
            catch (RemoteException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorRemovingKeys.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            catch (MdException e) {
                type = tableImportItem.getTypeInterface().getDisplayType();
                name = tableImportItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.errorRemovingKeys.txt"), (Object)type, (Object)name), (Throwable)e);
                returnValue |= 8;
            }
            finally {
                if (mdStore == null || mdStore.isDisposed()) continue;
                mdStore.dispose();
            }
        }
        if (bMetadataChanges) {
            importOperationProperties.setProperty("METADATA_CHANGES", Boolean.TRUE.toString());
        }
        return returnValue;
    }

    private String updateTableName(ImportOperationInterface operation, TableImportItem tableImportItem, PhysicalTable table, String previousSASTableName) throws RemoteException {
        String returnValue = null;
        String sNewSASTableName = null;
        sNewSASTableName = operation.getPromotionType() == 1 ? tableImportItem.getSASTableName() : operation.getPropertiesFile().getProperty(tableImportItem.getID() + "SASTableName");
        if (sNewSASTableName == null || sNewSASTableName.length() < 1) {
            returnValue = null;
        } else {
            previousSASTableName = table.getSASTableName();
            if (!sNewSASTableName.equals(previousSASTableName)) {
                table.setSASTableName(sNewSASTableName);
                table.setTableName(sNewSASTableName);
                returnValue = sNewSASTableName;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateTablePackages(ImportOperationInterface operation, List objects, Properties importOperationProperties) throws RemoteException {
        int returnValue = 0;
        for (TableImportItem tableImportItem : objects) {
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TablePackageStatusIndicator.fmt.txt"), (Object)tableImportItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TablePackageInfo.fmt.txt"), (Object)tableImportItem.getName()));
            List tableConnectionPoints = tableImportItem.getConnectionPoints();
            for (ConnectionPointInterface cpoint : tableConnectionPoints) {
                String typeValue = cpoint.getUserDefinedProperty("TargetType");
                if (typeValue == null) continue;
                MdObjectStore mdStore = null;
                try {
                    RelationalSchema rsTarget;
                    RelationalSchema targetPackage;
                    mdStore = operation.getMetadataFactory().createObjectStore(null, "TableImportListener:cleanUpKeys");
                    PhysicalTable tableToImport = TableUtil.getTableMetadataObject(mdStore, "PhysicalTable", tableImportItem.getTargetID(), "<Templates><PhysicalTable><TablePackage><SASLibrary/><DatabaseSchema/></TablePackage></PhysicalTable></Templates>");
                    String typeId = cpoint.getUserDefinedProperty("TargetID");
                    int options = 284;
                    String metadataFetchTemplate = null;
                    if ("SASLibrary".equals(typeValue)) {
                        metadataFetchTemplate = "<Templates><SASLibrary><UsingPackages/></SASLibrary><DatabaseSchema/></Templates>";
                    } else if ("DatabaseSchema".equals(typeValue)) {
                        metadataFetchTemplate = "<Templates><DatabaseSchema><Tables/><UsedByPackages/></DatabaseSchema></Templates>";
                    }
                    if ((targetPackage = (rsTarget = (RelationalSchema)tableToImport.getObjectStore().getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, typeValue, typeId, null, null, metadataFetchTemplate, options))) == tableToImport.getTablePackage()) continue;
                    tableToImport.setTablePackage(targetPackage);
                    tableToImport.updateMetadataAll();
                }
                catch (MdException e) {
                    operation.getLogger().error((Object)e.getLocalizedMessage());
                    returnValue |= 8;
                }
                finally {
                    if (mdStore == null || mdStore.isDisposed()) continue;
                    mdStore.dispose();
                }
            }
        }
        return returnValue;
    }

    private boolean includeOptionalContentForItem(ImportOperationInterface operation, TableImportItem tableImportItem) {
        boolean bIncludeContent = false;
        if (operation.getPromotionType() == 1) {
            bIncludeContent = tableImportItem.isContentIncluded();
        } else if (operation.getPromotionType() == 3) {
            String sIncludeContent = operation.getPropertiesFile().getProperty(tableImportItem.getID() + "Content");
            bIncludeContent = "true".equals(sIncludeContent);
        }
        return bIncludeContent;
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new TableNameValidator();
    }

    public int analyzeObjectsToImport(ImportOperationInterface event, List objects) throws MetadataPromotionException {
        List connectionPoints;
        int count;
        int index;
        int iRC = 0;
        boolean deleteSrcCols = Boolean.getBoolean(this.PROPERTY_EXCLUDE_SOURCE_ONLY_COLUMNS);
        boolean deleteTgtCols = Boolean.getBoolean(this.PROPERTY_EXCLUDE_TARGET_ONLY_COLUMNS);
        NestedItemMergeManager _mergeManager = NestedItemMergeManager.getInstance(objects);
        if (event.getPromotionType() != 1) {
            index = 1;
            count = objects.size();
            for (ImportItemInterface importItem : objects) {
                this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
                connectionPoints = importItem.getConnectionPoints();
                for (ConnectionPointInterface connectionPoint : connectionPoints) {
                    if (!connectionPoint.isActive() || !"ForeignKey".equals(connectionPoint.getMetadataType()) || connectionPoint.isDirectConnection()) continue;
                    event.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportExportListener.KeyRemovalWarning.fmt.txt"), (Object)connectionPoint.toString()));
                    ((ConnectionPoint)connectionPoint).setActive(false);
                }
            }
        }
        if (event.getPackageFileVersion() < 9200) {
            iRC |= this.m_manager.analyzeTableForPreviousVersionOverwrite(objects);
            try {
                iRC |= this.m_manager.reportUnmatchedColumnsPreviousVersion(this, event, objects);
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
            catch (MdException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        index = 0;
        count = objects.size();
        for (ImportItemInterface importItem : objects) {
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
            _mergeManager.setImportOptions(deleteSrcCols, deleteTgtCols, importItem);
            if (event.getPackageFileVersion() >= 9200) {
                _mergeManager.mergeColumns(importItem);
                _mergeManager.restoreColumnConnectionPoints(importItem);
            }
            connectionPoints = importItem.getConnectionPoints();
            for (ConnectionPointInterface connPoint : connectionPoints) {
                List libraries;
                Map importedItems;
                List libraries2;
                Map deselectedItems;
                Map deploymentMappings;
                Map tableMapping;
                if (!"DatabaseSchema".equals(connPoint.getMetadataType())) continue;
                String libraryId = LibraryConnectionType.getLibraryId(connPoint);
                if (libraryId == null && (tableMapping = (Map)(deploymentMappings = event.getAssociationsForObject((PromotionItemInterface)importItem, "<Template><PhysicalTable><TablePackage><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></TablePackage></PhysicalTable></Template>")).get(importItem.getID())) != null) {
                    List schemas = (List)tableMapping.get("TablePackage");
                    for (Map schemaDeploymentMap : schemas) {
                        List librariesDeploymentMappings = (List)schemaDeploymentMap.get("UsedByPackages");
                        Iterator iterator2 = librariesDeploymentMappings.iterator();
                        if (!iterator2.hasNext()) continue;
                        Map libraryDeploymentObjectMap = (Map)iterator2.next();
                        libraryId = (String)libraryDeploymentObjectMap.get("Id");
                    }
                }
                if ((deselectedItems = event.getDeselectedItems()) != null && (libraries2 = (List)deselectedItems.get("Library")) != null && libraries2.size() > 0) {
                    Iterator iterator2 = libraries2.iterator();
                    while (iterator2.hasNext() && libraryId != null) {
                        ImportItemInterface libImportItem = (ImportItemInterface)iterator2.next();
                        if (!libImportItem.getID().equals(libraryId)) continue;
                        ((ConnectionPoint)connPoint).setActive(true);
                    }
                }
                if ((importedItems = event.getImportItems()) == null || (libraries = (List)importedItems.get("Library")) == null || libraries.size() <= 0) continue;
                Iterator iterator2 = libraries.iterator();
                while (iterator2.hasNext() && libraryId != null) {
                    ImportItemInterface libImportItem = (ImportItemInterface)iterator2.next();
                    if (!libImportItem.getID().equals(libraryId)) continue;
                    ((ConnectionPoint)connPoint).setActive(false);
                }
            }
        }
        return iRC;
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.m_manager = new ColumnMergeManager(this, operation);
        operation.addNotificationListener((NotificationListener)this);
    }

    public void notify(NotificationEvent event) {
        if (event != null && event.getEventType() == 200) {
            ComparisonTemplateFactory.getInstance().dispose();
        }
    }
}

