/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.UniqueKey;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.search.ObjectNameFilter;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFactory;
import com.sas.services.information.search.SearchFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@SASScope
public class TableExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    boolean m_bContentIncluded;
    String m_sSASTableName;
    Boolean isNoTableContentLibrary = null;
    private static final String XML_ENGINE = "XML";
    private static final String IMLE_ENGINE = "SASIOIME";
    private static final String MAPPATH = "MAPPATH";

    public TableExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObjectInterface> lLogicalObjects = new ArrayList<SimpleLogicalObjectInterface>();
        try {
            if (relationshipType == 0) {
                int iOptions = 268;
                MdObjectStore mdStore = this._exportOperation.getMetadataFactory().createObjectStore(null, "TableExportItem.getRelatedObjects");
                try {
                    PhysicalTable mdTable = (PhysicalTable)this._exportOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "PhysicalTable", this.getID(), null, null, "<Templates><PhysicalTable><Columns/><Documents/><Notes/><ResponsibleParties/><PropertySets/><TablePackage/></PhysicalTable><Column><Documents/><Notes/></Column><PropertySet><Properties/></PropertySet><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></Templates>", iOptions);
                    if (mdTable == null) {
                        throw new LogicalTypeException("Couldn't find corresponding metadata object for table \"" + this.getName() + "\".");
                    }
                    RelationalSchema schema = mdTable.getTablePackage();
                    SASLibrary library = null;
                    if (schema != null) {
                        if (schema instanceof DatabaseSchema) {
                            DatabaseSchema dbmsSchema = (DatabaseSchema)schema;
                            AssociationList usedByPackages = dbmsSchema.getUsedByPackages();
                            if (usedByPackages.size() > 0) {
                                SimpleLogicalObjectInterface logicalschema;
                                DeployedDataPackage usedBy = (DeployedDataPackage)usedByPackages.get(0);
                                if (usedBy instanceof SASLibrary) {
                                    library = (SASLibrary)usedBy;
                                }
                                if ((logicalschema = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)usedBy)) != null) {
                                    lLogicalObjects.add(logicalschema);
                                }
                            }
                        } else {
                            SimpleLogicalObjectInterface logicalschema = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)schema);
                            if (logicalschema != null) {
                                lLogicalObjects.add(logicalschema);
                            }
                        }
                    }
                    lLogicalObjects.addAll(NoteUtil.getDependentNotes((Root)mdTable));
                    lLogicalObjects.addAll(DocumentUtil.getDependentDocuments((Root)mdTable));
                    AssociationList lColumns = mdTable.getColumns();
                    for (Column mdColumn : lColumns) {
                        lLogicalObjects.addAll(NoteUtil.getDependentNotes((Root)mdColumn));
                        lLogicalObjects.addAll(DocumentUtil.getDependentDocuments((Root)mdColumn));
                    }
                    AssociationList fkeys = mdTable.getForeignKeys();
                    for (ForeignKey fk : fkeys) {
                        SimpleLogicalObjectInterface logicalFKTable;
                        DataTable fkTable;
                        UniqueKey uk = fk.getPartnerUniqueKey();
                        if (uk == null || (fkTable = uk.getTable()) == null || (logicalFKTable = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)fkTable)) == null) continue;
                        lLogicalObjects.add(logicalFKTable);
                    }
                    AssociationList ttrans = mdTable.getTargetTransformations();
                    for (AbstractTransformation t : ttrans) {
                        SimpleLogicalObjectInterface logicalInfoMap;
                        if (!(t instanceof Transformation) || (logicalInfoMap = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)t)) == null) continue;
                        lLogicalObjects.add(logicalInfoMap);
                    }
                    List<SimpleLogicalObjectInterface> orphanedMapList = this.getOrphanedMaps(library, mdTable);
                    lLogicalObjects.addAll(orphanedMapList);
                    List promptUsedLogical = PrivateObjectImportUtility.getLogicalObjectsUsedByPrompts((PromotionInterface)this._exportOperation, (Root)mdTable);
                    lLogicalObjects.addAll(promptUsedLogical);
                }
                catch (MdException mde) {
                    throw new LogicalTypeException((Exception)((Object)mde));
                }
                catch (ServiceException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                finally {
                    mdStore.dispose();
                }
            }
            if (relationshipType == 1) {
                int iOptions = 268;
                MdObjectStore mdStore = this._exportOperation.getMetadataFactory().createObjectStore(null, "TableExportItem.getRelatedObjects");
                try {
                    PhysicalTable mdTable = (PhysicalTable)this._exportOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "PhysicalTable", this.getID(), null, null, "<Templates><PhysicalTable><Columns/><Documents/><Notes/><ResponsibleParties/><PropertySets/><TablePackage/></PhysicalTable><Column><Documents/><Notes/></Column><PropertySet><Properties/></PropertySet><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></Templates>", iOptions);
                    if (mdTable == null) {
                        throw new LogicalTypeException("Couldn't find corresponding metadata object for table \"" + this.getName() + "\".");
                    }
                    AssociationList targets = mdTable.getSourceTransformations();
                    for (Root targetUser : targets) {
                        SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)targetUser);
                        if (logicalUser == null) continue;
                        lLogicalObjects.add(logicalUser);
                    }
                    AssociationList ttrans = mdTable.getTargetTransformations();
                    for (AbstractTransformation t : ttrans) {
                        if (!(t instanceof TransformationActivity)) continue;
                        TransformationActivity ta = (TransformationActivity)t;
                        AssociationList jobs = ta.getJobs();
                        for (Job job : jobs) {
                            SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)job);
                            if (logicalUser == null) continue;
                            lLogicalObjects.add(logicalUser);
                        }
                    }
                    AssociationList specSrcTrans = mdTable.getSpecSourceTransformations();
                    for (AbstractTransformation t : specSrcTrans) {
                        if (!(t instanceof Transformation)) continue;
                        Transformation tr = (Transformation)t;
                        AssociationList targetSpecs = tr.getTargetSpecifications();
                        for (Root root : targetSpecs) {
                            PropertySet propSet;
                            Root ownObj;
                            Property prop;
                            Root assocObject;
                            if (!(root instanceof Property) || !((assocObject = (prop = (Property)root).getAssociatedObject()) instanceof PropertySet) || !((ownObj = (propSet = (PropertySet)assocObject).getOwningObject()) instanceof TransformationStep)) continue;
                            TransformationStep step = (TransformationStep)ownObj;
                            this.addDependentJobFromStep(lLogicalObjects, step);
                        }
                    }
                    AssociationList clssMaps = mdTable.getSourceClassifierMaps();
                    for (ClassifierMap classMap : clssMaps) {
                        AssociationList clSteps = classMap.getSteps();
                        for (TransformationStep step : clSteps) {
                            this.addDependentJobFromStep(lLogicalObjects, step);
                        }
                    }
                    AssociationList ukeys = mdTable.getUniqueKeys();
                    for (UniqueKey uk : ukeys) {
                        AssociationList fks = uk.getForeignKeys();
                        for (ForeignKey fk : fks) {
                            SimpleLogicalObjectInterface logicalFKTable;
                            DataTable fkTable = fk.getTable();
                            if (fkTable == null || (logicalFKTable = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)fkTable)) == null) continue;
                            lLogicalObjects.add(logicalFKTable);
                        }
                    }
                }
                catch (MdException mde) {
                    throw new LogicalTypeException((Exception)((Object)mde));
                }
                finally {
                    mdStore.dispose();
                }
            }
            return lLogicalObjects;
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }

    private void addDependentJobFromStep(List lLogicalObjects, TransformationStep step) throws RemoteException, MdException, LogicalTypeException {
        AssociationList activities = step.getActivities();
        for (TransformationActivity ta : activities) {
            AssociationList jobs = ta.getJobs();
            for (Job job : jobs) {
                SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)job);
                if (logicalUser == null) continue;
                lLogicalObjects.add(logicalUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContentExportAllowed() {
        boolean returnValue = true;
        if (this.isNoTableContentLibrary == null) {
            try {
                MdObjectStore mdStore = this._exportOperation.getMetadataFactory().createObjectStore(null, "TableExportItem.isContentExportAllowed");
                try {
                    RelationalSchema schema;
                    int iOptions = 268;
                    PhysicalTable mdTable = (PhysicalTable)this._exportOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "PhysicalTable", this.getID(), null, null, "<Templates><PhysicalTable><Columns/><Documents/><Notes/><ResponsibleParties/><PropertySets/><TablePackage/></PhysicalTable><Column><Documents/><Notes/></Column><PropertySet><Properties/></PropertySet><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></Templates>", iOptions);
                    if (mdTable != null && (schema = mdTable.getTablePackage()) != null) {
                        SASLibrary library;
                        if (schema instanceof DatabaseSchema) {
                            SASLibrary library2;
                            Root lib;
                            DatabaseSchema dbmsSchema = (DatabaseSchema)schema;
                            AssociationList usedByPackages = dbmsSchema.getUsedByPackages();
                            if (usedByPackages.size() > 0 && (lib = (Root)usedByPackages.get(0)) instanceof SASLibrary && (library2 = (SASLibrary)lib) != null && (XML_ENGINE.equals(library2.getEngine()) || IMLE_ENGINE.equals(library2.getEngine()))) {
                                this.isNoTableContentLibrary = Boolean.TRUE;
                            }
                        } else if (schema instanceof SASLibrary && (library = (SASLibrary)schema) != null && (XML_ENGINE.equals(library.getEngine()) || IMLE_ENGINE.equals(library.getEngine()))) {
                            this.isNoTableContentLibrary = Boolean.TRUE;
                        }
                    }
                }
                catch (MdException mdException) {
                }
                finally {
                    mdStore.dispose();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.isNoTableContentLibrary != null && Boolean.TRUE == this.isNoTableContentLibrary) {
            returnValue = false;
            this.m_bContentIncluded = false;
        }
        return returnValue;
    }

    private List<SimpleLogicalObjectInterface> getOrphanedMaps(SASLibrary library, PhysicalTable mdTable) throws MdException, RemoteException, LogicalTypeException, ServiceException {
        if (library == null || mdTable == null) {
            return Collections.emptyList();
        }
        Property property = null;
        if (IMLE_ENGINE.equals(library.getEngine())) {
            AssociationList propertyList = library.getProperties();
            for (Property p : propertyList) {
                if (!MAPPATH.equals(p.getPropertyName())) continue;
                property = p;
                break;
            }
        }
        if (property == null) {
            return Collections.emptyList();
        }
        ServerInterface authServer = this.getExportOperation().getServer();
        String path = property.getDefaultValue().substring(1, property.getDefaultValue().length() - 1);
        PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)authServer, (String)path);
        Search search = SearchFactory.createSearch((ServerInterface)authServer);
        search.addFilter((SearchFilter)new PublicTypeFilter(Arrays.asList("InformationMap")));
        search.addFilter((SearchFilter)new ObjectNameFilter(mdTable.getName(), false));
        search.setFolderScope(pathUrl, false);
        List infoMapList = search.search();
        PublicObjectInterface poi = null;
        for (PublicObjectInterface p : infoMapList) {
            if (!p.getName().equals(mdTable.getName())) continue;
            poi = p;
            break;
        }
        if (poi == null) {
            return Collections.emptyList();
        }
        String publicType = poi.getTypeDescriptor().getTypeName();
        TypeInterface ti = Factory.getInstance().getTypeInterface(publicType);
        SimpleLogicalObject loi = new SimpleLogicalObject(poi.getName(), poi.getIdentifier(), ti);
        return Arrays.asList(loi);
    }
}

