/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.PublicObjectPromotionOptions;
import java.util.List;

public class DefaultMergeImportItem
extends DefaultImportItem
implements PublicObjectPromotionOptions {
    private String PROPERTY_EXCLUDE_SOURCE_ONLY_COLUMNS = "sas.promotion.columns.excludenewcolumns";
    private String PROPERTY_EXCLUDE_TARGET_ONLY_COLUMNS = "sas.promotion.columns.deletetargetcolumns";
    private String PROPERTY_SKIP_UPDATE_ONLY_COLUMNS = "sas.promotion.columns.excludeupdatecolumns";
    private PublicObjectPromotionOptions.SelectionState m_eKeepTargetColumns;
    private PublicObjectPromotionOptions.SelectionState m_eKeepSourceColumns;
    private boolean m_bContentIncluded;
    private String m_sSASTableName;
    private boolean skipupdatecolumn;
    private MergeProperties mergeProps;

    public DefaultMergeImportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        boolean keepSource = !Boolean.getBoolean(this.PROPERTY_EXCLUDE_SOURCE_ONLY_COLUMNS);
        boolean keeptarget = !Boolean.getBoolean(this.PROPERTY_EXCLUDE_TARGET_ONLY_COLUMNS);
        this.skipupdatecolumn = Boolean.getBoolean(this.PROPERTY_SKIP_UPDATE_ONLY_COLUMNS);
        this.m_eKeepSourceColumns = !keepSource ? PublicObjectPromotionOptions.SelectionState.OFF : PublicObjectPromotionOptions.SelectionState.ON;
        this.m_eKeepTargetColumns = !keeptarget ? PublicObjectPromotionOptions.SelectionState.OFF : PublicObjectPromotionOptions.SelectionState.ON;
    }

    public boolean isContentIncluded() {
        return this.m_bContentIncluded;
    }

    public void setContentIncluded(boolean contentIncluded) {
        this.m_bContentIncluded = contentIncluded;
    }

    public String getSASTableName() {
        return this.m_sSASTableName;
    }

    public Boolean getStateOfSkipUpdateOption() {
        return this.skipupdatecolumn;
    }

    public void setSASTableName(String tableName) {
        this.m_sSASTableName = tableName;
    }

    public PublicObjectPromotionOptions.SelectionState getStateOfKeepNewOption() {
        return this.m_eKeepSourceColumns;
    }

    public PublicObjectPromotionOptions.SelectionState getStateOfKeepDeletedOption() {
        return this.m_eKeepTargetColumns;
    }

    public void setStateOfKeepNewOption(PublicObjectPromotionOptions.SelectionState selectionState) {
        this.m_eKeepSourceColumns = selectionState;
    }

    public void setStateOfKeepDeletedOption(PublicObjectPromotionOptions.SelectionState selectionState) {
        this.m_eKeepTargetColumns = selectionState;
    }

    public void setMergeProperties(boolean hasNewColumns, boolean hasDeletedColumns) {
        this.mergeProps = new MergeProperties(hasNewColumns, hasDeletedColumns);
    }

    public boolean isMerged() {
        return this.mergeProps != null && this.mergeProps.isMerged;
    }

    public MergeProperties getMergeProperties() {
        return this.mergeProps;
    }

    private boolean processreinitilization(boolean checkOnly) {
        List nestedItems;
        boolean reinit = true;
        if (this.isMerged() && (nestedItems = this.getNestedItems()) != null) {
            for (NestedImportItemInterface nested : nestedItems) {
                if (checkOnly && nested.getImportState() != 0) {
                    return false;
                }
                if (checkOnly) continue;
                nested.setImportState(-1);
            }
        }
        return true;
    }

    public boolean isReinitilizationRequired() {
        return this.processreinitilization(true);
    }

    public void renitilize() {
        this.processreinitilization(false);
    }

    public class MergeProperties {
        private boolean isMerged = true;
        private boolean hasNewColumns;
        private boolean hasDeletedColumns;

        MergeProperties(boolean hasNewColumns, boolean hasDeletedColumns) {
            this.hasNewColumns = hasNewColumns;
            this.hasDeletedColumns = hasDeletedColumns;
        }

        public boolean isMerged() {
            return this.isMerged;
        }

        public boolean hasNewColumns() {
            return this.hasNewColumns;
        }

        public boolean hasDeletedColumns() {
            return this.hasDeletedColumns;
        }
    }
}

