/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.externalfile.ExternalFileImportItem;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.logical.table.TableImportItem;
import com.sas.metadata.logical.table.TableUtil;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItem;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.PublicObjectPromotionOptions;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SASScope
public class ColumnMergeManager {
    public static final String PROPERTY_CASE_SENSITIVE_MATCH = "sas.promotion.columns.casesensitivemapping";
    ImportOperationInterface m_operation = null;
    AbstractImportListener m_listener = null;
    Map m_columnMappingCache = null;
    Map m_objectColumnRelationshipMapping = null;
    boolean m_ignoreColumnCase = true;

    public ColumnMergeManager(AbstractImportListener importListener, ImportOperationInterface operation) {
        this.m_listener = importListener;
        this.m_operation = operation;
        String caseValue = System.getProperty(PROPERTY_CASE_SENSITIVE_MATCH);
        if (caseValue != null && (caseValue.equalsIgnoreCase("true") || caseValue.equalsIgnoreCase("y"))) {
            this.m_ignoreColumnCase = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int analyzeTableForPreviousVersionOverwrite(List importItems) {
        if (!this.m_ignoreColumnCase) {
            this.m_operation.getLogger().debug((Object)"Applying case sensitive matching during column mapping.");
        }
        int iRC = 0;
        this.m_columnMappingCache = new HashMap();
        this.m_objectColumnRelationshipMapping = new HashMap();
        int index = 1;
        int count = importItems.size();
        for (ImportItemInterface importItem : importItems) {
            this.m_listener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
            MdObjectStore mdStore = null;
            try {
                String targetTableID;
                mdStore = this.m_operation.getMetadataFactory().createObjectStore(null, "ColumnMergeManager:analyzeTargetTables");
                if (importItem.getImportState() != 2 || (targetTableID = importItem.getTargetID()) == null || targetTableID.length() <= 0) continue;
                DataTable targetTable = this.getTargetTable(mdStore, importItem);
                if (targetTable == null) {
                    iRC |= 8;
                    this.m_operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)importItem.getTargetID()));
                    continue;
                }
                AssociationList targetColumns = targetTable.getColumns();
                HashMap<String, String> tableColumnMapping = new HashMap<String, String>();
                this.m_columnMappingCache.put(importItem.getTargetID(), tableColumnMapping);
                for (Column column : targetColumns) {
                    String uniqueId = TableUtil.generateColumnUniqueId(column, this.m_ignoreColumnCase);
                    String metadataId = column.getId();
                    tableColumnMapping.put(uniqueId, metadataId);
                    this.mapObjectRelationshipsToColumns(this.m_objectColumnRelationshipMapping, column);
                }
            }
            catch (MdException e) {
                this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
                iRC |= 8;
            }
            catch (RemoteException e) {
                this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
                iRC |= 8;
            }
            finally {
                try {
                    if (mdStore == null || mdStore.isDisposed()) continue;
                    mdStore.dispose();
                }
                catch (RemoteException e) {
                    this.m_operation.getLogger().debug((Object)e.getLocalizedMessage());
                }
            }
        }
        return iRC;
    }

    private void mapObjectRelationshipsToColumns(Map objectColumnRelationshipMapping, Column column) throws RemoteException, MdException {
        Map assocs = column.getPopulatedAssocs();
        for (String assocName : assocs.keySet()) {
            AssociationList association;
            if (assocName.equals("Table") || (association = (AssociationList)assocs.get(assocName)) == null || association.size() <= 0) continue;
            for (Root otherObject : association) {
                ArrayList oppAssn;
                AssociationList oppositeList = this.getOppositeSideAssn(association, otherObject, true);
                HashMap assnMapping = (HashMap)objectColumnRelationshipMapping.get(otherObject.getId());
                if (assnMapping == null) {
                    assnMapping = new HashMap();
                    objectColumnRelationshipMapping.put(otherObject.getId(), assnMapping);
                }
                if ((oppAssn = (ArrayList)assnMapping.get(oppositeList.getAssociationName())) == null) {
                    oppAssn = new ArrayList();
                    assnMapping.put(oppositeList.getAssociationName(), oppAssn);
                }
                oppAssn.addAll(oppositeList.getObjectIDs());
            }
        }
    }

    private AssociationList getOppositeSideAssn(AssociationList association, Root otherObject, boolean fromServer) throws RemoteException, MdException {
        AssociationList otherList = null;
        boolean isPred = association.getIsPredAssoc();
        String assocationType = association.getAssociationType();
        if (isPred) {
            otherList = otherObject.getMdObjectAssociation(assocationType.substring(assocationType.indexOf(45) + 1, assocationType.length()));
            if (otherList != null && fromServer) {
                otherList = this.getListFromServer(otherObject, otherList);
            }
        } else {
            otherList = otherObject.getMdObjectAssociation(assocationType.substring(0, assocationType.indexOf(45)));
            if (otherList != null && fromServer) {
                otherList = this.getListFromServer(otherObject, otherList);
            }
        }
        return otherList;
    }

    private AssociationList getListFromServer(Root otherObject, AssociationList otherList) {
        boolean bAddS = false;
        if (otherList.getMaxCardinality().equals("1")) {
            bAddS = true;
        }
        String assnName = otherList.getAssociationName();
        if (bAddS) {
            assnName = assnName + "s";
        }
        try {
            Object returnValue;
            Method getAssnMethod = otherObject.getClass().getMethod("get" + assnName, Boolean.TYPE);
            if (getAssnMethod != null && (returnValue = getAssnMethod.invoke((Object)otherObject, Boolean.TRUE)) != null && returnValue instanceof AssociationList) {
                otherList = (AssociationList)returnValue;
            }
        }
        catch (SecurityException e) {
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
        }
        return otherList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTableForPreviousVersionOverwrite(List importItems) {
        int iRC = 0;
        HashMap<String, String> idMappingOldColumnIdToNewColumnId = new HashMap<String, String>();
        MdObjectStore mdStore = null;
        try {
            mdStore = this.m_operation.getMetadataFactory().createObjectStore(null, "ColumnMergeManager:updateColumnAssociations");
            for (ImportItemInterface importItem : importItems) {
                this.m_listener.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ColumnsIndicator.fmt.txt"), (Object)importItem.getName()));
                this.m_operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.ColumnsInfo.fmt.txt"), (Object)importItem.getName()));
                if (importItem.getImportState() != 2) continue;
                DataTable targetTable = this.getTargetTable(mdStore, importItem);
                if (targetTable == null) {
                    iRC |= 8;
                    this.m_operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)importItem.getTargetID()));
                    continue;
                }
                AssociationList columns = targetTable.getColumns();
                Map tableColumnMappings = (Map)this.m_columnMappingCache.get(importItem.getTargetID());
                if (tableColumnMappings == null) continue;
                for (Column column : columns) {
                    String uniqueId = TableUtil.generateColumnUniqueId(column, this.m_ignoreColumnCase);
                    String metadataId = column.getId();
                    String oldMetadataId = (String)tableColumnMappings.get(uniqueId);
                    if (oldMetadataId == null) continue;
                    idMappingOldColumnIdToNewColumnId.put(oldMetadataId, metadataId);
                }
            }
            if (idMappingOldColumnIdToNewColumnId.size() > 0) {
                this.remapObjectRelationshipsToColumns(mdStore, this.m_objectColumnRelationshipMapping, idMappingOldColumnIdToNewColumnId);
            }
        }
        catch (MdException e) {
            this.m_operation.getLogger().debug((Object)"Exception in updateColumnAssociations");
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        catch (RemoteException e) {
            this.m_operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        finally {
            try {
                if (mdStore != null && !mdStore.isDisposed()) {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                this.m_operation.getLogger().debug((Object)e.getLocalizedMessage());
            }
        }
        return iRC;
    }

    private DataTable getTargetTable(MdObjectStore mdStore, ImportItemInterface importItem) throws RemoteException, MdException {
        DataTable returnValue = null;
        if (importItem.getTypeInterface().getMetadataType().equals("PhysicalTable")) {
            returnValue = this.getTableMetadataObject(mdStore, "PhysicalTable", importItem.getTargetID(), "<Templates><PhysicalTable><Columns/></PhysicalTable><Column><Documents/><Notes/><SourceFeatureMaps/><TargetFeatureMaps/><Keys/><QueryClauses/><ReferencedObjects/><SpecSourceTransformations/><SpecTargetTransformations/><Variables/></Column></Templates>");
        } else if (importItem.getTypeInterface().getMetadataType().equals("ExternalTable")) {
            returnValue = this.getTableMetadataObject(mdStore, "ExternalTable", importItem.getTargetID(), "<Templates><ExternalTable><Columns/></ExternalTable><Column><Documents/><Notes/><SourceFeatureMaps/><TargetFeatureMaps/><Keys/><QueryClauses/><ReferencedObjects/><SpecSourceTransformations/><SpecTargetTransformations/><Variables/></Column></Templates>");
        }
        return returnValue;
    }

    private DataTable getTableMetadataObject(MdObjectStore store, String type, String fqid, String template) throws MdException, RemoteException {
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return (DataTable)object;
    }

    private void remapObjectRelationshipsToColumns(MdObjectStore objectStore, Map objectColumnRelationshipMapping, Map idMappingOldColumnIdToNewColumnId) throws RemoteException, MdException {
        HashMap searchObjectCache = new HashMap();
        for (String targetObjectId : objectColumnRelationshipMapping.keySet()) {
            Root targetObject = this.getTargetObjectFromId(objectStore, targetObjectId, false, searchObjectCache);
            if (targetObject == null) continue;
            Map assnMapping = (Map)objectColumnRelationshipMapping.get(targetObjectId);
            for (String assnName : assnMapping.keySet()) {
                List assnObjectIds = (List)assnMapping.get(assnName);
                AssociationList otherList = targetObject.getAssociatedObjects(assnName);
                otherList = this.getListFromServer(targetObject, otherList);
                ArrayList existingList = new ArrayList(otherList);
                otherList.clear();
                for (String assocObjectId : assnObjectIds) {
                    Root associatedObject;
                    String newAssocObjectId = (String)idMappingOldColumnIdToNewColumnId.get(assocObjectId);
                    if (newAssocObjectId == null || (associatedObject = this.getTargetObjectFromId(objectStore, newAssocObjectId, true)) == null) continue;
                    otherList.add((Object)associatedObject);
                }
                for (Root associatedObject : existingList) {
                    if (otherList.contains((Object)associatedObject)) continue;
                    otherList.add((Object)associatedObject);
                }
            }
            targetObject.updateMetadataAll();
        }
    }

    private Root getTargetObjectFromId(MdObjectStore objectStore, String newAssocObjectId, boolean b, Map searchedObjects) throws RemoteException {
        Root returnValue = null;
        if (searchedObjects.containsKey(newAssocObjectId)) {
            returnValue = (Root)searchedObjects.get(newAssocObjectId);
        } else {
            returnValue = this.getTargetObjectFromId(objectStore, newAssocObjectId, b);
            if (returnValue != null) {
                searchedObjects.put(returnValue.getId(), returnValue);
            }
        }
        return returnValue;
    }

    private Root getTargetObjectFromId(MdObjectStore objectStore, String targetAssocObjId, boolean useClientCache) throws RemoteException {
        Root ret = null;
        if (useClientCache) {
            ret = (Root)objectStore.getObject(targetAssocObjId);
        }
        if (ret == null) {
            try {
                List returnObjects = objectStore.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, "A0000001." + targetAssocObjId.substring(0, targetAssocObjId.indexOf(".")), "Root", 412, "<XMLSelect search=\"*[@Id='" + targetAssocObjId + "']\"/>", true);
                if (returnObjects != null && returnObjects.size() == 1) {
                    ret = (Root)returnObjects.get(0);
                }
            }
            catch (MdException mex) {
                this.m_operation.getLogger().error((Object)mex.getLocalizedMessage(), (Throwable)mex);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int analyzeColumnsForOverwrite(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        try {
            ArrayList<ImportItemInterface> objectsToOverwrite = new ArrayList<ImportItemInterface>();
            for (ImportItemInterface importItem : objects) {
                if (importItem.getImportState() != 2) continue;
                objectsToOverwrite.add(importItem);
            }
            if (objectsToOverwrite.isEmpty()) {
                return iRC;
            }
            Map mapExternalFiles = operation.getAssociationsForObjects(objectsToOverwrite, "<Template><PhysicalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></PhysicalTable><RelationalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></RelationalTable></Template>");
            int index = 1;
            int count = objectsToOverwrite.size();
            for (ImportItemInterface importItem : objectsToOverwrite) {
                this.m_listener.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
                Map mapExtFile = (Map)mapExternalFiles.get(importItem.getID());
                List lColumns = (List)mapExtFile.get("Columns");
                HashMap<String, String> columnMetadataIdToUniqueId = new HashMap<String, String>(lColumns.size());
                for (Map columnMap : lColumns) {
                    String importColumnUniqueId = TableUtil.generateColumnUniqueId(columnMap, this.m_ignoreColumnCase);
                    String importColumnId = (String)columnMap.get("Id");
                    columnMetadataIdToUniqueId.put(importColumnUniqueId, importColumnId);
                }
                String targetTableID = importItem.getTargetID();
                if (targetTableID == null || targetTableID.length() <= 0) continue;
                MdObjectStore mdStore = null;
                try {
                    mdStore = operation.getMetadataFactory().createObjectStore(null, "ColumnMergeManager:analyzeColumns");
                    DataTable targetTable = this.getTargetTable(mdStore, importItem);
                    if (targetTable == null) {
                        iRC |= 8;
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.TargetFqidNotFoundError.txt"), (Object)importItem.getTargetID()));
                        continue;
                    }
                    iRC |= this.analyzeNestedImportedColumns(importItem, targetTable, columnMetadataIdToUniqueId);
                    targetTable.updateMetadataAll();
                }
                finally {
                    if (mdStore == null || mdStore.isDisposed()) continue;
                    mdStore.dispose();
                }
            }
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.getLocalizedMessage());
            iRC |= 8;
        }
        catch (MdException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        catch (LogicalTypeException e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            iRC |= 8;
        }
        return iRC;
    }

    private int analyzeNestedImportedColumns(ImportItemInterface importItem, DataTable targetTable, Map columnMetadataIdToUniqueId) throws RemoteException, MdException, LogicalTypeException {
        Column column;
        PublicObjectPromotionOptions.SelectionState selection;
        if (!this.m_ignoreColumnCase) {
            this.m_operation.getLogger().debug((Object)"Applying case sensitive matching during column mapping.");
        }
        String objectType = null;
        try {
            ServerInterface server = this.m_operation.getServer();
            TypeDescriptorInterface type = server.getTypeDescriptor(targetTable.getPublicType());
            if (type != null) {
                objectType = type.getType();
            }
        }
        catch (Exception e) {
            this.m_operation.getLogger().debug((Object)("Unable to retrieve target object type: " + e.getLocalizedMessage()));
        }
        if (objectType == null) {
            objectType = "Table";
        }
        int iRC = 0;
        HashMap<String, Column> idMappings = new HashMap<String, Column>();
        AssociationList columns = targetTable.getColumns();
        for (Column column2 : columns) {
            String uniqueColumnId = TableUtil.generateColumnUniqueId(column2, this.m_ignoreColumnCase);
            String sourceId = (String)columnMetadataIdToUniqueId.get(uniqueColumnId);
            if (sourceId != null && sourceId.length() > 0) {
                idMappings.put(sourceId, column2);
                continue;
            }
            idMappings.put(column2.getId(), column2);
        }
        if (importItem.containsNestedItems()) {
            List nestedColumns = importItem.getNestedItems();
            for (NestedImportItemInterface nestedItem : nestedColumns) {
                Column target = (Column)idMappings.get(nestedItem.getID());
                if (target != null) {
                    nestedItem.setTargetID(target.getId());
                    nestedItem.setImportState(2);
                } else {
                    nestedItem.setImportState(1);
                    this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ColumnMergeManager.ColumnConnectionForTableNotFound.fmt"), (Object)nestedItem.getName(), (Object)targetTable.getName()));
                    iRC |= 4;
                }
                idMappings.remove(nestedItem.getID());
            }
        }
        boolean bMergeColumns = true;
        if (importItem instanceof TableImportItem) {
            selection = ((TableImportItem)importItem).getStateOfKeepDeletedOption();
            bMergeColumns = selection == PublicObjectPromotionOptions.SelectionState.ON || selection == PublicObjectPromotionOptions.SelectionState.MIXED;
        } else if (importItem instanceof ExternalFileImportItem) {
            selection = ((ExternalFileImportItem)importItem).getStateOfKeepDeletedOption();
            boolean bl = bMergeColumns = selection == PublicObjectPromotionOptions.SelectionState.ON || selection == PublicObjectPromotionOptions.SelectionState.MIXED;
        }
        if (!bMergeColumns) {
            for (String sourceId : idMappings.keySet()) {
                column = (Column)idMappings.get(sourceId);
                NestedImportItem nii = new NestedImportItem(column.getName(), column.getId(), (TransportableTypeInterface)Factory.getInstance().getTypeInterface("Column"));
                nii.setImportState(3);
                nii.setTargetID(column.getId());
                importItem.addNestedItem((NestedImportItemInterface)nii);
                this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ColumnMergeManager.ColumnConnectionForTableNotFoundDelete.fmt"), (Object)nii.getName(), (Object)objectType, (Object)targetTable.getName()));
                iRC |= 4;
            }
        } else {
            for (String sourceId : idMappings.keySet()) {
                column = (Column)idMappings.get(sourceId);
                this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ColumnMergeManager.ColumnConnectionForTableNotFoundKept.fmt"), (Object)column.getName(), (Object)objectType, (Object)targetTable.getName()));
                iRC |= 4;
            }
        }
        return iRC;
    }

    public int reportUnmatchedColumnsPreviousVersion(AbstractImportListener listener, ImportOperationInterface operation, List objects) throws MetadataPromotionException, RemoteException, MdException {
        Map<String, String> colUIDToName;
        List<String> lColumnUniqueIds;
        int iRC = 0;
        Map mapExternalFiles = operation.getAssociationsForObjects(objects, "<Template><PhysicalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></PhysicalTable><RelationalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></RelationalTable></Template>");
        HashMap<String, Cloneable> tableColumns = new HashMap<String, Cloneable>();
        for (ImportItemInterface importItem : objects) {
            if (importItem.getImportState() != 2) continue;
            Map mapExtFile = (Map)mapExternalFiles.get(importItem.getID());
            List lColumns = (List)mapExtFile.get("Columns");
            lColumnUniqueIds = new ArrayList();
            colUIDToName = new HashMap();
            tableColumns.put(importItem.getTargetID(), (Cloneable)((Object)lColumnUniqueIds));
            tableColumns.put(importItem.getTargetID() + "SOURCE_COL_NAMEMAP", (Cloneable)((Object)colUIDToName));
            for (Map columnMap : lColumns) {
                String importColumnUniqueId = TableUtil.generateColumnUniqueId(columnMap, this.m_ignoreColumnCase);
                String name = (String)columnMap.get("Name");
                colUIDToName.put(importColumnUniqueId, name);
                lColumnUniqueIds.add(importColumnUniqueId);
            }
        }
        for (ImportItemInterface importItem : objects) {
            DataTable targetTable;
            if (importItem.getImportState() != 2 || (targetTable = this.getTargetTable(operation.getStore(), importItem)) == null) continue;
            AssociationList columns = targetTable.getColumns();
            if (tableColumns.size() <= 0 || (lColumnUniqueIds = (List)tableColumns.get(importItem.getTargetID())) == null) continue;
            for (Column column : columns) {
                String uniqueId = TableUtil.generateColumnUniqueId(column, this.m_ignoreColumnCase);
                boolean bMatch = false;
                String toRemove = null;
                Iterator coluidIter = lColumnUniqueIds.iterator();
                while (coluidIter.hasNext() && !bMatch) {
                    String matchId = (String)coluidIter.next();
                    if (!matchId.equals(uniqueId)) continue;
                    bMatch = true;
                    toRemove = matchId;
                }
                if (!bMatch) {
                    this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ColumnMergeManager.ColumnConnectionForTableNotFoundDelete.fmt"), (Object)column.getName(), (Object)targetTable.getPublicType(), (Object)targetTable.getName()));
                    iRC |= 4;
                    continue;
                }
                if (toRemove == null) continue;
                lColumnUniqueIds.remove(toRemove);
            }
            colUIDToName = (Map)tableColumns.get(importItem.getTargetID() + "SOURCE_COL_NAMEMAP");
            for (String matchId : lColumnUniqueIds) {
                String columnName = (String)colUIDToName.get(matchId);
                this.m_operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ColumnMergeManager.ColumnConnectionForTableNotFound.fmt"), (Object)columnName, (Object)targetTable.getName()));
                iRC |= 4;
            }
        }
        return iRC;
    }

    public Map getTableUnmatchedColumnsMappings(AbstractImportListener listener, ImportOperationInterface operation, List objects) throws MetadataPromotionException, RemoteException, MdException {
        List<String> lColumnUniqueIds;
        HashMap<DataTable, ArrayList<Column>> returnValue = new HashMap<DataTable, ArrayList<Column>>();
        Map mapExternalFiles = operation.getAssociationsForObjects(objects, "<Template><PhysicalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></PhysicalTable><RelationalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></RelationalTable></Template>");
        HashMap tableColumns = new HashMap();
        for (ImportItemInterface importItem : objects) {
            if (importItem.getImportState() != 2) continue;
            Map mapExtFile = (Map)mapExternalFiles.get(importItem.getID());
            List lColumns = (List)mapExtFile.get("Columns");
            lColumnUniqueIds = new ArrayList();
            tableColumns.put(importItem.getTargetID(), lColumnUniqueIds);
            for (Map columnMap : lColumns) {
                String importColumnUniqueId = TableUtil.generateColumnUniqueId(columnMap, this.m_ignoreColumnCase);
                lColumnUniqueIds.add(importColumnUniqueId);
            }
        }
        for (ImportItemInterface importItem : objects) {
            DataTable targetTable;
            if (importItem.getImportState() != 2 || (targetTable = this.getTargetTable(operation.getStore(), importItem)) == null) continue;
            AssociationList columns = targetTable.getColumns();
            if (tableColumns.size() <= 0 || (lColumnUniqueIds = (List)tableColumns.get(importItem.getTargetID())) == null) continue;
            for (Column column : columns) {
                String uniqueId = TableUtil.generateColumnUniqueId(column, this.m_ignoreColumnCase);
                boolean bMatch = false;
                Iterator coluidIter = lColumnUniqueIds.iterator();
                while (coluidIter.hasNext() && !bMatch) {
                    String matchId = (String)coluidIter.next();
                    if (!matchId.equals(uniqueId)) continue;
                    bMatch = true;
                }
                if (bMatch) continue;
                ArrayList<Column> lUnmatchedColumns = (ArrayList<Column>)returnValue.get(targetTable);
                if (lUnmatchedColumns == null) {
                    lUnmatchedColumns = new ArrayList<Column>();
                    returnValue.put(targetTable, lUnmatchedColumns);
                }
                lUnmatchedColumns.add(column);
            }
        }
        return returnValue;
    }
}

