/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerUtil;
import com.sas.metadata.logical.secureddata.SecuredLibraryDataObject;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.secureddata.SecuredLibrary;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;

public class SecuredLibraryReportDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private SecuredLibrary _securedLibrary;
    private Root _root;
    private Config _config;
    private SecuredLibraryDataObject _slDataObject;
    private SecuredLibraryAppServerPanel appServerPanel;
    private String _name = null;
    private String _urlPathString = null;
    private JPanel libraryNameLocationPanel;
    private JLabel _lblLibraryName;
    private WATextField _txtLibraryName;
    private JLabel _lblLibraryLocation;
    private WATextField _txtLibraryLocation;
    private JCheckBox encryptionKey;
    private JPasswordField _txtEncryptKey;

    public SecuredLibraryReportDialog(SecuredLibrary slibrary, Root root, Config config) {
        super((Frame)Workspace.getWorkspace(), RB.getStringResource("SecuredLibraryReportDialog.Title.txt"), true);
        this._securedLibrary = slibrary;
        this._root = root;
        this._config = config;
        this.initializeDialog();
    }

    protected void initializeDialog() {
        String repositoryFQID;
        block4: {
            this.setName(RB.getStringResource("SecuredLibraryReportDialog.Title.txt"));
            this.setHelpProduct("folderview");
            this.setHelpTopic("seclib_reportdialog");
            this.setOKButtonVisible(true);
            this.setCancelButtonVisible(true);
            this.setHelpButtonVisible(true);
            this.setResizable(true);
            this.setPreferredSize(new Dimension(500, 390));
            this._slDataObject = new SecuredLibraryDataObject();
            repositoryFQID = null;
            try {
                repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)this._root);
                this._name = this._root.getName();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            try {
                PathUrl parentPathUrl = this.getParentPathUrl(this._securedLibrary.getPathUrl());
                this._urlPathString = parentPathUrl.getDisplayPath();
            }
            catch (Exception e) {
                if (this._urlPathString != null) break block4;
                this._urlPathString = " ";
            }
        }
        this.appServerPanel = new SecuredLibraryAppServerPanel(this._root, repositoryFQID);
        this._txtLibraryName = new WATextField();
        this._txtLibraryName.setMaxCharacters(256);
        this._txtLibraryName.setText(this._name);
        this._txtLibraryName.setEditable(false);
        this._txtLibraryName.setToolTipText(RB.getStringResource("SecuredLibraryRemoveDialog.LibraryName.Tooltip.txt"));
        this._lblLibraryName = UtilGui.createLabelForComponent((Component)this._txtLibraryName, (String)RB.getStringResource("SecuredLibraryRemoveDialog.LibraryName.Lbl.txt"));
        this._txtLibraryLocation = new WATextField();
        this._txtLibraryLocation.setMaxCharacters(256);
        this._txtLibraryLocation.setText(this._urlPathString);
        this._txtLibraryLocation.setEditable(false);
        this._txtLibraryLocation.setToolTipText(RB.getStringResource("SecuredLibraryRemoveDialog.LibraryLocation.Tooltip.txt"));
        this._lblLibraryLocation = UtilGui.createLabelForComponent((Component)this._txtLibraryLocation, (String)RB.getStringResource("SecuredLibraryRemoveDialog.LibraryLocation.Lbl.txt"));
        this.encryptionKey = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptKey.Lbl.txt"));
        this.encryptionKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (SecuredLibraryReportDialog.this.encryptionKey.isSelected()) {
                    SecuredLibraryReportDialog.this._txtEncryptKey.setEnabled(true);
                    SecuredLibraryReportDialog.this._txtEncryptKey.setBackground(SystemColor.text);
                    SecuredLibraryReportDialog.this._txtEncryptKey.requestFocus();
                } else {
                    SecuredLibraryReportDialog.this._txtEncryptKey.setEnabled(false);
                    SecuredLibraryReportDialog.this._txtEncryptKey.setBackground(SystemColor.control);
                }
            }
        });
        this._txtEncryptKey = new JPasswordField(64);
        this._txtEncryptKey.setEnabled(false);
        this._txtEncryptKey.setBackground(SystemColor.control);
        this._txtEncryptKey.setToolTipText(RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptKey.Tooltip.txt"));
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        int row = 0;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        this.libraryNameLocationPanel = new JPanel();
        TitledBorder infoBorder = BorderFactory.createTitledBorder(RB.getStringResource("SecuredLibrary.Common.Label.txt"));
        this.libraryNameLocationPanel.setBorder(infoBorder);
        GridBagLayout libraryNameLocationPanelLayout = new GridBagLayout();
        this.libraryNameLocationPanel.setLayout(libraryNameLocationPanelLayout);
        this.libraryNameLocationPanel.add((Component)this._lblLibraryName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryNameLocationPanel.add((Component)this._txtLibraryName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.libraryNameLocationPanel.add((Component)this._lblLibraryLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryNameLocationPanel.add((Component)this._txtLibraryLocation, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        mainPanel.add((Component)this.libraryNameLocationPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        mainPanel.add((Component)this.appServerPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        JPanel encryptionPanel = new JPanel();
        TitledBorder encryptBorder = BorderFactory.createTitledBorder(RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptionGroup.Lbl.txt"));
        encryptionPanel.setBorder(encryptBorder);
        GridBagLayout encryptionPanelLayout = new GridBagLayout();
        encryptionPanel.setLayout(encryptionPanelLayout);
        encryptionPanel.add((Component)this.encryptionKey, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        encryptionPanel.add((Component)this._txtEncryptKey, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        mainPanel.add((Component)encryptionPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        JPanel eaterPanel = new JPanel();
        mainPanel.add((Component)eaterPanel, new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add(mainPanel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                this.appServerPanel.loadDialogPanelData();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        } else {
            this.runReport(this._slDataObject);
        }
        return true;
    }

    protected boolean onCancel() {
        this._slDataObject = null;
        return true;
    }

    protected boolean validateData() {
        this._slDataObject.setLibraryName(this._name);
        this._slDataObject.setFolderLocation(this._urlPathString);
        if (this.encryptionKey.isSelected()) {
            String encryptKey = new String(this._txtEncryptKey.getPassword());
            if (encryptKey.length() == 0) {
                this._slDataObject.setEncryption(null);
            } else {
                this._slDataObject.setEncryptKey(encryptKey);
            }
        } else {
            this._slDataObject.setEncryptKey(null);
        }
        return this.appServerPanel.dataDialogValidate(this._slDataObject);
    }

    private PathUrl getParentPathUrl(PathUrl objPathUrl) {
        if (objPathUrl.getName() == null) {
            return new PathUrl(objPathUrl.getRepository(), null, null, "/", "Folder");
        }
        return new PathUrl(objPathUrl.getRepository(), objPathUrl.getRootTree(), objPathUrl.getPath(), null, "Folder");
    }

    protected void runReport(SecuredLibraryDataObject slDataObject) {
        String libraryName = null;
        String folderLocation = null;
        ServerContext serverComp = null;
        String libraryPath = null;
        String encryptKey = null;
        libraryName = slDataObject.getLibraryName();
        folderLocation = slDataObject.getFolderLocation();
        serverComp = (ServerContext)slDataObject.getServerComponent();
        libraryPath = slDataObject.getLibraryPath();
        encryptKey = slDataObject.getEncryptKey();
        SecuredLibraryAppServerUtil appServerUtil = new SecuredLibraryAppServerUtil(serverComp);
        StringBuffer generatedCode = new StringBuffer();
        generatedCode.append("libname slibref \"").append(libraryPath).append("\";");
        generatedCode.append("\n");
        generatedCode.append("proc authlib lib=slibref; \n");
        generatedCode.append("report securedfolder=\"").append(folderLocation).append("\"\n");
        generatedCode.append("securedlibrary=\"").append(libraryName).append("\"\n");
        if (encryptKey != null) {
            generatedCode.append("encryptkey=\"").append(encryptKey).append("\"\n");
        }
        generatedCode.append("; run; quit;");
        boolean result = appServerUtil.submitAppServerRequest(generatedCode.toString());
        LogListHolder appLog = appServerUtil.getAppServerLog();
        LogListHolder appOutputHolder = appServerUtil.getAppServerOutputHolder();
        this.showAppServerOutputDialog(appLog, appOutputHolder, result);
    }

    private void showAppServerOutputDialog(LogListHolder log, LogListHolder outputHolder, boolean result) {
        String msg;
        int type;
        if (result) {
            type = 1;
            msg = RB.getStringResource("SecuredLibraryReportDialog.AppServerLog.Success.txt");
        } else {
            type = 0;
            msg = RB.getStringResource("SecuredLibraryReportDialog.AppServerLog.Error.txt");
        }
        int rc = MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("SecuredLibraryReportDialog.Title.txt"), (int)type, (int)0);
        if (rc == 0) {
            this.displayOutputList(log, outputHolder);
        }
    }

    private void displayOutputList(LogListHolder log, LogListHolder outputHolder) {
        String[] strArray = new String[1];
        Integer[] intArray = new Integer[1];
        strArray[0] = "";
        intArray[0] = new Integer(5);
        LogListViewer sasLog = new LogListViewer(5, new LogListHolder(strArray, intArray), Workspace.getWorkspace().getCodeEditorDefaults());
        if (outputHolder != null) {
            sasLog.append(outputHolder);
        }
        if (log != null) {
            sasLog.append(log);
        }
        SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), RB.getStringResource("SecuredLibraryReportDialog.ReportOutput.Title.txt"), true, sasLog);
        logDlg.setResizable(true);
        logDlg.show();
    }
}

