/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryDataObject;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SecuredLibraryPasswordWizardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel libraryPasswordPanel;
    private JPanel libraryStandardPasswordPanel;
    private JPanel libraryAdvancedPasswordPanel;
    private JLabel _lblConfirmPassword;
    private JPasswordField _readPassword;
    private JPasswordField _writePassword;
    private JPasswordField _alterPassword;
    private JPasswordField _readConfirmPassword;
    private JPasswordField _writeConfirmPassword;
    private JPasswordField _alterConfirmPassword;
    private JLabel _lblcommonConfirmPassword;
    private JPasswordField _commonPassword;
    private JPasswordField _commonConfirmPassword;
    private JCheckBox multiplePasswords;
    private boolean _bMultiplePasswordsSelected = false;

    public SecuredLibraryPasswordWizardPanel() {
        this.initializePanel();
        this.layoutWidgets();
    }

    private void initializePanel() {
        this._lblConfirmPassword = new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.ConfirmPassword.Row.Lbl.txt"));
        this._readPassword = new JPasswordField(8);
        this._readPassword.setDocument(new JTextFieldLimit(8));
        this._readPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.ReadPassword.Tooltip.txt"));
        this._writePassword = new JPasswordField(8);
        this._writePassword.setDocument(new JTextFieldLimit(8));
        this._writePassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.WritePassword.Tooltip.txt"));
        this._alterPassword = new JPasswordField(8);
        this._alterPassword.setDocument(new JTextFieldLimit(8));
        this._alterPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.AlterPassword.Tooltip.txt"));
        this._readConfirmPassword = new JPasswordField(8);
        this._readConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._readConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.ReadConfirmPassword.Tooltip.txt"));
        this._writeConfirmPassword = new JPasswordField(8);
        this._writeConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._writeConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.WriteConfirmPassword.Tooltip.txt"));
        this._alterConfirmPassword = new JPasswordField(8);
        this._alterConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._alterConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.AlterConfirmPassword.Tooltip.txt"));
        this._commonPassword = new JPasswordField(8);
        this._commonPassword.setDocument(new JTextFieldLimit(8));
        this._commonPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.CommonPassword.Tooltip.txt"));
        this._commonConfirmPassword = new JPasswordField(8);
        this._commonConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._commonConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordWizardPanel.CommonConfirmPassword.Tooltip.txt"));
        this._lblcommonConfirmPassword = UtilGui.createLabelForComponent((Component)this._commonConfirmPassword, (String)RB.getStringResource("SecuredLibraryPasswordPanel.CommonConfirmPassword.Lbl.txt"));
        this.multiplePasswords = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryPasswordPanel.MultiplePasswords.Lbl.txt"));
        this.multiplePasswords.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.MultiplePasswords.Tooltip.txt"));
        this.multiplePasswords.setSelected(this._bMultiplePasswordsSelected);
        this.multiplePasswords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecuredLibraryPasswordWizardPanel.this.updateVisiblePasswordFields();
                if (SecuredLibraryPasswordWizardPanel.this.multiplePasswords.isSelected()) {
                    SecuredLibraryPasswordWizardPanel.this._bMultiplePasswordsSelected = true;
                } else {
                    SecuredLibraryPasswordWizardPanel.this._bMultiplePasswordsSelected = false;
                }
                SecuredLibraryPasswordWizardPanel.this.updateVisiblePasswordFields();
            }
        });
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.libraryPasswordPanel = new JPanel();
        TitledBorder passwordBorder = BorderFactory.createTitledBorder(RB.getStringResource("SecuredLibraryPasswordPanel.PasswordPanel.Lbl.txt"));
        this.libraryPasswordPanel.setBorder(passwordBorder);
        GridBagLayout libraryPasswordOptionsPanelLayout = new GridBagLayout();
        this.libraryPasswordPanel.setLayout(libraryPasswordOptionsPanelLayout);
        this.libraryPasswordPanel.add((Component)this.multiplePasswords, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryStandardPasswordPanel = new JPanel();
        this.libraryStandardPasswordPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryStandardPasswordPanel.setLayout(new GridBagLayout());
        this.libraryStandardPasswordPanel.add((Component)this.getCommonPasswordLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryStandardPasswordPanel.add((Component)this._commonPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryStandardPasswordPanel.add((Component)this._lblcommonConfirmPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryStandardPasswordPanel.add((Component)this._commonConfirmPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryPasswordPanel.add((Component)this.libraryStandardPasswordPanel, new GridBagConstraints(0, 1, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.libraryAdvancedPasswordPanel = new JPanel();
        this.libraryAdvancedPasswordPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryAdvancedPasswordPanel.setLayout(new GridBagLayout());
        this.libraryAdvancedPasswordPanel.add((Component)this.getReadColumnLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this.getWriteColumnLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this.getAlterColumnLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this.getPasswordRowLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._readPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._writePassword, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._alterPassword, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._lblConfirmPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._readConfirmPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._writeConfirmPassword, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._alterConfirmPassword, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.libraryPasswordPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    private void updateVisiblePasswordFields() {
        if (this.isMultiplePasswordsSelected()) {
            this.loadAdvancedPasswordFields();
        } else {
            this.loadStandardPasswordFields();
        }
    }

    private void loadStandardPasswordFields() {
        this.removeAllPasswordPanelsfromMainPanel();
        this.libraryStandardPasswordPanel.setVisible(true);
        this.libraryPasswordPanel.add((Component)this.libraryStandardPasswordPanel, new GridBagConstraints(0, 1, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
    }

    private void loadAdvancedPasswordFields() {
        this.removeAllPasswordPanelsfromMainPanel();
        this.libraryAdvancedPasswordPanel.setVisible(true);
        this.libraryPasswordPanel.add((Component)this.libraryAdvancedPasswordPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0));
    }

    private void removeAllPasswordPanelsfromMainPanel() {
        this.libraryStandardPasswordPanel.setVisible(false);
        this.libraryPasswordPanel.remove(this.libraryStandardPasswordPanel);
        this.libraryAdvancedPasswordPanel.setVisible(false);
        this.libraryPasswordPanel.remove(this.libraryAdvancedPasswordPanel);
    }

    protected boolean dataValidate() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        SecuredLibraryDataObject slDataObject = new SecuredLibraryDataObject();
        boolean valid = this.validatePasswordPanel(slDataObject);
        if (!valid) {
            return false;
        }
        wizard.replaceWizardData("LibraryPassword", (Object)slDataObject.getCommonPassword());
        wizard.replaceWizardData("ReadPassword", (Object)slDataObject.getReadPassword());
        wizard.replaceWizardData("WritePassword", (Object)slDataObject.getWritePassword());
        wizard.replaceWizardData("AlterPassword", (Object)slDataObject.getAlterPassword());
        return true;
    }

    protected boolean validatePasswordPanel(SecuredLibraryDataObject slDataObject) {
        if (this.isMultiplePasswordsSelected()) {
            return this.validateMultiplePassword(slDataObject);
        }
        return this.validateSinglePassword(slDataObject);
    }

    private boolean validateSinglePassword(SecuredLibraryDataObject slDataObject) {
        String passwordValue = null;
        String confirmPasswordValue = null;
        passwordValue = new String(this._commonPassword.getPassword());
        confirmPasswordValue = new String(this._commonConfirmPassword.getPassword());
        if (this.isPasswordMissing(passwordValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordWizardPanel.LibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._commonPassword.requestFocusInWindow();
            return false;
        }
        if (this.isPasswordMissing(confirmPasswordValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.ConfirmLibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._commonConfirmPassword.requestFocusInWindow();
            return false;
        }
        if (!passwordValue.equals(confirmPasswordValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordWizardPanel.PasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._commonConfirmPassword.requestFocusInWindow();
            return false;
        }
        String passwordEncoded = this.encodePassword(passwordValue);
        if (passwordEncoded == null) {
            return false;
        }
        slDataObject.setCommonPassword(passwordEncoded);
        slDataObject.setReadPassword(null);
        slDataObject.setWritePassword(null);
        slDataObject.setAlterPassword(null);
        return true;
    }

    private boolean validateMultiplePassword(SecuredLibraryDataObject slDataObject) {
        String readPassValue = null;
        String confirmReadPassValue = null;
        String writePassValue = null;
        String confirmWritePassValue = null;
        String alterPassValue = null;
        String confirmAlterPassValue = null;
        readPassValue = new String(this._readPassword.getPassword());
        writePassValue = new String(this._writePassword.getPassword());
        alterPassValue = new String(this._alterPassword.getPassword());
        confirmReadPassValue = new String(this._readConfirmPassword.getPassword());
        confirmWritePassValue = new String(this._writeConfirmPassword.getPassword());
        confirmAlterPassValue = new String(this._alterConfirmPassword.getPassword());
        boolean readMissing = this.isPasswordMissing(readPassValue);
        boolean writeMissing = this.isPasswordMissing(writePassValue);
        boolean alterMissing = this.isPasswordMissing(alterPassValue);
        if (readMissing || writeMissing || alterMissing) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordWizardPanel.LibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            if (readMissing) {
                this._readPassword.requestFocusInWindow();
            } else if (writeMissing) {
                this._writePassword.requestFocusInWindow();
            } else if (alterMissing) {
                this._alterPassword.requestFocusInWindow();
            }
            return false;
        }
        boolean confirmReadMissing = this.isPasswordMissing(confirmReadPassValue);
        boolean confirmWriteMissing = this.isPasswordMissing(confirmWritePassValue);
        boolean confirmAlterMissing = this.isPasswordMissing(confirmAlterPassValue);
        if (confirmReadMissing || confirmWriteMissing || confirmAlterMissing) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.ConfirmLibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            if (confirmReadMissing) {
                this._readConfirmPassword.requestFocusInWindow();
            } else if (confirmWriteMissing) {
                this._writeConfirmPassword.requestFocusInWindow();
            } else if (confirmAlterMissing) {
                this._alterConfirmPassword.requestFocusInWindow();
            }
            return false;
        }
        if (!readPassValue.equals(confirmReadPassValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordWizardPanel.PasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._readConfirmPassword.requestFocusInWindow();
            return false;
        }
        if (!writePassValue.equals(confirmWritePassValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordWizardPanel.PasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._writeConfirmPassword.requestFocusInWindow();
            return false;
        }
        if (!alterPassValue.equals(confirmAlterPassValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordWizardPanel.PasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._alterConfirmPassword.requestFocusInWindow();
            return false;
        }
        String readPasswordEncoded = this.encodePassword(readPassValue);
        if (readPasswordEncoded == null) {
            return false;
        }
        String writePasswordEncoded = this.encodePassword(writePassValue);
        if (writePasswordEncoded == null) {
            return false;
        }
        String alterPasswordEncoded = this.encodePassword(alterPassValue);
        if (alterPasswordEncoded == null) {
            return false;
        }
        slDataObject.setReadPassword(readPasswordEncoded);
        slDataObject.setWritePassword(writePasswordEncoded);
        slDataObject.setAlterPassword(alterPasswordEncoded);
        slDataObject.setCommonPassword(null);
        return true;
    }

    private String encodePassword(String password) {
        String passwordEncoded = null;
        try {
            passwordEncoded = SasPasswordString.encode((String)"sas002", (String)password);
        }
        catch (SasPasswordEncodingException e) {
            String sMsg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryPasswordPanel.LibraryPasswordEncodingError.fmt", (Object)e.getMessage());
            MessageUtil.displayMessage((String)sMsg, (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
        }
        return passwordEncoded;
    }

    private boolean isPasswordMissing(String passwordValue) {
        return passwordValue == null || passwordValue.isEmpty();
    }

    public boolean isMultiplePasswordsSelected() {
        return this._bMultiplePasswordsSelected;
    }

    private JLabel getCommonPasswordLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Password.Row.Lbl.txt"));
    }

    private JLabel getReadColumnLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Read.Column.Lbl.txt"));
    }

    private JLabel getWriteColumnLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Write.Column.Lbl.txt"));
    }

    private JLabel getAlterColumnLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Alter.Column.Lbl.txt"));
    }

    private JLabel getPasswordRowLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Password.Row.Lbl.txt"));
    }

    class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        public static final int DEFAULT_MAX_CHARS = 24;
        private int maxCharacters = 24;

        public JTextFieldLimit() {
        }

        public JTextFieldLimit(int maxChars) {
            this.maxCharacters = maxChars;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str != null && this.getLength() + str.length() <= this.maxCharacters) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

