/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryDataObject;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SecuredLibraryPasswordPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel libraryPasswordPanel;
    private JPanel libraryStandardPasswordPanel;
    private JPanel libraryAdvancedPasswordPanel;
    private JPanel libraryStandardPasswordPanel2;
    private JPanel libraryAdvancedPasswordPanel2;
    private JLabel _lblNewPassword;
    private JLabel _lblConfirmPassword;
    private JPasswordField _readPassword;
    private JPasswordField _writePassword;
    private JPasswordField _alterPassword;
    private JPasswordField _readPassword2;
    private JPasswordField _writePassword2;
    private JPasswordField _alterPassword2;
    private JPasswordField _readNewPassword;
    private JPasswordField _writeNewPassword;
    private JPasswordField _alterNewPassword;
    private JPasswordField _readConfirmPassword;
    private JPasswordField _writeConfirmPassword;
    private JPasswordField _alterConfirmPassword;
    private JLabel _lblcommonNewPassword;
    private JLabel _lblcommonConfirmPassword;
    private JPasswordField _commonPassword;
    private JPasswordField _commonNewPassword;
    private JPasswordField _commonConfirmPassword;
    private JPasswordField _commonPassword2;
    private JCheckBox multiplePasswords;
    private JCheckBox changePasswords;
    private boolean _bMultiplePasswordsSelected = false;
    private boolean _bChangePasswordsSelected = false;

    public SecuredLibraryPasswordPanel() {
        this.initializePanel();
        this.layoutWidgets();
    }

    private void initializePanel() {
        this._lblNewPassword = new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.NewPassword.Row.Lbl.txt"));
        this._lblConfirmPassword = new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.ConfirmPassword.Row.Lbl.txt"));
        this._readPassword = new JPasswordField(8);
        this._readPassword.setDocument(new JTextFieldLimit(8));
        this._readPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.ReadPassword.Tooltip.txt"));
        this._readNewPassword = new JPasswordField(8);
        this._readNewPassword.setDocument(new JTextFieldLimit(8));
        this._readNewPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.ReadNewPassword.Tooltip.txt"));
        this._writePassword = new JPasswordField(8);
        this._writePassword.setDocument(new JTextFieldLimit(8));
        this._writePassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.WritePassword.Tooltip.txt"));
        this._writeNewPassword = new JPasswordField(8);
        this._writeNewPassword.setDocument(new JTextFieldLimit(8));
        this._writeNewPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.WriteNewPassword.Tooltip.txt"));
        this._alterPassword = new JPasswordField(8);
        this._alterPassword.setDocument(new JTextFieldLimit(8));
        this._alterPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.AlterPassword.Tooltip.txt"));
        this._alterNewPassword = new JPasswordField(8);
        this._alterNewPassword.setDocument(new JTextFieldLimit(8));
        this._alterNewPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.AlterNewPassword.Tooltip.txt"));
        this._readConfirmPassword = new JPasswordField(8);
        this._readConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._readConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.ReadConfirmPassword.Tooltip.txt"));
        this._writeConfirmPassword = new JPasswordField(8);
        this._writeConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._writeConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.WriteConfirmPassword.Tooltip.txt"));
        this._alterConfirmPassword = new JPasswordField(8);
        this._alterConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._alterConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.AlterConfirmPassword.Tooltip.txt"));
        this._readPassword2 = new JPasswordField(8);
        this._readPassword2.setDocument(new JTextFieldLimit(8));
        this._readPassword2.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.ReadPassword.Tooltip.txt"));
        this._writePassword2 = new JPasswordField(8);
        this._writePassword2.setDocument(new JTextFieldLimit(8));
        this._writePassword2.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.WritePassword.Tooltip.txt"));
        this._alterPassword2 = new JPasswordField(8);
        this._alterPassword2.setDocument(new JTextFieldLimit(8));
        this._alterPassword2.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.AlterPassword.Tooltip.txt"));
        this._commonPassword = new JPasswordField(8);
        this._commonPassword.setDocument(new JTextFieldLimit(8));
        this._commonPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.CommonPassword.Tooltip.txt"));
        this._commonNewPassword = new JPasswordField(8);
        this._commonNewPassword.setDocument(new JTextFieldLimit(8));
        this._commonNewPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.CommonNewPassword.Tooltip.txt"));
        this._lblcommonNewPassword = UtilGui.createLabelForComponent((Component)this._commonNewPassword, (String)RB.getStringResource("SecuredLibraryPasswordPanel.CommonNewPassword.Lbl.txt"));
        this._commonConfirmPassword = new JPasswordField(8);
        this._commonConfirmPassword.setDocument(new JTextFieldLimit(8));
        this._commonConfirmPassword.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.CommonConfirmPassword.Tooltip.txt"));
        this._lblcommonConfirmPassword = UtilGui.createLabelForComponent((Component)this._commonConfirmPassword, (String)RB.getStringResource("SecuredLibraryPasswordPanel.CommonConfirmPassword.Lbl.txt"));
        this._commonPassword2 = new JPasswordField(8);
        this._commonPassword2.setDocument(new JTextFieldLimit(8));
        this._commonPassword2.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.CommonPassword.Tooltip.txt"));
        this.multiplePasswords = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryPasswordPanel.MultiplePasswords.Lbl.txt"));
        this.multiplePasswords.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.MultiplePasswords.Tooltip.txt"));
        this.multiplePasswords.setSelected(this._bMultiplePasswordsSelected);
        this.multiplePasswords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecuredLibraryPasswordPanel.this.updateVisiblePasswordFields();
                if (SecuredLibraryPasswordPanel.this.multiplePasswords.isSelected()) {
                    SecuredLibraryPasswordPanel.this._bMultiplePasswordsSelected = true;
                } else {
                    SecuredLibraryPasswordPanel.this._bMultiplePasswordsSelected = false;
                }
                SecuredLibraryPasswordPanel.this.updateVisiblePasswordFields();
            }
        });
        this.changePasswords = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryPasswordPanel.ChangePasswords.Lbl.txt"));
        this.changePasswords.setToolTipText(RB.getStringResource("SecuredLibraryPasswordPanel.ChangePasswords.Tooltip.txt"));
        this.changePasswords.setSelected(this._bChangePasswordsSelected);
        this.changePasswords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryPasswordPanel.this.changePasswords.isSelected()) {
                    SecuredLibraryPasswordPanel.this._bChangePasswordsSelected = true;
                } else {
                    SecuredLibraryPasswordPanel.this._bChangePasswordsSelected = false;
                }
                SecuredLibraryPasswordPanel.this.updateVisiblePasswordFields();
            }
        });
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.libraryPasswordPanel = new JPanel();
        TitledBorder passwordBorder = BorderFactory.createTitledBorder(RB.getStringResource("SecuredLibraryPasswordPanel.PasswordPanel.Lbl.txt"));
        this.libraryPasswordPanel.setBorder(passwordBorder);
        GridBagLayout libraryPasswordOptionsPanelLayout = new GridBagLayout();
        this.libraryPasswordPanel.setLayout(libraryPasswordOptionsPanelLayout);
        this.libraryPasswordPanel.add((Component)this.multiplePasswords, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryPasswordPanel.add((Component)this.changePasswords, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryStandardPasswordPanel = new JPanel();
        this.libraryStandardPasswordPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryStandardPasswordPanel.setLayout(new GridBagLayout());
        this.libraryStandardPasswordPanel.add((Component)this.getCommonPasswordLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryStandardPasswordPanel.add((Component)this._commonPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryPasswordPanel.add((Component)this.libraryStandardPasswordPanel, new GridBagConstraints(0, 1, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.libraryStandardPasswordPanel2 = new JPanel();
        this.libraryStandardPasswordPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryStandardPasswordPanel2.setLayout(new GridBagLayout());
        this.libraryStandardPasswordPanel2.add((Component)this.getCommonPasswordLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryStandardPasswordPanel2.add((Component)this._commonPassword2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryStandardPasswordPanel2.add((Component)this._lblcommonNewPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryStandardPasswordPanel2.add((Component)this._commonNewPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryStandardPasswordPanel2.add((Component)this._lblcommonConfirmPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryStandardPasswordPanel2.add((Component)this._commonConfirmPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel = new JPanel();
        this.libraryAdvancedPasswordPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryAdvancedPasswordPanel.setLayout(new GridBagLayout());
        this.libraryAdvancedPasswordPanel.add((Component)this.getReadColumnLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this.getWriteColumnLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this.getAlterColumnLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this.getPasswordRowLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._readPassword, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._writePassword, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel.add((Component)this._alterPassword, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2 = new JPanel();
        this.libraryAdvancedPasswordPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.libraryAdvancedPasswordPanel2.setLayout(new GridBagLayout());
        this.libraryAdvancedPasswordPanel2.add((Component)this.getReadColumnLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this.getWriteColumnLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this.getAlterColumnLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this.getPasswordRowLabel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._readPassword2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._writePassword2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._alterPassword2, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._lblNewPassword, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._readNewPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._writeNewPassword, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._alterNewPassword, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._lblConfirmPassword, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._readConfirmPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._writeConfirmPassword, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryAdvancedPasswordPanel2.add((Component)this._alterConfirmPassword, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.libraryPasswordPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    private void updateVisiblePasswordFields() {
        if (this.isMultiplePasswordsSelected()) {
            this.loadAdvancedPasswordFields();
        } else {
            this.loadStandardPasswordFields();
        }
    }

    private void loadStandardPasswordFields() {
        this.removeAllPasswordPanelsfromMainPanel();
        if (this.isChangePasswordsSelected()) {
            this.libraryStandardPasswordPanel2.setVisible(true);
            this.libraryPasswordPanel.add((Component)this.libraryStandardPasswordPanel2, new GridBagConstraints(0, 1, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        } else {
            this.libraryStandardPasswordPanel.setVisible(true);
            this.libraryPasswordPanel.add((Component)this.libraryStandardPasswordPanel, new GridBagConstraints(0, 1, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        }
    }

    private void loadAdvancedPasswordFields() {
        this.removeAllPasswordPanelsfromMainPanel();
        if (this.isChangePasswordsSelected()) {
            this.libraryAdvancedPasswordPanel2.setVisible(true);
            this.libraryPasswordPanel.add((Component)this.libraryAdvancedPasswordPanel2, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        } else {
            this.libraryAdvancedPasswordPanel.setVisible(true);
            this.libraryPasswordPanel.add((Component)this.libraryAdvancedPasswordPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        }
    }

    private void removeAllPasswordPanelsfromMainPanel() {
        this.libraryStandardPasswordPanel.setVisible(false);
        this.libraryPasswordPanel.remove(this.libraryStandardPasswordPanel);
        this.libraryStandardPasswordPanel2.setVisible(false);
        this.libraryPasswordPanel.remove(this.libraryStandardPasswordPanel2);
        this.libraryAdvancedPasswordPanel.setVisible(false);
        this.libraryPasswordPanel.remove(this.libraryAdvancedPasswordPanel);
        this.libraryAdvancedPasswordPanel2.setVisible(false);
        this.libraryPasswordPanel.remove(this.libraryAdvancedPasswordPanel2);
    }

    protected boolean dataValidate() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        SecuredLibraryDataObject slDataObject = new SecuredLibraryDataObject();
        this.validatePasswordPanel(slDataObject);
        wizard.replaceWizardData("LibraryPassword", (Object)slDataObject.getCommonPassword());
        wizard.replaceWizardData("ReadPassword", (Object)slDataObject.getReadPassword());
        wizard.replaceWizardData("WritePassword", (Object)slDataObject.getWritePassword());
        wizard.replaceWizardData("AlterPassword", (Object)slDataObject.getAlterPassword());
        return true;
    }

    protected boolean validatePasswordPanel(SecuredLibraryDataObject slDataObject) {
        if (this.isMultiplePasswordsSelected()) {
            return this.validateMultiplePassword(slDataObject);
        }
        return this.validateSinglePassword(slDataObject);
    }

    private boolean validateSinglePassword(SecuredLibraryDataObject slDataObject) {
        String passwordValue = null;
        String newPasswordValue = null;
        String confirmPasswordValue = null;
        if (this.isChangePasswordsSelected()) {
            passwordValue = new String(this._commonPassword2.getPassword());
            newPasswordValue = new String(this._commonNewPassword.getPassword());
            confirmPasswordValue = new String(this._commonConfirmPassword.getPassword());
            if (this.isPasswordMissing(passwordValue)) {
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.LibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                this._commonPassword2.requestFocusInWindow();
                return false;
            }
            String passwordEncoded = this.encodePassword(passwordValue);
            if (passwordEncoded == null) {
                return false;
            }
            String newPasswordEncoded = null;
            if (!this.isPasswordMissing(newPasswordValue) || !this.isPasswordMissing(confirmPasswordValue)) {
                if (!newPasswordValue.equals(confirmPasswordValue)) {
                    MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.NewPasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                    this._commonConfirmPassword.requestFocusInWindow();
                    return false;
                }
                newPasswordEncoded = this.encodePassword(newPasswordValue);
                if (newPasswordEncoded == null) {
                    return false;
                }
            }
            slDataObject.setCommonPassword(passwordEncoded);
            slDataObject.setNewCommonPassword(newPasswordEncoded);
        } else {
            passwordValue = new String(this._commonPassword.getPassword());
            if (this.isPasswordMissing(passwordValue)) {
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.LibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                this._commonPassword.requestFocusInWindow();
                return false;
            }
            String passwordEncoded = this.encodePassword(passwordValue);
            if (passwordEncoded == null) {
                return false;
            }
            slDataObject.setCommonPassword(passwordEncoded);
            slDataObject.setNewCommonPassword(null);
        }
        slDataObject.setReadPassword(null);
        slDataObject.setWritePassword(null);
        slDataObject.setAlterPassword(null);
        slDataObject.setNewReadPassword(null);
        slDataObject.setNewWritePassword(null);
        slDataObject.setNewAlterPassword(null);
        return true;
    }

    private boolean validateMultiplePassword(SecuredLibraryDataObject slDataObject) {
        String readPassValue = null;
        String newReadPassValue = null;
        String confirmReadPassValue = null;
        String writePassValue = null;
        String newWritePassValue = null;
        String confirmWritePassValue = null;
        String alterPassValue = null;
        String newAlterPassValue = null;
        String confirmAlterPassValue = null;
        if (this.isChangePasswordsSelected()) {
            readPassValue = new String(this._readPassword2.getPassword());
            writePassValue = new String(this._writePassword2.getPassword());
            alterPassValue = new String(this._alterPassword2.getPassword());
            newReadPassValue = new String(this._readNewPassword.getPassword());
            newWritePassValue = new String(this._writeNewPassword.getPassword());
            newAlterPassValue = new String(this._alterNewPassword.getPassword());
            confirmReadPassValue = new String(this._readConfirmPassword.getPassword());
            confirmWritePassValue = new String(this._writeConfirmPassword.getPassword());
            confirmAlterPassValue = new String(this._alterConfirmPassword.getPassword());
            boolean readMissing = this.isPasswordMissing(readPassValue);
            boolean writeMissing = this.isPasswordMissing(writePassValue);
            boolean alterMissing = this.isPasswordMissing(alterPassValue);
            if (readMissing || writeMissing || alterMissing) {
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.LibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                if (readMissing) {
                    this._readPassword2.requestFocusInWindow();
                } else if (writeMissing) {
                    this._writePassword2.requestFocusInWindow();
                } else if (alterMissing) {
                    this._alterPassword2.requestFocusInWindow();
                }
                return false;
            }
            String readPasswordEncoded = this.encodePassword(readPassValue);
            if (readPasswordEncoded == null) {
                return false;
            }
            String writePasswordEncoded = this.encodePassword(writePassValue);
            if (writePasswordEncoded == null) {
                return false;
            }
            String alterPasswordEncoded = this.encodePassword(alterPassValue);
            if (alterPasswordEncoded == null) {
                return false;
            }
            String newReadPasswordEncoded = null;
            if (!this.isPasswordMissing(newReadPassValue) || !this.isPasswordMissing(confirmReadPassValue)) {
                if (!newReadPassValue.equals(confirmReadPassValue)) {
                    MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.NewPasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                    this._readConfirmPassword.requestFocusInWindow();
                    return false;
                }
                if (newReadPassValue != null && (newReadPasswordEncoded = this.encodePassword(newReadPassValue)) == null) {
                    return false;
                }
            }
            String newWritePasswordEncoded = null;
            if (!this.isPasswordMissing(newWritePassValue) || !this.isPasswordMissing(confirmWritePassValue)) {
                if (!newWritePassValue.equals(confirmWritePassValue)) {
                    MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.NewPasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                    this._writeConfirmPassword.requestFocusInWindow();
                    return false;
                }
                if (newWritePassValue != null && (newWritePasswordEncoded = this.encodePassword(newWritePassValue)) == null) {
                    return false;
                }
            }
            String newAlterPasswordEncoded = null;
            if (!this.isPasswordMissing(newAlterPassValue) || !this.isPasswordMissing(confirmAlterPassValue)) {
                if (!newAlterPassValue.equals(confirmAlterPassValue)) {
                    MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.NewPasswordConfirmPasswordMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                    this._alterConfirmPassword.requestFocusInWindow();
                    return false;
                }
                if (newAlterPassValue != null && (newAlterPasswordEncoded = this.encodePassword(newAlterPassValue)) == null) {
                    return false;
                }
            }
            slDataObject.setReadPassword(readPasswordEncoded);
            slDataObject.setNewReadPassword(newReadPasswordEncoded);
            slDataObject.setWritePassword(writePasswordEncoded);
            slDataObject.setNewWritePassword(newWritePasswordEncoded);
            slDataObject.setAlterPassword(alterPasswordEncoded);
            slDataObject.setNewAlterPassword(newAlterPasswordEncoded);
        } else {
            readPassValue = new String(this._readPassword.getPassword());
            writePassValue = new String(this._writePassword.getPassword());
            alterPassValue = new String(this._alterPassword.getPassword());
            boolean readMissing = this.isPasswordMissing(readPassValue);
            boolean writeMissing = this.isPasswordMissing(writePassValue);
            boolean alterMissing = this.isPasswordMissing(alterPassValue);
            if (readMissing || writeMissing || alterMissing) {
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryPasswordPanel.LibraryPasswordRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                if (readMissing) {
                    this._readPassword.requestFocusInWindow();
                } else if (writeMissing) {
                    this._writePassword.requestFocusInWindow();
                } else if (alterMissing) {
                    this._alterPassword.requestFocusInWindow();
                }
                return false;
            }
            String readPasswordEncoded = this.encodePassword(readPassValue);
            if (readPasswordEncoded == null) {
                return false;
            }
            String writePasswordEncoded = this.encodePassword(writePassValue);
            if (writePasswordEncoded == null) {
                return false;
            }
            String alterPasswordEncoded = this.encodePassword(alterPassValue);
            if (alterPasswordEncoded == null) {
                return false;
            }
            slDataObject.setReadPassword(readPasswordEncoded);
            slDataObject.setNewReadPassword(null);
            slDataObject.setWritePassword(writePasswordEncoded);
            slDataObject.setNewWritePassword(null);
            slDataObject.setAlterPassword(alterPasswordEncoded);
            slDataObject.setNewAlterPassword(null);
        }
        slDataObject.setCommonPassword(null);
        slDataObject.setNewCommonPassword(null);
        return true;
    }

    private String encodePassword(String password) {
        String passwordEncoded = null;
        try {
            passwordEncoded = SasPasswordString.encode((String)"sas002", (String)password);
        }
        catch (SasPasswordEncodingException e) {
            String sMsg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryPasswordPanel.LibraryPasswordEncodingError.fmt", (Object)e.getMessage());
            MessageUtil.displayMessage((String)sMsg, (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
        }
        return passwordEncoded;
    }

    private boolean isPasswordMissing(String passwordValue) {
        return passwordValue == null || passwordValue.isEmpty();
    }

    public boolean isChangePasswordsSelected() {
        return this._bChangePasswordsSelected;
    }

    public boolean isMultiplePasswordsSelected() {
        return this._bMultiplePasswordsSelected;
    }

    private JLabel getCommonPasswordLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Password.Row.Lbl.txt"));
    }

    private JLabel getReadColumnLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Read.Column.Lbl.txt"));
    }

    private JLabel getWriteColumnLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Write.Column.Lbl.txt"));
    }

    private JLabel getAlterColumnLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Alter.Column.Lbl.txt"));
    }

    private JLabel getPasswordRowLabel() {
        return new JLabel(RB.getStringResource("SecuredLibraryPasswordPanel.Password.Row.Lbl.txt"));
    }

    class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        public static final int DEFAULT_MAX_CHARS = 24;
        private int maxCharacters = 24;

        public JTextFieldLimit() {
        }

        public JTextFieldLimit(int maxChars) {
            this.maxCharacters = maxChars;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str != null && this.getLength() + str.length() <= this.maxCharacters) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

