/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerUtil;
import com.sas.metadata.logical.secureddata.SecuredLibraryDataObject;
import com.sas.metadata.logical.secureddata.SecuredLibraryEncryptionPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryPasswordPanel;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASPassword;
import com.sas.metadata.remote.SecuredLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.information.metadata.PathUrl;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SecuredLibraryModifyDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private com.sas.services.information.metadata.secureddata.SecuredLibrary _securedLibrary;
    private Root _root;
    private Config _config;
    private SecuredLibraryDataObject _slDataObject;
    private SecuredLibraryAppServerPanel appServerPanel;
    private SecuredLibraryPasswordPanel passwordPanel;
    private SecuredLibraryEncryptionPanel encryptionPanel;
    private String _name = null;
    private String _urlPathString = null;
    private JPanel libraryNameLocationPanel;
    private JLabel _lblLibraryName;
    private WATextField _txtLibraryName;
    private JLabel _lblLibraryLocation;
    private WATextField _txtLibraryLocation;
    private JCheckBox purgeCredentials;

    public SecuredLibraryModifyDialog(com.sas.services.information.metadata.secureddata.SecuredLibrary slibrary, Root root, Config config) {
        super((Frame)Workspace.getWorkspace(), RB.getStringResource("SecuredLibraryModifyDialog.Title.txt"), true);
        this._securedLibrary = slibrary;
        this._root = root;
        this._config = config;
        this.initializeDialog();
    }

    protected void initializeDialog() {
        String repositoryFQID;
        block4: {
            this.setName(RB.getStringResource("SecuredLibraryModifyDialog.Title.txt"));
            this.setHelpProduct("folderview");
            this.setHelpTopic("seclib_modifydialog");
            this.setOKButtonVisible(true);
            this.setCancelButtonVisible(true);
            this.setHelpButtonVisible(true);
            this.setResizable(true);
            this.setPreferredSize(new Dimension(500, 740));
            this._slDataObject = new SecuredLibraryDataObject();
            repositoryFQID = null;
            try {
                repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)this._root);
                this._name = this._root.getName();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            try {
                PathUrl parentPathUrl = this.getParentPathUrl(this._securedLibrary.getPathUrl());
                this._urlPathString = parentPathUrl.getDisplayPath();
            }
            catch (Exception e) {
                if (this._urlPathString != null) break block4;
                this._urlPathString = " ";
            }
        }
        this.appServerPanel = new SecuredLibraryAppServerPanel(this._root, repositoryFQID);
        this.passwordPanel = new SecuredLibraryPasswordPanel();
        this.encryptionPanel = new SecuredLibraryEncryptionPanel(true);
        this._txtLibraryName = new WATextField();
        this._txtLibraryName.setMaxCharacters(256);
        this._txtLibraryName.setText(this._name);
        this._txtLibraryName.setEditable(false);
        this._txtLibraryName.setToolTipText(RB.getStringResource("SecuredLibraryRemoveDialog.LibraryName.Tooltip.txt"));
        this._lblLibraryName = UtilGui.createLabelForComponent((Component)this._txtLibraryName, (String)RB.getStringResource("SecuredLibraryRemoveDialog.LibraryName.Lbl.txt"));
        this._txtLibraryLocation = new WATextField();
        this._txtLibraryLocation.setMaxCharacters(256);
        this._txtLibraryLocation.setText(this._urlPathString);
        this._txtLibraryLocation.setEditable(false);
        this._txtLibraryLocation.setToolTipText(RB.getStringResource("SecuredLibraryRemoveDialog.LibraryLocation.Tooltip.txt"));
        this._lblLibraryLocation = UtilGui.createLabelForComponent((Component)this._txtLibraryLocation, (String)RB.getStringResource("SecuredLibraryRemoveDialog.LibraryLocation.Lbl.txt"));
        this.purgeCredentials = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryModifyDialog.PurgeCredentials.Lbl.txt"));
        this.purgeCredentials.setToolTipText(RB.getStringResource("SecuredLibraryModifyDialog.PurgeCredentials.Tooltip.txt"));
        this.purgeCredentials.setSelected(true);
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        int row = 0;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        this.libraryNameLocationPanel = new JPanel();
        TitledBorder infoBorder = BorderFactory.createTitledBorder(RB.getStringResource("SecuredLibrary.Common.Label.txt"));
        this.libraryNameLocationPanel.setBorder(infoBorder);
        GridBagLayout libraryNameLocationPanelLayout = new GridBagLayout();
        this.libraryNameLocationPanel.setLayout(libraryNameLocationPanelLayout);
        this.libraryNameLocationPanel.add((Component)this._lblLibraryName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryNameLocationPanel.add((Component)this._txtLibraryName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.libraryNameLocationPanel.add((Component)this._lblLibraryLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryNameLocationPanel.add((Component)this._txtLibraryLocation, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        mainPanel.add((Component)this.libraryNameLocationPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        mainPanel.add((Component)this.appServerPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        mainPanel.add((Component)this.purgeCredentials, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        mainPanel.add((Component)this.passwordPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        mainPanel.add((Component)this.encryptionPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        JPanel eaterPanel = new JPanel();
        mainPanel.add((Component)eaterPanel, new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add(mainPanel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                this.appServerPanel.loadDialogPanelData();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        } else {
            this.modifySecuredLibrary(this._slDataObject);
        }
        return true;
    }

    protected boolean onCancel() {
        this._slDataObject = null;
        return true;
    }

    protected boolean validateData() {
        this._slDataObject.setLibraryName(this._name);
        this._slDataObject.setFolderLocation(this._urlPathString);
        this._slDataObject.setPurgeCredentials(this.purgeCredentials.isSelected());
        if (this.appServerPanel.dataDialogValidate(this._slDataObject)) {
            if (this.passwordPanel.validatePasswordPanel(this._slDataObject)) {
                if (this.encryptionPanel.validateEncryptionPanel(this._slDataObject)) {
                    return this.encryptionValidationModifyChecks();
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private PathUrl getParentPathUrl(PathUrl objPathUrl) {
        if (objPathUrl.getName() == null) {
            return new PathUrl(objPathUrl.getRepository(), null, null, "/", "Folder");
        }
        return new PathUrl(objPathUrl.getRepository(), objPathUrl.getRootTree(), objPathUrl.getPath(), null, "Folder");
    }

    private boolean encryptionValidationModifyChecks() {
        String requireEncryption = this._slDataObject.getRequireEncryption();
        String encrypt = this._slDataObject.getEncryption();
        if (requireEncryption != null && requireEncryption.equals("YES")) {
            if (encrypt == null) {
                try {
                    if (((SecuredLibrary)this._root).getEncrypt().equals("R")) {
                        return true;
                    }
                    AssociationList libraryPasswords = ((SecuredLibrary)this._root).getDefaultPasswords();
                    if (!libraryPasswords.isEmpty()) {
                        String MetadataBoundLibraryKeyType = "MBL_K";
                        for (int i = 0; i < libraryPasswords.size(); ++i) {
                            SASPassword password;
                            Object obj = libraryPasswords.get(i);
                            if (!(obj instanceof SASPassword) || !(password = (SASPassword)obj).getType().equals(MetadataBoundLibraryKeyType)) continue;
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryConnectionDataTabPanel.RequireEncryption.EncryptionType.Required.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                return false;
            }
            return true;
        }
        if (requireEncryption == null) {
            try {
                if (((SecuredLibrary)this._root).getEncrypt().equals("R") && encrypt != null && encrypt.equals("NO")) {
                    MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryConnectionDataTabPanel.RequireEncryption.EncryptionType.NOInvalid.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                    return false;
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected void modifySecuredLibrary(SecuredLibraryDataObject slDataObject) {
        String libraryName = null;
        String folderLocation = null;
        ServerContext serverComp = null;
        String libraryPath = null;
        String commonPassword = null;
        String newCommonPassword = null;
        String readPassword = null;
        String newReadPassword = null;
        String writePassword = null;
        String newWritePassword = null;
        String alterPassword = null;
        String newAlterPassword = null;
        String requireEncryption = null;
        String encrypt = null;
        String encryptKey = null;
        String newEncryptKey = null;
        libraryName = slDataObject.getLibraryName();
        folderLocation = slDataObject.getFolderLocation();
        serverComp = (ServerContext)slDataObject.getServerComponent();
        libraryPath = slDataObject.getLibraryPath();
        commonPassword = slDataObject.getCommonPassword();
        newCommonPassword = slDataObject.getNewCommonPassword();
        readPassword = slDataObject.getReadPassword();
        newReadPassword = slDataObject.getNewReadPassword();
        writePassword = slDataObject.getWritePassword();
        newWritePassword = slDataObject.getNewWritePassword();
        alterPassword = slDataObject.getAlterPassword();
        newAlterPassword = slDataObject.getNewAlterPassword();
        requireEncryption = slDataObject.getRequireEncryption();
        encrypt = slDataObject.getEncryption();
        encryptKey = slDataObject.getEncryptKey();
        newEncryptKey = slDataObject.getNewEncryptKey();
        boolean purgeCredentials = slDataObject.isPurgeCredentials();
        SecuredLibraryAppServerUtil appServerUtil = new SecuredLibraryAppServerUtil(serverComp);
        StringBuffer generatedCode = new StringBuffer();
        generatedCode.append("libname slibref \"").append(libraryPath).append("\";");
        generatedCode.append("\n");
        generatedCode.append("proc authlib lib=slibref; \n");
        generatedCode.append("modify securedfolder=\"").append(folderLocation).append("\"\n");
        generatedCode.append("securedlibrary=\"").append(libraryName).append("\"\n");
        if (commonPassword != null) {
            if (newCommonPassword != null) {
                generatedCode.append("pw=\"").append(commonPassword).append("\"/\"").append(newCommonPassword).append("\"\n");
            } else {
                generatedCode.append("pw=\"").append(commonPassword).append("\"\n");
            }
        } else {
            if (newReadPassword != null) {
                generatedCode.append("read=\"").append(readPassword).append("\"/\"").append(newReadPassword).append("\"");
            } else {
                generatedCode.append("read=\"").append(readPassword).append("\"");
            }
            if (newWritePassword != null) {
                generatedCode.append(" write=\"").append(writePassword).append("\"/\"").append(newWritePassword).append("\"");
            } else {
                generatedCode.append(" write=\"").append(writePassword).append("\"");
            }
            if (newAlterPassword != null) {
                generatedCode.append(" alter=\"").append(alterPassword).append("\"/\"").append(newAlterPassword).append("\"\n");
            } else {
                generatedCode.append(" alter=\"").append(alterPassword).append("\"\n");
            }
        }
        if (requireEncryption != null) {
            generatedCode.append("require_encryption=").append(requireEncryption).append("\n");
        }
        if (encrypt != null) {
            generatedCode.append("encrypt=").append(encrypt).append("\n");
        }
        if (encryptKey != null) {
            if (newEncryptKey != null) {
                generatedCode.append("encryptkey=\"").append(encryptKey).append("\"/\"").append(newEncryptKey).append("\"\n");
            } else {
                generatedCode.append("encryptkey=\"").append(encryptKey).append("\"\n");
            }
        } else if (newEncryptKey != null) {
            generatedCode.append("encryptkey=/").append("\"").append(newEncryptKey).append("\"\n");
        }
        if (!purgeCredentials) {
            generatedCode.append("PURGE=NO \n");
        }
        generatedCode.append("; run; quit;");
        boolean result = appServerUtil.submitAppServerRequest(generatedCode.toString());
        LogListHolder appLog = appServerUtil.getAppServerLog();
        LogListHolder appOutputHolder = appServerUtil.getAppServerOutputHolder();
        this.showAppServerOutputDialog(appLog, appOutputHolder, result);
        if (result) {
            try {
                MdFactory factory = Workspace.getMdFactory();
                HashMap<String, String> libraryMap = new HashMap<String, String>();
                String libraryFQID = this._root.getFQID();
                libraryMap.put(libraryFQID, "SecuredLibrary");
                factory.fireMdObjectsModified(new MdFactoryEvent(factory, libraryMap));
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private void showAppServerOutputDialog(LogListHolder log, LogListHolder outputHolder, boolean result) {
        String msg;
        int type;
        if (result) {
            type = 1;
            msg = RB.getStringResource("SecuredLibraryModifyDialog.AppServerLog.Success.txt");
        } else {
            type = 0;
            msg = RB.getStringResource("SecuredLibraryModifyDialog.AppServerLog.Error.txt");
        }
        int rc = MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("SecuredLibraryModifyDialog.Title.txt"), (int)type, (int)0);
        if (rc == 0) {
            this.displayOutputList(log, outputHolder);
        }
    }

    private void displayOutputList(LogListHolder log, LogListHolder outputHolder) {
        String[] strArray = new String[1];
        Integer[] intArray = new Integer[1];
        strArray[0] = "";
        intArray[0] = new Integer(5);
        LogListViewer sasLog = new LogListViewer(5, new LogListHolder(strArray, intArray), Workspace.getWorkspace().getCodeEditorDefaults());
        if (log != null) {
            sasLog.append(log);
        }
        if (outputHolder != null) {
            sasLog.append(outputHolder);
        }
        SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), RB.getStringResource("SecuredLibraryModifyDialog.Title.txt"), true, sasLog);
        logDlg.setResizable(true);
        logDlg.show();
    }
}

