/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryDataObject;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SecuredLibraryEncryptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String YES = "YES";
    private static final String NO = "NO";
    private static final String AES = "AES";
    private static final String AES2 = "AES2";
    private JPanel libraryEncryptionPanel;
    private JCheckBox _requireEncryptionOption;
    private JCheckBox _encryptOption;
    private JRadioButton requiredNoValue;
    private JRadioButton requiredYesValue;
    private JRadioButton sasValue;
    private JRadioButton noValue;
    private JRadioButton aesValue;
    private JRadioButton aes2Value;
    private JLabel _lblEncryptionKey;
    private JPasswordField _txtEncryptKey;
    private JLabel _lblNewEncryptionKey;
    private JPasswordField _txtNewEncryptKey;
    private JLabel _lblConfirmEncryptionKey;
    private JPasswordField _txtconfirmEncryptKey;
    private boolean _showRequireEncryption;

    public SecuredLibraryEncryptionPanel(boolean requireEncryption) {
        this._showRequireEncryption = requireEncryption;
        this.initializePanel();
        this.layoutWidgets();
    }

    private void initializePanel() {
        this._requireEncryptionOption = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryEncryptionPanel.Encryption.Lbl.txt"));
        this._requireEncryptionOption.setToolTipText(RB.getStringResource("SecuredLibraryEncryptionPanel.Encryption.Tooltip.txt"));
        this._requireEncryptionOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this._requireEncryptionOption.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.enableRequiredRadioButtons();
                    if (SecuredLibraryEncryptionPanel.this.requiredNoValue.isSelected() && SecuredLibraryEncryptionPanel.this._encryptOption.isSelected()) {
                        SecuredLibraryEncryptionPanel.this.disableSASProprietaryRadioButton();
                    }
                    if (SecuredLibraryEncryptionPanel.this.requiredYesValue.isSelected() && SecuredLibraryEncryptionPanel.this._encryptOption.isSelected()) {
                        SecuredLibraryEncryptionPanel.this.disableNoneRadioButton();
                    }
                } else {
                    SecuredLibraryEncryptionPanel.this.disableRequiredRadioButtons();
                    if (SecuredLibraryEncryptionPanel.this._encryptOption.isSelected()) {
                        SecuredLibraryEncryptionPanel.this.enableSASProprietaryRadioButton();
                        SecuredLibraryEncryptionPanel.this.enableNoneRadioButton();
                    }
                }
            }
        });
        this.requiredNoValue = UtilGui.createRadioButton((String)RB.getStringResource("SecuredLibrary.Common.No.Lbl.txt"));
        this.requiredNoValue.setEnabled(false);
        this.requiredNoValue.setSelected(false);
        this.requiredNoValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this.requiredNoValue.isSelected() && SecuredLibraryEncryptionPanel.this._encryptOption.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.disableSASProprietaryRadioButton();
                    SecuredLibraryEncryptionPanel.this.enableNoneRadioButton();
                }
            }
        });
        this.requiredYesValue = UtilGui.createRadioButton((String)RB.getStringResource("SecuredLibrary.Common.Yes.Lbl.txt"));
        this.requiredYesValue.setEnabled(false);
        this.requiredYesValue.setSelected(true);
        this.requiredYesValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this.requiredYesValue.isSelected() && SecuredLibraryEncryptionPanel.this._encryptOption.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.enableSASProprietaryRadioButton();
                    SecuredLibraryEncryptionPanel.this.disableNoneRadioButton();
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.requiredYesValue);
        buttonGroup.add(this.requiredNoValue);
        this._encryptOption = UtilGui.createCheckBox((String)RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptType.Lbl.txt"));
        this._encryptOption.setToolTipText(RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptType.Tooltip.txt"));
        this._encryptOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this._encryptOption.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.enableEncryptRadioButtons();
                    if (SecuredLibraryEncryptionPanel.this.aesValue.isSelected()) {
                        SecuredLibraryEncryptionPanel.this.enableNewEncryptKeyFields();
                    }
                } else {
                    SecuredLibraryEncryptionPanel.this.disableEncryptRadioButtons();
                    SecuredLibraryEncryptionPanel.this.disableNewEncryptKeyFields();
                }
            }
        });
        this.sasValue = UtilGui.createRadioButton((String)RB.getStringResource("SecuredLibrary.Encryption.SASProprietary.Lbl.txt"));
        this.sasValue.setEnabled(false);
        this.sasValue.setSelected(false);
        this.sasValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this.sasValue.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.disableNewEncryptKeyFields();
                }
            }
        });
        this.noValue = UtilGui.createRadioButton((String)RB.getStringResource("SecuredLibrary.Encryption.No.Lbl.txt"));
        this.noValue.setEnabled(false);
        this.noValue.setSelected(false);
        this.noValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this.noValue.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.disableNewEncryptKeyFields();
                }
            }
        });
        this.aesValue = UtilGui.createRadioButton((String)RB.getStringResource("SecuredLibrary.Encryption.AES.Lbl.txt"));
        this.aesValue.setEnabled(false);
        this.aesValue.setSelected(true);
        this.aesValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this.aesValue.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.enableNewEncryptKeyFields();
                    SecuredLibraryEncryptionPanel.this._txtNewEncryptKey.requestFocus();
                }
            }
        });
        this.aes2Value = UtilGui.createRadioButton((String)RB.getStringResource("SecuredLibrary.Encryption.AES2.Lbl.txt"));
        this.aes2Value.setEnabled(false);
        this.aes2Value.setSelected(false);
        this.aes2Value.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SecuredLibraryEncryptionPanel.this.aes2Value.isSelected()) {
                    SecuredLibraryEncryptionPanel.this.enableNewEncryptKeyFields();
                    SecuredLibraryEncryptionPanel.this._txtNewEncryptKey.requestFocus();
                }
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.aesValue);
        buttonGroup2.add(this.aes2Value);
        buttonGroup2.add(this.sasValue);
        buttonGroup2.add(this.noValue);
        this._txtEncryptKey = new JPasswordField(64);
        this._txtEncryptKey.setEnabled(true);
        this._txtEncryptKey.setBackground(SystemColor.text);
        this._txtEncryptKey.setToolTipText(RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptKey.Tooltip.txt"));
        this._lblEncryptionKey = UtilGui.createLabelForComponent((Component)this._txtNewEncryptKey, (String)RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptKey.Lbl.txt"));
        this._txtNewEncryptKey = new JPasswordField(64);
        this._txtNewEncryptKey.setEnabled(false);
        this._txtNewEncryptKey.setBackground(SystemColor.control);
        this._txtNewEncryptKey.setToolTipText(RB.getStringResource("SecuredLibraryEncryptionPanel.NewEncryptKey.Tooltip.txt"));
        this._lblNewEncryptionKey = UtilGui.createLabelForComponent((Component)this._txtNewEncryptKey, (String)RB.getStringResource("SecuredLibraryEncryptionPanel.NewEncryptKey.Lbl.txt"));
        this._lblNewEncryptionKey.setEnabled(false);
        this._txtconfirmEncryptKey = new JPasswordField(64);
        this._txtconfirmEncryptKey.setEnabled(false);
        this._txtconfirmEncryptKey.setBackground(SystemColor.control);
        this._txtconfirmEncryptKey.setToolTipText(RB.getStringResource("SecuredLibraryEncryptionPanel.ConfirmEncryptKey.Tooltip.txt"));
        this._lblConfirmEncryptionKey = UtilGui.createLabelForComponent((Component)this._txtconfirmEncryptKey, (String)RB.getStringResource("SecuredLibraryEncryptionPanel.ConfirmEncryptKey.Lbl.txt"));
        this._lblConfirmEncryptionKey.setEnabled(false);
    }

    public void layoutWidgets() {
        int row = 0;
        this.setLayout(new GridBagLayout());
        this.libraryEncryptionPanel = new JPanel();
        TitledBorder encyptionBorder = BorderFactory.createTitledBorder(RB.getStringResource("SecuredLibraryEncryptionPanel.EncryptionGroup.Lbl.txt"));
        this.libraryEncryptionPanel.setBorder(encyptionBorder);
        GridBagLayout encryptionPanelLayout = new GridBagLayout();
        this.libraryEncryptionPanel.setLayout(encryptionPanelLayout);
        this.libraryEncryptionPanel.add((Component)this._lblEncryptionKey, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.libraryEncryptionPanel.add((Component)this._txtEncryptKey, new GridBagConstraints(1, row++, 4, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this._showRequireEncryption) {
            this.libraryEncryptionPanel.add((Component)this._requireEncryptionOption, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.libraryEncryptionPanel.add((Component)this.requiredYesValue, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.libraryEncryptionPanel.add((Component)this.requiredNoValue, new GridBagConstraints(2, row++, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.libraryEncryptionPanel.add((Component)this._encryptOption, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryEncryptionPanel.add((Component)this.aesValue, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryEncryptionPanel.add((Component)this.aes2Value, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryEncryptionPanel.add((Component)this.sasValue, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryEncryptionPanel.add((Component)this.noValue, new GridBagConstraints(4, row++, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryEncryptionPanel.add((Component)this._lblNewEncryptionKey, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.libraryEncryptionPanel.add((Component)this._txtNewEncryptKey, new GridBagConstraints(1, row++, 4, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryEncryptionPanel.add((Component)this._lblConfirmEncryptionKey, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.libraryEncryptionPanel.add((Component)this._txtconfirmEncryptKey, new GridBagConstraints(1, row, 4, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.libraryEncryptionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    protected boolean dataValidate() {
        SecuredLibraryDataObject slDataObject = new SecuredLibraryDataObject();
        boolean valid = this.validateEncryptionPanel(slDataObject);
        return valid;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean validateEncryptionPanel(SecuredLibraryDataObject slDataObject) {
        String encryptionValue = null;
        String newEncryptionValue = null;
        String confirmEncryptionValue = null;
        encryptionValue = new String(this._txtEncryptKey.getPassword());
        newEncryptionValue = new String(this._txtNewEncryptKey.getPassword());
        confirmEncryptionValue = new String(this._txtconfirmEncryptKey.getPassword());
        if (encryptionValue.equals("")) {
            slDataObject.setEncryption(null);
        } else {
            slDataObject.setEncryptKey(encryptionValue);
        }
        if (this._requireEncryptionOption.isSelected()) {
            if (this.requiredNoValue.isSelected()) {
                slDataObject.setRequireEncryption(NO);
            } else {
                slDataObject.setRequireEncryption(YES);
            }
        } else {
            slDataObject.setRequireEncryption(null);
        }
        if (!this._encryptOption.isSelected()) {
            slDataObject.setEncryption(null);
            return true;
        }
        if (this.noValue.isSelected()) {
            slDataObject.setEncryption(NO);
            return true;
        }
        if (this.sasValue.isSelected()) {
            slDataObject.setEncryption(YES);
            return true;
        }
        if (this.aesValue.isSelected()) {
            slDataObject.setEncryption(AES);
            if (this.isEncryptionKeyMissing(newEncryptionValue) && this.isEncryptionKeyMissing(confirmEncryptionValue)) {
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryEncryptionPanel.NewEncryptKey.ConfirmEncryptionKey.Missing.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                this._txtNewEncryptKey.requestFocusInWindow();
                return false;
            }
            if (!newEncryptionValue.equals(confirmEncryptionValue)) {
                MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryEncryptionPanel.NewEncryptKey.ConfirmEncryptionKeyMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                this._txtconfirmEncryptKey.requestFocusInWindow();
                return false;
            }
            slDataObject.setNewEncryptKey(newEncryptionValue);
            return true;
        }
        if (!this.aes2Value.isSelected()) return true;
        slDataObject.setEncryption(AES2);
        if (this.isEncryptionKeyMissing(newEncryptionValue) && this.isEncryptionKeyMissing(confirmEncryptionValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryEncryptionPanel.NewEncryptKey.ConfirmEncryptionKey.Missing.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._txtNewEncryptKey.requestFocusInWindow();
            return false;
        }
        if (!newEncryptionValue.equals(confirmEncryptionValue)) {
            MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryEncryptionPanel.NewEncryptKey.ConfirmEncryptionKeyMatch.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            this._txtconfirmEncryptKey.requestFocusInWindow();
            return false;
        }
        slDataObject.setNewEncryptKey(newEncryptionValue);
        return true;
    }

    private boolean isEncryptionKeyMissing(String encryptionValue) {
        return encryptionValue == null || encryptionValue.isEmpty();
    }

    protected void enableRequiredRadioButtons() {
        this.requiredNoValue.setEnabled(true);
        this.requiredYesValue.setEnabled(true);
        if (this._encryptOption.isSelected()) {
            this.enableSASProprietaryRadioButton();
            this.enableNoneRadioButton();
        }
    }

    protected void disableRequiredRadioButtons() {
        this.requiredNoValue.setEnabled(false);
        this.requiredNoValue.setSelected(false);
        this.requiredYesValue.setEnabled(false);
        this.requiredYesValue.setSelected(false);
    }

    protected void enableSASProprietaryRadioButton() {
        this.sasValue.setEnabled(true);
    }

    protected void disableSASProprietaryRadioButton() {
        if (this.sasValue.isSelected()) {
            this.aesValue.setSelected(true);
            if (this._encryptOption.isSelected()) {
                this.enableNewEncryptKeyFields();
            }
        }
        this.sasValue.setEnabled(false);
        this.sasValue.setSelected(false);
    }

    protected void enableEncryptRadioButtons() {
        if (this._requireEncryptionOption.isSelected() && this.requiredNoValue.isSelected()) {
            this.disableSASProprietaryRadioButton();
        } else {
            this.enableSASProprietaryRadioButton();
        }
        if (this._requireEncryptionOption.isSelected() && this.requiredYesValue.isSelected()) {
            this.disableNoneRadioButton();
        } else {
            this.enableNoneRadioButton();
        }
        this.aesValue.setEnabled(true);
        this.aes2Value.setEnabled(true);
    }

    protected void disableEncryptRadioButtons() {
        this.sasValue.setEnabled(false);
        this.sasValue.setSelected(false);
        this.aesValue.setEnabled(false);
        this.aesValue.setSelected(false);
        this.aes2Value.setEnabled(false);
        this.aes2Value.setSelected(false);
        this.noValue.setEnabled(false);
        this.noValue.setSelected(false);
    }

    protected void enableNewEncryptKeyFields() {
        this._lblNewEncryptionKey.setEnabled(true);
        this._txtNewEncryptKey.setEnabled(true);
        this._txtNewEncryptKey.setBackground(SystemColor.text);
        this._lblConfirmEncryptionKey.setEnabled(true);
        this._txtconfirmEncryptKey.setEnabled(true);
        this._txtconfirmEncryptKey.setBackground(SystemColor.text);
    }

    protected void disableNewEncryptKeyFields() {
        this._lblNewEncryptionKey.setEnabled(false);
        this._txtNewEncryptKey.setEnabled(false);
        this._txtNewEncryptKey.setBackground(SystemColor.control);
        this._lblConfirmEncryptionKey.setEnabled(false);
        this._txtconfirmEncryptKey.setEnabled(false);
        this._txtconfirmEncryptKey.setBackground(SystemColor.control);
    }

    protected void enableNoneRadioButton() {
        this.noValue.setEnabled(true);
    }

    protected void disableNoneRadioButton() {
        if (this.noValue.isSelected()) {
            this.aesValue.setSelected(true);
            if (this._encryptOption.isSelected()) {
                this.enableNewEncryptKeyFields();
            }
        }
        this.noValue.setEnabled(false);
        this.noValue.setSelected(false);
    }
}

