/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryEncryptionWizardPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryPasswordWizardPanel;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

class SecuredLibraryConnectionDataTabPanel
extends SmartWsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private SecuredLibraryAppServerPanel appServerPanel;
    private SecuredLibraryPasswordWizardPanel passwordPanel;
    private SecuredLibraryEncryptionWizardPanel encryptionPanel;
    private boolean _dataPreviouslyMovedToView;

    SecuredLibraryConnectionDataTabPanel(Root root, ObjectFactoryInterface objectFactory, int type, String serverRepositoryID, Config config) {
        this.initialize(root, serverRepositoryID, config);
        this.layoutWidgets();
    }

    protected void initialize(Root root, String serverRepositoryID, Config config) {
        this.setName(RB.getStringResource("ConnectionData.Tab.Title.txt"));
        this.setDescription(RB.getStringResource("ConnectionData.Tab.Description.txt"));
        this.setHelpProduct("folderview");
        this.setHelpTopic("seclib_connectionpage");
        this.appServerPanel = new SecuredLibraryAppServerPanel(root, serverRepositoryID);
        this.passwordPanel = new SecuredLibraryPasswordWizardPanel();
        this.encryptionPanel = new SecuredLibraryEncryptionWizardPanel();
    }

    protected void layoutWidgets() {
        int row = 0;
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add(this.appServerPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add(this.passwordPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add(this.encryptionPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        this.appServerPanel.populateServerData();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this._dataPreviouslyMovedToView) {
            this.appServerPanel.moveDataToView();
            this._dataPreviouslyMovedToView = true;
        }
    }

    protected boolean dataValidate() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        if (this.appServerPanel.dataValidate()) {
            if (this.passwordPanel.dataValidate()) {
                if (this.encryptionPanel.dataValidate()) {
                    String encrypt;
                    String requireEncryption = (String)wizard.getWizardData("RequiredEncryption");
                    if (requireEncryption != null && requireEncryption.equalsIgnoreCase("YES") && (encrypt = (String)wizard.getWizardData("EncryptAlgorithm")) == null) {
                        MessageUtil.displayMessage((String)RB.getStringResource("SecuredLibraryConnectionDataTabPanel.RequireEncryption.EncryptionType.Required.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

