/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.editor.LogListHolder;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.util.Encryption;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.util.List;

public class SecuredLibraryAppServerUtil {
    ServerContext _server = null;
    WsAppServer appServer = null;
    LogListHolder appLog = null;
    LogListHolder appOutputHolder = null;

    public SecuredLibraryAppServerUtil(ServerContext server) {
        this._server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitAppServerRequest(String requestString) {
        if (this.appServer == null) {
            this.createAppServer();
        }
        try {
            this.appServer.openSASCodeSession();
            this.appServer.submitSASCode(requestString);
            this.appLog = this.appServer.getLog();
            this.appOutputHolder = this.appServer.getOutput();
        }
        catch (Exception e) {
            if (this.appLog == null) {
                try {
                    this.appLog = this.appServer.getLog();
                }
                catch (WsAppServerFailException e1) {
                    UtilGui.displayExceptionError((Exception)e);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.appServer.dispose();
        }
        return true;
    }

    public void createAppServer() {
        if (this._server != null && this._server instanceof ServerContext) {
            this.appServer = WsAppServer.createAppServer((ServerContext)this._server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesFileExist(String path) {
        boolean exists = false;
        if (this.appServer == null) {
            this.createAppServer();
        }
        try {
            this.appServer.openSASCodeSession();
            exists = this.appServer.doesFileExist(path);
        }
        catch (Exception e) {
            if (this.appLog == null) {
                try {
                    this.appLog = this.appServer.getLog();
                }
                catch (WsAppServerFailException e1) {
                    UtilGui.displayExceptionError((Exception)e);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.appServer.dispose();
        }
        return exists;
    }

    public String getMetaConnectionOptions(UserContextInterface user) {
        String connectOptions = "";
        String uid = "";
        String password = "";
        try {
            ServerInterface server = user.getAuthServer();
            if (server == null) {
                return connectOptions;
            }
            if (user != null) {
                UserIdentityInterface ident = null;
                List identities = user.getIdentities();
                for (UserIdentityInterface ui : identities) {
                    if (ui == null || !ui.isPrimary()) continue;
                    ident = ui;
                    break;
                }
                if (ident != null) {
                    uid = (String)ident.getPrincipal();
                    password = Encryption.encrypt((String)((String)ident.getCredential()));
                }
            }
        }
        catch (Exception e) {
            UtilGui.displayExceptionError((Exception)e);
            return connectOptions;
        }
        StringBuffer optionsBuffer = new StringBuffer();
        optionsBuffer.append("options metauser=\"").append(uid).append("\"");
        optionsBuffer.append(" metapass=\"").append(password).append("\"");
        optionsBuffer.append(";");
        connectOptions = optionsBuffer.toString();
        return connectOptions;
    }

    public LogListHolder getAppServerLog() {
        return this.appLog;
    }

    public LogListHolder getAppServerOutputHolder() {
        return this.appOutputHolder;
    }
}

