/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeActionEvent;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerUtil;
import com.sas.metadata.logical.secureddata.SecuredLibraryConnectionDataTabPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryGeneralTabPanel;
import com.sas.metadata.logical.secureddata.SecuredLibraryObjectFactory;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SecuredLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.ResourceBundle;

class NewSecuredLibraryWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    private final SecuredLibraryObjectFactory _factory;
    private String _repositoryId;
    FolderInterface _loParentFolder;

    public NewSecuredLibraryWizard(SecuredLibraryObjectFactory factory, Frame frame, com.sas.services.information.metadata.secureddata.SecuredLibrary slib, Tree tree, String repositoryId, FolderInterface parentFolder, Config config) throws RemoteException {
        super(frame, true);
        this._factory = factory;
        this._repositoryId = repositoryId;
        this._loParentFolder = parentFolder;
        this.initialize(frame, slib, tree, config);
    }

    protected void initialize(Frame frame, com.sas.services.information.metadata.secureddata.SecuredLibrary slib, Tree tree, Config config) throws RemoteException {
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(RB.getStringResource("NewSecuredLibraryWizard.Title.txt"));
        SecuredLibrary jomaSecLibrary = (SecuredLibrary)slib.getRepositoryEntity();
        String genTitle = RB.getStringResource("General.Tab.Title.txt");
        this.addTab(genTitle, RB.getStringResource("General.Tab.Title.txt"), (WAPropertyTab)new SecuredLibraryGeneralTabPanel((Root)jomaSecLibrary, tree, this._factory.getType(), 0, config), "gen", null);
        String execTitle = RB.getStringResource("ConnectionData.Tab.Title.txt");
        this.addTab(execTitle, RB.getStringResource("ConnectionData.Tab.Title.txt"), (WAPropertyTab)new SecuredLibraryConnectionDataTabPanel((Root)jomaSecLibrary, (ObjectFactoryInterface)this._factory, 0, this._repositoryId, config), "exe", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onFinish() {
        if (super.onFinish()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String libraryName = null;
            String libraryDescription = null;
            String folderLocation = null;
            ServerContext serverComp = null;
            String libraryPath = null;
            String commonPassword = null;
            String readPassword = null;
            String writePassword = null;
            String alterPassword = null;
            String requireEncryption = null;
            String encrypt = null;
            String encryptKey = null;
            String newEncryptKey = null;
            libraryName = (String)this.getWizardData("LibraryName");
            libraryDescription = (String)this.getWizardData("LibraryDescription");
            folderLocation = (String)this.getWizardData("FolderLocation");
            serverComp = (ServerContext)this.getWizardData("SL_AppServer");
            libraryPath = (String)this.getWizardData("LibraryPath");
            commonPassword = (String)this.getWizardData("LibraryPassword");
            readPassword = (String)this.getWizardData("ReadPassword");
            writePassword = (String)this.getWizardData("WritePassword");
            alterPassword = (String)this.getWizardData("AlterPassword");
            requireEncryption = (String)this.getWizardData("RequiredEncryption");
            encrypt = (String)this.getWizardData("EncryptAlgorithm");
            encryptKey = (String)this.getWizardData("EncryptionKey");
            newEncryptKey = (String)this.getWizardData("NewEncryptionKey");
            SecuredLibraryAppServerUtil appServerUtil = new SecuredLibraryAppServerUtil(serverComp);
            StringBuffer generatedCode = new StringBuffer();
            generatedCode.append("libname slibref \"").append(libraryPath).append("\";");
            generatedCode.append("\n");
            generatedCode.append("proc authlib lib=slibref; \n");
            generatedCode.append("create securedfolder=\"").append(folderLocation).append("\"\n");
            generatedCode.append("securedlibrary=\"").append(libraryName).append("\"\n");
            if (commonPassword != null) {
                generatedCode.append("pw=\"").append(commonPassword).append("\"\n");
            } else {
                generatedCode.append("read=\"").append(readPassword).append("\"");
                generatedCode.append(" write=\"").append(writePassword).append("\"");
                generatedCode.append(" alter=\"").append(alterPassword).append("\"\n");
            }
            if (requireEncryption != null) {
                generatedCode.append("require_encryption=").append(requireEncryption).append("\n");
            }
            if (encrypt != null) {
                generatedCode.append("encrypt=").append(encrypt).append("\n");
            }
            if (encryptKey != null) {
                if (newEncryptKey != null) {
                    generatedCode.append("encryptkey=\"").append(encryptKey).append("\"/\"").append(newEncryptKey).append("\"\n");
                } else {
                    generatedCode.append("encryptkey=\"").append(encryptKey).append("\"\n");
                }
            } else if (newEncryptKey != null) {
                generatedCode.append("encryptkey=/").append("\"").append(newEncryptKey).append("\"\n");
            }
            generatedCode.append("; run; quit;");
            boolean result = appServerUtil.submitAppServerRequest(generatedCode.toString());
            boolean libraryCreated = false;
            ChildServerInterface childServer = null;
            MetadataInterface mi = null;
            try {
                MetadataServerInterface server = Factory.getInstance().getMetadataServerInterface();
                childServer = server.newChild(true);
                String pathtoSL = folderLocation + "/" + libraryName;
                PathUrl url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)childServer, (String)pathtoSL);
                url.setType("SecuredLibrary");
                mi = childServer.getObjectByPath(url);
                if (mi != null) {
                    libraryCreated = true;
                }
                if (libraryDescription != null && libraryCreated) {
                    if (!(mi instanceof com.sas.services.information.metadata.secureddata.SecuredLibrary)) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewSecuredLibraryWizard.NoSecuredLibrary.fmt.txt", (Object)libraryName);
                        throw new ServiceException(msg);
                    }
                    mi.setDescription(libraryDescription);
                    mi.update();
                }
            }
            catch (RemoteException e) {
                UtilGui.displayExceptionError((Exception)e);
            }
            catch (ServiceException e) {
                UtilGui.displayExceptionError((Exception)((Object)e));
            }
            finally {
                if (childServer != null) {
                    try {
                        childServer.rollback();
                        childServer = null;
                    }
                    catch (Exception e) {}
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            LogListHolder appLog = appServerUtil.getAppServerLog();
            LogListHolder appOutputHolder = appServerUtil.getAppServerOutputHolder();
            this.showAppServerOutputDialog(appLog, appOutputHolder, result);
            this.signalFolderRefresh((LogicalObjectInterface)this._loParentFolder);
            return libraryCreated;
        }
        return false;
    }

    protected boolean onCancel() {
        boolean brc = super.onCancel();
        return brc;
    }

    private void signalFolderRefresh(LogicalObjectInterface parentFolder) {
        ArrayList<LogicalObjectInterface> objects = new ArrayList<LogicalObjectInterface>(1);
        if (parentFolder != null) {
            objects.add(parentFolder);
            LogicalTypeActionEvent event = new LogicalTypeActionEvent((Object)this, "EVENT_REFRESH_CONTAINER", objects);
            try {
                Factory.getInstance().fireActionPerformed(event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void showAppServerOutputDialog(LogListHolder log, LogListHolder outputHolder, boolean result) {
        String msg;
        int type;
        if (result) {
            type = 1;
            msg = RB.getStringResource("NewSecuredLibraryWizard.AppServerLog.Success.txt");
        } else {
            type = 0;
            msg = RB.getStringResource("NewSecuredLibraryWizard.AppServerLog.Error.txt");
        }
        int rc = MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("NewSecuredLibraryWizard.Title.txt"), (int)type, (int)0);
        if (rc == 0) {
            this.displayOutputList(log, outputHolder);
        }
    }

    private void displayOutputList(LogListHolder log, LogListHolder outputHolder) {
        String[] strArray = new String[1];
        Integer[] intArray = new Integer[1];
        strArray[0] = "";
        intArray[0] = new Integer(5);
        LogListViewer sasLog = new LogListViewer(5, new LogListHolder(strArray, intArray), Workspace.getWorkspace().getCodeEditorDefaults());
        if (log != null) {
            sasLog.append(log);
        }
        if (outputHolder != null) {
            sasLog.append(outputHolder);
        }
        SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), RB.getStringResource("NewSecuredLibraryWizard.Title.txt"), true, sasLog);
        logDlg.setResizable(true);
        logDlg.show();
    }
}

