/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.secureddata.NewSecuredLibraryWizard;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryObjectFactory;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.Images;
import com.sas.metadata.logical.visuals.NewObjectActionInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.secureddata.SecuredLibrary;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class NewSecuredLibraryAction
extends AbstractAction
implements NewObjectActionInterface {
    public static final Action[] NO_ACTIONS = new Action[0];
    private static final long serialVersionUID = 1L;
    private Frame _frame;
    private FolderInterface _parentFolder;
    private Tree _tree;
    private Config _config;
    private SecuredLibraryObjectFactory _factory;

    public NewSecuredLibraryAction(Frame frame, FolderInterface logicalObject, Tree tree, SecuredLibraryObjectFactory factory, Config config) {
        this._frame = frame;
        this._parentFolder = logicalObject;
        this._tree = tree;
        this._factory = factory;
        this._config = config;
        UtilGui.setLabelAndMnemonicOnAction((AbstractAction)this, (String)RB.getStringResource("NewSecuredLibraryAction.Label.txt"));
        this.putValue("SmallIcon", Images.getNewObjectIcon((String)"SecuredLibrary"));
        this.putValue("ShortDescription", RB.getStringResource("NewSecuredLibraryAction.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._parentFolder == null) {
            return;
        }
        ChildServerInterface childServer = null;
        ServerInterface server23333332 = Workspace.getWorkspace().getUserContext().getAuthServer();
        childServer = server23333332.newChild(true);
        String key = this._parentFolder.getID() + "/" + this._parentFolder.getTypeInterface().getMetadataType();
        com.sas.services.information.metadata.FolderInterface folder = (com.sas.services.information.metadata.FolderInterface)childServer.fetch(key, true);
        if (folder == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewSecuredLibraryAction.NoFolder.fmt.txt", (Object)this._parentFolder.getName());
            throw new ServiceException(msg);
        }
        InformationServiceInterface is = Workspace.getWorkspace().getInformationService();
        SecuredLibrary slibrary = null;
        if (is != null) {
            RepositoryInterface ri = folder.getRepository();
            String name = "TempSecuredLibrary: " + System.currentTimeMillis();
            slibrary = (SecuredLibrary)is.newMetadataInFolder(folder, ri, "SecuredLibrary", name);
        }
        String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)this._tree);
        NewSecuredLibraryWizard wizard = new NewSecuredLibraryWizard(this._factory, this._frame, slibrary, this._tree, repositoryFQID, this._parentFolder, this._config);
        wizard.show();
        if (childServer == null) return;
        try {
            childServer.rollback();
            return;
        }
        catch (Exception server23333332) {}
        return;
        catch (ServiceException ex2222222) {
            UtilGui.displayExceptionError((Exception)((Object)ex2222222));
            if (childServer == null) return;
            try {
                childServer.rollback();
                return;
            }
            catch (Exception ex2222222) {}
            return;
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
            if (childServer == null) return;
            {
                catch (Throwable throwable) {
                    if (childServer == null) throw throwable;
                    try {
                        ((ChildServerInterface)childServer).rollback();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                childServer.rollback();
                return;
            }
            catch (Exception exception) {}
            return;
        }
    }

    public String getActionLabel() {
        return RB.getStringResource("NewSecuredLibraryAction.Label.txt");
    }
}

