/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryUtil;
import com.sas.metadata.remote.Root;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSecuredDataObject
extends LogicalObject {
    private static final Logger log = LogManager.getLogger(AbstractSecuredDataObject.class);

    public AbstractSecuredDataObject(Root meta, TypeInterface ti, Factory factory) throws RemoteException {
        super(meta, ti, factory);
    }

    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        int choice;
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("This object cannot be deleted.");
        }
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        if (!oui.isUserInteractionSupported()) {
            if (!SecuredLibraryUtil.isDeletePromptDisplayed(oui)) {
                log.warn(RB.getStringResource("Common.BatchDeleteWarning.txt"));
                SecuredLibraryUtil.setDeletePromptResponse(oui, true);
            }
            choice = 3;
        } else if (SecuredLibraryUtil.isDeletePromptDisplayed(oui)) {
            boolean response = SecuredLibraryUtil.getDeletePromptResponse(oui);
            choice = response ? 0 : 3;
        } else {
            String message;
            String title = RB.getStringResource("Common.WarningTitle.txt");
            choice = oui.displayMessage(title, message = Message.format((ResourceBundle)RB.getResources(), (String)"Common.DeleteWarning.fmt.txt", (Object)this.getName()), 1, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
            boolean response = choice == 0;
            SecuredLibraryUtil.setDeletePromptResponse(oui, response);
        }
        if (choice == 0) {
            return super.delete(oui);
        }
        return false;
    }
}

